/*     */ package com.sun.xml.bind.v2.runtime;
/*     */ 
/*     */ import com.sun.xml.bind.DatatypeConverterImpl;
/*     */ import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
/*     */ import com.sun.xml.bind.marshaller.DataWriter;
/*     */ import com.sun.xml.bind.marshaller.DumbEscapeHandler;
/*     */ import com.sun.xml.bind.marshaller.MinimumEscapeHandler;
/*     */ import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
/*     */ import com.sun.xml.bind.marshaller.NioEscapeHandler;
/*     */ import com.sun.xml.bind.marshaller.SAX2DOMEx;
/*     */ import com.sun.xml.bind.marshaller.XMLWriter;
/*     */ import com.sun.xml.bind.v2.runtime.output.C14nXmlOutput;
/*     */ import com.sun.xml.bind.v2.runtime.output.Encoded;
/*     */ import com.sun.xml.bind.v2.runtime.output.ForkXmlOutput;
/*     */ import com.sun.xml.bind.v2.runtime.output.IndentingUTF8XmlOutput;
/*     */ import com.sun.xml.bind.v2.runtime.output.NamespaceContextImpl;
/*     */ import com.sun.xml.bind.v2.runtime.output.SAXOutput;
/*     */ import com.sun.xml.bind.v2.runtime.output.UTF8XmlOutput;
/*     */ import com.sun.xml.bind.v2.runtime.output.XMLEventWriterOutput;
/*     */ import com.sun.xml.bind.v2.runtime.output.XMLStreamWriterOutput;
/*     */ import com.sun.xml.bind.v2.runtime.output.XmlOutput;
/*     */ import com.sun.xml.bind.v2.util.FatalAdapter;
/*     */ import java.io.BufferedWriter;
/*     */ import java.io.Closeable;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.Flushable;
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.io.Writer;
/*     */ import javax.xml.bind.DatatypeConverter;
/*     */ import javax.xml.bind.JAXBException;
/*     */ import javax.xml.bind.MarshalException;
/*     */ import javax.xml.bind.Marshaller.Listener;
/*     */ import javax.xml.bind.PropertyException;
/*     */ import javax.xml.bind.ValidationEvent;
/*     */ import javax.xml.bind.ValidationEventHandler;
/*     */ import javax.xml.bind.annotation.adapters.XmlAdapter;
/*     */ import javax.xml.bind.attachment.AttachmentMarshaller;
/*     */ import javax.xml.bind.helpers.AbstractMarshallerImpl;
/*     */ import javax.xml.stream.XMLEventWriter;
/*     */ import javax.xml.stream.XMLStreamException;
/*     */ import javax.xml.stream.XMLStreamWriter;
/*     */ import javax.xml.transform.Result;
/*     */ import javax.xml.transform.dom.DOMResult;
/*     */ import javax.xml.transform.sax.SAXResult;
/*     */ import javax.xml.transform.stream.StreamResult;
/*     */ import javax.xml.validation.Schema;
/*     */ import javax.xml.validation.ValidatorHandler;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Node;
/*     */ import org.xml.sax.ContentHandler;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.helpers.XMLFilterImpl;
/*     */ 
/*     */ public final class MarshallerImpl extends AbstractMarshallerImpl
/*     */   implements ValidationEventHandler
/*     */ {
/* 108 */   private String indent = "    ";
/*     */ 
/* 111 */   private NamespacePrefixMapper prefixMapper = null;
/*     */ 
/* 114 */   private CharacterEscapeHandler escapeHandler = null;
/*     */ 
/* 117 */   private String header = null;
/*     */   final JAXBContextImpl context;
/*     */   protected final XMLSerializer serializer;
/*     */   private Schema schema;
/* 130 */   private Marshaller.Listener externalListener = null;
/*     */   private boolean c14nSupport;
/*     */   private Flushable toBeFlushed;
/*     */   private Closeable toBeClosed;
/*     */   protected static final String INDENT_STRING = "com.sun.xml.bind.indentString";
/*     */   protected static final String PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
/*     */   protected static final String ENCODING_HANDLER = "com.sun.xml.bind.characterEscapeHandler";
/*     */   protected static final String ENCODING_HANDLER2 = "com.sun.xml.bind.marshaller.CharacterEscapeHandler";
/*     */   protected static final String XMLDECLARATION = "com.sun.xml.bind.xmlDeclaration";
/*     */   protected static final String XML_HEADERS = "com.sun.xml.bind.xmlHeaders";
/*     */   protected static final String C14N = "com.sun.xml.bind.c14n";
/*     */   protected static final String OBJECT_IDENTITY_CYCLE_DETECTION = "com.sun.xml.bind.objectIdentitityCycleDetection";
/*     */ 
/*     */   public MarshallerImpl(JAXBContextImpl c, AssociationMap assoc)
/*     */   {
/* 146 */     DatatypeConverter.setDatatypeConverter(DatatypeConverterImpl.theInstance);
/*     */ 
/* 148 */     this.context = c;
/* 149 */     this.serializer = new XMLSerializer(this);
/* 150 */     this.c14nSupport = this.context.c14nSupport;
/*     */     try
/*     */     {
/* 153 */       setEventHandler(this);
/*     */     } catch (JAXBException e) {
/* 155 */       throw new AssertionError(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public JAXBContextImpl getContext() {
/* 160 */     return this.context;
/*     */   }
/*     */ 
/*     */   public void marshal(Object obj, XMLStreamWriter writer) throws JAXBException {
/* 164 */     write(obj, XMLStreamWriterOutput.create(writer, this.context), new StAXPostInitAction(writer, this.serializer));
/*     */   }
/*     */ 
/*     */   public void marshal(Object obj, XMLEventWriter writer) throws JAXBException {
/* 168 */     write(obj, new XMLEventWriterOutput(writer), new StAXPostInitAction(writer, this.serializer));
/*     */   }
/*     */ 
/*     */   public void marshal(Object obj, XmlOutput output) throws JAXBException {
/* 172 */     write(obj, output, null);
/*     */   }
/*     */ 
/*     */   final XmlOutput createXmlOutput(Result result)
/*     */     throws JAXBException
/*     */   {
/* 179 */     if ((result instanceof SAXResult)) {
/* 180 */       return new SAXOutput(((SAXResult)result).getHandler());
/*     */     }
/* 182 */     if ((result instanceof DOMResult)) {
/* 183 */       Node node = ((DOMResult)result).getNode();
/*     */ 
/* 185 */       if (node == null) {
/* 186 */         Document doc = JAXBContextImpl.createDom();
/* 187 */         ((DOMResult)result).setNode(doc);
/* 188 */         return new SAXOutput(new SAX2DOMEx(doc));
/*     */       }
/* 190 */       return new SAXOutput(new SAX2DOMEx(node));
/*     */     }
/*     */ 
/* 193 */     if ((result instanceof StreamResult)) {
/* 194 */       StreamResult sr = (StreamResult)result;
/*     */ 
/* 196 */       if (sr.getWriter() != null)
/* 197 */         return createWriter(sr.getWriter());
/* 198 */       if (sr.getOutputStream() != null)
/* 199 */         return createWriter(sr.getOutputStream());
/* 200 */       if (sr.getSystemId() != null) {
/* 201 */         String fileURL = sr.getSystemId();
/*     */ 
/* 203 */         if (fileURL.startsWith("file:///")) {
/* 204 */           if (fileURL.substring(8).indexOf(":") > 0)
/* 205 */             fileURL = fileURL.substring(8);
/*     */           else
/* 207 */             fileURL = fileURL.substring(7);
/*     */         }
/* 209 */         if (fileURL.startsWith("file:/"))
/*     */         {
/* 212 */           if (fileURL.substring(6).indexOf(":") > 0)
/* 213 */             fileURL = fileURL.substring(6);
/*     */           else {
/* 215 */             fileURL = fileURL.substring(5);
/*     */           }
/*     */         }
/*     */         try
/*     */         {
/* 220 */           FileOutputStream fos = new FileOutputStream(fileURL);
/* 221 */           assert (this.toBeClosed == null);
/* 222 */           this.toBeClosed = fos;
/* 223 */           return createWriter(fos);
/*     */         } catch (IOException e) {
/* 225 */           throw new MarshalException(e);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 231 */     throw new MarshalException(Messages.UNSUPPORTED_RESULT.format(new Object[0]));
/*     */   }
/*     */ 
/*     */   final Runnable createPostInitAction(Result result)
/*     */   {
/* 238 */     if ((result instanceof DOMResult)) {
/* 239 */       Node node = ((DOMResult)result).getNode();
/* 240 */       return new DomPostInitAction(node, this.serializer);
/*     */     }
/* 242 */     return null;
/*     */   }
/*     */ 
/*     */   public void marshal(Object target, Result result) throws JAXBException {
/* 246 */     write(target, createXmlOutput(result), createPostInitAction(result));
/*     */   }
/*     */ 
/*     */   protected final <T> void write(Name rootTagName, JaxBeanInfo<T> bi, T obj, XmlOutput out, Runnable postInitAction)
/*     */     throws JAXBException
/*     */   {
/*     */     try
/*     */     {
/* 282 */       return;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*     */     }
/*     */     finally
/*     */     {
/* 280 */       cleanUp();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void write(Object obj, XmlOutput out, Runnable postInitAction)
/*     */     throws JAXBException
/*     */   {
/*     */     try
/*     */     {
/* 289 */       if (obj == null) {
/* 290 */         throw new IllegalArgumentException(Messages.NOT_MARSHALLABLE.format(new Object[0]));
/*     */       }
/* 292 */       if (this.schema != null)
/*     */       {
/* 294 */         ValidatorHandler validator = this.schema.newValidatorHandler();
/* 295 */         validator.setErrorHandler(new FatalAdapter(this.serializer));
/*     */ 
/* 297 */         XMLFilterImpl f = new XMLFilterImpl() {
/*     */           public void startPrefixMapping(String prefix, String uri) throws SAXException {
/* 299 */             super.startPrefixMapping(prefix.intern(), uri.intern());
/*     */           }
/*     */         };
/* 302 */         f.setContentHandler(validator);
/* 303 */         out = new ForkXmlOutput(new SAXOutput(f)
/*     */         {
/*     */           public void startDocument(XMLSerializer serializer, boolean fragment, int[] nsUriIndex2prefixIndex, NamespaceContextImpl nsContext) throws SAXException, IOException, XMLStreamException {
/* 306 */             super.startDocument(serializer, false, nsUriIndex2prefixIndex, nsContext);
/*     */           }
/*     */ 
/*     */           public void endDocument(boolean fragment) throws SAXException, IOException, XMLStreamException {
/* 310 */             super.endDocument(false);
/*     */           }
/*     */         }
/*     */         , out);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 316 */         prewrite(out, isFragment(), postInitAction);
/* 317 */         this.serializer.childAsRoot(obj);
/* 318 */         postwrite();
/*     */       } catch (SAXException e) {
/* 320 */         throw new MarshalException(e);
/*     */       } catch (IOException e) {
/* 322 */         throw new MarshalException(e);
/*     */       } catch (XMLStreamException e) {
/* 324 */         throw new MarshalException(e);
/*     */       } finally {
/* 326 */         this.serializer.close();
/*     */       }
/*     */     } finally {
/* 329 */       cleanUp();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void cleanUp() {
/* 334 */     if (this.toBeFlushed != null)
/*     */       try {
/* 336 */         this.toBeFlushed.flush();
/*     */       }
/*     */       catch (IOException e) {
/*     */       }
/* 340 */     if (this.toBeClosed != null)
/*     */       try {
/* 342 */         this.toBeClosed.close();
/*     */       }
/*     */       catch (IOException e) {
/*     */       }
/* 346 */     this.toBeFlushed = null;
/* 347 */     this.toBeClosed = null;
/*     */   }
/*     */ 
/*     */   private void prewrite(XmlOutput out, boolean fragment, Runnable postInitAction)
/*     */     throws IOException, SAXException, XMLStreamException
/*     */   {
/* 353 */     this.serializer.startDocument(out, fragment, getSchemaLocation(), getNoNSSchemaLocation());
/* 354 */     if (postInitAction != null) postInitAction.run();
/* 355 */     if (this.prefixMapper != null)
/*     */     {
/* 357 */       String[] decls = this.prefixMapper.getContextualNamespaceDecls();
/* 358 */       if (decls != null) {
/* 359 */         for (int i = 0; i < decls.length; i += 2) {
/* 360 */           String prefix = decls[i];
/* 361 */           String nsUri = decls[(i + 1)];
/* 362 */           if ((nsUri != null) && (prefix != null))
/* 363 */             this.serializer.addInscopeBinding(nsUri, prefix);
/*     */         }
/*     */       }
/*     */     }
/* 367 */     this.serializer.setPrefixMapper(this.prefixMapper);
/*     */   }
/*     */ 
/*     */   private void postwrite() throws IOException, SAXException, XMLStreamException {
/* 371 */     this.serializer.endDocument();
/* 372 */     this.serializer.reconcileID();
/*     */   }
/*     */ 
/*     */   protected CharacterEscapeHandler createEscapeHandler(String encoding)
/*     */   {
/* 383 */     if (this.escapeHandler != null)
/*     */     {
/* 385 */       return this.escapeHandler;
/*     */     }
/* 387 */     if (encoding.startsWith("UTF"))
/*     */     {
/* 390 */       return MinimumEscapeHandler.theInstance;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 395 */       return new NioEscapeHandler(getJavaEncoding(encoding));
/*     */     } catch (Throwable e) {
/*     */     }
/* 398 */     return DumbEscapeHandler.theInstance;
/*     */   }
/*     */ 
/*     */   public XmlOutput createWriter(Writer w, String encoding)
/*     */   {
/* 404 */     if (!(w instanceof BufferedWriter)) {
/* 405 */       w = new BufferedWriter(w);
/*     */     }
/* 407 */     assert (this.toBeFlushed == null);
/* 408 */     this.toBeFlushed = w;
/*     */ 
/* 410 */     CharacterEscapeHandler ceh = createEscapeHandler(encoding);
/*     */     XMLWriter xw;
/*     */     XMLWriter xw;
/* 413 */     if (isFormattedOutput()) {
/* 414 */       DataWriter d = new DataWriter(w, encoding, ceh);
/* 415 */       d.setIndentStep(this.indent);
/* 416 */       xw = d;
/*     */     } else {
/* 418 */       xw = new XMLWriter(w, encoding, ceh);
/*     */     }
/* 420 */     xw.setXmlDecl(!isFragment());
/* 421 */     xw.setHeader(this.header);
/* 422 */     return new SAXOutput(xw);
/*     */   }
/*     */ 
/*     */   public XmlOutput createWriter(Writer w) {
/* 426 */     return createWriter(w, getEncoding());
/*     */   }
/*     */ 
/*     */   public XmlOutput createWriter(OutputStream os) throws JAXBException {
/* 430 */     return createWriter(os, getEncoding()); } 
/*     */   public XmlOutput createWriter(OutputStream os, String encoding) throws JAXBException { // Byte code:
/*     */     //   0: aload_2
/*     */     //   1: ldc 131
/*     */     //   3: invokevirtual 132	java/lang/String:equals	(Ljava/lang/Object;)Z
/*     */     //   6: ifeq +94 -> 100
/*     */     //   9: aload_0
/*     */     //   10: getfield 10	com/sun/xml/bind/v2/runtime/MarshallerImpl:context	Lcom/sun/xml/bind/v2/runtime/JAXBContextImpl;
/*     */     //   13: invokevirtual 133	com/sun/xml/bind/v2/runtime/JAXBContextImpl:getUTF8NameTable	()[Lcom/sun/xml/bind/v2/runtime/output/Encoded;
/*     */     //   16: astore_3
/*     */     //   17: aload_0
/*     */     //   18: invokevirtual 120	com/sun/xml/bind/v2/runtime/MarshallerImpl:isFormattedOutput	()Z
/*     */     //   21: ifeq +21 -> 42
/*     */     //   24: new 134	com/sun/xml/bind/v2/runtime/output/IndentingUTF8XmlOutput
/*     */     //   27: dup
/*     */     //   28: aload_1
/*     */     //   29: aload_0
/*     */     //   30: getfield 3	com/sun/xml/bind/v2/runtime/MarshallerImpl:indent	Ljava/lang/String;
/*     */     //   33: aload_3
/*     */     //   34: invokespecial 135	com/sun/xml/bind/v2/runtime/output/IndentingUTF8XmlOutput:<init>	(Ljava/io/OutputStream;Ljava/lang/String;[Lcom/sun/xml/bind/v2/runtime/output/Encoded;)V
/*     */     //   37: astore 4
/*     */     //   39: goto +42 -> 81
/*     */     //   42: aload_0
/*     */     //   43: getfield 15	com/sun/xml/bind/v2/runtime/MarshallerImpl:c14nSupport	Z
/*     */     //   46: ifeq +24 -> 70
/*     */     //   49: new 136	com/sun/xml/bind/v2/runtime/output/C14nXmlOutput
/*     */     //   52: dup
/*     */     //   53: aload_1
/*     */     //   54: aload_3
/*     */     //   55: aload_0
/*     */     //   56: getfield 10	com/sun/xml/bind/v2/runtime/MarshallerImpl:context	Lcom/sun/xml/bind/v2/runtime/JAXBContextImpl;
/*     */     //   59: getfield 14	com/sun/xml/bind/v2/runtime/JAXBContextImpl:c14nSupport	Z
/*     */     //   62: invokespecial 137	com/sun/xml/bind/v2/runtime/output/C14nXmlOutput:<init>	(Ljava/io/OutputStream;[Lcom/sun/xml/bind/v2/runtime/output/Encoded;Z)V
/*     */     //   65: astore 4
/*     */     //   67: goto +14 -> 81
/*     */     //   70: new 138	com/sun/xml/bind/v2/runtime/output/UTF8XmlOutput
/*     */     //   73: dup
/*     */     //   74: aload_1
/*     */     //   75: aload_3
/*     */     //   76: invokespecial 139	com/sun/xml/bind/v2/runtime/output/UTF8XmlOutput:<init>	(Ljava/io/OutputStream;[Lcom/sun/xml/bind/v2/runtime/output/Encoded;)V
/*     */     //   79: astore 4
/*     */     //   81: aload_0
/*     */     //   82: getfield 6	com/sun/xml/bind/v2/runtime/MarshallerImpl:header	Ljava/lang/String;
/*     */     //   85: ifnull +12 -> 97
/*     */     //   88: aload 4
/*     */     //   90: aload_0
/*     */     //   91: getfield 6	com/sun/xml/bind/v2/runtime/MarshallerImpl:header	Ljava/lang/String;
/*     */     //   94: invokevirtual 140	com/sun/xml/bind/v2/runtime/output/UTF8XmlOutput:setHeader	(Ljava/lang/String;)V
/*     */     //   97: aload 4
/*     */     //   99: areturn
/*     */     //   100: aload_0
/*     */     //   101: new 141	java/io/OutputStreamWriter
/*     */     //   104: dup
/*     */     //   105: aload_1
/*     */     //   106: aload_0
/*     */     //   107: aload_2
/*     */     //   108: invokevirtual 113	com/sun/xml/bind/v2/runtime/MarshallerImpl:getJavaEncoding	(Ljava/lang/String;)Ljava/lang/String;
/*     */     //   111: invokespecial 142	java/io/OutputStreamWriter:<init>	(Ljava/io/OutputStream;Ljava/lang/String;)V
/*     */     //   114: aload_2
/*     */     //   115: invokevirtual 129	com/sun/xml/bind/v2/runtime/MarshallerImpl:createWriter	(Ljava/io/Writer;Ljava/lang/String;)Lcom/sun/xml/bind/v2/runtime/output/XmlOutput;
/*     */     //   118: areturn
/*     */     //   119: astore_3
/*     */     //   120: new 55	javax/xml/bind/MarshalException
/*     */     //   123: dup
/*     */     //   124: getstatic 144	com/sun/xml/bind/v2/runtime/Messages:UNSUPPORTED_ENCODING	Lcom/sun/xml/bind/v2/runtime/Messages;
/*     */     //   127: iconst_1
/*     */     //   128: anewarray 58	java/lang/Object
/*     */     //   131: dup
/*     */     //   132: iconst_0
/*     */     //   133: aload_2
/*     */     //   134: aastore
/*     */     //   135: invokevirtual 59	com/sun/xml/bind/v2/runtime/Messages:format	([Ljava/lang/Object;)Ljava/lang/String;
/*     */     //   138: aload_3
/*     */     //   139: invokespecial 145	javax/xml/bind/MarshalException:<init>	(Ljava/lang/String;Ljava/lang/Throwable;)V
/*     */     //   142: athrow
/*     */     //
/*     */     // Exception table:
/*     */     //   from	to	target	type
/*     */     //   100	118	119	java/io/UnsupportedEncodingException } 
/* 467 */   public Object getProperty(String name) throws PropertyException { if ("com.sun.xml.bind.indentString".equals(name))
/* 468 */       return this.indent;
/* 469 */     if (("com.sun.xml.bind.characterEscapeHandler".equals(name)) || ("com.sun.xml.bind.marshaller.CharacterEscapeHandler".equals(name)))
/* 470 */       return this.escapeHandler;
/* 471 */     if ("com.sun.xml.bind.namespacePrefixMapper".equals(name))
/* 472 */       return this.prefixMapper;
/* 473 */     if ("com.sun.xml.bind.xmlDeclaration".equals(name))
/* 474 */       return Boolean.valueOf(!isFragment());
/* 475 */     if ("com.sun.xml.bind.xmlHeaders".equals(name))
/* 476 */       return this.header;
/* 477 */     if ("com.sun.xml.bind.c14n".equals(name))
/* 478 */       return Boolean.valueOf(this.c14nSupport);
/* 479 */     if ("com.sun.xml.bind.objectIdentitityCycleDetection".equals(name)) {
/* 480 */       return Boolean.valueOf(this.serializer.getObjectIdentityCycleDetection());
/*     */     }
/*     */ 
/* 483 */     return super.getProperty(name); }
/*     */ 
/*     */   public void setProperty(String name, Object value) throws PropertyException
/*     */   {
/* 487 */     if ("com.sun.xml.bind.indentString".equals(name)) {
/* 488 */       checkString(name, value);
/* 489 */       this.indent = ((String)value);
/* 490 */       return;
/*     */     }
/* 492 */     if (("com.sun.xml.bind.characterEscapeHandler".equals(name)) || ("com.sun.xml.bind.marshaller.CharacterEscapeHandler".equals(name))) {
/* 493 */       if (!(value instanceof CharacterEscapeHandler)) {
/* 494 */         throw new PropertyException(Messages.MUST_BE_X.format(new Object[] { name, CharacterEscapeHandler.class.getName(), value.getClass().getName() }));
/*     */       }
/*     */ 
/* 499 */       this.escapeHandler = ((CharacterEscapeHandler)value);
/* 500 */       return;
/*     */     }
/* 502 */     if ("com.sun.xml.bind.namespacePrefixMapper".equals(name)) {
/* 503 */       if (!(value instanceof NamespacePrefixMapper)) {
/* 504 */         throw new PropertyException(Messages.MUST_BE_X.format(new Object[] { name, NamespacePrefixMapper.class.getName(), value.getClass().getName() }));
/*     */       }
/*     */ 
/* 509 */       this.prefixMapper = ((NamespacePrefixMapper)value);
/* 510 */       return;
/*     */     }
/* 512 */     if ("com.sun.xml.bind.xmlDeclaration".equals(name)) {
/* 513 */       checkBoolean(name, value);
/*     */ 
/* 516 */       super.setProperty("jaxb.fragment", Boolean.valueOf(!((Boolean)value).booleanValue()));
/* 517 */       return;
/*     */     }
/* 519 */     if ("com.sun.xml.bind.xmlHeaders".equals(name)) {
/* 520 */       checkString(name, value);
/* 521 */       this.header = ((String)value);
/* 522 */       return;
/*     */     }
/* 524 */     if ("com.sun.xml.bind.c14n".equals(name)) {
/* 525 */       checkBoolean(name, value);
/* 526 */       this.c14nSupport = ((Boolean)value).booleanValue();
/* 527 */       return;
/*     */     }
/* 529 */     if ("com.sun.xml.bind.objectIdentitityCycleDetection".equals(name)) {
/* 530 */       checkBoolean(name, value);
/* 531 */       this.serializer.setObjectIdentityCycleDetection(((Boolean)value).booleanValue());
/* 532 */       return;
/*     */     }
/*     */ 
/* 535 */     super.setProperty(name, value);
/*     */   }
/*     */ 
/*     */   private void checkBoolean(String name, Object value)
/*     */     throws PropertyException
/*     */   {
/* 542 */     if (!(value instanceof Boolean))
/* 543 */       throw new PropertyException(Messages.MUST_BE_X.format(new Object[] { name, Boolean.class.getName(), value.getClass().getName() }));
/*     */   }
/*     */ 
/*     */   private void checkString(String name, Object value)
/*     */     throws PropertyException
/*     */   {
/* 554 */     if (!(value instanceof String))
/* 555 */       throw new PropertyException(Messages.MUST_BE_X.format(new Object[] { name, String.class.getName(), value.getClass().getName() }));
/*     */   }
/*     */ 
/*     */   public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter)
/*     */   {
/* 564 */     if (type == null)
/* 565 */       throw new IllegalArgumentException();
/* 566 */     this.serializer.putAdapter(type, adapter);
/*     */   }
/*     */ 
/*     */   public <A extends XmlAdapter> A getAdapter(Class<A> type)
/*     */   {
/* 571 */     if (type == null)
/* 572 */       throw new IllegalArgumentException();
/* 573 */     if (this.serializer.containsAdapter(type))
/*     */     {
/* 575 */       return this.serializer.getAdapter(type);
/*     */     }
/* 577 */     return null;
/*     */   }
/*     */ 
/*     */   public void setAttachmentMarshaller(AttachmentMarshaller am)
/*     */   {
/* 582 */     this.serializer.attachmentMarshaller = am;
/*     */   }
/*     */ 
/*     */   public AttachmentMarshaller getAttachmentMarshaller()
/*     */   {
/* 587 */     return this.serializer.attachmentMarshaller;
/*     */   }
/*     */ 
/*     */   public Schema getSchema() {
/* 591 */     return this.schema;
/*     */   }
/*     */ 
/*     */   public void setSchema(Schema s) {
/* 595 */     this.schema = s;
/*     */   }
/*     */ 
/*     */   public boolean handleEvent(ValidationEvent event)
/*     */   {
/* 603 */     return false;
/*     */   }
/*     */ 
/*     */   public Marshaller.Listener getListener() {
/* 607 */     return this.externalListener;
/*     */   }
/*     */ 
/*     */   public void setListener(Marshaller.Listener listener) {
/* 611 */     this.externalListener = listener;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.MarshallerImpl
 * JD-Core Version:    0.6.0
 */