/*     */ package com.sun.xml.bind.v2.runtime;
/*     */ 
/*     */ import com.sun.xml.bind.v2.ClassFactory;
/*     */ import java.util.HashMap;
/*     */ import javax.xml.bind.ValidationEventHandler;
/*     */ import javax.xml.bind.ValidationEventLocator;
/*     */ import javax.xml.bind.annotation.adapters.XmlAdapter;
/*     */ import javax.xml.bind.helpers.ValidationEventImpl;
/*     */ import org.xml.sax.ErrorHandler;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.SAXParseException;
/*     */ 
/*     */ public abstract class Coordinator
/*     */   implements ErrorHandler, ValidationEventHandler
/*     */ {
/*  78 */   private final HashMap<Class<? extends XmlAdapter>, XmlAdapter> adapters = new HashMap();
/*     */   private Coordinator old;
/*     */   private Coordinator[] table;
/*     */   public Exception guyWhoSetTheTableToNull;
/*     */   private static final ThreadLocal<Coordinator[]> activeTable;
/*     */   public static boolean debugTableNPE;
/*     */ 
/*     */   public final XmlAdapter putAdapter(Class<? extends XmlAdapter> c, XmlAdapter a)
/*     */   {
/*  83 */     if (a == null) {
/*  84 */       return (XmlAdapter)this.adapters.remove(c);
/*     */     }
/*  86 */     return (XmlAdapter)this.adapters.put(c, a);
/*     */   }
/*     */ 
/*     */   public final <T extends XmlAdapter> T getAdapter(Class<T> key)
/*     */   {
/*  96 */     XmlAdapter v = (XmlAdapter)key.cast(this.adapters.get(key));
/*  97 */     if (v == null) {
/*  98 */       v = (XmlAdapter)ClassFactory.create(key);
/*  99 */       putAdapter(key, v);
/*     */     }
/* 101 */     return v;
/*     */   }
/*     */ 
/*     */   public <T extends XmlAdapter> boolean containsAdapter(Class<T> type) {
/* 105 */     return this.adapters.containsKey(type);
/*     */   }
/*     */ 
/*     */   protected final void setThreadAffinity()
/*     */   {
/* 131 */     this.table = ((Coordinator[])activeTable.get());
/* 132 */     assert (this.table != null);
/*     */   }
/*     */ 
/*     */   protected final void resetThreadAffinity()
/*     */   {
/* 140 */     if (debugTableNPE)
/* 141 */       this.guyWhoSetTheTableToNull = new Exception();
/* 142 */     this.table = null;
/*     */   }
/*     */ 
/*     */   protected final void pushCoordinator()
/*     */   {
/* 149 */     this.old = this.table[0];
/* 150 */     this.table[0] = this;
/*     */   }
/*     */ 
/*     */   protected final void popCoordinator()
/*     */   {
/* 157 */     assert (this.table[0] == this);
/* 158 */     this.table[0] = this.old;
/* 159 */     this.old = null;
/*     */   }
/*     */ 
/*     */   public static Coordinator _getInstance() {
/* 163 */     return ((Coordinator[])activeTable.get())[0];
/*     */   }
/*     */ 
/*     */   protected abstract ValidationEventLocator getLocation();
/*     */ 
/*     */   public final void error(SAXParseException exception)
/*     */     throws SAXException
/*     */   {
/* 185 */     propagateEvent(1, exception);
/*     */   }
/*     */ 
/*     */   public final void warning(SAXParseException exception) throws SAXException {
/* 189 */     propagateEvent(0, exception);
/*     */   }
/*     */ 
/*     */   public final void fatalError(SAXParseException exception) throws SAXException {
/* 193 */     propagateEvent(2, exception);
/*     */   }
/*     */ 
/*     */   private void propagateEvent(int severity, SAXParseException saxException)
/*     */     throws SAXException
/*     */   {
/* 199 */     ValidationEventImpl ve = new ValidationEventImpl(severity, saxException.getMessage(), getLocation());
/*     */ 
/* 202 */     Exception e = saxException.getException();
/* 203 */     if (e != null)
/* 204 */       ve.setLinkedException(e);
/*     */     else {
/* 206 */       ve.setLinkedException(saxException);
/*     */     }
/*     */ 
/* 211 */     boolean result = handleEvent(ve);
/* 212 */     if (!result)
/*     */     {
/* 215 */       throw saxException;
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 167 */     activeTable = new ThreadLocal() {
/*     */       public Coordinator[] initialValue() {
/* 169 */         return new Coordinator[1];
/*     */       }
/*     */ 
/*     */     };
/*     */     try
/*     */     {
/* 223 */       debugTableNPE = Boolean.getBoolean(Coordinator.class.getName() + ".debugTableNPE");
/*     */     }
/*     */     catch (SecurityException t)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.Coordinator
 * JD-Core Version:    0.6.0
 */