/*     */ package com.sun.xml.bind.v2.runtime;
/*     */ 
/*     */ import com.sun.xml.bind.v2.model.runtime.RuntimeTypeInfo;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.DomLoader;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.Loader;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.XsiTypeLoader;
/*     */ import java.io.IOException;
/*     */ import javax.xml.bind.annotation.W3CDomHandler;
/*     */ import javax.xml.bind.helpers.ValidationEventImpl;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.stream.XMLStreamException;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ final class AnyTypeBeanInfo extends JaxBeanInfo<Object>
/*     */ {
/* 175 */   private static final W3CDomHandler domHandler = new W3CDomHandler();
/* 176 */   private static final DomLoader domLoader = new DomLoader(domHandler);
/* 177 */   private final XsiTypeLoader substLoader = new XsiTypeLoader(this);
/*     */ 
/*     */   public AnyTypeBeanInfo(JAXBContextImpl grammar, RuntimeTypeInfo anyTypeInfo)
/*     */   {
/*  69 */     super(grammar, anyTypeInfo, Object.class, new QName("http://www.w3.org/2001/XMLSchema", "anyType"), false, true, false);
/*     */   }
/*     */ 
/*     */   public String getElementNamespaceURI(Object element) {
/*  73 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public String getElementLocalName(Object element) {
/*  77 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Object createInstance(UnmarshallingContext context) {
/*  81 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean reset(Object element, UnmarshallingContext context)
/*     */   {
/*  86 */     return false;
/*     */   }
/*     */ 
/*     */   public String getId(Object element, XMLSerializer target)
/*     */   {
/*  97 */     return null;
/*     */   }
/*     */ 
/*     */   public void serializeBody(Object element, XMLSerializer target) throws SAXException, IOException, XMLStreamException {
/* 101 */     NodeList childNodes = ((Element)element).getChildNodes();
/* 102 */     int len = childNodes.getLength();
/* 103 */     for (int i = 0; i < len; i++) {
/* 104 */       Node child = childNodes.item(i);
/* 105 */       switch (child.getNodeType()) {
/*     */       case 3:
/*     */       case 4:
/* 108 */         target.text(child.getNodeValue(), null);
/* 109 */         break;
/*     */       case 1:
/* 111 */         target.writeDom((Element)child, domHandler, null, null);
/*     */       case 2:
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void serializeAttributes(Object element, XMLSerializer target) throws SAXException {
/* 118 */     NamedNodeMap al = ((Element)element).getAttributes();
/* 119 */     int len = al.getLength();
/* 120 */     for (int i = 0; i < len; i++) {
/* 121 */       Attr a = (Attr)al.item(i);
/*     */ 
/* 123 */       String uri = a.getNamespaceURI();
/* 124 */       if (uri == null) uri = "";
/* 125 */       String local = a.getLocalName();
/* 126 */       String name = a.getName();
/* 127 */       if (local == null) local = name;
/*     */ 
/* 129 */       if (name.startsWith("xmlns"))
/*     */         continue;
/* 131 */       target.attribute(uri, local, a.getValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void serializeRoot(Object element, XMLSerializer target) throws SAXException {
/* 136 */     target.reportError(new ValidationEventImpl(1, Messages.UNABLE_TO_MARSHAL_NON_ELEMENT.format(new Object[] { element.getClass().getName() }), null, null));
/*     */   }
/*     */ 
/*     */   public void serializeURIs(Object element, XMLSerializer target)
/*     */   {
/* 145 */     NamedNodeMap al = ((Element)element).getAttributes();
/* 146 */     int len = al.getLength();
/* 147 */     NamespaceContext2 context = target.getNamespaceContext();
/* 148 */     for (int i = 0; i < len; i++) {
/* 149 */       Attr a = (Attr)al.item(i);
/* 150 */       if ("xmlns".equals(a.getPrefix())) {
/* 151 */         context.force(a.getValue(), a.getLocalName());
/*     */       }
/* 154 */       else if ("xmlns".equals(a.getName())) {
/* 155 */         context.force(a.getValue(), "");
/*     */       }
/*     */       else {
/* 158 */         String nsUri = a.getNamespaceURI();
/* 159 */         if ((nsUri != null) && (nsUri.length() > 0))
/* 160 */           context.declareNamespace(nsUri, a.getPrefix(), true); 
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Transducer<Object> getTransducer() {
/* 165 */     return null;
/*     */   }
/*     */ 
/*     */   public Loader getLoader(JAXBContextImpl context, boolean typeSubstitutionCapable) {
/* 169 */     if (typeSubstitutionCapable) {
/* 170 */       return this.substLoader;
/*     */     }
/* 172 */     return domLoader;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.AnyTypeBeanInfo
 * JD-Core Version:    0.6.0
 */