/*     */ package com.sun.xml.bind.v2.model.impl;
/*     */ 
/*     */ import com.sun.xml.bind.api.impl.NameConverter;
/*     */ import com.sun.xml.bind.v2.model.annotation.AnnotationReader;
/*     */ import com.sun.xml.bind.v2.model.core.AttributePropertyInfo;
/*     */ import com.sun.xml.bind.v2.model.core.PropertyKind;
/*     */ import com.sun.xml.bind.v2.model.nav.Navigator;
/*     */ import javax.xml.bind.annotation.XmlAttribute;
/*     */ import javax.xml.bind.annotation.XmlSchema;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ class AttributePropertyInfoImpl<TypeT, ClassDeclT, FieldT, MethodT> extends SingleTypePropertyInfoImpl<TypeT, ClassDeclT, FieldT, MethodT>
/*     */   implements AttributePropertyInfo<TypeT, ClassDeclT>
/*     */ {
/*     */   private final QName xmlName;
/*     */   private final boolean isRequired;
/*     */ 
/*     */   AttributePropertyInfoImpl(ClassInfoImpl<TypeT, ClassDeclT, FieldT, MethodT> parent, PropertySeed<TypeT, ClassDeclT, FieldT, MethodT> seed)
/*     */   {
/*  59 */     super(parent, seed);
/*  60 */     XmlAttribute att = (XmlAttribute)seed.readAnnotation(XmlAttribute.class);
/*  61 */     assert (att != null);
/*     */ 
/*  63 */     if (att.required())
/*  64 */       this.isRequired = true;
/*  65 */     else this.isRequired = nav().isPrimitive(getIndividualType());
/*     */ 
/*  67 */     this.xmlName = calcXmlName(att);
/*     */   }
/*     */ 
/*     */   private QName calcXmlName(XmlAttribute att)
/*     */   {
/*  74 */     String uri = att.namespace();
/*  75 */     String local = att.name();
/*     */ 
/*  78 */     if (local.equals("##default"))
/*  79 */       local = NameConverter.standard.toVariableName(getName());
/*  80 */     if (uri.equals("##default")) {
/*  81 */       XmlSchema xs = (XmlSchema)reader().getPackageAnnotation(XmlSchema.class, this.parent.getClazz(), this);
/*     */ 
/*  84 */       if (xs != null)
/*  85 */         switch (1.$SwitchMap$javax$xml$bind$annotation$XmlNsForm[xs.attributeFormDefault().ordinal()]) {
/*     */         case 1:
/*  87 */           uri = this.parent.getTypeName().getNamespaceURI();
/*  88 */           if (uri.length() != 0) break;
/*  89 */           uri = this.parent.builder.defaultNsUri; break;
/*     */         case 2:
/*     */         case 3:
/*  93 */           uri = "";
/*     */         }
/*     */       else {
/*  96 */         uri = "";
/*     */       }
/*     */     }
/*  99 */     return new QName(uri.intern(), local.intern());
/*     */   }
/*     */ 
/*     */   public boolean isRequired() {
/* 103 */     return this.isRequired;
/*     */   }
/*     */ 
/*     */   public final QName getXmlName() {
/* 107 */     return this.xmlName;
/*     */   }
/*     */ 
/*     */   public final PropertyKind kind() {
/* 111 */     return PropertyKind.ATTRIBUTE;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.model.impl.AttributePropertyInfoImpl
 * JD-Core Version:    0.6.0
 */