/*     */ package com.sun.xml.bind.marshaller;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.Writer;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map.Entry;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.helpers.AttributesImpl;
/*     */ import org.xml.sax.helpers.XMLFilterImpl;
/*     */ 
/*     */ public class XMLWriter extends XMLFilterImpl
/*     */ {
/* 409 */   private final HashMap<String, String> locallyDeclaredPrefix = new HashMap();
/*     */ 
/* 963 */   private final Attributes EMPTY_ATTS = new AttributesImpl();
/*     */ 
/* 971 */   private int elementLevel = 0;
/*     */   private Writer output;
/*     */   private String encoding;
/* 974 */   private boolean writeXmlDecl = true;
/*     */ 
/* 980 */   private String header = null;
/*     */   private final CharacterEscapeHandler escapeHandler;
/* 984 */   private boolean startTagIsClosed = true;
/*     */ 
/*     */   public XMLWriter(Writer writer, String encoding, CharacterEscapeHandler _escapeHandler)
/*     */   {
/* 290 */     init(writer, encoding);
/* 291 */     this.escapeHandler = _escapeHandler;
/*     */   }
/*     */ 
/*     */   public XMLWriter(Writer writer, String encoding) {
/* 295 */     this(writer, encoding, DumbEscapeHandler.theInstance);
/*     */   }
/*     */ 
/*     */   private void init(Writer writer, String encoding)
/*     */   {
/* 310 */     setOutput(writer, encoding);
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 341 */     this.elementLevel = 0;
/* 342 */     this.startTagIsClosed = true;
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */     throws IOException
/*     */   {
/* 363 */     this.output.flush();
/*     */   }
/*     */ 
/*     */   public void setOutput(Writer writer, String _encoding)
/*     */   {
/* 376 */     if (writer == null)
/* 377 */       this.output = new OutputStreamWriter(System.out);
/*     */     else {
/* 379 */       this.output = writer;
/*     */     }
/* 381 */     this.encoding = _encoding;
/*     */   }
/*     */ 
/*     */   public void setXmlDecl(boolean _writeXmlDecl)
/*     */   {
/* 391 */     this.writeXmlDecl = _writeXmlDecl;
/*     */   }
/*     */ 
/*     */   public void setHeader(String _header)
/*     */   {
/* 405 */     this.header = _header;
/*     */   }
/*     */ 
/*     */   public void startPrefixMapping(String prefix, String uri)
/*     */     throws SAXException
/*     */   {
/* 411 */     this.locallyDeclaredPrefix.put(prefix, uri);
/*     */   }
/*     */ 
/*     */   public void startDocument()
/*     */     throws SAXException
/*     */   {
/*     */     try
/*     */     {
/* 433 */       reset();
/*     */ 
/* 435 */       if (this.writeXmlDecl) {
/* 436 */         String e = "";
/* 437 */         if (this.encoding != null) {
/* 438 */           e = " encoding=\"" + this.encoding + '"';
/*     */         }
/* 440 */         writeXmlDecl("<?xml version=\"1.0\"" + e + " standalone=\"yes\"?>");
/*     */       }
/*     */ 
/* 443 */       if (this.header != null) {
/* 444 */         write(this.header);
/*     */       }
/* 446 */       super.startDocument();
/*     */     } catch (IOException e) {
/* 448 */       throw new SAXException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void writeXmlDecl(String decl) throws IOException {
/* 453 */     write(decl);
/*     */   }
/*     */ 
/*     */   public void endDocument()
/*     */     throws SAXException
/*     */   {
/*     */     try
/*     */     {
/* 471 */       super.endDocument();
/* 472 */       flush();
/*     */     } catch (IOException e) {
/* 474 */       throw new SAXException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void startElement(String uri, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/*     */     try
/*     */     {
/* 503 */       if (!this.startTagIsClosed) {
/* 504 */         write(">");
/*     */       }
/* 506 */       this.elementLevel += 1;
/*     */ 
/* 509 */       write('<');
/* 510 */       write(qName);
/* 511 */       writeAttributes(atts);
/*     */ 
/* 514 */       if (!this.locallyDeclaredPrefix.isEmpty()) {
/* 515 */         for (Map.Entry e : this.locallyDeclaredPrefix.entrySet()) {
/* 516 */           String p = (String)e.getKey();
/* 517 */           String u = (String)e.getValue();
/* 518 */           if (u == null) {
/* 519 */             u = "";
/*     */           }
/* 521 */           write(' ');
/* 522 */           if ("".equals(p)) {
/* 523 */             write("xmlns=\"");
/*     */           } else {
/* 525 */             write("xmlns:");
/* 526 */             write(p);
/* 527 */             write("=\"");
/*     */           }
/* 529 */           char[] ch = u.toCharArray();
/* 530 */           writeEsc(ch, 0, ch.length, true);
/* 531 */           write('"');
/*     */         }
/* 533 */         this.locallyDeclaredPrefix.clear();
/*     */       }
/*     */ 
/* 540 */       super.startElement(uri, localName, qName, atts);
/* 541 */       this.startTagIsClosed = false;
/*     */     } catch (IOException e) {
/* 543 */       throw new SAXException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void endElement(String uri, String localName, String qName)
/*     */     throws SAXException
/*     */   {
/*     */     try
/*     */     {
/* 570 */       if (this.startTagIsClosed) {
/* 571 */         write("</");
/* 572 */         write(qName);
/* 573 */         write('>');
/*     */       } else {
/* 575 */         write("/>");
/* 576 */         this.startTagIsClosed = true;
/*     */       }
/* 578 */       super.endElement(uri, localName, qName);
/*     */ 
/* 580 */       this.elementLevel -= 1;
/*     */     } catch (IOException e) {
/* 582 */       throw new SAXException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int len)
/*     */     throws SAXException
/*     */   {
/*     */     try
/*     */     {
/* 604 */       if (!this.startTagIsClosed) {
/* 605 */         write('>');
/* 606 */         this.startTagIsClosed = true;
/*     */       }
/* 608 */       writeEsc(ch, start, len, false);
/* 609 */       super.characters(ch, start, len);
/*     */     } catch (IOException e) {
/* 611 */       throw new SAXException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void ignorableWhitespace(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/*     */     try
/*     */     {
/* 633 */       writeEsc(ch, start, length, false);
/* 634 */       super.ignorableWhitespace(ch, start, length);
/*     */     } catch (IOException e) {
/* 636 */       throw new SAXException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processingInstruction(String target, String data)
/*     */     throws SAXException
/*     */   {
/*     */     try
/*     */     {
/* 658 */       if (!this.startTagIsClosed) {
/* 659 */         write('>');
/* 660 */         this.startTagIsClosed = true;
/*     */       }
/* 662 */       write("<?");
/* 663 */       write(target);
/* 664 */       write(' ');
/* 665 */       write(data);
/* 666 */       write("?>");
/* 667 */       if (this.elementLevel < 1) {
/* 668 */         write('\n');
/*     */       }
/* 670 */       super.processingInstruction(target, data);
/*     */     } catch (IOException e) {
/* 672 */       throw new SAXException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void startElement(String uri, String localName)
/*     */     throws SAXException
/*     */   {
/* 703 */     startElement(uri, localName, "", this.EMPTY_ATTS);
/*     */   }
/*     */ 
/*     */   public void startElement(String localName)
/*     */     throws SAXException
/*     */   {
/* 725 */     startElement("", localName, "", this.EMPTY_ATTS);
/*     */   }
/*     */ 
/*     */   public void endElement(String uri, String localName)
/*     */     throws SAXException
/*     */   {
/* 746 */     endElement(uri, localName, "");
/*     */   }
/*     */ 
/*     */   public void endElement(String localName)
/*     */     throws SAXException
/*     */   {
/* 767 */     endElement("", localName, "");
/*     */   }
/*     */ 
/*     */   public void dataElement(String uri, String localName, String qName, Attributes atts, String content)
/*     */     throws SAXException
/*     */   {
/* 801 */     startElement(uri, localName, qName, atts);
/* 802 */     characters(content);
/* 803 */     endElement(uri, localName, qName);
/*     */   }
/*     */ 
/*     */   public void dataElement(String uri, String localName, String content)
/*     */     throws SAXException
/*     */   {
/* 834 */     dataElement(uri, localName, "", this.EMPTY_ATTS, content);
/*     */   }
/*     */ 
/*     */   public void dataElement(String localName, String content)
/*     */     throws SAXException
/*     */   {
/* 865 */     dataElement("", localName, "", this.EMPTY_ATTS, content);
/*     */   }
/*     */ 
/*     */   public void characters(String data)
/*     */     throws SAXException
/*     */   {
/*     */     try
/*     */     {
/* 884 */       if (!this.startTagIsClosed) {
/* 885 */         write('>');
/* 886 */         this.startTagIsClosed = true;
/*     */       }
/* 888 */       char[] ch = data.toCharArray();
/* 889 */       characters(ch, 0, ch.length);
/*     */     } catch (IOException e) {
/* 891 */       throw new SAXException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected final void write(char c)
/*     */     throws IOException
/*     */   {
/* 910 */     this.output.write(c);
/*     */   }
/*     */ 
/*     */   protected final void write(String s)
/*     */     throws IOException
/*     */   {
/* 918 */     this.output.write(s);
/*     */   }
/*     */ 
/*     */   private void writeAttributes(Attributes atts)
/*     */     throws IOException
/*     */   {
/* 930 */     int len = atts.getLength();
/* 931 */     for (int i = 0; i < len; i++) {
/* 932 */       char[] ch = atts.getValue(i).toCharArray();
/* 933 */       write(' ');
/* 934 */       write(atts.getQName(i));
/* 935 */       write("=\"");
/* 936 */       writeEsc(ch, 0, ch.length, true);
/* 937 */       write('"');
/*     */     }
/*     */   }
/*     */ 
/*     */   private void writeEsc(char[] ch, int start, int length, boolean isAttVal)
/*     */     throws IOException
/*     */   {
/* 954 */     this.escapeHandler.escape(ch, start, length, isAttVal, this.output);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.marshaller.XMLWriter
 * JD-Core Version:    0.6.0
 */