package antlr.preprocessor;

import antlr.collections.impl.IndexedVector;
import java.util.Enumeration;

class Rule
{
  protected String name;
  protected String block;
  protected String args;
  protected String returnValue;
  protected String throwsSpec;
  protected String initAction;
  protected IndexedVector options;
  protected String visibility;
  protected Grammar enclosingGrammar;
  protected boolean bang = false;

  public Rule(String paramString1, String paramString2, IndexedVector paramIndexedVector, Grammar paramGrammar)
  {
    this.name = paramString1;
    this.block = paramString2;
    this.options = paramIndexedVector;
    setEnclosingGrammar(paramGrammar);
  }

  public String getArgs()
  {
    return this.args;
  }

  public boolean getBang()
  {
    return this.bang;
  }

  public String getName()
  {
    return this.name;
  }

  public String getReturnValue()
  {
    return this.returnValue;
  }

  public String getVisibility()
  {
    return this.visibility;
  }

  public boolean narrowerVisibility(Rule paramRule)
  {
    if (this.visibility.equals("public"))
      return !paramRule.equals("public");
    if (this.visibility.equals("protected"))
      return paramRule.equals("private");
    return !this.visibility.equals("private");
  }

  public boolean sameSignature(Rule paramRule)
  {
    boolean bool1 = true;
    boolean bool2 = true;
    boolean bool3 = true;
    bool1 = this.name.equals(paramRule.getName());
    if (this.args != null)
      bool2 = this.args.equals(paramRule.getArgs());
    if (this.returnValue != null)
      bool3 = this.returnValue.equals(paramRule.getReturnValue());
    return (bool1) && (bool2) && (bool3);
  }

  public void setArgs(String paramString)
  {
    this.args = paramString;
  }

  public void setBang()
  {
    this.bang = true;
  }

  public void setEnclosingGrammar(Grammar paramGrammar)
  {
    this.enclosingGrammar = paramGrammar;
  }

  public void setInitAction(String paramString)
  {
    this.initAction = paramString;
  }

  public void setOptions(IndexedVector paramIndexedVector)
  {
    this.options = paramIndexedVector;
  }

  public void setReturnValue(String paramString)
  {
    this.returnValue = paramString;
  }

  public void setThrowsSpec(String paramString)
  {
    this.throwsSpec = paramString;
  }

  public void setVisibility(String paramString)
  {
    this.visibility = paramString;
  }

  public String toString()
  {
    String str1 = "";
    String str2 = "returns " + this.returnValue;
    String str3 = this.args == null ? "" : this.args;
    String str4 = getBang() ? "!" : "";
    str1 = str1 + (this.visibility == null ? "" : new StringBuffer().append(this.visibility).append(" ").toString());
    str1 = str1 + this.name + str4 + str3 + " " + str2 + this.throwsSpec;
    if (this.options != null)
    {
      str1 = str1 + System.getProperty("line.separator") + "options {" + System.getProperty("line.separator");
      Enumeration localEnumeration = this.options.elements();
      while (localEnumeration.hasMoreElements())
        str1 = str1 + (Option)localEnumeration.nextElement() + System.getProperty("line.separator");
      str1 = str1 + "}" + System.getProperty("line.separator");
    }
    if (this.initAction != null)
      str1 = str1 + this.initAction + System.getProperty("line.separator");
    str1 = str1 + this.block;
    return str1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.preprocessor.Rule
 * JD-Core Version:    0.6.0
 */