package antlr.preprocessor;

import antlr.ANTLRHashString;
import antlr.ANTLRStringBuffer;
import antlr.ByteBuffer;
import antlr.CharBuffer;
import antlr.CharScanner;
import antlr.CharStreamException;
import antlr.CharStreamIOException;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.NoViableAltForCharException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.impl.BitSet;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;

public class PreprocessorLexer extends CharScanner
  implements PreprocessorTokenTypes, TokenStream
{
  public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
  public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
  public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
  public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
  public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
  public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
  public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
  public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
  public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
  public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
  public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());

  public PreprocessorLexer(InputStream paramInputStream)
  {
    this(new ByteBuffer(paramInputStream));
  }

  public PreprocessorLexer(Reader paramReader)
  {
    this(new CharBuffer(paramReader));
  }

  public PreprocessorLexer(InputBuffer paramInputBuffer)
  {
    this(new LexerSharedInputState(paramInputBuffer));
  }

  public PreprocessorLexer(LexerSharedInputState paramLexerSharedInputState)
  {
    super(paramLexerSharedInputState);
    this.caseSensitiveLiterals = true;
    setCaseSensitive(true);
    this.literals = new Hashtable();
    this.literals.put(new ANTLRHashString("public", this), new Integer(18));
    this.literals.put(new ANTLRHashString("class", this), new Integer(8));
    this.literals.put(new ANTLRHashString("throws", this), new Integer(23));
    this.literals.put(new ANTLRHashString("catch", this), new Integer(26));
    this.literals.put(new ANTLRHashString("private", this), new Integer(17));
    this.literals.put(new ANTLRHashString("extends", this), new Integer(10));
    this.literals.put(new ANTLRHashString("protected", this), new Integer(16));
    this.literals.put(new ANTLRHashString("returns", this), new Integer(21));
    this.literals.put(new ANTLRHashString("tokens", this), new Integer(4));
    this.literals.put(new ANTLRHashString("exception", this), new Integer(25));
  }

  public Token nextToken()
    throws TokenStreamException
  {
    Token localToken = null;
    while (true)
    {
      Object localObject = null;
      int i = 0;
      resetText();
      try
      {
        switch (LA(1))
        {
        case ':':
          mRULE_BLOCK(true);
          localToken = this._returnToken;
          break;
        case '\t':
        case '\n':
        case '\r':
        case ' ':
          mWS(true);
          localToken = this._returnToken;
          break;
        case '/':
          mCOMMENT(true);
          localToken = this._returnToken;
          break;
        case '{':
          mACTION(true);
          localToken = this._returnToken;
          break;
        case '"':
          mSTRING_LITERAL(true);
          localToken = this._returnToken;
          break;
        case '\'':
          mCHAR_LITERAL(true);
          localToken = this._returnToken;
          break;
        case '!':
          mBANG(true);
          localToken = this._returnToken;
          break;
        case ';':
          mSEMI(true);
          localToken = this._returnToken;
          break;
        case ',':
          mCOMMA(true);
          localToken = this._returnToken;
          break;
        case '}':
          mRCURLY(true);
          localToken = this._returnToken;
          break;
        case ')':
          mRPAREN(true);
          localToken = this._returnToken;
          break;
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':
          mID_OR_KEYWORD(true);
          localToken = this._returnToken;
          break;
        case '=':
          mASSIGN_RHS(true);
          localToken = this._returnToken;
          break;
        case '[':
          mARG_ACTION(true);
          localToken = this._returnToken;
          break;
        case '\013':
        case '\f':
        case '\016':
        case '\017':
        case '\020':
        case '\021':
        case '\022':
        case '\023':
        case '\024':
        case '\025':
        case '\026':
        case '\027':
        case '\030':
        case '\031':
        case '\032':
        case '\033':
        case '\034':
        case '\035':
        case '\036':
        case '\037':
        case '#':
        case '$':
        case '%':
        case '&':
        case '(':
        case '*':
        case '+':
        case '-':
        case '.':
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case '<':
        case '>':
        case '?':
        case '@':
        case '\\':
        case ']':
        case '^':
        case '`':
        case '|':
        default:
          if ((LA(1) == '(') && (_tokenSet_0.member(LA(2))))
          {
            mSUBRULE_BLOCK(true);
            localToken = this._returnToken;
          }
          else if (LA(1) == '(')
          {
            mLPAREN(true);
            localToken = this._returnToken;
          }
          else if (LA(1) == 65535)
          {
            uponEOF();
            this._returnToken = makeToken(1);
          }
          else
          {
            throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
          }
        }
        if (this._returnToken == null)
          continue;
        i = this._returnToken.getType();
        i = testLiteralsTable(i);
        this._returnToken.setType(i);
        return this._returnToken;
      }
      catch (RecognitionException localRecognitionException)
      {
        throw new TokenStreamRecognitionException(localRecognitionException);
      }
      catch (CharStreamException localCharStreamException)
      {
        if (!(localCharStreamException instanceof CharStreamIOException))
          break;
        throw new TokenStreamIOException(((CharStreamIOException)localCharStreamException).io);
      }
    }
    throw new TokenStreamException(localCharStreamException.getMessage());
  }

  public final void mRULE_BLOCK(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 22;
    match(':');
    int k;
    if ((_tokenSet_1.member(LA(1))) && (_tokenSet_2.member(LA(2))))
    {
      k = this.text.length();
      mWS(false);
      this.text.setLength(k);
    }
    else if (!_tokenSet_2.member(LA(1)))
    {
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    mALT(false);
    switch (LA(1))
    {
    case '\t':
    case '\n':
    case '\r':
    case ' ':
      k = this.text.length();
      mWS(false);
      this.text.setLength(k);
      break;
    case ';':
    case '|':
      break;
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    while (LA(1) == '|')
    {
      match('|');
      if ((_tokenSet_1.member(LA(1))) && (_tokenSet_2.member(LA(2))))
      {
        k = this.text.length();
        mWS(false);
        this.text.setLength(k);
      }
      else if (!_tokenSet_2.member(LA(1)))
      {
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      mALT(false);
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        k = this.text.length();
        mWS(false);
        this.text.setLength(k);
        break;
      case ';':
      case '|':
        break;
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    }
    match(';');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mWS(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 33;
    for (int k = 0; ; k++)
      if (LA(1) == ' ')
      {
        match(' ');
      }
      else if (LA(1) == '\t')
      {
        match('\t');
      }
      else if ((LA(1) == '\n') || (LA(1) == '\r'))
      {
        mNEWLINE(false);
      }
      else
      {
        if (k >= 1)
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    i = -1;
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mALT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 27;
    while ((_tokenSet_3.member(LA(1))) && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      mELEMENT(false);
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mSUBRULE_BLOCK(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 6;
    match('(');
    if ((_tokenSet_1.member(LA(1))) && (_tokenSet_0.member(LA(2))))
      mWS(false);
    else if (!_tokenSet_0.member(LA(1)))
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    mALT(false);
    while ((_tokenSet_4.member(LA(1))) && (_tokenSet_0.member(LA(2))))
    {
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        mWS(false);
        break;
      case '|':
        break;
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      match('|');
      if ((_tokenSet_1.member(LA(1))) && (_tokenSet_0.member(LA(2))))
        mWS(false);
      else if (!_tokenSet_0.member(LA(1)))
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      mALT(false);
    }
    switch (LA(1))
    {
    case '\t':
    case '\n':
    case '\r':
    case ' ':
      mWS(false);
      break;
    case ')':
      break;
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    match(')');
    if ((LA(1) == '=') && (LA(2) == '>'))
      match("=>");
    else if (LA(1) == '*')
      match('*');
    else if (LA(1) == '+')
      match('+');
    else if (LA(1) == '?')
      match('?');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mELEMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 28;
    switch (LA(1))
    {
    case '/':
      mCOMMENT(false);
      break;
    case '{':
      mACTION(false);
      break;
    case '"':
      mSTRING_LITERAL(false);
      break;
    case '\'':
      mCHAR_LITERAL(false);
      break;
    case '(':
      mSUBRULE_BLOCK(false);
      break;
    case '\n':
    case '\r':
      mNEWLINE(false);
      break;
    default:
      if (_tokenSet_5.member(LA(1)))
        match(_tokenSet_5);
      else
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mCOMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 35;
    if ((LA(1) == '/') && (LA(2) == '/'))
      mSL_COMMENT(false);
    else if ((LA(1) == '/') && (LA(2) == '*'))
      mML_COMMENT(false);
    else
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    i = -1;
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mACTION(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 7;
    match('{');
    while (LA(1) != '}')
    {
      if (((LA(1) == '\n') || (LA(1) == '\r')) && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mNEWLINE(false);
        continue;
      }
      if ((LA(1) == '{') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mACTION(false);
        continue;
      }
      if ((LA(1) == '\'') && (_tokenSet_6.member(LA(2))))
      {
        mCHAR_LITERAL(false);
        continue;
      }
      if ((LA(1) == '/') && ((LA(2) == '*') || (LA(2) == '/')))
      {
        mCOMMENT(false);
        continue;
      }
      if ((LA(1) == '"') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mSTRING_LITERAL(false);
        continue;
      }
      if ((LA(1) < '\003') || (LA(1) > 'ÿ') || (LA(2) < '\003') || (LA(2) > 'ÿ'))
        break;
      matchNot(65535);
    }
    match('}');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mSTRING_LITERAL(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 39;
    match('"');
    while (true)
    {
      if (LA(1) == '\\')
      {
        mESC(false);
        continue;
      }
      if (!_tokenSet_7.member(LA(1)))
        break;
      matchNot('"');
    }
    match('"');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mCHAR_LITERAL(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 38;
    match('\'');
    if (LA(1) == '\\')
      mESC(false);
    else if (_tokenSet_8.member(LA(1)))
      matchNot('\'');
    else
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    match('\'');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mNEWLINE(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 34;
    if ((LA(1) == '\r') && (LA(2) == '\n'))
    {
      match('\r');
      match('\n');
      newline();
    }
    else if (LA(1) == '\r')
    {
      match('\r');
      newline();
    }
    else if (LA(1) == '\n')
    {
      match('\n');
      newline();
    }
    else
    {
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mBANG(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 19;
    match('!');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mSEMI(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 11;
    match(';');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mCOMMA(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 24;
    match(',');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mRCURLY(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 15;
    match('}');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mLPAREN(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 29;
    match('(');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mRPAREN(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 30;
    match(')');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mID_OR_KEYWORD(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken1 = null;
    int j = this.text.length();
    int i = 31;
    Token localToken2 = null;
    mID(true);
    localToken2 = this._returnToken;
    i = localToken2.getType();
    if ((_tokenSet_9.member(LA(1))) && (LA(2) >= '\003') && (LA(2) <= 'ÿ') && (localToken2.getText().equals("header")))
    {
      if ((_tokenSet_1.member(LA(1))) && (_tokenSet_9.member(LA(2))))
        mWS(false);
      else if ((!_tokenSet_9.member(LA(1))) || (LA(2) < '\003') || (LA(2) > 'ÿ'))
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      switch (LA(1))
      {
      case '"':
        mSTRING_LITERAL(false);
        break;
      case '\t':
      case '\n':
      case '\r':
      case ' ':
      case '/':
      case '{':
        break;
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      while (true)
        switch (LA(1))
        {
        case '\t':
        case '\n':
        case '\r':
        case ' ':
          mWS(false);
          break;
        case '/':
          mCOMMENT(false);
        }
      mACTION(false);
      i = 5;
    }
    else if ((_tokenSet_10.member(LA(1))) && (LA(2) >= '\003') && (LA(2) <= 'ÿ') && (localToken2.getText().equals("tokens")))
    {
      while (true)
        switch (LA(1))
        {
        case '\t':
        case '\n':
        case '\r':
        case ' ':
          mWS(false);
          break;
        case '/':
          mCOMMENT(false);
        }
      mCURLY_BLOCK_SCARF(false);
      i = 12;
    }
    else if ((_tokenSet_10.member(LA(1))) && (localToken2.getText().equals("options")))
    {
      while (true)
        switch (LA(1))
        {
        case '\t':
        case '\n':
        case '\r':
        case ' ':
          mWS(false);
          break;
        case '/':
          mCOMMENT(false);
        }
      match('{');
      i = 13;
    }
    if ((paramBoolean) && (localToken1 == null) && (i != -1))
    {
      localToken1 = makeToken(i);
      localToken1.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken1;
  }

  protected final void mID(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 9;
    switch (LA(1))
    {
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
    case 'g':
    case 'h':
    case 'i':
    case 'j':
    case 'k':
    case 'l':
    case 'm':
    case 'n':
    case 'o':
    case 'p':
    case 'q':
    case 'r':
    case 's':
    case 't':
    case 'u':
    case 'v':
    case 'w':
    case 'x':
    case 'y':
    case 'z':
      matchRange('a', 'z');
      break;
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
      matchRange('A', 'Z');
      break;
    case '_':
      match('_');
      break;
    case '[':
    case '\\':
    case ']':
    case '^':
    case '`':
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    while (true)
      switch (LA(1))
      {
      case 'a':
      case 'b':
      case 'c':
      case 'd':
      case 'e':
      case 'f':
      case 'g':
      case 'h':
      case 'i':
      case 'j':
      case 'k':
      case 'l':
      case 'm':
      case 'n':
      case 'o':
      case 'p':
      case 'q':
      case 'r':
      case 's':
      case 't':
      case 'u':
      case 'v':
      case 'w':
      case 'x':
      case 'y':
      case 'z':
        matchRange('a', 'z');
        break;
      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
      case 'G':
      case 'H':
      case 'I':
      case 'J':
      case 'K':
      case 'L':
      case 'M':
      case 'N':
      case 'O':
      case 'P':
      case 'Q':
      case 'R':
      case 'S':
      case 'T':
      case 'U':
      case 'V':
      case 'W':
      case 'X':
      case 'Y':
      case 'Z':
        matchRange('A', 'Z');
        break;
      case '_':
        match('_');
        break;
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
        matchRange('0', '9');
      case ':':
      case ';':
      case '<':
      case '=':
      case '>':
      case '?':
      case '@':
      case '[':
      case '\\':
      case ']':
      case '^':
      case '`':
      }
    i = testLiteralsTable(new String(this.text.getBuffer(), j, this.text.length() - j), i);
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mCURLY_BLOCK_SCARF(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 32;
    match('{');
    while (LA(1) != '}')
    {
      if (((LA(1) == '\n') || (LA(1) == '\r')) && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mNEWLINE(false);
        continue;
      }
      if ((LA(1) == '"') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mSTRING_LITERAL(false);
        continue;
      }
      if ((LA(1) == '\'') && (_tokenSet_6.member(LA(2))))
      {
        mCHAR_LITERAL(false);
        continue;
      }
      if ((LA(1) == '/') && ((LA(2) == '*') || (LA(2) == '/')))
      {
        mCOMMENT(false);
        continue;
      }
      if ((LA(1) < '\003') || (LA(1) > 'ÿ') || (LA(2) < '\003') || (LA(2) > 'ÿ'))
        break;
      matchNot(65535);
    }
    match('}');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mASSIGN_RHS(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 14;
    int k = this.text.length();
    match('=');
    this.text.setLength(k);
    while (LA(1) != ';')
    {
      if ((LA(1) == '"') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mSTRING_LITERAL(false);
        continue;
      }
      if ((LA(1) == '\'') && (_tokenSet_6.member(LA(2))))
      {
        mCHAR_LITERAL(false);
        continue;
      }
      if (((LA(1) == '\n') || (LA(1) == '\r')) && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mNEWLINE(false);
        continue;
      }
      if ((LA(1) < '\003') || (LA(1) > 'ÿ') || (LA(2) < '\003') || (LA(2) > 'ÿ'))
        break;
      matchNot(65535);
    }
    match(';');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mSL_COMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 36;
    match("//");
    while ((LA(1) != '\n') && (LA(1) != '\r') && (LA(1) >= '\003') && (LA(1) <= 'ÿ') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      matchNot(65535);
    mNEWLINE(false);
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mML_COMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 37;
    match("/*");
    while ((LA(1) != '*') || (LA(2) != '/'))
    {
      if (((LA(1) == '\n') || (LA(1) == '\r')) && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mNEWLINE(false);
        continue;
      }
      if ((LA(1) < '\003') || (LA(1) > 'ÿ') || (LA(2) < '\003') || (LA(2) > 'ÿ'))
        break;
      matchNot(65535);
    }
    match("*/");
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mESC(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 40;
    match('\\');
    switch (LA(1))
    {
    case 'n':
      match('n');
      break;
    case 'r':
      match('r');
      break;
    case 't':
      match('t');
      break;
    case 'b':
      match('b');
      break;
    case 'f':
      match('f');
      break;
    case 'w':
      match('w');
      break;
    case 'a':
      match('a');
      break;
    case '"':
      match('"');
      break;
    case '\'':
      match('\'');
      break;
    case '\\':
      match('\\');
      break;
    case '0':
    case '1':
    case '2':
    case '3':
      matchRange('0', '3');
      if ((LA(1) >= '0') && (LA(1) <= '9') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mDIGIT(false);
        if ((LA(1) >= '0') && (LA(1) <= '9') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
        {
          mDIGIT(false);
        }
        else
        {
          if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
            break;
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
      }
      else
      {
        if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    case '4':
    case '5':
    case '6':
    case '7':
      matchRange('4', '7');
      if ((LA(1) >= '0') && (LA(1) <= '9') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mDIGIT(false);
      }
      else
      {
        if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    case 'u':
      match('u');
      mXDIGIT(false);
      mXDIGIT(false);
      mXDIGIT(false);
      mXDIGIT(false);
      break;
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mDIGIT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 41;
    matchRange('0', '9');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mXDIGIT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 42;
    switch (LA(1))
    {
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
      matchRange('0', '9');
      break;
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
      matchRange('a', 'f');
      break;
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
      matchRange('A', 'F');
      break;
    case ':':
    case ';':
    case '<':
    case '=':
    case '>':
    case '?':
    case '@':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
    case '[':
    case '\\':
    case ']':
    case '^':
    case '_':
    case '`':
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mARG_ACTION(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 20;
    match('[');
    while (LA(1) != ']')
    {
      if ((LA(1) == '[') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mARG_ACTION(false);
        continue;
      }
      if (((LA(1) == '\n') || (LA(1) == '\r')) && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mNEWLINE(false);
        continue;
      }
      if ((LA(1) == '\'') && (_tokenSet_6.member(LA(2))))
      {
        mCHAR_LITERAL(false);
        continue;
      }
      if ((LA(1) == '"') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mSTRING_LITERAL(false);
        continue;
      }
      if ((LA(1) < '\003') || (LA(1) > 'ÿ') || (LA(2) < '\003') || (LA(2) > 'ÿ'))
        break;
      matchNot(65535);
    }
    match(']');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  private static final long[] mk_tokenSet_0()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -576460752303423496L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_1()
  {
    long[] arrayOfLong = { 4294977024L, 0L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_2()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -2199023255560L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_3()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -576462951326679048L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_4()
  {
    long[] arrayOfLong = { 4294977024L, 1152921504606846976L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_5()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -576605355262354440L;
    arrayOfLong[1] = -576460752303423489L;
    for (int i = 2; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_6()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -549755813896L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_7()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -17179869192L;
    arrayOfLong[1] = -268435457L;
    for (int i = 2; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_8()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -549755813896L;
    arrayOfLong[1] = -268435457L;
    for (int i = 2; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_9()
  {
    long[] arrayOfLong = { 140758963201536L, 576460752303423488L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_10()
  {
    long[] arrayOfLong = { 140741783332352L, 576460752303423488L, 0L, 0L, 0L };
    return arrayOfLong;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.preprocessor.PreprocessorLexer
 * JD-Core Version:    0.6.0
 */