package antlr.debug.misc;

import antlr.collections.AST;
import java.io.PrintStream;
import java.util.NoSuchElementException;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeASTModel
  implements TreeModel
{
  AST root = null;

  public JTreeASTModel(AST paramAST)
  {
    if (paramAST == null)
      throw new IllegalArgumentException("root is null");
    this.root = paramAST;
  }

  public void addTreeModelListener(TreeModelListener paramTreeModelListener)
  {
  }

  public Object getChild(Object paramObject, int paramInt)
  {
    if (paramObject == null)
      return null;
    AST localAST1 = (AST)paramObject;
    AST localAST2 = localAST1.getFirstChild();
    if (localAST2 == null)
      throw new ArrayIndexOutOfBoundsException("node has no children");
    for (int i = 0; (localAST2 != null) && (i < paramInt); i++)
      localAST2 = localAST2.getNextSibling();
    return localAST2;
  }

  public int getChildCount(Object paramObject)
  {
    if (paramObject == null)
      throw new IllegalArgumentException("root is null");
    AST localAST1 = (AST)paramObject;
    AST localAST2 = localAST1.getFirstChild();
    for (int i = 0; localAST2 != null; i++)
      localAST2 = localAST2.getNextSibling();
    return i;
  }

  public int getIndexOfChild(Object paramObject1, Object paramObject2)
  {
    if ((paramObject1 == null) || (paramObject2 == null))
      throw new IllegalArgumentException("root or child is null");
    AST localAST1 = (AST)paramObject1;
    AST localAST2 = localAST1.getFirstChild();
    if (localAST2 == null)
      throw new ArrayIndexOutOfBoundsException("node has no children");
    for (int i = 0; (localAST2 != null) && (localAST2 != paramObject2); i++)
      localAST2 = localAST2.getNextSibling();
    if (localAST2 == paramObject2)
      return i;
    throw new NoSuchElementException("node is not a child");
  }

  public Object getRoot()
  {
    return this.root;
  }

  public boolean isLeaf(Object paramObject)
  {
    if (paramObject == null)
      throw new IllegalArgumentException("node is null");
    AST localAST = (AST)paramObject;
    return localAST.getFirstChild() == null;
  }

  public void removeTreeModelListener(TreeModelListener paramTreeModelListener)
  {
  }

  public void valueForPathChanged(TreePath paramTreePath, Object paramObject)
  {
    System.out.println("heh, who is calling this mystery method?");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.debug.misc.JTreeASTModel
 * JD-Core Version:    0.6.0
 */