package antlr.debug;

import antlr.ANTLRStringBuffer;
import antlr.CharScanner;
import antlr.CharStreamException;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.MismatchedCharException;
import antlr.Token;
import antlr.collections.impl.BitSet;

public abstract class DebuggingCharScanner extends CharScanner
  implements DebuggingParser
{
  private ParserEventSupport parserEventSupport = new ParserEventSupport(this);
  private boolean _notDebugMode = false;
  protected String[] ruleNames;
  protected String[] semPredNames;

  public DebuggingCharScanner(InputBuffer paramInputBuffer)
  {
    super(paramInputBuffer);
  }

  public DebuggingCharScanner(LexerSharedInputState paramLexerSharedInputState)
  {
    super(paramLexerSharedInputState);
  }

  public void addMessageListener(MessageListener paramMessageListener)
  {
    this.parserEventSupport.addMessageListener(paramMessageListener);
  }

  public void addNewLineListener(NewLineListener paramNewLineListener)
  {
    this.parserEventSupport.addNewLineListener(paramNewLineListener);
  }

  public void addParserListener(ParserListener paramParserListener)
  {
    this.parserEventSupport.addParserListener(paramParserListener);
  }

  public void addParserMatchListener(ParserMatchListener paramParserMatchListener)
  {
    this.parserEventSupport.addParserMatchListener(paramParserMatchListener);
  }

  public void addParserTokenListener(ParserTokenListener paramParserTokenListener)
  {
    this.parserEventSupport.addParserTokenListener(paramParserTokenListener);
  }

  public void addSemanticPredicateListener(SemanticPredicateListener paramSemanticPredicateListener)
  {
    this.parserEventSupport.addSemanticPredicateListener(paramSemanticPredicateListener);
  }

  public void addSyntacticPredicateListener(SyntacticPredicateListener paramSyntacticPredicateListener)
  {
    this.parserEventSupport.addSyntacticPredicateListener(paramSyntacticPredicateListener);
  }

  public void addTraceListener(TraceListener paramTraceListener)
  {
    this.parserEventSupport.addTraceListener(paramTraceListener);
  }

  public void consume()
    throws CharStreamException
  {
    int i = -99;
    try
    {
      i = LA(1);
    }
    catch (CharStreamException localCharStreamException)
    {
    }
    super.consume();
    this.parserEventSupport.fireConsume(i);
  }

  protected void fireEnterRule(int paramInt1, int paramInt2)
  {
    if (isDebugMode())
      this.parserEventSupport.fireEnterRule(paramInt1, this.inputState.guessing, paramInt2);
  }

  protected void fireExitRule(int paramInt1, int paramInt2)
  {
    if (isDebugMode())
      this.parserEventSupport.fireExitRule(paramInt1, this.inputState.guessing, paramInt2);
  }

  protected boolean fireSemanticPredicateEvaluated(int paramInt1, int paramInt2, boolean paramBoolean)
  {
    if (isDebugMode())
      return this.parserEventSupport.fireSemanticPredicateEvaluated(paramInt1, paramInt2, paramBoolean, this.inputState.guessing);
    return paramBoolean;
  }

  protected void fireSyntacticPredicateFailed()
  {
    if (isDebugMode())
      this.parserEventSupport.fireSyntacticPredicateFailed(this.inputState.guessing);
  }

  protected void fireSyntacticPredicateStarted()
  {
    if (isDebugMode())
      this.parserEventSupport.fireSyntacticPredicateStarted(this.inputState.guessing);
  }

  protected void fireSyntacticPredicateSucceeded()
  {
    if (isDebugMode())
      this.parserEventSupport.fireSyntacticPredicateSucceeded(this.inputState.guessing);
  }

  public String getRuleName(int paramInt)
  {
    return this.ruleNames[paramInt];
  }

  public String getSemPredName(int paramInt)
  {
    return this.semPredNames[paramInt];
  }

  public synchronized void goToSleep()
  {
    try
    {
      wait();
    }
    catch (InterruptedException localInterruptedException)
    {
    }
  }

  public boolean isDebugMode()
  {
    return !this._notDebugMode;
  }

  public char LA(int paramInt)
    throws CharStreamException
  {
    int i = super.LA(paramInt);
    this.parserEventSupport.fireLA(paramInt, i);
    return i;
  }

  protected Token makeToken(int paramInt)
  {
    return super.makeToken(paramInt);
  }

  public void match(char paramChar)
    throws MismatchedCharException, CharStreamException
  {
    char c = LA(1);
    try
    {
      super.match(paramChar);
      this.parserEventSupport.fireMatch(paramChar, this.inputState.guessing);
    }
    catch (MismatchedCharException localMismatchedCharException)
    {
      if (this.inputState.guessing == 0)
        this.parserEventSupport.fireMismatch(c, paramChar, this.inputState.guessing);
      throw localMismatchedCharException;
    }
  }

  public void match(BitSet paramBitSet)
    throws MismatchedCharException, CharStreamException
  {
    String str = this.text.toString();
    int i = LA(1);
    try
    {
      super.match(paramBitSet);
      this.parserEventSupport.fireMatch(i, paramBitSet, str, this.inputState.guessing);
    }
    catch (MismatchedCharException localMismatchedCharException)
    {
      if (this.inputState.guessing == 0)
        this.parserEventSupport.fireMismatch(i, paramBitSet, str, this.inputState.guessing);
      throw localMismatchedCharException;
    }
  }

  public void match(String paramString)
    throws MismatchedCharException, CharStreamException
  {
    StringBuffer localStringBuffer = new StringBuffer("");
    int i = paramString.length();
    try
    {
      for (int j = 1; j <= i; j++)
        localStringBuffer.append(super.LA(j));
    }
    catch (Exception localException)
    {
    }
    try
    {
      super.match(paramString);
      this.parserEventSupport.fireMatch(paramString, this.inputState.guessing);
    }
    catch (MismatchedCharException localMismatchedCharException)
    {
      if (this.inputState.guessing == 0)
        this.parserEventSupport.fireMismatch(localStringBuffer.toString(), paramString, this.inputState.guessing);
      throw localMismatchedCharException;
    }
  }

  public void matchNot(char paramChar)
    throws MismatchedCharException, CharStreamException
  {
    char c = LA(1);
    try
    {
      super.matchNot(paramChar);
      this.parserEventSupport.fireMatchNot(c, paramChar, this.inputState.guessing);
    }
    catch (MismatchedCharException localMismatchedCharException)
    {
      if (this.inputState.guessing == 0)
        this.parserEventSupport.fireMismatchNot(c, paramChar, this.inputState.guessing);
      throw localMismatchedCharException;
    }
  }

  public void matchRange(char paramChar1, char paramChar2)
    throws MismatchedCharException, CharStreamException
  {
    char c = LA(1);
    try
    {
      super.matchRange(paramChar1, paramChar2);
      this.parserEventSupport.fireMatch(c, "" + paramChar1 + paramChar2, this.inputState.guessing);
    }
    catch (MismatchedCharException localMismatchedCharException)
    {
      if (this.inputState.guessing == 0)
        this.parserEventSupport.fireMismatch(c, "" + paramChar1 + paramChar2, this.inputState.guessing);
      throw localMismatchedCharException;
    }
  }

  public void newline()
  {
    super.newline();
    this.parserEventSupport.fireNewLine(getLine());
  }

  public void removeMessageListener(MessageListener paramMessageListener)
  {
    this.parserEventSupport.removeMessageListener(paramMessageListener);
  }

  public void removeNewLineListener(NewLineListener paramNewLineListener)
  {
    this.parserEventSupport.removeNewLineListener(paramNewLineListener);
  }

  public void removeParserListener(ParserListener paramParserListener)
  {
    this.parserEventSupport.removeParserListener(paramParserListener);
  }

  public void removeParserMatchListener(ParserMatchListener paramParserMatchListener)
  {
    this.parserEventSupport.removeParserMatchListener(paramParserMatchListener);
  }

  public void removeParserTokenListener(ParserTokenListener paramParserTokenListener)
  {
    this.parserEventSupport.removeParserTokenListener(paramParserTokenListener);
  }

  public void removeSemanticPredicateListener(SemanticPredicateListener paramSemanticPredicateListener)
  {
    this.parserEventSupport.removeSemanticPredicateListener(paramSemanticPredicateListener);
  }

  public void removeSyntacticPredicateListener(SyntacticPredicateListener paramSyntacticPredicateListener)
  {
    this.parserEventSupport.removeSyntacticPredicateListener(paramSyntacticPredicateListener);
  }

  public void removeTraceListener(TraceListener paramTraceListener)
  {
    this.parserEventSupport.removeTraceListener(paramTraceListener);
  }

  public void reportError(MismatchedCharException paramMismatchedCharException)
  {
    this.parserEventSupport.fireReportError(paramMismatchedCharException);
    super.reportError(paramMismatchedCharException);
  }

  public void reportError(String paramString)
  {
    this.parserEventSupport.fireReportError(paramString);
    super.reportError(paramString);
  }

  public void reportWarning(String paramString)
  {
    this.parserEventSupport.fireReportWarning(paramString);
    super.reportWarning(paramString);
  }

  public void setDebugMode(boolean paramBoolean)
  {
    this._notDebugMode = (!paramBoolean);
  }

  public void setupDebugging()
  {
  }

  public synchronized void wakeUp()
  {
    notify();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.debug.DebuggingCharScanner
 * JD-Core Version:    0.6.0
 */