package antlr.build;

import java.io.File;
import java.io.FilenameFilter;

public class ANTLR
{
  public static String compiler = "javac";
  public static String jarName = "antlr.jar";
  public static String root = ".";
  public static String[] srcdir = { "antlr", "antlr/actions/cpp", "antlr/actions/java", "antlr/actions/csharp", "antlr/collections", "antlr/collections/impl", "antlr/debug", "antlr/ASdebug", "antlr/debug/misc", "antlr/preprocessor" };

  public ANTLR()
  {
    compiler = System.getProperty("antlr.build.compiler", compiler);
    root = System.getProperty("antlr.build.root", root);
  }

  public String getName()
  {
    return "ANTLR";
  }

  public void build(Tool paramTool)
  {
    if (!rootIsValidANTLRDir(paramTool))
      return;
    paramTool.antlr(root + "/antlr/antlr.g");
    paramTool.antlr(root + "/antlr/tokdef.g");
    paramTool.antlr(root + "/antlr/preprocessor/preproc.g");
    paramTool.antlr(root + "/antlr/actions/java/action.g");
    paramTool.antlr(root + "/antlr/actions/cpp/action.g");
    paramTool.antlr(root + "/antlr/actions/csharp/action.g");
    for (int i = 0; i < srcdir.length; i++)
    {
      String str = compiler + " -d " + root + " " + root + "/" + srcdir[i] + "/*.java";
      paramTool.system(str);
    }
  }

  public void jar(Tool paramTool)
  {
    if (!rootIsValidANTLRDir(paramTool))
      return;
    StringBuffer localStringBuffer = new StringBuffer(2000);
    localStringBuffer.append("jar cvf " + root + "/" + jarName);
    for (int i = 0; i < srcdir.length; i++)
      localStringBuffer.append(" " + root + "/" + srcdir[i] + "/*.class");
    paramTool.system(localStringBuffer.toString());
  }

  protected boolean rootIsValidANTLRDir(Tool paramTool)
  {
    if (root == null)
      return false;
    File localFile1 = new File(root);
    if (!localFile1.exists())
    {
      paramTool.error("Property antlr.build.root==" + root + " does not exist");
      return false;
    }
    if (!localFile1.isDirectory())
    {
      paramTool.error("Property antlr.build.root==" + root + " is not a directory");
      return false;
    }
    String[] arrayOfString1 = localFile1.list(new FilenameFilter()
    {
      public boolean accept(File paramFile, String paramString)
      {
        return (paramFile.isDirectory()) && (paramString.equals("antlr"));
      }
    });
    if ((arrayOfString1 == null) || (arrayOfString1.length == 0))
    {
      paramTool.error("Property antlr.build.root==" + root + " does not appear to be a valid ANTLR project root (no antlr subdir)");
      return false;
    }
    File localFile2 = new File(root + "/antlr");
    String[] arrayOfString2 = localFile2.list();
    if ((arrayOfString2 == null) || (arrayOfString2.length == 0))
    {
      paramTool.error("Property antlr.build.root==" + root + " does not appear to be a valid ANTLR project root (no .java files in antlr subdir");
      return false;
    }
    return true;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.build.ANTLR
 * JD-Core Version:    0.6.0
 */