package antlr;

import antlr.collections.AST;
import antlr.collections.impl.BitSet;
import java.io.PrintStream;

public class TreeParser
{
  public static ASTNULLType ASTNULL = new ASTNULLType();
  protected AST _retTree;
  protected TreeParserSharedInputState inputState = new TreeParserSharedInputState();
  protected String[] tokenNames;
  protected AST returnAST;
  protected ASTFactory astFactory = new ASTFactory();
  protected int traceDepth = 0;

  public AST getAST()
  {
    return this.returnAST;
  }

  public ASTFactory getASTFactory()
  {
    return this.astFactory;
  }

  public String getTokenName(int paramInt)
  {
    return this.tokenNames[paramInt];
  }

  public String[] getTokenNames()
  {
    return this.tokenNames;
  }

  protected void match(AST paramAST, int paramInt)
    throws MismatchedTokenException
  {
    if ((paramAST == null) || (paramAST == ASTNULL) || (paramAST.getType() != paramInt))
      throw new MismatchedTokenException(getTokenNames(), paramAST, paramInt, false);
  }

  public void match(AST paramAST, BitSet paramBitSet)
    throws MismatchedTokenException
  {
    if ((paramAST == null) || (paramAST == ASTNULL) || (!paramBitSet.member(paramAST.getType())))
      throw new MismatchedTokenException(getTokenNames(), paramAST, paramBitSet, false);
  }

  protected void matchNot(AST paramAST, int paramInt)
    throws MismatchedTokenException
  {
    if ((paramAST == null) || (paramAST == ASTNULL) || (paramAST.getType() == paramInt))
      throw new MismatchedTokenException(getTokenNames(), paramAST, paramInt, true);
  }

  /** @deprecated */
  public static void panic()
  {
    System.err.println("TreeWalker: panic");
    Utils.error("");
  }

  public void reportError(RecognitionException paramRecognitionException)
  {
    System.err.println(paramRecognitionException.toString());
  }

  public void reportError(String paramString)
  {
    System.err.println("error: " + paramString);
  }

  public void reportWarning(String paramString)
  {
    System.err.println("warning: " + paramString);
  }

  public void setASTFactory(ASTFactory paramASTFactory)
  {
    this.astFactory = paramASTFactory;
  }

  /** @deprecated */
  public void setASTNodeType(String paramString)
  {
    setASTNodeClass(paramString);
  }

  public void setASTNodeClass(String paramString)
  {
    this.astFactory.setASTNodeType(paramString);
  }

  public void traceIndent()
  {
    for (int i = 0; i < this.traceDepth; i++)
      System.out.print(" ");
  }

  public void traceIn(String paramString, AST paramAST)
  {
    this.traceDepth += 1;
    traceIndent();
    System.out.println("> " + paramString + "(" + (paramAST != null ? paramAST.toString() : "null") + ")" + (this.inputState.guessing > 0 ? " [guessing]" : ""));
  }

  public void traceOut(String paramString, AST paramAST)
  {
    traceIndent();
    System.out.println("< " + paramString + "(" + (paramAST != null ? paramAST.toString() : "null") + ")" + (this.inputState.guessing > 0 ? " [guessing]" : ""));
    this.traceDepth -= 1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.TreeParser
 * JD-Core Version:    0.6.0
 */