package antlr;

import antlr.ASdebug.ASDebugStream;
import antlr.ASdebug.IASDebugStream;
import antlr.ASdebug.TokenOffsetInfo;
import antlr.collections.impl.BitSet;

public class TokenStreamBasicFilter
  implements TokenStream, IASDebugStream
{
  protected BitSet discardMask;
  protected TokenStream input;

  public TokenStreamBasicFilter(TokenStream paramTokenStream)
  {
    this.input = paramTokenStream;
    this.discardMask = new BitSet();
  }

  public void discard(int paramInt)
  {
    this.discardMask.add(paramInt);
  }

  public void discard(BitSet paramBitSet)
  {
    this.discardMask = paramBitSet;
  }

  public Token nextToken()
    throws TokenStreamException
  {
    for (Token localToken = this.input.nextToken(); (localToken != null) && (this.discardMask.member(localToken.getType())); localToken = this.input.nextToken());
    return localToken;
  }

  public String getEntireText()
  {
    return ASDebugStream.getEntireText(this.input);
  }

  public TokenOffsetInfo getOffsetInfo(Token paramToken)
  {
    return ASDebugStream.getOffsetInfo(this.input, paramToken);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.TokenStreamBasicFilter
 * JD-Core Version:    0.6.0
 */