package antlr;

class TokenRangeElement extends AlternativeElement
{
  String label;
  protected int begin = 0;
  protected int end = 0;
  protected String beginText;
  protected String endText;

  public TokenRangeElement(Grammar paramGrammar, Token paramToken1, Token paramToken2, int paramInt)
  {
    super(paramGrammar, paramToken1, paramInt);
    this.beginText = paramToken1.getText();
    this.end = this.grammar.tokenManager.getTokenSymbol(paramToken2.getText()).getTokenType();
    this.endText = paramToken2.getText();
    this.line = paramToken1.getLine();
  }

  public void generate()
  {
    this.grammar.generator.gen(this);
  }

  public String getLabel()
  {
    return this.label;
  }

  public Lookahead look(int paramInt)
  {
    return this.grammar.theLLkAnalyzer.look(paramInt, this);
  }

  public void setLabel(String paramString)
  {
    this.label = paramString;
  }

  public String toString()
  {
    if (this.label != null)
      return " " + this.label + ":" + this.beginText + ".." + this.endText;
    return " " + this.beginText + ".." + this.endText;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.TokenRangeElement
 * JD-Core Version:    0.6.0
 */