package antlr;

import antlr.collections.impl.BitSet;

class StringLiteralElement extends GrammarAtom
{
  protected String processedAtomText;

  public StringLiteralElement(Grammar paramGrammar, Token paramToken, int paramInt)
  {
    super(paramGrammar, paramToken, paramInt);
    if (!(paramGrammar instanceof LexerGrammar))
    {
      TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(this.atomText);
      if (localTokenSymbol == null)
        paramGrammar.antlrTool.error("Undefined literal: " + this.atomText, this.grammar.getFilename(), paramToken.getLine(), paramToken.getColumn());
      else
        this.tokenType = localTokenSymbol.getTokenType();
    }
    this.line = paramToken.getLine();
    this.processedAtomText = new String();
    for (int i = 1; i < this.atomText.length() - 1; i++)
    {
      char c = this.atomText.charAt(i);
      if ((c == '\\') && (i + 1 < this.atomText.length() - 1))
      {
        i++;
        c = this.atomText.charAt(i);
        switch (c)
        {
        case 'n':
          c = '\n';
          break;
        case 'r':
          c = '\r';
          break;
        case 't':
          c = '\t';
        }
      }
      if ((paramGrammar instanceof LexerGrammar))
        ((LexerGrammar)paramGrammar).charVocabulary.add(c);
      this.processedAtomText += c;
    }
  }

  public void generate()
  {
    this.grammar.generator.gen(this);
  }

  public Lookahead look(int paramInt)
  {
    return this.grammar.theLLkAnalyzer.look(paramInt, this);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.StringLiteralElement
 * JD-Core Version:    0.6.0
 */