package antlr;

import antlr.collections.impl.Vector;
import java.util.Enumeration;
import java.util.Hashtable;

class SimpleTokenManager
  implements TokenManager, Cloneable
{
  protected int maxToken = 4;
  protected Vector vocabulary;
  private Hashtable table;
  protected Tool antlrTool;
  protected String name;
  protected boolean readOnly = false;

  SimpleTokenManager(String paramString, Tool paramTool)
  {
    this.antlrTool = paramTool;
    this.name = paramString;
    this.vocabulary = new Vector(1);
    this.table = new Hashtable();
    TokenSymbol localTokenSymbol = new TokenSymbol("EOF");
    localTokenSymbol.setTokenType(1);
    define(localTokenSymbol);
    this.vocabulary.ensureCapacity(3);
    this.vocabulary.setElementAt("NULL_TREE_LOOKAHEAD", 3);
  }

  public Object clone()
  {
    SimpleTokenManager localSimpleTokenManager;
    try
    {
      localSimpleTokenManager = (SimpleTokenManager)super.clone();
      localSimpleTokenManager.vocabulary = ((Vector)this.vocabulary.clone());
      localSimpleTokenManager.table = ((Hashtable)this.table.clone());
      localSimpleTokenManager.maxToken = this.maxToken;
      localSimpleTokenManager.antlrTool = this.antlrTool;
      localSimpleTokenManager.name = this.name;
    }
    catch (CloneNotSupportedException localCloneNotSupportedException)
    {
      this.antlrTool.panic("cannot clone token manager");
      return null;
    }
    return localSimpleTokenManager;
  }

  public void define(TokenSymbol paramTokenSymbol)
  {
    this.vocabulary.ensureCapacity(paramTokenSymbol.getTokenType());
    this.vocabulary.setElementAt(paramTokenSymbol.getId(), paramTokenSymbol.getTokenType());
    mapToTokenSymbol(paramTokenSymbol.getId(), paramTokenSymbol);
  }

  public String getName()
  {
    return this.name;
  }

  public String getTokenStringAt(int paramInt)
  {
    return (String)this.vocabulary.elementAt(paramInt);
  }

  public TokenSymbol getTokenSymbol(String paramString)
  {
    return (TokenSymbol)this.table.get(paramString);
  }

  public TokenSymbol getTokenSymbolAt(int paramInt)
  {
    return getTokenSymbol(getTokenStringAt(paramInt));
  }

  public Enumeration getTokenSymbolElements()
  {
    return this.table.elements();
  }

  public Enumeration getTokenSymbolKeys()
  {
    return this.table.keys();
  }

  public Vector getVocabulary()
  {
    return this.vocabulary;
  }

  public boolean isReadOnly()
  {
    return false;
  }

  public void mapToTokenSymbol(String paramString, TokenSymbol paramTokenSymbol)
  {
    this.table.put(paramString, paramTokenSymbol);
  }

  public int maxTokenType()
  {
    return this.maxToken - 1;
  }

  public int nextTokenType()
  {
    return this.maxToken++;
  }

  public void setName(String paramString)
  {
    this.name = paramString;
  }

  public void setReadOnly(boolean paramBoolean)
  {
    this.readOnly = paramBoolean;
  }

  public boolean tokenDefined(String paramString)
  {
    return this.table.containsKey(paramString);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.SimpleTokenManager
 * JD-Core Version:    0.6.0
 */