package antlr;

import antlr.actions.python.ActionLexer;
import antlr.actions.python.CodeLexer;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class PythonCodeGenerator extends CodeGenerator
{
  protected int syntacticPredLevel = 0;
  protected boolean genAST = false;
  protected boolean saveText = false;
  String labeledElementType;
  String labeledElementASTType;
  String labeledElementInit;
  String commonExtraArgs;
  String commonExtraParams;
  String commonLocalVars;
  String lt1Value;
  String exceptionThrown;
  String throwNoViable;
  public static final String initHeaderAction = "__init__";
  public static final String mainHeaderAction = "__main__";
  String lexerClassName;
  String parserClassName;
  String treeWalkerClassName;
  RuleBlock currentRule;
  String currentASTResult;
  Hashtable treeVariableMap = new Hashtable();
  Hashtable declaredASTVariables = new Hashtable();
  int astVarNumber = 1;
  protected static final String NONUNIQUE = new String();
  public static final int caseSizeThreshold = 127;
  private Vector semPreds;

  protected void printTabs()
  {
    for (int i = 0; i < this.tabs; i++)
      this.currentOutput.print("    ");
  }

  public PythonCodeGenerator()
  {
    this.charFormatter = new PythonCharFormatter();
    this.DEBUG_CODE_GENERATOR = true;
  }

  protected int addSemPred(String paramString)
  {
    this.semPreds.appendElement(paramString);
    return this.semPreds.size() - 1;
  }

  public void exitIfError()
  {
    if (this.antlrTool.hasError())
      this.antlrTool.fatalError("Exiting due to errors.");
  }

  protected void checkCurrentOutputStream()
  {
    try
    {
      if (this.currentOutput == null)
        throw new NullPointerException();
    }
    catch (Exception localException)
    {
      Utils.error("current output is not set");
    }
  }

  protected String extractIdOfAction(String paramString, int paramInt1, int paramInt2)
  {
    paramString = removeAssignmentFromDeclaration(paramString);
    paramString = paramString.trim();
    return paramString;
  }

  protected String extractTypeOfAction(String paramString, int paramInt1, int paramInt2)
  {
    return "";
  }

  protected void flushTokens()
  {
    try
    {
      int i = 0;
      checkCurrentOutputStream();
      println("");
      println("### import antlr.Token ");
      println("from antlr import Token");
      println("### >>>The Known Token Types <<<");
      PrintWriter localPrintWriter = this.currentOutput;
      Enumeration localEnumeration = this.behavior.tokenManagers.elements();
      while (localEnumeration.hasMoreElements())
      {
        TokenManager localTokenManager = (TokenManager)localEnumeration.nextElement();
        if (!localTokenManager.isReadOnly())
        {
          if (i == 0)
          {
            genTokenTypes(localTokenManager);
            i = 1;
          }
          this.currentOutput = localPrintWriter;
          genTokenInterchange(localTokenManager);
          this.currentOutput = localPrintWriter;
        }
        exitIfError();
      }
    }
    catch (Exception localException)
    {
      exitIfError();
    }
    checkCurrentOutputStream();
    println("");
  }

  public void gen()
  {
    try
    {
      Enumeration localEnumeration = this.behavior.grammars.elements();
      while (localEnumeration.hasMoreElements())
      {
        Grammar localGrammar = (Grammar)localEnumeration.nextElement();
        localGrammar.setGrammarAnalyzer(this.analyzer);
        localGrammar.setCodeGenerator(this);
        this.analyzer.setGrammar(localGrammar);
        setupGrammarParameters(localGrammar);
        localGrammar.generate();
        exitIfError();
      }
    }
    catch (IOException localIOException)
    {
      this.antlrTool.reportException(localIOException, null);
    }
  }

  public void gen(ActionElement paramActionElement)
  {
    if (paramActionElement.isSemPred)
    {
      genSemPred(paramActionElement.actionText, paramActionElement.line);
    }
    else
    {
      if (this.grammar.hasSyntacticPredicate)
      {
        println("if not self.inputState.guessing:");
        this.tabs += 1;
      }
      ActionTransInfo localActionTransInfo = new ActionTransInfo();
      String str = processActionForSpecialSymbols(paramActionElement.actionText, paramActionElement.getLine(), this.currentRule, localActionTransInfo);
      if (localActionTransInfo.refRuleRoot != null)
        println(localActionTransInfo.refRuleRoot + " = currentAST.root");
      printAction(str);
      if (localActionTransInfo.assignToRoot)
      {
        println("currentAST.root = " + localActionTransInfo.refRuleRoot + "");
        println("if (" + localActionTransInfo.refRuleRoot + " != None) and (" + localActionTransInfo.refRuleRoot + ".getFirstChild() != None):");
        this.tabs += 1;
        println("currentAST.child = " + localActionTransInfo.refRuleRoot + ".getFirstChild()");
        this.tabs -= 1;
        println("else:");
        this.tabs += 1;
        println("currentAST.child = " + localActionTransInfo.refRuleRoot);
        this.tabs -= 1;
        println("currentAST.advanceChildToEnd()");
      }
      if (this.grammar.hasSyntacticPredicate)
        this.tabs -= 1;
    }
  }

  public void gen(AlternativeBlock paramAlternativeBlock)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("gen(" + paramAlternativeBlock + ")");
    genBlockPreamble(paramAlternativeBlock);
    genBlockInitAction(paramAlternativeBlock);
    String str = this.currentASTResult;
    if (paramAlternativeBlock.getLabel() != null)
      this.currentASTResult = paramAlternativeBlock.getLabel();
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramAlternativeBlock);
    int i = this.tabs;
    PythonBlockFinishingInfo localPythonBlockFinishingInfo = genCommonBlock(paramAlternativeBlock, true);
    genBlockFinish(localPythonBlockFinishingInfo, this.throwNoViable);
    this.tabs = i;
    this.currentASTResult = str;
  }

  public void gen(BlockEndElement paramBlockEndElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genRuleEnd(" + paramBlockEndElement + ")");
  }

  public void gen(CharLiteralElement paramCharLiteralElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genChar(" + paramCharLiteralElement + ")");
    if (paramCharLiteralElement.getLabel() != null)
      println(paramCharLiteralElement.getLabel() + " = " + this.lt1Value);
    boolean bool = this.saveText;
    this.saveText = ((this.saveText) && (paramCharLiteralElement.getAutoGenType() == 1));
    genMatch(paramCharLiteralElement);
    this.saveText = bool;
  }

  String toString(boolean paramBoolean)
  {
    String str;
    if (paramBoolean)
      str = "True";
    else
      str = "False";
    return str;
  }

  public void gen(CharRangeElement paramCharRangeElement)
  {
    if ((paramCharRangeElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramCharRangeElement.getLabel() + " = " + this.lt1Value);
    int i = ((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramCharRangeElement.getAutoGenType() == 3)) ? 1 : 0;
    if (i != 0)
      println("_saveIndex = self.text.length()");
    println("self.matchRange(u" + paramCharRangeElement.beginText + ", u" + paramCharRangeElement.endText + ")");
    if (i != 0)
      println("self.text.setLength(_saveIndex)");
  }

  public void gen(LexerGrammar paramLexerGrammar)
    throws IOException
  {
    if (paramLexerGrammar.debuggingOutput)
      this.semPreds = new Vector();
    setGrammar(paramLexerGrammar);
    if (!(this.grammar instanceof LexerGrammar))
      this.antlrTool.panic("Internal error generating lexer");
    setupOutput(this.grammar.getClassName());
    this.genAST = false;
    this.saveText = true;
    this.tabs = 0;
    genHeader();
    println("### import antlr and other modules ..");
    println("import sys");
    println("import antlr");
    println("");
    println("version = sys.version.split()[0]");
    println("if version < '2.2.1':");
    this.tabs += 1;
    println("False = 0");
    this.tabs -= 1;
    println("if version < '2.3':");
    this.tabs += 1;
    println("True = not False");
    this.tabs -= 1;
    println("### header action >>> ");
    printActionCode(this.behavior.getHeaderAction(""), 0);
    println("### header action <<< ");
    println("### preamble action >>> ");
    printActionCode(this.grammar.preambleAction.getText(), 0);
    println("### preamble action <<< ");
    String str = null;
    if (this.grammar.superClass != null)
      str = this.grammar.superClass;
    else
      str = "antlr." + this.grammar.getSuperClass();
    Object localObject1 = "";
    Token localToken = (Token)this.grammar.options.get("classHeaderPrefix");
    if (localToken != null)
    {
      localObject2 = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
      if (localObject2 != null)
        localObject1 = localObject2;
    }
    println("### >>>The Literals<<<");
    println("literals = {}");
    Object localObject2 = this.grammar.tokenManager.getTokenSymbolKeys();
    Object localObject4;
    while (((Enumeration)localObject2).hasMoreElements())
    {
      localObject3 = (String)((Enumeration)localObject2).nextElement();
      if (((String)localObject3).charAt(0) != '"')
        continue;
      TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol((String)localObject3);
      if (!(localTokenSymbol instanceof StringLiteralSymbol))
        continue;
      localObject4 = (StringLiteralSymbol)localTokenSymbol;
      println("literals[u" + ((StringLiteralSymbol)localObject4).getId() + "] = " + ((StringLiteralSymbol)localObject4).getTokenType());
    }
    println("");
    flushTokens();
    genJavadocComment(this.grammar);
    println("class " + this.lexerClassName + "(" + str + ") :");
    this.tabs += 1;
    printGrammarAction(this.grammar);
    println("def __init__(self, *argv, **kwargs) :");
    this.tabs += 1;
    println(str + ".__init__(self, *argv, **kwargs)");
    println("self.caseSensitiveLiterals = " + toString(paramLexerGrammar.caseSensitiveLiterals));
    println("self.setCaseSensitive(" + toString(paramLexerGrammar.caseSensitive) + ")");
    println("self.literals = literals");
    if (this.grammar.debuggingOutput)
    {
      println("ruleNames[] = [");
      localObject3 = this.grammar.rules.elements();
      i = 0;
      this.tabs += 1;
      while (((Enumeration)localObject3).hasMoreElements())
      {
        localObject4 = (GrammarSymbol)((Enumeration)localObject3).nextElement();
        if (!(localObject4 instanceof RuleSymbol))
          continue;
        println("\"" + ((RuleSymbol)localObject4).getId() + "\",");
      }
      this.tabs -= 1;
      println("]");
    }
    genHeaderInit(this.grammar);
    this.tabs -= 1;
    genNextToken();
    println("");
    Object localObject3 = this.grammar.rules.elements();
    int i = 0;
    while (((Enumeration)localObject3).hasMoreElements())
    {
      localObject4 = (RuleSymbol)((Enumeration)localObject3).nextElement();
      if (!((RuleSymbol)localObject4).getId().equals("mnextToken"))
        genRule((RuleSymbol)localObject4, false, i++);
      exitIfError();
    }
    if (this.grammar.debuggingOutput)
      genSemPredMap();
    genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
    println("");
    genHeaderMain(this.grammar);
    this.currentOutput.close();
    this.currentOutput = null;
  }

  protected void genHeaderMain(Grammar paramGrammar)
  {
    String str1 = paramGrammar.getClassName() + "." + "__main__";
    String str2 = this.behavior.getHeaderAction(str1);
    if (isEmpty(str2))
      str2 = this.behavior.getHeaderAction("__main__");
    int i;
    if (isEmpty(str2))
    {
      if ((paramGrammar instanceof LexerGrammar))
      {
        i = this.tabs;
        this.tabs = 0;
        println("### __main__ header action >>> ");
        genLexerTest();
        this.tabs = 0;
        println("### __main__ header action <<< ");
        this.tabs = i;
      }
    }
    else
    {
      i = this.tabs;
      this.tabs = 0;
      println("");
      println("### __main__ header action >>> ");
      printMainFunc(str2);
      this.tabs = 0;
      println("### __main__ header action <<< ");
      this.tabs = i;
    }
  }

  protected void genHeaderInit(Grammar paramGrammar)
  {
    String str1 = paramGrammar.getClassName() + "." + "__init__";
    String str2 = this.behavior.getHeaderAction(str1);
    if (isEmpty(str2))
      str2 = this.behavior.getHeaderAction("__init__");
    if (!isEmpty(str2))
    {
      int i = this.tabs;
      println("### __init__ header action >>> ");
      printActionCode(str2, 0);
      this.tabs = i;
      println("### __init__ header action <<< ");
    }
  }

  protected void printMainFunc(String paramString)
  {
    int i = this.tabs;
    this.tabs = 0;
    println("if __name__ == '__main__':");
    this.tabs += 1;
    printActionCode(paramString, 0);
    this.tabs -= 1;
    this.tabs = i;
  }

  public void gen(OneOrMoreBlock paramOneOrMoreBlock)
  {
    int i = this.tabs;
    genBlockPreamble(paramOneOrMoreBlock);
    String str1;
    if (paramOneOrMoreBlock.getLabel() != null)
      str1 = "_cnt_" + paramOneOrMoreBlock.getLabel();
    else
      str1 = "_cnt" + paramOneOrMoreBlock.ID;
    println("" + str1 + "= 0");
    println("while True:");
    this.tabs += 1;
    i = this.tabs;
    genBlockInitAction(paramOneOrMoreBlock);
    String str2 = this.currentASTResult;
    if (paramOneOrMoreBlock.getLabel() != null)
      this.currentASTResult = paramOneOrMoreBlock.getLabel();
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramOneOrMoreBlock);
    int j = 0;
    int k = this.grammar.maxk;
    if ((!paramOneOrMoreBlock.greedy) && (paramOneOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk) && (paramOneOrMoreBlock.exitCache[paramOneOrMoreBlock.exitLookaheadDepth].containsEpsilon()))
    {
      j = 1;
      k = paramOneOrMoreBlock.exitLookaheadDepth;
    }
    else if ((!paramOneOrMoreBlock.greedy) && (paramOneOrMoreBlock.exitLookaheadDepth == 2147483647))
    {
      j = 1;
    }
    if (j != 0)
    {
      println("### nongreedy (...)+ loop; exit depth is " + paramOneOrMoreBlock.exitLookaheadDepth);
      String str3 = getLookaheadTestExpression(paramOneOrMoreBlock.exitCache, k);
      println("### nongreedy exit test");
      println("if " + str1 + " >= 1 and " + str3 + ":");
      this.tabs += 1;
      println("break");
      this.tabs -= 1;
    }
    int m = this.tabs;
    PythonBlockFinishingInfo localPythonBlockFinishingInfo = genCommonBlock(paramOneOrMoreBlock, false);
    genBlockFinish(localPythonBlockFinishingInfo, "break");
    this.tabs = m;
    this.tabs = i;
    println(str1 + " += 1");
    this.tabs = i;
    this.tabs -= 1;
    println("if " + str1 + " < 1:");
    this.tabs += 1;
    println(this.throwNoViable);
    this.tabs -= 1;
    this.currentASTResult = str2;
  }

  public void gen(ParserGrammar paramParserGrammar)
    throws IOException
  {
    if (paramParserGrammar.debuggingOutput)
      this.semPreds = new Vector();
    setGrammar(paramParserGrammar);
    if (!(this.grammar instanceof ParserGrammar))
      this.antlrTool.panic("Internal error generating parser");
    setupOutput(this.grammar.getClassName());
    this.genAST = this.grammar.buildAST;
    this.tabs = 0;
    genHeader();
    println("### import antlr and other modules ..");
    println("import sys");
    println("import antlr");
    println("");
    println("version = sys.version.split()[0]");
    println("if version < '2.2.1':");
    this.tabs += 1;
    println("False = 0");
    this.tabs -= 1;
    println("if version < '2.3':");
    this.tabs += 1;
    println("True = not False");
    this.tabs -= 1;
    println("### header action >>> ");
    printActionCode(this.behavior.getHeaderAction(""), 0);
    println("### header action <<< ");
    println("### preamble action>>>");
    printActionCode(this.grammar.preambleAction.getText(), 0);
    println("### preamble action <<<");
    flushTokens();
    String str = null;
    if (this.grammar.superClass != null)
      str = this.grammar.superClass;
    else
      str = "antlr." + this.grammar.getSuperClass();
    genJavadocComment(this.grammar);
    Object localObject1 = "";
    Token localToken = (Token)this.grammar.options.get("classHeaderPrefix");
    if (localToken != null)
    {
      localObject2 = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
      if (localObject2 != null)
        localObject1 = localObject2;
    }
    print("class " + this.parserClassName + "(" + str);
    println("):");
    this.tabs += 1;
    GrammarSymbol localGrammarSymbol;
    if (this.grammar.debuggingOutput)
    {
      println("_ruleNames = [");
      localObject2 = this.grammar.rules.elements();
      i = 0;
      this.tabs += 1;
      while (((Enumeration)localObject2).hasMoreElements())
      {
        localGrammarSymbol = (GrammarSymbol)((Enumeration)localObject2).nextElement();
        if (!(localGrammarSymbol instanceof RuleSymbol))
          continue;
        println("\"" + ((RuleSymbol)localGrammarSymbol).getId() + "\",");
      }
      this.tabs -= 1;
      println("]");
    }
    printGrammarAction(this.grammar);
    println("");
    println("def __init__(self, *args, **kwargs):");
    this.tabs += 1;
    println(str + ".__init__(self, *args, **kwargs)");
    println("self.tokenNames = _tokenNames");
    if (this.grammar.debuggingOutput)
    {
      println("self.ruleNames  = _ruleNames");
      println("self.semPredNames = _semPredNames");
      println("self.setupDebugging(self.tokenBuf)");
    }
    if (this.grammar.buildAST)
    {
      println("self.buildTokenTypeASTClassMap()");
      println("self.astFactory = antlr.ASTFactory(self.getTokenTypeToASTClassMap())");
      if (this.labeledElementASTType != null)
        println("self.astFactory.setASTNodeClass(" + this.labeledElementASTType + ")");
    }
    genHeaderInit(this.grammar);
    println("");
    Object localObject2 = this.grammar.rules.elements();
    int i = 0;
    while (((Enumeration)localObject2).hasMoreElements())
    {
      localGrammarSymbol = (GrammarSymbol)((Enumeration)localObject2).nextElement();
      if ((localGrammarSymbol instanceof RuleSymbol))
      {
        RuleSymbol localRuleSymbol = (RuleSymbol)localGrammarSymbol;
        genRule(localRuleSymbol, localRuleSymbol.references.size() == 0, i++);
      }
      exitIfError();
    }
    if (this.grammar.buildAST)
      genTokenASTNodeMap();
    genTokenStrings();
    genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
    if (this.grammar.debuggingOutput)
      genSemPredMap();
    println("");
    this.tabs = 0;
    genHeaderMain(this.grammar);
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void gen(RuleRefElement paramRuleRefElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genRR(" + paramRuleRefElement + ")");
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(paramRuleRefElement.targetRule);
    if ((localRuleSymbol == null) || (!localRuleSymbol.isDefined()))
    {
      this.antlrTool.error("Rule '" + paramRuleRefElement.targetRule + "' is not defined", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      return;
    }
    if (!(localRuleSymbol instanceof RuleSymbol))
    {
      this.antlrTool.error("'" + paramRuleRefElement.targetRule + "' does not name a grammar rule", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      return;
    }
    genErrorTryForElement(paramRuleRefElement);
    if (((this.grammar instanceof TreeWalkerGrammar)) && (paramRuleRefElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramRuleRefElement.getLabel() + " = antlr.ifelse(_t == antlr.ASTNULL, None, " + this.lt1Value + ")");
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramRuleRefElement.getAutoGenType() == 3)))
      println("_saveIndex = self.text.length()");
    printTabs();
    if (paramRuleRefElement.idAssign != null)
    {
      if (localRuleSymbol.block.returnAction == null)
        this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' has no return type", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      _print(paramRuleRefElement.idAssign + "=");
    }
    else if ((!(this.grammar instanceof LexerGrammar)) && (this.syntacticPredLevel == 0) && (localRuleSymbol.block.returnAction != null))
    {
      this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' returns a value", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
    }
    GenRuleInvocation(paramRuleRefElement);
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramRuleRefElement.getAutoGenType() == 3)))
      println("self.text.setLength(_saveIndex)");
    if (this.syntacticPredLevel == 0)
    {
      int i = (this.grammar.hasSyntacticPredicate) && (((this.grammar.buildAST) && (paramRuleRefElement.getLabel() != null)) || ((this.genAST) && (paramRuleRefElement.getAutoGenType() == 1))) ? 1 : 0;
      if ((i == 0) || ((this.grammar.buildAST) && (paramRuleRefElement.getLabel() != null)))
        println(paramRuleRefElement.getLabel() + "_AST = self.returnAST");
      if (this.genAST)
        switch (paramRuleRefElement.getAutoGenType())
        {
        case 1:
          println("self.addASTChild(currentAST, self.returnAST)");
          break;
        case 2:
          this.antlrTool.error("Internal: encountered ^ after rule reference");
          break;
        }
      if (((this.grammar instanceof LexerGrammar)) && (paramRuleRefElement.getLabel() != null))
        println(paramRuleRefElement.getLabel() + " = self._returnToken");
      if (i == 0);
    }
    genErrorCatchForElement(paramRuleRefElement);
  }

  public void gen(StringLiteralElement paramStringLiteralElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genString(" + paramStringLiteralElement + ")");
    if ((paramStringLiteralElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramStringLiteralElement.getLabel() + " = " + this.lt1Value + "");
    genElementAST(paramStringLiteralElement);
    boolean bool = this.saveText;
    this.saveText = ((this.saveText) && (paramStringLiteralElement.getAutoGenType() == 1));
    genMatch(paramStringLiteralElement);
    this.saveText = bool;
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t.getNextSibling()");
  }

  public void gen(TokenRangeElement paramTokenRangeElement)
  {
    genErrorTryForElement(paramTokenRangeElement);
    if ((paramTokenRangeElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramTokenRangeElement.getLabel() + " = " + this.lt1Value);
    genElementAST(paramTokenRangeElement);
    println("self.matchRange(u" + paramTokenRangeElement.beginText + ", u" + paramTokenRangeElement.endText + ")");
    genErrorCatchForElement(paramTokenRangeElement);
  }

  public void gen(TokenRefElement paramTokenRefElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genTokenRef(" + paramTokenRefElement + ")");
    if ((this.grammar instanceof LexerGrammar))
      this.antlrTool.panic("Token reference found in lexer");
    genErrorTryForElement(paramTokenRefElement);
    if ((paramTokenRefElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramTokenRefElement.getLabel() + " = " + this.lt1Value + "");
    genElementAST(paramTokenRefElement);
    genMatch(paramTokenRefElement);
    genErrorCatchForElement(paramTokenRefElement);
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t.getNextSibling()");
  }

  public void gen(TreeElement paramTreeElement)
  {
    println("_t" + paramTreeElement.ID + " = _t");
    if (paramTreeElement.root.getLabel() != null)
      println(paramTreeElement.root.getLabel() + " = antlr.ifelse(_t == antlr.ASTNULL, None, _t)");
    if (paramTreeElement.root.getAutoGenType() == 3)
    {
      this.antlrTool.error("Suffixing a root node with '!' is not implemented", this.grammar.getFilename(), paramTreeElement.getLine(), paramTreeElement.getColumn());
      paramTreeElement.root.setAutoGenType(1);
    }
    if (paramTreeElement.root.getAutoGenType() == 2)
    {
      this.antlrTool.warning("Suffixing a root node with '^' is redundant; already a root", this.grammar.getFilename(), paramTreeElement.getLine(), paramTreeElement.getColumn());
      paramTreeElement.root.setAutoGenType(1);
    }
    genElementAST(paramTreeElement.root);
    if (this.grammar.buildAST)
    {
      println("_currentAST" + paramTreeElement.ID + " = currentAST.copy()");
      println("currentAST.root = currentAST.child");
      println("currentAST.child = None");
    }
    if ((paramTreeElement.root instanceof WildcardElement))
      println("if not _t: raise antlr.MismatchedTokenException()");
    else
      genMatch(paramTreeElement.root);
    println("_t = _t.getFirstChild()");
    for (int i = 0; i < paramTreeElement.getAlternatives().size(); i++)
    {
      Alternative localAlternative = paramTreeElement.getAlternativeAt(i);
      for (AlternativeElement localAlternativeElement = localAlternative.head; localAlternativeElement != null; localAlternativeElement = localAlternativeElement.next)
        localAlternativeElement.generate();
    }
    if (this.grammar.buildAST)
      println("currentAST = _currentAST" + paramTreeElement.ID + "");
    println("_t = _t" + paramTreeElement.ID + "");
    println("_t = _t.getNextSibling()");
  }

  public void gen(TreeWalkerGrammar paramTreeWalkerGrammar)
    throws IOException
  {
    setGrammar(paramTreeWalkerGrammar);
    if (!(this.grammar instanceof TreeWalkerGrammar))
      this.antlrTool.panic("Internal error generating tree-walker");
    setupOutput(this.grammar.getClassName());
    this.genAST = this.grammar.buildAST;
    this.tabs = 0;
    genHeader();
    println("### import antlr and other modules ..");
    println("import sys");
    println("import antlr");
    println("");
    println("version = sys.version.split()[0]");
    println("if version < '2.2.1':");
    this.tabs += 1;
    println("False = 0");
    this.tabs -= 1;
    println("if version < '2.3':");
    this.tabs += 1;
    println("True = not False");
    this.tabs -= 1;
    println("### header action >>> ");
    printActionCode(this.behavior.getHeaderAction(""), 0);
    println("### header action <<< ");
    flushTokens();
    println("### user code>>>");
    printActionCode(this.grammar.preambleAction.getText(), 0);
    println("### user code<<<");
    String str1 = null;
    if (this.grammar.superClass != null)
      str1 = this.grammar.superClass;
    else
      str1 = "antlr." + this.grammar.getSuperClass();
    println("");
    Object localObject1 = "";
    Token localToken = (Token)this.grammar.options.get("classHeaderPrefix");
    if (localToken != null)
    {
      localObject2 = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
      if (localObject2 != null)
        localObject1 = localObject2;
    }
    genJavadocComment(this.grammar);
    println("class " + this.treeWalkerClassName + "(" + str1 + "):");
    this.tabs += 1;
    println("");
    println("# ctor ..");
    println("def __init__(self, *args, **kwargs):");
    this.tabs += 1;
    println(str1 + ".__init__(self, *args, **kwargs)");
    println("self.tokenNames = _tokenNames");
    genHeaderInit(this.grammar);
    this.tabs -= 1;
    println("");
    printGrammarAction(this.grammar);
    Object localObject2 = this.grammar.rules.elements();
    int i = 0;
    String str2 = "";
    while (((Enumeration)localObject2).hasMoreElements())
    {
      GrammarSymbol localGrammarSymbol = (GrammarSymbol)((Enumeration)localObject2).nextElement();
      if ((localGrammarSymbol instanceof RuleSymbol))
      {
        RuleSymbol localRuleSymbol = (RuleSymbol)localGrammarSymbol;
        genRule(localRuleSymbol, localRuleSymbol.references.size() == 0, i++);
      }
      exitIfError();
    }
    genTokenStrings();
    genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
    this.tabs = 0;
    genHeaderMain(this.grammar);
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void gen(WildcardElement paramWildcardElement)
  {
    if ((paramWildcardElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramWildcardElement.getLabel() + " = " + this.lt1Value + "");
    genElementAST(paramWildcardElement);
    if ((this.grammar instanceof TreeWalkerGrammar))
    {
      println("if not _t:");
      this.tabs += 1;
      println("raise antlr.MismatchedTokenException()");
      this.tabs -= 1;
    }
    else if ((this.grammar instanceof LexerGrammar))
    {
      if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramWildcardElement.getAutoGenType() == 3)))
        println("_saveIndex = self.text.length()");
      println("self.matchNot(antlr.EOF_CHAR)");
      if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramWildcardElement.getAutoGenType() == 3)))
        println("self.text.setLength(_saveIndex)");
    }
    else
    {
      println("self.matchNot(" + getValueString(1, false) + ")");
    }
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t.getNextSibling()");
  }

  public void gen(ZeroOrMoreBlock paramZeroOrMoreBlock)
  {
    int i = this.tabs;
    genBlockPreamble(paramZeroOrMoreBlock);
    println("while True:");
    this.tabs += 1;
    i = this.tabs;
    genBlockInitAction(paramZeroOrMoreBlock);
    String str1 = this.currentASTResult;
    if (paramZeroOrMoreBlock.getLabel() != null)
      this.currentASTResult = paramZeroOrMoreBlock.getLabel();
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramZeroOrMoreBlock);
    int j = 0;
    int k = this.grammar.maxk;
    if ((!paramZeroOrMoreBlock.greedy) && (paramZeroOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk) && (paramZeroOrMoreBlock.exitCache[paramZeroOrMoreBlock.exitLookaheadDepth].containsEpsilon()))
    {
      j = 1;
      k = paramZeroOrMoreBlock.exitLookaheadDepth;
    }
    else if ((!paramZeroOrMoreBlock.greedy) && (paramZeroOrMoreBlock.exitLookaheadDepth == 2147483647))
    {
      j = 1;
    }
    if (j != 0)
    {
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("nongreedy (...)* loop; exit depth is " + paramZeroOrMoreBlock.exitLookaheadDepth);
      String str2 = getLookaheadTestExpression(paramZeroOrMoreBlock.exitCache, k);
      println("###  nongreedy exit test");
      println("if (" + str2 + "):");
      this.tabs += 1;
      println("break");
      this.tabs -= 1;
    }
    int m = this.tabs;
    PythonBlockFinishingInfo localPythonBlockFinishingInfo = genCommonBlock(paramZeroOrMoreBlock, false);
    genBlockFinish(localPythonBlockFinishingInfo, "break");
    this.tabs = m;
    this.tabs = i;
    this.tabs -= 1;
    this.currentASTResult = str1;
  }

  protected void genAlt(Alternative paramAlternative, AlternativeBlock paramAlternativeBlock)
  {
    boolean bool1 = this.genAST;
    this.genAST = ((this.genAST) && (paramAlternative.getAutoGen()));
    boolean bool2 = this.saveText;
    this.saveText = ((this.saveText) && (paramAlternative.getAutoGen()));
    Hashtable localHashtable = this.treeVariableMap;
    this.treeVariableMap = new Hashtable();
    if (paramAlternative.exceptionSpec != null)
    {
      println("try:");
      this.tabs += 1;
    }
    println("pass");
    for (AlternativeElement localAlternativeElement = paramAlternative.head; !(localAlternativeElement instanceof BlockEndElement); localAlternativeElement = localAlternativeElement.next)
      localAlternativeElement.generate();
    if (this.genAST)
      if ((paramAlternativeBlock instanceof RuleBlock))
      {
        RuleBlock localRuleBlock = (RuleBlock)paramAlternativeBlock;
        if (this.grammar.hasSyntacticPredicate);
        println(localRuleBlock.getRuleName() + "_AST = currentAST.root");
        if (!this.grammar.hasSyntacticPredicate);
      }
      else if (paramAlternativeBlock.getLabel() != null)
      {
        this.antlrTool.warning("Labeled subrules not yet supported", this.grammar.getFilename(), paramAlternativeBlock.getLine(), paramAlternativeBlock.getColumn());
      }
    if (paramAlternative.exceptionSpec != null)
    {
      this.tabs -= 1;
      genErrorHandler(paramAlternative.exceptionSpec);
    }
    this.genAST = bool1;
    this.saveText = bool2;
    this.treeVariableMap = localHashtable;
  }

  protected void genBitsets(Vector paramVector, int paramInt)
  {
    println("");
    for (int i = 0; i < paramVector.size(); i++)
    {
      BitSet localBitSet = (BitSet)paramVector.elementAt(i);
      localBitSet.growToInclude(paramInt);
      genBitSet(localBitSet, i);
    }
  }

  private void genBitSet(BitSet paramBitSet, int paramInt)
  {
    int i = this.tabs;
    this.tabs = 0;
    println("");
    println("### generate bit set");
    println("def mk" + getBitsetName(paramInt) + "(): ");
    this.tabs += 1;
    int j = paramBitSet.lengthInLongWords();
    if (j < 8)
    {
      println("### var1");
      println("data = [ " + paramBitSet.toStringOfWords() + "]");
    }
    else
    {
      println("data = [0L] * " + j + " ### init list");
      long[] arrayOfLong = paramBitSet.toPackedArray();
      int k = 0;
      while (k < arrayOfLong.length)
      {
        if (arrayOfLong[k] == 0L)
        {
          k++;
          continue;
        }
        if ((k + 1 == arrayOfLong.length) || (arrayOfLong[k] != arrayOfLong[(k + 1)]))
        {
          println("data[" + k + "] =" + arrayOfLong[k] + "L");
          k++;
          continue;
        }
        for (int m = k + 1; (m < arrayOfLong.length) && (arrayOfLong[m] == arrayOfLong[k]); m++);
        long l = arrayOfLong[k];
        println("for x in xrange(" + k + ", " + m + "):");
        this.tabs += 1;
        println("data[x] = " + l + "L");
        this.tabs -= 1;
        k = m;
      }
    }
    println("return data");
    this.tabs -= 1;
    println(getBitsetName(paramInt) + " = antlr.BitSet(mk" + getBitsetName(paramInt) + "())");
    this.tabs = i;
  }

  private void genBlockFinish(PythonBlockFinishingInfo paramPythonBlockFinishingInfo, String paramString)
  {
    if ((paramPythonBlockFinishingInfo.needAnErrorClause) && ((paramPythonBlockFinishingInfo.generatedAnIf) || (paramPythonBlockFinishingInfo.generatedSwitch)))
    {
      if (paramPythonBlockFinishingInfo.generatedAnIf)
        println("else:");
      this.tabs += 1;
      println(paramString);
      this.tabs -= 1;
    }
    if (paramPythonBlockFinishingInfo.postscript != null)
      println(paramPythonBlockFinishingInfo.postscript);
  }

  private void genBlockFinish1(PythonBlockFinishingInfo paramPythonBlockFinishingInfo, String paramString)
  {
    if ((paramPythonBlockFinishingInfo.needAnErrorClause) && ((paramPythonBlockFinishingInfo.generatedAnIf) || (paramPythonBlockFinishingInfo.generatedSwitch)))
    {
      if (paramPythonBlockFinishingInfo.generatedAnIf)
        println("else:");
      this.tabs += 1;
      println(paramString);
      this.tabs -= 1;
      if (!paramPythonBlockFinishingInfo.generatedAnIf);
    }
    if (paramPythonBlockFinishingInfo.postscript != null)
      println(paramPythonBlockFinishingInfo.postscript);
  }

  protected void genBlockInitAction(AlternativeBlock paramAlternativeBlock)
  {
    if (paramAlternativeBlock.initAction != null)
      printAction(processActionForSpecialSymbols(paramAlternativeBlock.initAction, paramAlternativeBlock.getLine(), this.currentRule, null));
  }

  protected void genBlockPreamble(AlternativeBlock paramAlternativeBlock)
  {
    if ((paramAlternativeBlock instanceof RuleBlock))
    {
      RuleBlock localRuleBlock = (RuleBlock)paramAlternativeBlock;
      if (localRuleBlock.labeledElements != null)
        for (int i = 0; i < localRuleBlock.labeledElements.size(); i++)
        {
          AlternativeElement localAlternativeElement = (AlternativeElement)localRuleBlock.labeledElements.elementAt(i);
          if (((localAlternativeElement instanceof RuleRefElement)) || (((localAlternativeElement instanceof AlternativeBlock)) && (!(localAlternativeElement instanceof RuleBlock)) && (!(localAlternativeElement instanceof SynPredBlock))))
          {
            if ((!(localAlternativeElement instanceof RuleRefElement)) && (((AlternativeBlock)localAlternativeElement).not) && (this.analyzer.subruleCanBeInverted((AlternativeBlock)localAlternativeElement, this.grammar instanceof LexerGrammar)))
            {
              println(localAlternativeElement.getLabel() + " = " + this.labeledElementInit);
              if (!this.grammar.buildAST)
                continue;
              genASTDeclaration(localAlternativeElement);
            }
            else
            {
              if (this.grammar.buildAST)
                genASTDeclaration(localAlternativeElement);
              if ((this.grammar instanceof LexerGrammar))
                println(localAlternativeElement.getLabel() + " = None");
              if (!(this.grammar instanceof TreeWalkerGrammar))
                continue;
              println(localAlternativeElement.getLabel() + " = " + this.labeledElementInit);
            }
          }
          else
          {
            println(localAlternativeElement.getLabel() + " = " + this.labeledElementInit);
            if (!this.grammar.buildAST)
              continue;
            if (((localAlternativeElement instanceof GrammarAtom)) && (((GrammarAtom)localAlternativeElement).getASTNodeType() != null))
            {
              GrammarAtom localGrammarAtom = (GrammarAtom)localAlternativeElement;
              genASTDeclaration(localAlternativeElement, localGrammarAtom.getASTNodeType());
            }
            else
            {
              genASTDeclaration(localAlternativeElement);
            }
          }
        }
    }
  }

  protected void genCases(BitSet paramBitSet)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genCases(" + paramBitSet + ")");
    int[] arrayOfInt = paramBitSet.toArray();
    int i = (this.grammar instanceof LexerGrammar) ? 4 : 1;
    int j = 1;
    int k = 1;
    print("elif la1 and la1 in ");
    if ((this.grammar instanceof LexerGrammar))
    {
      _print("u'");
      for (m = 0; m < arrayOfInt.length; m++)
        _print(getValueString(arrayOfInt[m], false));
      _print("':\n");
      return;
    }
    _print("[");
    for (int m = 0; m < arrayOfInt.length; m++)
    {
      _print(getValueString(arrayOfInt[m], false));
      if (m + 1 >= arrayOfInt.length)
        continue;
      _print(",");
    }
    _print("]:\n");
  }

  public PythonBlockFinishingInfo genCommonBlock(AlternativeBlock paramAlternativeBlock, boolean paramBoolean)
  {
    int i = this.tabs;
    int j = 0;
    int k = 0;
    int m = 0;
    PythonBlockFinishingInfo localPythonBlockFinishingInfo = new PythonBlockFinishingInfo();
    boolean bool1 = this.genAST;
    this.genAST = ((this.genAST) && (paramAlternativeBlock.getAutoGen()));
    boolean bool2 = this.saveText;
    this.saveText = ((this.saveText) && (paramAlternativeBlock.getAutoGen()));
    Object localObject1;
    if ((paramAlternativeBlock.not) && (this.analyzer.subruleCanBeInverted(paramAlternativeBlock, this.grammar instanceof LexerGrammar)))
    {
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("special case: ~(subrule)");
      localObject1 = this.analyzer.look(1, paramAlternativeBlock);
      if ((paramAlternativeBlock.getLabel() != null) && (this.syntacticPredLevel == 0))
        println(paramAlternativeBlock.getLabel() + " = " + this.lt1Value);
      genElementAST(paramAlternativeBlock);
      String str1 = "";
      if ((this.grammar instanceof TreeWalkerGrammar))
        str1 = "_t, ";
      println("self.match(" + str1 + getBitsetName(markBitsetForGen(((Lookahead)localObject1).fset)) + ")");
      if ((this.grammar instanceof TreeWalkerGrammar))
        println("_t = _t.getNextSibling()");
      return localPythonBlockFinishingInfo;
    }
    if (paramAlternativeBlock.getAlternatives().size() == 1)
    {
      localObject1 = paramAlternativeBlock.getAlternativeAt(0);
      if (((Alternative)localObject1).synPred != null)
        this.antlrTool.warning("Syntactic predicate superfluous for single alternative", this.grammar.getFilename(), paramAlternativeBlock.getAlternativeAt(0).synPred.getLine(), paramAlternativeBlock.getAlternativeAt(0).synPred.getColumn());
      if (paramBoolean)
      {
        if (((Alternative)localObject1).semPred != null)
          genSemPred(((Alternative)localObject1).semPred, paramAlternativeBlock.line);
        genAlt((Alternative)localObject1, paramAlternativeBlock);
        return localPythonBlockFinishingInfo;
      }
    }
    int n = 0;
    for (int i1 = 0; i1 < paramAlternativeBlock.getAlternatives().size(); i1++)
    {
      Alternative localAlternative1 = paramAlternativeBlock.getAlternativeAt(i1);
      if (!suitableForCaseExpression(localAlternative1))
        continue;
      n++;
    }
    Object localObject2;
    if (n >= this.makeSwitchThreshold)
    {
      String str2 = lookaheadString(1);
      k = 1;
      if ((this.grammar instanceof TreeWalkerGrammar))
      {
        println("if not _t:");
        this.tabs += 1;
        println("_t = antlr.ASTNULL");
        this.tabs -= 1;
      }
      println("la1 = " + str2);
      println("if False:");
      this.tabs += 1;
      println("pass");
      this.tabs -= 1;
      for (i3 = 0; i3 < paramAlternativeBlock.alternatives.size(); i3++)
      {
        Alternative localAlternative2 = paramAlternativeBlock.getAlternativeAt(i3);
        if (!suitableForCaseExpression(localAlternative2))
          continue;
        localObject2 = localAlternative2.cache[1];
        if ((((Lookahead)localObject2).fset.degree() == 0) && (!((Lookahead)localObject2).containsEpsilon()))
        {
          this.antlrTool.warning("Alternate omitted due to empty prediction set", this.grammar.getFilename(), localAlternative2.head.getLine(), localAlternative2.head.getColumn());
        }
        else
        {
          genCases(((Lookahead)localObject2).fset);
          this.tabs += 1;
          genAlt(localAlternative2, paramAlternativeBlock);
          this.tabs -= 1;
        }
      }
      println("else:");
      this.tabs += 1;
    }
    int i2 = (this.grammar instanceof LexerGrammar) ? this.grammar.maxk : 0;
    for (int i3 = i2; i3 >= 0; i3--)
      for (int i4 = 0; i4 < paramAlternativeBlock.alternatives.size(); i4++)
      {
        localObject2 = paramAlternativeBlock.getAlternativeAt(i4);
        if (this.DEBUG_CODE_GENERATOR)
          System.out.println("genAlt: " + i4);
        if ((k != 0) && (suitableForCaseExpression((Alternative)localObject2)))
        {
          if (!this.DEBUG_CODE_GENERATOR)
            continue;
          System.out.println("ignoring alt because it was in the switch");
        }
        else
        {
          boolean bool3 = false;
          String str4;
          if ((this.grammar instanceof LexerGrammar))
          {
            int i5 = ((Alternative)localObject2).lookaheadDepth;
            if (i5 == 2147483647);
            for (i5 = this.grammar.maxk; (i5 >= 1) && (localObject2.cache[i5].containsEpsilon()); i5--);
            if (i5 != i3)
            {
              if (!this.DEBUG_CODE_GENERATOR)
                continue;
              System.out.println("ignoring alt because effectiveDepth!=altDepth" + i5 + "!=" + i3);
              continue;
            }
            bool3 = lookaheadIsEmpty((Alternative)localObject2, i5);
            str4 = getLookaheadTestExpression((Alternative)localObject2, i5);
          }
          else
          {
            bool3 = lookaheadIsEmpty((Alternative)localObject2, this.grammar.maxk);
            str4 = getLookaheadTestExpression((Alternative)localObject2, this.grammar.maxk);
          }
          if ((localObject2.cache[1].fset.degree() > 127) && (suitableForCaseExpression((Alternative)localObject2)))
          {
            if (j == 0)
              println("<m1> if " + str4 + ":");
            else
              println("<m2> elif " + str4 + ":");
          }
          else if ((bool3) && (((Alternative)localObject2).semPred == null) && (((Alternative)localObject2).synPred == null))
          {
            if (j == 0)
            {
              println("##<m3> <closing");
            }
            else
            {
              println("else: ## <m4>");
              this.tabs += 1;
            }
            localPythonBlockFinishingInfo.needAnErrorClause = false;
          }
          else
          {
            if (((Alternative)localObject2).semPred != null)
            {
              ActionTransInfo localActionTransInfo = new ActionTransInfo();
              String str5 = processActionForSpecialSymbols(((Alternative)localObject2).semPred, paramAlternativeBlock.line, this.currentRule, localActionTransInfo);
              if ((((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))) && (this.grammar.debuggingOutput))
                str4 = "(" + str4 + " and fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.PREDICTING, " + addSemPred(this.charFormatter.escapeString(str5)) + ", " + str5 + "))";
              else
                str4 = "(" + str4 + " and (" + str5 + "))";
            }
            if (j > 0)
            {
              if (((Alternative)localObject2).synPred != null)
              {
                println("else:");
                this.tabs += 1;
                genSynPred(((Alternative)localObject2).synPred, str4);
                m++;
              }
              else
              {
                println("elif " + str4 + ":");
              }
            }
            else if (((Alternative)localObject2).synPred != null)
            {
              genSynPred(((Alternative)localObject2).synPred, str4);
            }
            else
            {
              if ((this.grammar instanceof TreeWalkerGrammar))
              {
                println("if not _t:");
                this.tabs += 1;
                println("_t = antlr.ASTNULL");
                this.tabs -= 1;
              }
              println("if " + str4 + ":");
            }
          }
          j++;
          this.tabs += 1;
          genAlt((Alternative)localObject2, paramAlternativeBlock);
          this.tabs -= 1;
        }
      }
    String str3 = "";
    this.genAST = bool1;
    this.saveText = bool2;
    if (k != 0)
    {
      localPythonBlockFinishingInfo.postscript = str3;
      localPythonBlockFinishingInfo.generatedSwitch = true;
      localPythonBlockFinishingInfo.generatedAnIf = (j > 0);
    }
    else
    {
      localPythonBlockFinishingInfo.postscript = str3;
      localPythonBlockFinishingInfo.generatedSwitch = false;
      localPythonBlockFinishingInfo.generatedAnIf = (j > 0);
    }
    return (PythonBlockFinishingInfo)(PythonBlockFinishingInfo)localPythonBlockFinishingInfo;
  }

  private static boolean suitableForCaseExpression(Alternative paramAlternative)
  {
    return (paramAlternative.lookaheadDepth == 1) && (paramAlternative.semPred == null) && (!paramAlternative.cache[1].containsEpsilon()) && (paramAlternative.cache[1].fset.degree() <= 127);
  }

  private void genElementAST(AlternativeElement paramAlternativeElement)
  {
    if (((this.grammar instanceof TreeWalkerGrammar)) && (!this.grammar.buildAST))
    {
      if (paramAlternativeElement.getLabel() == null)
      {
        String str1 = this.lt1Value;
        String str2 = "tmp" + this.astVarNumber + "_AST";
        this.astVarNumber += 1;
        mapTreeVariable(paramAlternativeElement, str2);
        println(str2 + "_in = " + str1);
      }
      return;
    }
    if ((this.grammar.buildAST) && (this.syntacticPredLevel == 0))
    {
      int i = (this.genAST) && ((paramAlternativeElement.getLabel() != null) || (paramAlternativeElement.getAutoGenType() != 3)) ? 1 : 0;
      if ((paramAlternativeElement.getAutoGenType() != 3) && ((paramAlternativeElement instanceof TokenRefElement)))
        i = 1;
      int j = (this.grammar.hasSyntacticPredicate) && (i != 0) ? 1 : 0;
      String str3;
      String str4;
      if (paramAlternativeElement.getLabel() != null)
      {
        str3 = paramAlternativeElement.getLabel();
        str4 = paramAlternativeElement.getLabel();
      }
      else
      {
        str3 = this.lt1Value;
        str4 = "tmp" + this.astVarNumber;
        this.astVarNumber += 1;
      }
      if (i != 0)
        if ((paramAlternativeElement instanceof GrammarAtom))
        {
          localObject = (GrammarAtom)paramAlternativeElement;
          if (((GrammarAtom)localObject).getASTNodeType() != null)
            genASTDeclaration(paramAlternativeElement, str4, ((GrammarAtom)localObject).getASTNodeType());
          else
            genASTDeclaration(paramAlternativeElement, str4, this.labeledElementASTType);
        }
        else
        {
          genASTDeclaration(paramAlternativeElement, str4, this.labeledElementASTType);
        }
      Object localObject = str4 + "_AST";
      mapTreeVariable(paramAlternativeElement, (String)localObject);
      if ((this.grammar instanceof TreeWalkerGrammar))
        println((String)localObject + "_in = None");
      if ((j == 0) || (paramAlternativeElement.getLabel() != null))
        if ((paramAlternativeElement instanceof GrammarAtom))
          println((String)localObject + " = " + getASTCreateString((GrammarAtom)paramAlternativeElement, str3) + "");
        else
          println((String)localObject + " = " + getASTCreateString(str3) + "");
      if ((paramAlternativeElement.getLabel() == null) && (i != 0))
      {
        str3 = this.lt1Value;
        if ((paramAlternativeElement instanceof GrammarAtom))
          println((String)localObject + " = " + getASTCreateString((GrammarAtom)paramAlternativeElement, str3) + "");
        else
          println((String)localObject + " = " + getASTCreateString(str3) + "");
        if ((this.grammar instanceof TreeWalkerGrammar))
          println((String)localObject + "_in = " + str3 + "");
      }
      if (this.genAST)
        switch (paramAlternativeElement.getAutoGenType())
        {
        case 1:
          println("self.addASTChild(currentAST, " + (String)localObject + ")");
          break;
        case 2:
          println("self.makeASTRoot(currentAST, " + (String)localObject + ")");
          break;
        }
      if (j == 0);
    }
  }

  private void genErrorCatchForElement(AlternativeElement paramAlternativeElement)
  {
    if (paramAlternativeElement.getLabel() == null)
      return;
    String str = paramAlternativeElement.enclosingRuleName;
    if ((this.grammar instanceof LexerGrammar))
      str = CodeGenerator.encodeLexerRuleName(paramAlternativeElement.enclosingRuleName);
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(str);
    if (localRuleSymbol == null)
      this.antlrTool.panic("Enclosing rule not found!");
    ExceptionSpec localExceptionSpec = localRuleSymbol.block.findExceptionSpec(paramAlternativeElement.getLabel());
    if (localExceptionSpec != null)
    {
      this.tabs -= 1;
      genErrorHandler(localExceptionSpec);
    }
  }

  private void genErrorHandler(ExceptionSpec paramExceptionSpec)
  {
    for (int i = 0; i < paramExceptionSpec.handlers.size(); i++)
    {
      ExceptionHandler localExceptionHandler = (ExceptionHandler)paramExceptionSpec.handlers.elementAt(i);
      String str1 = "";
      String str2 = "";
      String str3 = localExceptionHandler.exceptionTypeAndName.getText();
      str3 = removeAssignmentFromDeclaration(str3);
      str3 = str3.trim();
      for (int j = str3.length() - 1; j >= 0; j--)
      {
        if ((Character.isLetterOrDigit(str3.charAt(j))) || (str3.charAt(j) == '_'))
          continue;
        str1 = str3.substring(0, j);
        str2 = str3.substring(j + 1);
        break;
      }
      println("except " + str1 + ", " + str2 + ":");
      this.tabs += 1;
      if (this.grammar.hasSyntacticPredicate)
      {
        println("if not self.inputState.guessing:");
        this.tabs += 1;
      }
      ActionTransInfo localActionTransInfo = new ActionTransInfo();
      printAction(processActionForSpecialSymbols(localExceptionHandler.action.getText(), localExceptionHandler.action.getLine(), this.currentRule, localActionTransInfo));
      if (this.grammar.hasSyntacticPredicate)
      {
        this.tabs -= 1;
        println("else:");
        this.tabs += 1;
        println("raise " + str2);
        this.tabs -= 1;
      }
      this.tabs -= 1;
    }
  }

  private void genErrorTryForElement(AlternativeElement paramAlternativeElement)
  {
    if (paramAlternativeElement.getLabel() == null)
      return;
    String str = paramAlternativeElement.enclosingRuleName;
    if ((this.grammar instanceof LexerGrammar))
      str = CodeGenerator.encodeLexerRuleName(paramAlternativeElement.enclosingRuleName);
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(str);
    if (localRuleSymbol == null)
      this.antlrTool.panic("Enclosing rule not found!");
    ExceptionSpec localExceptionSpec = localRuleSymbol.block.findExceptionSpec(paramAlternativeElement.getLabel());
    if (localExceptionSpec != null)
    {
      println("try: # for error handling");
      this.tabs += 1;
    }
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement)
  {
    genASTDeclaration(paramAlternativeElement, this.labeledElementASTType);
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement, String paramString)
  {
    genASTDeclaration(paramAlternativeElement, paramAlternativeElement.getLabel(), paramString);
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement, String paramString1, String paramString2)
  {
    if (this.declaredASTVariables.contains(paramAlternativeElement))
      return;
    println(paramString1 + "_AST = None");
    this.declaredASTVariables.put(paramAlternativeElement, paramAlternativeElement);
  }

  protected void genHeader()
  {
    println("### $ANTLR " + Tool.version + ": " + "\"" + this.antlrTool.fileMinusPath(this.antlrTool.grammarFile) + "\"" + " -> " + "\"" + this.grammar.getClassName() + ".py\"$");
  }

  protected void genLexerTest()
  {
    String str = this.grammar.getClassName();
    println("if __name__ == '__main__' :");
    this.tabs += 1;
    println("import sys");
    println("import antlr");
    println("import " + str);
    println("");
    println("### create lexer - shall read from stdin");
    println("try:");
    this.tabs += 1;
    println("for token in " + str + ".Lexer():");
    this.tabs += 1;
    println("print token");
    println("");
    this.tabs -= 1;
    this.tabs -= 1;
    println("except antlr.TokenStreamException, e:");
    this.tabs += 1;
    println("print \"error: exception caught while lexing: \", e");
    this.tabs -= 1;
    this.tabs -= 1;
  }

  private void genLiteralsTest()
  {
    println("### option { testLiterals=true } ");
    println("_ttype = self.testLiteralsTable(_ttype)");
  }

  private void genLiteralsTestForPartialToken()
  {
    println("_ttype = self.testLiteralsTable(self.text.getString(), _begin, self.text.length()-_begin, _ttype)");
  }

  protected void genMatch(BitSet paramBitSet)
  {
  }

  protected void genMatch(GrammarAtom paramGrammarAtom)
  {
    if ((paramGrammarAtom instanceof StringLiteralElement))
    {
      if ((this.grammar instanceof LexerGrammar))
        genMatchUsingAtomText(paramGrammarAtom);
      else
        genMatchUsingAtomTokenType(paramGrammarAtom);
    }
    else if ((paramGrammarAtom instanceof CharLiteralElement))
    {
      if ((this.grammar instanceof LexerGrammar))
        genMatchUsingAtomText(paramGrammarAtom);
      else
        this.antlrTool.error("cannot ref character literals in grammar: " + paramGrammarAtom);
    }
    else if ((paramGrammarAtom instanceof TokenRefElement))
      genMatchUsingAtomText(paramGrammarAtom);
    else if ((paramGrammarAtom instanceof WildcardElement))
      gen((WildcardElement)paramGrammarAtom);
  }

  protected void genMatchUsingAtomText(GrammarAtom paramGrammarAtom)
  {
    String str = "";
    if ((this.grammar instanceof TreeWalkerGrammar))
      str = "_t,";
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramGrammarAtom.getAutoGenType() == 3)))
      println("_saveIndex = self.text.length()");
    print(paramGrammarAtom.not ? "self.matchNot(" : "self.match(");
    _print(str);
    if (paramGrammarAtom.atomText.equals("EOF"))
      _print("EOF_TYPE");
    else
      _print(paramGrammarAtom.atomText);
    _println(")");
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramGrammarAtom.getAutoGenType() == 3)))
      println("self.text.setLength(_saveIndex)");
  }

  protected void genMatchUsingAtomTokenType(GrammarAtom paramGrammarAtom)
  {
    String str1 = "";
    if ((this.grammar instanceof TreeWalkerGrammar))
      str1 = "_t,";
    Object localObject = null;
    String str2 = str1 + getValueString(paramGrammarAtom.getType(), true);
    println((paramGrammarAtom.not ? "self.matchNot(" : "self.match(") + str2 + ")");
  }

  public void genNextToken()
  {
    int i = 0;
    for (int j = 0; j < this.grammar.rules.size(); j++)
    {
      localRuleSymbol1 = (RuleSymbol)this.grammar.rules.elementAt(j);
      if ((!localRuleSymbol1.isDefined()) || (!localRuleSymbol1.access.equals("public")))
        continue;
      i = 1;
      break;
    }
    if (i == 0)
    {
      println("");
      println("def nextToken(self): ");
      this.tabs += 1;
      println("try:");
      this.tabs += 1;
      println("self.uponEOF()");
      this.tabs -= 1;
      println("except antlr.CharStreamIOException, csioe:");
      this.tabs += 1;
      println("raise antlr.TokenStreamIOException(csioe.io)");
      this.tabs -= 1;
      println("except antlr.CharStreamException, cse:");
      this.tabs += 1;
      println("raise antlr.TokenStreamException(str(cse))");
      this.tabs -= 1;
      println("return antlr.CommonToken(type=EOF_TYPE, text=\"\")");
      this.tabs -= 1;
      return;
    }
    RuleBlock localRuleBlock = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
    RuleSymbol localRuleSymbol1 = new RuleSymbol("mnextToken");
    localRuleSymbol1.setDefined();
    localRuleSymbol1.setBlock(localRuleBlock);
    localRuleSymbol1.access = "private";
    this.grammar.define(localRuleSymbol1);
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(localRuleBlock);
    String str1 = null;
    if (((LexerGrammar)this.grammar).filterMode)
      str1 = ((LexerGrammar)this.grammar).filterRule;
    println("");
    println("def nextToken(self):");
    this.tabs += 1;
    println("while True:");
    this.tabs += 1;
    println("try: ### try again ..");
    this.tabs += 1;
    println("while True:");
    this.tabs += 1;
    int k = this.tabs;
    println("_token = None");
    println("_ttype = INVALID_TYPE");
    if (((LexerGrammar)this.grammar).filterMode)
    {
      println("self.setCommitToPath(False)");
      if (str1 != null)
      {
        if (!this.grammar.isDefined(CodeGenerator.encodeLexerRuleName(str1)))
        {
          this.grammar.antlrTool.error("Filter rule " + str1 + " does not exist in this lexer");
        }
        else
        {
          RuleSymbol localRuleSymbol2 = (RuleSymbol)this.grammar.getSymbol(CodeGenerator.encodeLexerRuleName(str1));
          if (!localRuleSymbol2.isDefined())
            this.grammar.antlrTool.error("Filter rule " + str1 + " does not exist in this lexer");
          else if (localRuleSymbol2.access.equals("public"))
            this.grammar.antlrTool.error("Filter rule " + str1 + " must be protected");
        }
        println("_m = self.mark()");
      }
    }
    println("self.resetText()");
    println("try: ## for char stream error handling");
    this.tabs += 1;
    k = this.tabs;
    println("try: ##for lexical error handling");
    this.tabs += 1;
    k = this.tabs;
    for (int m = 0; m < localRuleBlock.getAlternatives().size(); m++)
    {
      localObject1 = localRuleBlock.getAlternativeAt(m);
      if (!localObject1.cache[1].containsEpsilon())
        continue;
      localObject2 = (RuleRefElement)((Alternative)localObject1).head;
      String str3 = CodeGenerator.decodeLexerRuleName(((RuleRefElement)localObject2).targetRule);
      this.antlrTool.warning("public lexical rule " + str3 + " is optional (can match \"nothing\")");
    }
    String str2 = System.getProperty("line.separator");
    Object localObject1 = genCommonBlock(localRuleBlock, false);
    Object localObject2 = "";
    if (((LexerGrammar)this.grammar).filterMode)
    {
      if (str1 == null)
        localObject2 = (String)localObject2 + "self.filterdefault(self.LA(1))";
      else
        localObject2 = (String)localObject2 + "self.filterdefault(self.LA(1), self.m" + str1 + ", False)";
    }
    else
      localObject2 = "self.default(self.LA(1))";
    genBlockFinish1((PythonBlockFinishingInfo)localObject1, (String)localObject2);
    this.tabs = k;
    if ((((LexerGrammar)this.grammar).filterMode) && (str1 != null))
      println("self.commit()");
    println("if not self._returnToken:");
    this.tabs += 1;
    println("raise antlr.TryAgain ### found SKIP token");
    this.tabs -= 1;
    if (((LexerGrammar)this.grammar).getTestLiterals())
    {
      println("### option { testLiterals=true } ");
      println("self.testForLiteral(self._returnToken)");
    }
    println("### return token to caller");
    println("return self._returnToken");
    this.tabs -= 1;
    println("### handle lexical errors ....");
    println("except antlr.RecognitionException, e:");
    this.tabs += 1;
    if (((LexerGrammar)this.grammar).filterMode)
      if (str1 == null)
      {
        println("if not self.getCommitToPath():");
        this.tabs += 1;
        println("self.consume()");
        println("raise antlr.TryAgain()");
        this.tabs -= 1;
      }
      else
      {
        println("if not self.getCommitToPath(): ");
        this.tabs += 1;
        println("self.rewind(_m)");
        println("self.resetText()");
        println("try:");
        this.tabs += 1;
        println("self.m" + str1 + "(False)");
        this.tabs -= 1;
        println("except antlr.RecognitionException, ee:");
        this.tabs += 1;
        println("### horrendous failure: error in filter rule");
        println("self.reportError(ee)");
        println("self.consume()");
        this.tabs -= 1;
        println("raise antlr.TryAgain()");
        this.tabs -= 1;
      }
    if (localRuleBlock.getDefaultErrorHandler())
    {
      println("self.reportError(e)");
      println("self.consume()");
    }
    else
    {
      println("raise antlr.TokenStreamRecognitionException(e)");
    }
    this.tabs -= 1;
    this.tabs -= 1;
    println("### handle char stream errors ...");
    println("except antlr.CharStreamException,cse:");
    this.tabs += 1;
    println("if isinstance(cse, antlr.CharStreamIOException):");
    this.tabs += 1;
    println("raise antlr.TokenStreamIOException(cse.io)");
    this.tabs -= 1;
    println("else:");
    this.tabs += 1;
    println("raise antlr.TokenStreamException(str(cse))");
    this.tabs -= 1;
    this.tabs -= 1;
    this.tabs -= 1;
    this.tabs -= 1;
    println("except antlr.TryAgain:");
    this.tabs += 1;
    println("pass");
    this.tabs -= 1;
    this.tabs -= 1;
  }

  public void genRule(RuleSymbol paramRuleSymbol, boolean paramBoolean, int paramInt)
  {
    this.tabs = 1;
    if (!paramRuleSymbol.isDefined())
    {
      this.antlrTool.error("undefined rule: " + paramRuleSymbol.getId());
      return;
    }
    RuleBlock localRuleBlock = paramRuleSymbol.getBlock();
    this.currentRule = localRuleBlock;
    this.currentASTResult = paramRuleSymbol.getId();
    this.declaredASTVariables.clear();
    boolean bool1 = this.genAST;
    this.genAST = ((this.genAST) && (localRuleBlock.getAutoGen()));
    this.saveText = localRuleBlock.getAutoGen();
    genJavadocComment(paramRuleSymbol);
    print("def " + paramRuleSymbol.getId() + "(");
    _print(this.commonExtraParams);
    if ((this.commonExtraParams.length() != 0) && (localRuleBlock.argAction != null))
      _print(",");
    if (localRuleBlock.argAction != null)
    {
      _println("");
      this.tabs += 1;
      println(localRuleBlock.argAction);
      this.tabs -= 1;
      print("):");
    }
    else
    {
      _print("):");
    }
    println("");
    this.tabs += 1;
    if (localRuleBlock.returnAction != null)
      if (localRuleBlock.returnAction.indexOf('=') >= 0)
        println(localRuleBlock.returnAction);
      else
        println(extractIdOfAction(localRuleBlock.returnAction, localRuleBlock.getLine(), localRuleBlock.getColumn()) + " = None");
    println(this.commonLocalVars);
    if (this.grammar.traceRules)
      if ((this.grammar instanceof TreeWalkerGrammar))
        println("self.traceIn(\"" + paramRuleSymbol.getId() + "\",_t)");
      else
        println("self.traceIn(\"" + paramRuleSymbol.getId() + "\")");
    if ((this.grammar instanceof LexerGrammar))
    {
      if (paramRuleSymbol.getId().equals("mEOF"))
        println("_ttype = EOF_TYPE");
      else
        println("_ttype = " + paramRuleSymbol.getId().substring(1));
      println("_saveIndex = 0");
    }
    if (this.grammar.debuggingOutput)
      if ((this.grammar instanceof ParserGrammar))
        println("self.fireEnterRule(" + paramInt + ", 0)");
      else if ((this.grammar instanceof LexerGrammar))
        println("self.fireEnterRule(" + paramInt + ", _ttype)");
    if ((this.grammar.debuggingOutput) || (this.grammar.traceRules))
    {
      println("try: ### debugging");
      this.tabs += 1;
    }
    if ((this.grammar instanceof TreeWalkerGrammar))
    {
      println(paramRuleSymbol.getId() + "_AST_in = None");
      println("if _t != antlr.ASTNULL:");
      this.tabs += 1;
      println(paramRuleSymbol.getId() + "_AST_in = _t");
      this.tabs -= 1;
    }
    if (this.grammar.buildAST)
    {
      println("self.returnAST = None");
      println("currentAST = antlr.ASTPair()");
      println(paramRuleSymbol.getId() + "_AST = None");
    }
    genBlockPreamble(localRuleBlock);
    genBlockInitAction(localRuleBlock);
    ExceptionSpec localExceptionSpec = localRuleBlock.findExceptionSpec("");
    if ((localExceptionSpec != null) || (localRuleBlock.getDefaultErrorHandler()))
    {
      println("try:      ## for error handling");
      this.tabs += 1;
    }
    int i = this.tabs;
    Object localObject;
    if (localRuleBlock.alternatives.size() == 1)
    {
      Alternative localAlternative = localRuleBlock.getAlternativeAt(0);
      localObject = localAlternative.semPred;
      if (localObject != null)
        genSemPred((String)localObject, this.currentRule.line);
      if (localAlternative.synPred != null)
        this.antlrTool.warning("Syntactic predicate ignored for single alternative", this.grammar.getFilename(), localAlternative.synPred.getLine(), localAlternative.synPred.getColumn());
      genAlt(localAlternative, localRuleBlock);
    }
    else
    {
      boolean bool2 = this.grammar.theLLkAnalyzer.deterministic(localRuleBlock);
      localObject = genCommonBlock(localRuleBlock, false);
      genBlockFinish((PythonBlockFinishingInfo)localObject, this.throwNoViable);
    }
    this.tabs = i;
    if ((localExceptionSpec != null) || (localRuleBlock.getDefaultErrorHandler()))
    {
      this.tabs -= 1;
      println("");
    }
    if (localExceptionSpec != null)
    {
      genErrorHandler(localExceptionSpec);
    }
    else if (localRuleBlock.getDefaultErrorHandler())
    {
      println("except " + this.exceptionThrown + ", ex:");
      this.tabs += 1;
      if (this.grammar.hasSyntacticPredicate)
      {
        println("if not self.inputState.guessing:");
        this.tabs += 1;
      }
      println("self.reportError(ex)");
      if (!(this.grammar instanceof TreeWalkerGrammar))
      {
        Lookahead localLookahead = this.grammar.theLLkAnalyzer.FOLLOW(1, localRuleBlock.endNode);
        localObject = getBitsetName(markBitsetForGen(localLookahead.fset));
        println("self.consume()");
        println("self.consumeUntil(" + (String)localObject + ")");
      }
      else
      {
        println("if _t:");
        this.tabs += 1;
        println("_t = _t.getNextSibling()");
        this.tabs -= 1;
      }
      if (this.grammar.hasSyntacticPredicate)
      {
        this.tabs -= 1;
        println("else:");
        this.tabs += 1;
        println("raise ex");
        this.tabs -= 1;
      }
      this.tabs -= 1;
      println("");
    }
    if (this.grammar.buildAST)
      println("self.returnAST = " + paramRuleSymbol.getId() + "_AST");
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("self._retTree = _t");
    if (localRuleBlock.getTestLiterals())
      if (paramRuleSymbol.access.equals("protected"))
        genLiteralsTestForPartialToken();
      else
        genLiteralsTest();
    if ((this.grammar instanceof LexerGrammar))
      println("self.set_return_token(_createToken, _token, _ttype, _begin)");
    if (localRuleBlock.returnAction != null)
      println("return " + extractIdOfAction(localRuleBlock.returnAction, localRuleBlock.getLine(), localRuleBlock.getColumn()) + "");
    if ((this.grammar.debuggingOutput) || (this.grammar.traceRules))
    {
      this.tabs -= 1;
      println("finally:  ### debugging");
      this.tabs += 1;
      if (this.grammar.debuggingOutput)
        if ((this.grammar instanceof ParserGrammar))
          println("self.fireExitRule(" + paramInt + ", 0)");
        else if ((this.grammar instanceof LexerGrammar))
          println("self.fireExitRule(" + paramInt + ", _ttype)");
      if (this.grammar.traceRules)
        if ((this.grammar instanceof TreeWalkerGrammar))
          println("self.traceOut(\"" + paramRuleSymbol.getId() + "\", _t)");
        else
          println("self.traceOut(\"" + paramRuleSymbol.getId() + "\")");
      this.tabs -= 1;
    }
    this.tabs -= 1;
    println("");
    this.genAST = bool1;
  }

  private void GenRuleInvocation(RuleRefElement paramRuleRefElement)
  {
    _print("self." + paramRuleRefElement.targetRule + "(");
    if ((this.grammar instanceof LexerGrammar))
    {
      if (paramRuleRefElement.getLabel() != null)
        _print("True");
      else
        _print("False");
      if ((this.commonExtraArgs.length() != 0) || (paramRuleRefElement.args != null))
        _print(", ");
    }
    _print(this.commonExtraArgs);
    if ((this.commonExtraArgs.length() != 0) && (paramRuleRefElement.args != null))
      _print(", ");
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(paramRuleRefElement.targetRule);
    if (paramRuleRefElement.args != null)
    {
      ActionTransInfo localActionTransInfo = new ActionTransInfo();
      String str = processActionForSpecialSymbols(paramRuleRefElement.args, 0, this.currentRule, localActionTransInfo);
      if ((localActionTransInfo.assignToRoot) || (localActionTransInfo.refRuleRoot != null))
        this.antlrTool.error("Arguments of rule reference '" + paramRuleRefElement.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName(), this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      _print(str);
      if (localRuleSymbol.block.argAction == null)
        this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' accepts no arguments", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
    }
    else if (localRuleSymbol.block.argAction != null)
    {
      this.antlrTool.warning("Missing parameters on reference to rule " + paramRuleRefElement.targetRule, this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
    }
    _println(")");
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = self._retTree");
  }

  protected void genSemPred(String paramString, int paramInt)
  {
    ActionTransInfo localActionTransInfo = new ActionTransInfo();
    paramString = processActionForSpecialSymbols(paramString, paramInt, this.currentRule, localActionTransInfo);
    String str = this.charFormatter.escapeString(paramString);
    if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
      paramString = "fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.VALIDATING," + addSemPred(str) + ", " + paramString + ")";
    println("if not " + paramString + ":");
    this.tabs += 1;
    println("raise antlr.SemanticException(\"" + str + "\")");
    this.tabs -= 1;
  }

  protected void genSemPredMap()
  {
    Enumeration localEnumeration = this.semPreds.elements();
    println("_semPredNames = [");
    this.tabs += 1;
    while (localEnumeration.hasMoreElements())
      println("\"" + localEnumeration.nextElement() + "\",");
    this.tabs -= 1;
    println("]");
  }

  protected void genSynPred(SynPredBlock paramSynPredBlock, String paramString)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("gen=>(" + paramSynPredBlock + ")");
    println("synPredMatched" + paramSynPredBlock.ID + " = False");
    println("if " + paramString + ":");
    this.tabs += 1;
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t" + paramSynPredBlock.ID + " = _t");
    else
      println("_m" + paramSynPredBlock.ID + " = self.mark()");
    println("synPredMatched" + paramSynPredBlock.ID + " = True");
    println("self.inputState.guessing += 1");
    if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
      println("self.fireSyntacticPredicateStarted()");
    this.syntacticPredLevel += 1;
    println("try:");
    this.tabs += 1;
    gen(paramSynPredBlock);
    this.tabs -= 1;
    println("except " + this.exceptionThrown + ", pe:");
    this.tabs += 1;
    println("synPredMatched" + paramSynPredBlock.ID + " = False");
    this.tabs -= 1;
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t" + paramSynPredBlock.ID + "");
    else
      println("self.rewind(_m" + paramSynPredBlock.ID + ")");
    println("self.inputState.guessing -= 1");
    if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
    {
      println("if synPredMatched" + paramSynPredBlock.ID + ":");
      this.tabs += 1;
      println("self.fireSyntacticPredicateSucceeded()");
      this.tabs -= 1;
      println("else:");
      this.tabs += 1;
      println("self.fireSyntacticPredicateFailed()");
      this.tabs -= 1;
    }
    this.syntacticPredLevel -= 1;
    this.tabs -= 1;
    println("if synPredMatched" + paramSynPredBlock.ID + ":");
  }

  public void genTokenStrings()
  {
    int i = this.tabs;
    this.tabs = 0;
    println("");
    println("_tokenNames = [");
    this.tabs += 1;
    Vector localVector = this.grammar.tokenManager.getVocabulary();
    for (int j = 0; j < localVector.size(); j++)
    {
      String str = (String)localVector.elementAt(j);
      if (str == null)
        str = "<" + String.valueOf(j) + ">";
      if ((!str.startsWith("\"")) && (!str.startsWith("<")))
      {
        TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(str);
        if ((localTokenSymbol != null) && (localTokenSymbol.getParaphrase() != null))
          str = StringUtils.stripFrontBack(localTokenSymbol.getParaphrase(), "\"", "\"");
      }
      print(this.charFormatter.literalString(str));
      if (j != localVector.size() - 1)
        _print(", ");
      _println("");
    }
    this.tabs -= 1;
    println("]");
    this.tabs = i;
  }

  protected void genTokenASTNodeMap()
  {
    println("");
    println("def buildTokenTypeASTClassMap(self):");
    this.tabs += 1;
    int i = 0;
    int j = 0;
    Vector localVector = this.grammar.tokenManager.getVocabulary();
    for (int k = 0; k < localVector.size(); k++)
    {
      String str = (String)localVector.elementAt(k);
      if (str == null)
        continue;
      TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(str);
      if ((localTokenSymbol == null) || (localTokenSymbol.getASTNodeType() == null))
        continue;
      j++;
      if (i == 0)
      {
        println("self.tokenTypeToASTClassMap = {}");
        i = 1;
      }
      println("self.tokenTypeToASTClassMap[" + localTokenSymbol.getTokenType() + "] = " + localTokenSymbol.getASTNodeType());
    }
    if (j == 0)
      println("self.tokenTypeToASTClassMap = None");
    this.tabs -= 1;
  }

  protected void genTokenTypes(TokenManager paramTokenManager)
    throws IOException
  {
    this.tabs = 0;
    Vector localVector = paramTokenManager.getVocabulary();
    println("SKIP                = antlr.SKIP");
    println("INVALID_TYPE        = antlr.INVALID_TYPE");
    println("EOF_TYPE            = antlr.EOF_TYPE");
    println("EOF                 = antlr.EOF");
    println("NULL_TREE_LOOKAHEAD = antlr.NULL_TREE_LOOKAHEAD");
    println("MIN_USER_TYPE       = antlr.MIN_USER_TYPE");
    for (int i = 4; i < localVector.size(); i++)
    {
      String str1 = (String)localVector.elementAt(i);
      if (str1 == null)
        continue;
      if (str1.startsWith("\""))
      {
        StringLiteralSymbol localStringLiteralSymbol = (StringLiteralSymbol)paramTokenManager.getTokenSymbol(str1);
        if (localStringLiteralSymbol == null)
          this.antlrTool.panic("String literal " + str1 + " not in symbol table");
        if (localStringLiteralSymbol.label != null)
        {
          println(localStringLiteralSymbol.label + " = " + i);
        }
        else
        {
          String str2 = mangleLiteral(str1);
          if (str2 != null)
          {
            println(str2 + " = " + i);
            localStringLiteralSymbol.label = str2;
          }
          else
          {
            println("### " + str1 + " = " + i);
          }
        }
      }
      else
      {
        if (str1.startsWith("<"))
          continue;
        println(str1 + " = " + i);
      }
    }
    this.tabs -= 1;
    exitIfError();
  }

  public String getASTCreateString(Vector paramVector)
  {
    if (paramVector.size() == 0)
      return "";
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append("antlr.make(");
    for (int i = 0; i < paramVector.size(); i++)
    {
      localStringBuffer.append(paramVector.elementAt(i));
      if (i + 1 >= paramVector.size())
        continue;
      localStringBuffer.append(", ");
    }
    localStringBuffer.append(")");
    return localStringBuffer.toString();
  }

  public String getASTCreateString(GrammarAtom paramGrammarAtom, String paramString)
  {
    if ((paramGrammarAtom != null) && (paramGrammarAtom.getASTNodeType() != null))
      return "self.astFactory.create(" + paramString + ", " + paramGrammarAtom.getASTNodeType() + ")";
    return getASTCreateString(paramString);
  }

  public String getASTCreateString(String paramString)
  {
    if (paramString == null)
      paramString = "";
    int i = 0;
    for (int j = 0; j < paramString.length(); j++)
    {
      if (paramString.charAt(j) != ',')
        continue;
      i++;
    }
    if (i < 2)
    {
      j = paramString.indexOf(',');
      int k = paramString.lastIndexOf(',');
      String str1 = paramString;
      if (i > 0)
        str1 = paramString.substring(0, j);
      TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(str1);
      if (localTokenSymbol != null)
      {
        String str2 = localTokenSymbol.getASTNodeType();
        String str3 = "";
        if (i == 0)
          str3 = ", \"\"";
        if (str2 != null)
          return "self.astFactory.create(" + paramString + str3 + ", " + str2 + ")";
      }
      if (this.labeledElementASTType.equals("AST"))
        return "self.astFactory.create(" + paramString + ")";
      return "self.astFactory.create(" + paramString + ")";
    }
    return "self.astFactory.create(" + paramString + ")";
  }

  protected String getLookaheadTestExpression(Lookahead[] paramArrayOfLookahead, int paramInt)
  {
    StringBuffer localStringBuffer = new StringBuffer(100);
    int i = 1;
    localStringBuffer.append("(");
    for (int j = 1; j <= paramInt; j++)
    {
      BitSet localBitSet = paramArrayOfLookahead[j].fset;
      if (i == 0)
        localStringBuffer.append(") and (");
      i = 0;
      if (paramArrayOfLookahead[j].containsEpsilon())
        localStringBuffer.append("True");
      else
        localStringBuffer.append(getLookaheadTestTerm(j, localBitSet));
    }
    localStringBuffer.append(")");
    String str = localStringBuffer.toString();
    return str;
  }

  protected String getLookaheadTestExpression(Alternative paramAlternative, int paramInt)
  {
    int i = paramAlternative.lookaheadDepth;
    if (i == 2147483647)
      i = this.grammar.maxk;
    if (paramInt == 0)
      return "True";
    return getLookaheadTestExpression(paramAlternative.cache, i);
  }

  protected String getLookaheadTestTerm(int paramInt, BitSet paramBitSet)
  {
    String str1 = lookaheadString(paramInt);
    int[] arrayOfInt = paramBitSet.toArray();
    if (elementsAreRange(arrayOfInt))
    {
      localObject = getRangeExpression(paramInt, arrayOfInt);
      return localObject;
    }
    int i = paramBitSet.degree();
    if (i == 0)
      return "True";
    if (i >= this.bitsetTestThreshold)
    {
      j = markBitsetForGen(paramBitSet);
      return getBitsetName(j) + ".member(" + str1 + ")";
    }
    Object localObject = new StringBuffer();
    for (int j = 0; j < arrayOfInt.length; j++)
    {
      String str3 = getValueString(arrayOfInt[j], true);
      if (j > 0)
        ((StringBuffer)localObject).append(" or ");
      ((StringBuffer)localObject).append(str1);
      ((StringBuffer)localObject).append("==");
      ((StringBuffer)localObject).append(str3);
    }
    String str2 = ((StringBuffer)localObject).toString();
    return (String)((StringBuffer)localObject).toString();
  }

  public String getRangeExpression(int paramInt, int[] paramArrayOfInt)
  {
    if (!elementsAreRange(paramArrayOfInt))
      this.antlrTool.panic("getRangeExpression called with non-range");
    int i = paramArrayOfInt[0];
    int j = paramArrayOfInt[(paramArrayOfInt.length - 1)];
    return "(" + lookaheadString(paramInt) + " >= " + getValueString(i, true) + " and " + lookaheadString(paramInt) + " <= " + getValueString(j, true) + ")";
  }

  private String getValueString(int paramInt, boolean paramBoolean)
  {
    Object localObject;
    if ((this.grammar instanceof LexerGrammar))
    {
      localObject = this.charFormatter.literalChar(paramInt);
      if (paramBoolean)
        localObject = "u'" + (String)localObject + "'";
      return localObject;
    }
    TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbolAt(paramInt);
    if (localTokenSymbol == null)
    {
      localObject = "" + paramInt;
      return localObject;
    }
    String str1 = localTokenSymbol.getId();
    if (!(localTokenSymbol instanceof StringLiteralSymbol))
    {
      localObject = str1;
      return localObject;
    }
    StringLiteralSymbol localStringLiteralSymbol = (StringLiteralSymbol)localTokenSymbol;
    String str2 = localStringLiteralSymbol.getLabel();
    if (str2 != null)
    {
      localObject = str2;
    }
    else
    {
      localObject = mangleLiteral(str1);
      if (localObject == null)
        localObject = String.valueOf(paramInt);
    }
    return (String)localObject;
  }

  protected boolean lookaheadIsEmpty(Alternative paramAlternative, int paramInt)
  {
    int i = paramAlternative.lookaheadDepth;
    if (i == 2147483647)
      i = this.grammar.maxk;
    for (int j = 1; (j <= i) && (j <= paramInt); j++)
    {
      BitSet localBitSet = paramAlternative.cache[j].fset;
      if (localBitSet.degree() != 0)
        return false;
    }
    return true;
  }

  private String lookaheadString(int paramInt)
  {
    if ((this.grammar instanceof TreeWalkerGrammar))
      return "_t.getType()";
    return "self.LA(" + paramInt + ")";
  }

  private String mangleLiteral(String paramString)
  {
    String str = this.antlrTool.literalsPrefix;
    for (int i = 1; i < paramString.length() - 1; i++)
    {
      if ((!Character.isLetter(paramString.charAt(i))) && (paramString.charAt(i) != '_'))
        return null;
      str = str + paramString.charAt(i);
    }
    if (this.antlrTool.upperCaseMangledLiterals)
      str = str.toUpperCase();
    return str;
  }

  public String mapTreeId(String paramString, ActionTransInfo paramActionTransInfo)
  {
    if (this.currentRule == null)
      return paramString;
    int i = 0;
    String str1 = paramString;
    if ((this.grammar instanceof TreeWalkerGrammar))
      if (!this.grammar.buildAST)
      {
        i = 1;
      }
      else if ((str1.length() > 3) && (str1.lastIndexOf("_in") == str1.length() - 3))
      {
        str1 = str1.substring(0, str1.length() - 3);
        i = 1;
      }
    Object localObject;
    for (int j = 0; j < this.currentRule.labeledElements.size(); j++)
    {
      localObject = (AlternativeElement)this.currentRule.labeledElements.elementAt(j);
      if (((AlternativeElement)localObject).getLabel().equals(str1))
        return str1 + "_AST";
    }
    String str2 = (String)this.treeVariableMap.get(str1);
    if (str2 != null)
    {
      if (str2 == NONUNIQUE)
      {
        this.antlrTool.error("Ambiguous reference to AST element " + str1 + " in rule " + this.currentRule.getRuleName());
        return null;
      }
      if (str2.equals(this.currentRule.getRuleName()))
      {
        this.antlrTool.error("Ambiguous reference to AST element " + str1 + " in rule " + this.currentRule.getRuleName());
        return null;
      }
      return i != 0 ? str2 + "_in" : str2;
    }
    if (str1.equals(this.currentRule.getRuleName()))
    {
      localObject = str1 + "_AST";
      if ((paramActionTransInfo != null) && (i == 0))
        paramActionTransInfo.refRuleRoot = ((String)localObject);
      return localObject;
    }
    return (String)str1;
  }

  private void mapTreeVariable(AlternativeElement paramAlternativeElement, String paramString)
  {
    if ((paramAlternativeElement instanceof TreeElement))
    {
      mapTreeVariable(((TreeElement)paramAlternativeElement).root, paramString);
      return;
    }
    String str = null;
    if (paramAlternativeElement.getLabel() == null)
      if ((paramAlternativeElement instanceof TokenRefElement))
        str = ((TokenRefElement)paramAlternativeElement).atomText;
      else if ((paramAlternativeElement instanceof RuleRefElement))
        str = ((RuleRefElement)paramAlternativeElement).targetRule;
    if (str != null)
      if (this.treeVariableMap.get(str) != null)
      {
        this.treeVariableMap.remove(str);
        this.treeVariableMap.put(str, NONUNIQUE);
      }
      else
      {
        this.treeVariableMap.put(str, paramString);
      }
  }

  protected String processActionForSpecialSymbols(String paramString, int paramInt, RuleBlock paramRuleBlock, ActionTransInfo paramActionTransInfo)
  {
    if ((paramString == null) || (paramString.length() == 0))
      return null;
    if (isEmpty(paramString))
      return "";
    if (this.grammar == null)
      return paramString;
    ActionLexer localActionLexer = new ActionLexer(paramString, paramRuleBlock, this, paramActionTransInfo);
    localActionLexer.setLineOffset(paramInt);
    localActionLexer.setFilename(this.grammar.getFilename());
    localActionLexer.setTool(this.antlrTool);
    try
    {
      localActionLexer.mACTION(true);
      paramString = localActionLexer.getTokenObject().getText();
    }
    catch (RecognitionException localRecognitionException)
    {
      localActionLexer.reportError(localRecognitionException);
    }
    catch (TokenStreamException localTokenStreamException)
    {
      this.antlrTool.panic("Error reading action:" + paramString);
    }
    catch (CharStreamException localCharStreamException)
    {
      this.antlrTool.panic("Error reading action:" + paramString);
    }
    return paramString;
  }

  static boolean isEmpty(String paramString)
  {
    int j = 1;
    for (int k = 0; (j != 0) && (k < paramString.length()); k++)
    {
      int i = paramString.charAt(k);
      switch (i)
      {
      case 9:
      case 10:
      case 12:
      case 13:
      case 32:
        break;
      default:
        j = 0;
      }
    }
    return j;
  }

  protected String processActionCode(String paramString, int paramInt)
  {
    if ((paramString == null) || (isEmpty(paramString)))
      return "";
    CodeLexer localCodeLexer = new CodeLexer(paramString, this.grammar.getFilename(), paramInt, this.antlrTool);
    try
    {
      localCodeLexer.mACTION(true);
      paramString = localCodeLexer.getTokenObject().getText();
    }
    catch (RecognitionException localRecognitionException)
    {
      localCodeLexer.reportError(localRecognitionException);
    }
    catch (TokenStreamException localTokenStreamException)
    {
      this.antlrTool.panic("Error reading action:" + paramString);
    }
    catch (CharStreamException localCharStreamException)
    {
      this.antlrTool.panic("Error reading action:" + paramString);
    }
    return paramString;
  }

  protected void printActionCode(String paramString, int paramInt)
  {
    paramString = processActionCode(paramString, paramInt);
    printAction(paramString);
  }

  private void setupGrammarParameters(Grammar paramGrammar)
  {
    Token localToken;
    String str;
    if ((paramGrammar instanceof ParserGrammar))
    {
      this.labeledElementASTType = "";
      if (paramGrammar.hasOption("ASTLabelType"))
      {
        localToken = paramGrammar.getOption("ASTLabelType");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
            this.labeledElementASTType = str;
        }
      }
      this.labeledElementType = "";
      this.labeledElementInit = "None";
      this.commonExtraArgs = "";
      this.commonExtraParams = "self";
      this.commonLocalVars = "";
      this.lt1Value = "self.LT(1)";
      this.exceptionThrown = "antlr.RecognitionException";
      this.throwNoViable = "raise antlr.NoViableAltException(self.LT(1), self.getFilename())";
      this.parserClassName = "Parser";
      if (paramGrammar.hasOption("className"))
      {
        localToken = paramGrammar.getOption("className");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
            this.parserClassName = str;
        }
      }
      return;
    }
    if ((paramGrammar instanceof LexerGrammar))
    {
      this.labeledElementType = "char ";
      this.labeledElementInit = "'\\0'";
      this.commonExtraArgs = "";
      this.commonExtraParams = "self, _createToken";
      this.commonLocalVars = "_ttype = 0\n        _token = None\n        _begin = self.text.length()";
      this.lt1Value = "self.LA(1)";
      this.exceptionThrown = "antlr.RecognitionException";
      this.throwNoViable = "self.raise_NoViableAlt(self.LA(1))";
      this.lexerClassName = "Lexer";
      if (paramGrammar.hasOption("className"))
      {
        localToken = paramGrammar.getOption("className");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
            this.lexerClassName = str;
        }
      }
      return;
    }
    if ((paramGrammar instanceof TreeWalkerGrammar))
    {
      this.labeledElementASTType = "";
      this.labeledElementType = "";
      if (paramGrammar.hasOption("ASTLabelType"))
      {
        localToken = paramGrammar.getOption("ASTLabelType");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
          {
            this.labeledElementASTType = str;
            this.labeledElementType = str;
          }
        }
      }
      if (!paramGrammar.hasOption("ASTLabelType"))
        paramGrammar.setOption("ASTLabelType", new Token(6, "<4>AST"));
      this.labeledElementInit = "None";
      this.commonExtraArgs = "_t";
      this.commonExtraParams = "self, _t";
      this.commonLocalVars = "";
      this.lt1Value = "_t";
      this.exceptionThrown = "antlr.RecognitionException";
      this.throwNoViable = "raise antlr.NoViableAltException(_t)";
      this.treeWalkerClassName = "Walker";
      if (paramGrammar.hasOption("className"))
      {
        localToken = paramGrammar.getOption("className");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
            this.treeWalkerClassName = str;
        }
      }
      return;
    }
    this.antlrTool.panic("Unknown grammar type");
  }

  public void setupOutput(String paramString)
    throws IOException
  {
    this.currentOutput = this.antlrTool.openOutputFile(paramString + ".py");
  }

  protected boolean isspace(char paramChar)
  {
    int i = 1;
    switch (paramChar)
    {
    case '\t':
    case '\n':
    case '\r':
    case ' ':
      break;
    default:
      i = 0;
    }
    return i;
  }

  protected void _printAction(String paramString)
  {
    if (paramString == null)
      return;
    int j = 0;
    int k = paramString.length();
    int i = 0;
    int m = 1;
    char c;
    while ((j < k) && (m != 0))
    {
      c = paramString.charAt(j++);
      switch (c)
      {
      case '\n':
        i = j;
        break;
      case '\r':
        if ((j <= k) && (paramString.charAt(j) == '\n'))
          j++;
        i = j;
        break;
      case ' ':
        break;
      case '\t':
      default:
        m = 0;
      }
    }
    if (m == 0)
      j--;
    i = j - i;
    k -= 1;
    while ((k > j) && (isspace(paramString.charAt(k))))
      k--;
    int n = 0;
    for (int i2 = j; i2 <= k; i2++)
    {
      c = paramString.charAt(i2);
      switch (c)
      {
      case '\n':
        n = 1;
        break;
      case '\r':
        n = 1;
        if ((i2 + 1 > k) || (paramString.charAt(i2 + 1) != '\n'))
          break;
        i2++;
        break;
      case '\t':
        System.err.println("warning: tab characters used in Python action");
        this.currentOutput.print("        ");
        break;
      case ' ':
        this.currentOutput.print(" ");
        break;
      default:
        this.currentOutput.print(c);
      }
      if (n == 0)
        continue;
      this.currentOutput.print("\n");
      printTabs();
      int i1 = 0;
      n = 0;
      i2 += 1;
      while (i2 <= k)
      {
        c = paramString.charAt(i2);
        if (!isspace(c))
        {
          i2--;
          break;
        }
        switch (c)
        {
        case '\n':
          n = 1;
          break;
        case '\r':
          if ((i2 + 1 <= k) && (paramString.charAt(i2 + 1) == '\n'))
            i2++;
          n = 1;
        }
        if (n != 0)
        {
          this.currentOutput.print("\n");
          printTabs();
          i1 = 0;
          n = 0;
        }
        else
        {
          if (i1 >= i)
            break;
          i1++;
        }
        i2++;
      }
    }
    this.currentOutput.println();
  }

  protected void od(String paramString1, int paramInt1, int paramInt2, String paramString2)
  {
    System.out.println(paramString2);
    for (int i = paramInt1; i <= paramInt2; i++)
    {
      char c = paramString1.charAt(i);
      switch (c)
      {
      case '\n':
        System.out.print(" nl ");
        break;
      case '\t':
        System.out.print(" ht ");
        break;
      case ' ':
        System.out.print(" sp ");
        break;
      default:
        System.out.print(" " + c + " ");
      }
    }
    System.out.println("");
  }

  protected void printAction(String paramString)
  {
    if (paramString != null)
    {
      printTabs();
      _printAction(paramString);
    }
  }

  protected void printGrammarAction(Grammar paramGrammar)
  {
    println("### user action >>>");
    printAction(processActionForSpecialSymbols(paramGrammar.classMemberAction.getText(), paramGrammar.classMemberAction.getLine(), this.currentRule, null));
    println("### user action <<<");
  }

  protected void _printJavadoc(String paramString)
  {
    int i = paramString.length();
    int j = 0;
    int k = 0;
    this.currentOutput.print("\n");
    printTabs();
    this.currentOutput.print("###");
    for (int m = j; m < i; m++)
    {
      char c = paramString.charAt(m);
      switch (c)
      {
      case '\n':
        k = 1;
        break;
      case '\r':
        k = 1;
        if ((m + 1 > i) || (paramString.charAt(m + 1) != '\n'))
          break;
        m++;
        break;
      case '\t':
        this.currentOutput.print("\t");
        break;
      case ' ':
        this.currentOutput.print(" ");
        break;
      default:
        this.currentOutput.print(c);
      }
      if (k == 0)
        continue;
      this.currentOutput.print("\n");
      printTabs();
      this.currentOutput.print("###");
      k = 0;
    }
    this.currentOutput.println();
  }

  protected void genJavadocComment(Grammar paramGrammar)
  {
    if (paramGrammar.comment != null)
      _printJavadoc(paramGrammar.comment);
  }

  protected void genJavadocComment(RuleSymbol paramRuleSymbol)
  {
    if (paramRuleSymbol.comment != null)
      _printJavadoc(paramRuleSymbol.comment);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.PythonCodeGenerator
 * JD-Core Version:    0.6.0
 */