package antlr;

import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;

public class Lookahead
  implements Cloneable
{
  BitSet fset;
  String cycle;
  BitSet epsilonDepth;
  boolean hasEpsilon = false;

  public Lookahead()
  {
    this.fset = new BitSet();
  }

  public Lookahead(BitSet paramBitSet)
  {
    this.fset = paramBitSet;
  }

  public Lookahead(String paramString)
  {
    this();
    this.cycle = paramString;
  }

  public Object clone()
  {
    Lookahead localLookahead = null;
    try
    {
      localLookahead = (Lookahead)super.clone();
      localLookahead.fset = ((BitSet)this.fset.clone());
      localLookahead.cycle = this.cycle;
      if (this.epsilonDepth != null)
        localLookahead.epsilonDepth = ((BitSet)this.epsilonDepth.clone());
    }
    catch (CloneNotSupportedException localCloneNotSupportedException)
    {
      throw new InternalError();
    }
    return localLookahead;
  }

  public void combineWith(Lookahead paramLookahead)
  {
    if (this.cycle == null)
      this.cycle = paramLookahead.cycle;
    if (paramLookahead.containsEpsilon())
      this.hasEpsilon = true;
    if (this.epsilonDepth != null)
    {
      if (paramLookahead.epsilonDepth != null)
        this.epsilonDepth.orInPlace(paramLookahead.epsilonDepth);
    }
    else if (paramLookahead.epsilonDepth != null)
      this.epsilonDepth = ((BitSet)paramLookahead.epsilonDepth.clone());
    this.fset.orInPlace(paramLookahead.fset);
  }

  public boolean containsEpsilon()
  {
    return this.hasEpsilon;
  }

  public Lookahead intersection(Lookahead paramLookahead)
  {
    Lookahead localLookahead = new Lookahead(this.fset.and(paramLookahead.fset));
    if ((this.hasEpsilon) && (paramLookahead.hasEpsilon))
      localLookahead.setEpsilon();
    return localLookahead;
  }

  public boolean nil()
  {
    return (this.fset.nil()) && (!this.hasEpsilon);
  }

  public static Lookahead of(int paramInt)
  {
    Lookahead localLookahead = new Lookahead();
    localLookahead.fset.add(paramInt);
    return localLookahead;
  }

  public void resetEpsilon()
  {
    this.hasEpsilon = false;
  }

  public void setEpsilon()
  {
    this.hasEpsilon = true;
  }

  public String toString()
  {
    String str1 = "";
    String str3 = "";
    String str4 = "";
    String str2 = this.fset.toString(",");
    if (containsEpsilon())
      str1 = "+<epsilon>";
    if (this.cycle != null)
      str3 = "; FOLLOW(" + this.cycle + ")";
    if (this.epsilonDepth != null)
      str4 = "; depths=" + this.epsilonDepth.toString(",");
    return str2 + str1 + str3 + str4;
  }

  public String toString(String paramString, CharFormatter paramCharFormatter)
  {
    String str1 = "";
    String str3 = "";
    String str4 = "";
    String str2 = this.fset.toString(paramString, paramCharFormatter);
    if (containsEpsilon())
      str1 = "+<epsilon>";
    if (this.cycle != null)
      str3 = "; FOLLOW(" + this.cycle + ")";
    if (this.epsilonDepth != null)
      str4 = "; depths=" + this.epsilonDepth.toString(",");
    return str2 + str1 + str3 + str4;
  }

  public String toString(String paramString, CharFormatter paramCharFormatter, Grammar paramGrammar)
  {
    if ((paramGrammar instanceof LexerGrammar))
      return toString(paramString, paramCharFormatter);
    return toString(paramString, paramGrammar.tokenManager.getVocabulary());
  }

  public String toString(String paramString, Vector paramVector)
  {
    String str2 = "";
    String str3 = "";
    String str1 = this.fset.toString(paramString, paramVector);
    if (this.cycle != null)
      str2 = "; FOLLOW(" + this.cycle + ")";
    if (this.epsilonDepth != null)
      str3 = "; depths=" + this.epsilonDepth.toString(",");
    return str1 + str2 + str3;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.Lookahead
 * JD-Core Version:    0.6.0
 */