package antlr;

import java.io.InputStream;
import java.io.Reader;

public class LexerSharedInputState
{
  protected int column = 1;
  protected int line = 1;
  protected int tokenStartColumn = 1;
  protected int tokenStartLine = 1;
  protected InputBuffer input;
  protected String filename;
  public int guessing = 0;

  public LexerSharedInputState(InputBuffer paramInputBuffer)
  {
    this.input = paramInputBuffer;
  }

  public LexerSharedInputState(InputStream paramInputStream)
  {
    this(new ByteBuffer(paramInputStream));
  }

  public LexerSharedInputState(Reader paramReader)
  {
    this(new CharBuffer(paramReader));
  }

  public String getFilename()
  {
    return this.filename;
  }

  public InputBuffer getInput()
  {
    return this.input;
  }

  public int getLine()
  {
    return this.line;
  }

  public int getTokenStartColumn()
  {
    return this.tokenStartColumn;
  }

  public int getTokenStartLine()
  {
    return this.tokenStartLine;
  }

  public int getColumn()
  {
    return this.column;
  }

  public void reset()
  {
    this.column = 1;
    this.line = 1;
    this.tokenStartColumn = 1;
    this.tokenStartLine = 1;
    this.guessing = 0;
    this.filename = null;
    this.input.reset();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.LexerSharedInputState
 * JD-Core Version:    0.6.0
 */