package antlr;

import antlr.collections.AST;
import java.io.PrintStream;

public class DumpASTVisitor
  implements ASTVisitor
{
  protected int level = 0;

  private void tabs()
  {
    for (int i = 0; i < this.level; i++)
      System.out.print("   ");
  }

  public void visit(AST paramAST)
  {
    int i = 0;
    for (AST localAST = paramAST; localAST != null; localAST = localAST.getNextSibling())
    {
      if (localAST.getFirstChild() == null)
        continue;
      i = 0;
      break;
    }
    for (localAST = paramAST; localAST != null; localAST = localAST.getNextSibling())
    {
      if ((i == 0) || (localAST == paramAST))
        tabs();
      if (localAST.getText() == null)
        System.out.print("nil");
      else
        System.out.print(localAST.getText());
      System.out.print(" [" + localAST.getType() + "] ");
      if (i != 0)
        System.out.print(" ");
      else
        System.out.println("");
      if (localAST.getFirstChild() == null)
        continue;
      this.level += 1;
      visit(localAST.getFirstChild());
      this.level -= 1;
    }
    if (i != 0)
      System.out.println("");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.DumpASTVisitor
 * JD-Core Version:    0.6.0
 */