package antlr;

import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class DiagnosticCodeGenerator extends CodeGenerator
{
  protected int syntacticPredLevel = 0;
  protected boolean doingLexRules = false;

  public DiagnosticCodeGenerator()
  {
    this.charFormatter = new JavaCharFormatter();
  }

  public void gen()
  {
    try
    {
      Enumeration localEnumeration = this.behavior.grammars.elements();
      while (localEnumeration.hasMoreElements())
      {
        localObject = (Grammar)localEnumeration.nextElement();
        ((Grammar)localObject).setGrammarAnalyzer(this.analyzer);
        ((Grammar)localObject).setCodeGenerator(this);
        this.analyzer.setGrammar((Grammar)localObject);
        ((Grammar)localObject).generate();
        if (!this.antlrTool.hasError())
          continue;
        this.antlrTool.panic("Exiting due to errors.");
      }
      Object localObject = this.behavior.tokenManagers.elements();
      while (((Enumeration)localObject).hasMoreElements())
      {
        TokenManager localTokenManager = (TokenManager)((Enumeration)localObject).nextElement();
        if (localTokenManager.isReadOnly())
          continue;
        genTokenTypes(localTokenManager);
      }
    }
    catch (IOException localIOException)
    {
      this.antlrTool.reportException(localIOException, null);
    }
  }

  public void gen(ActionElement paramActionElement)
  {
    if (!paramActionElement.isSemPred)
    {
      print("ACTION: ");
      _printAction(paramActionElement.actionText);
    }
  }

  public void gen(AlternativeBlock paramAlternativeBlock)
  {
    println("Start of alternative block.");
    this.tabs += 1;
    genBlockPreamble(paramAlternativeBlock);
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramAlternativeBlock);
    if (!bool)
      println("Warning: This alternative block is non-deterministic");
    genCommonBlock(paramAlternativeBlock);
    this.tabs -= 1;
  }

  public void gen(BlockEndElement paramBlockEndElement)
  {
  }

  public void gen(CharLiteralElement paramCharLiteralElement)
  {
    print("Match character ");
    if (paramCharLiteralElement.not)
      _print("NOT ");
    _print(paramCharLiteralElement.atomText);
    if (paramCharLiteralElement.label != null)
      _print(", label=" + paramCharLiteralElement.label);
    _println("");
  }

  public void gen(CharRangeElement paramCharRangeElement)
  {
    print("Match character range: " + paramCharRangeElement.beginText + ".." + paramCharRangeElement.endText);
    if (paramCharRangeElement.label != null)
      _print(", label = " + paramCharRangeElement.label);
    _println("");
  }

  public void gen(LexerGrammar paramLexerGrammar)
    throws IOException
  {
    setGrammar(paramLexerGrammar);
    this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + TokenTypesFileExt);
    this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + TokenTypesFileExt);
    this.tabs = 0;
    this.doingLexRules = true;
    genHeader();
    println("");
    println("*** Lexer Preamble Action.");
    println("This action will appear before the declaration of your lexer class:");
    this.tabs += 1;
    println(this.grammar.preambleAction.getText());
    this.tabs -= 1;
    println("*** End of Lexer Preamble Action");
    println("");
    println("*** Your lexer class is called '" + this.grammar.getClassName() + "' and is a subclass of '" + this.grammar.getSuperClass() + "'.");
    println("");
    println("*** User-defined lexer  class members:");
    println("These are the member declarations that you defined for your class:");
    this.tabs += 1;
    printAction(this.grammar.classMemberAction.getText());
    this.tabs -= 1;
    println("*** End of user-defined lexer class members");
    println("");
    println("*** String literals used in the parser");
    println("The following string literals were used in the parser.");
    println("An actual code generator would arrange to place these literals");
    println("into a table in the generated lexer, so that actions in the");
    println("generated lexer could match token text against the literals.");
    println("String literals used in the lexer are not listed here, as they");
    println("are incorporated into the mainstream lexer processing.");
    this.tabs += 1;
    Enumeration localEnumeration = this.grammar.getSymbols();
    Object localObject;
    while (localEnumeration.hasMoreElements())
    {
      localObject = (GrammarSymbol)localEnumeration.nextElement();
      if (!(localObject instanceof StringLiteralSymbol))
        continue;
      StringLiteralSymbol localStringLiteralSymbol = (StringLiteralSymbol)localObject;
      println(localStringLiteralSymbol.getId() + " = " + localStringLiteralSymbol.getTokenType());
    }
    this.tabs -= 1;
    println("*** End of string literals used by the parser");
    genNextToken();
    println("");
    println("*** User-defined Lexer rules:");
    this.tabs += 1;
    localEnumeration = this.grammar.rules.elements();
    while (localEnumeration.hasMoreElements())
    {
      localObject = (RuleSymbol)localEnumeration.nextElement();
      if (((RuleSymbol)localObject).id.equals("mnextToken"))
        continue;
      genRule((RuleSymbol)localObject);
    }
    this.tabs -= 1;
    println("");
    println("*** End User-defined Lexer rules:");
    this.currentOutput.close();
    this.currentOutput = null;
    this.doingLexRules = false;
  }

  public void gen(OneOrMoreBlock paramOneOrMoreBlock)
  {
    println("Start ONE-OR-MORE (...)+ block:");
    this.tabs += 1;
    genBlockPreamble(paramOneOrMoreBlock);
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramOneOrMoreBlock);
    if (!bool)
      println("Warning: This one-or-more block is non-deterministic");
    genCommonBlock(paramOneOrMoreBlock);
    this.tabs -= 1;
    println("End ONE-OR-MORE block.");
  }

  public void gen(ParserGrammar paramParserGrammar)
    throws IOException
  {
    setGrammar(paramParserGrammar);
    this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + TokenTypesFileExt);
    this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + TokenTypesFileExt);
    this.tabs = 0;
    genHeader();
    println("");
    println("*** Parser Preamble Action.");
    println("This action will appear before the declaration of your parser class:");
    this.tabs += 1;
    println(this.grammar.preambleAction.getText());
    this.tabs -= 1;
    println("*** End of Parser Preamble Action");
    println("");
    println("*** Your parser class is called '" + this.grammar.getClassName() + "' and is a subclass of '" + this.grammar.getSuperClass() + "'.");
    println("");
    println("*** User-defined parser class members:");
    println("These are the member declarations that you defined for your class:");
    this.tabs += 1;
    printAction(this.grammar.classMemberAction.getText());
    this.tabs -= 1;
    println("*** End of user-defined parser class members");
    println("");
    println("*** Parser rules:");
    this.tabs += 1;
    Enumeration localEnumeration = this.grammar.rules.elements();
    while (localEnumeration.hasMoreElements())
    {
      println("");
      GrammarSymbol localGrammarSymbol = (GrammarSymbol)localEnumeration.nextElement();
      if (!(localGrammarSymbol instanceof RuleSymbol))
        continue;
      genRule((RuleSymbol)localGrammarSymbol);
    }
    this.tabs -= 1;
    println("");
    println("*** End of parser rules");
    println("");
    println("*** End of parser");
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void gen(RuleRefElement paramRuleRefElement)
  {
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(paramRuleRefElement.targetRule);
    print("Rule Reference: " + paramRuleRefElement.targetRule);
    if (paramRuleRefElement.idAssign != null)
      _print(", assigned to '" + paramRuleRefElement.idAssign + "'");
    if (paramRuleRefElement.args != null)
      _print(", arguments = " + paramRuleRefElement.args);
    _println("");
    if ((localRuleSymbol == null) || (!localRuleSymbol.isDefined()))
    {
      println("Rule '" + paramRuleRefElement.targetRule + "' is referenced, but that rule is not defined.");
      println("\tPerhaps the rule is misspelled, or you forgot to define it.");
      return;
    }
    if (!(localRuleSymbol instanceof RuleSymbol))
    {
      println("Rule '" + paramRuleRefElement.targetRule + "' is referenced, but that is not a grammar rule.");
      return;
    }
    if (paramRuleRefElement.idAssign != null)
    {
      if (localRuleSymbol.block.returnAction == null)
        println("Error: You assigned from Rule '" + paramRuleRefElement.targetRule + "', but that rule has no return type.");
    }
    else if ((!(this.grammar instanceof LexerGrammar)) && (this.syntacticPredLevel == 0) && (localRuleSymbol.block.returnAction != null))
      println("Warning: Rule '" + paramRuleRefElement.targetRule + "' returns a value");
    if ((paramRuleRefElement.args != null) && (localRuleSymbol.block.argAction == null))
      println("Error: Rule '" + paramRuleRefElement.targetRule + "' accepts no arguments.");
  }

  public void gen(StringLiteralElement paramStringLiteralElement)
  {
    print("Match string literal ");
    _print(paramStringLiteralElement.atomText);
    if (paramStringLiteralElement.label != null)
      _print(", label=" + paramStringLiteralElement.label);
    _println("");
  }

  public void gen(TokenRangeElement paramTokenRangeElement)
  {
    print("Match token range: " + paramTokenRangeElement.beginText + ".." + paramTokenRangeElement.endText);
    if (paramTokenRangeElement.label != null)
      _print(", label = " + paramTokenRangeElement.label);
    _println("");
  }

  public void gen(TokenRefElement paramTokenRefElement)
  {
    print("Match token ");
    if (paramTokenRefElement.not)
      _print("NOT ");
    _print(paramTokenRefElement.atomText);
    if (paramTokenRefElement.label != null)
      _print(", label=" + paramTokenRefElement.label);
    _println("");
  }

  public void gen(TreeElement paramTreeElement)
  {
    print("Tree reference: " + paramTreeElement);
  }

  public void gen(TreeWalkerGrammar paramTreeWalkerGrammar)
    throws IOException
  {
    setGrammar(paramTreeWalkerGrammar);
    this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + TokenTypesFileExt);
    this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + TokenTypesFileExt);
    this.tabs = 0;
    genHeader();
    println("");
    println("*** Tree-walker Preamble Action.");
    println("This action will appear before the declaration of your tree-walker class:");
    this.tabs += 1;
    println(this.grammar.preambleAction.getText());
    this.tabs -= 1;
    println("*** End of tree-walker Preamble Action");
    println("");
    println("*** Your tree-walker class is called '" + this.grammar.getClassName() + "' and is a subclass of '" + this.grammar.getSuperClass() + "'.");
    println("");
    println("*** User-defined tree-walker class members:");
    println("These are the member declarations that you defined for your class:");
    this.tabs += 1;
    printAction(this.grammar.classMemberAction.getText());
    this.tabs -= 1;
    println("*** End of user-defined tree-walker class members");
    println("");
    println("*** tree-walker rules:");
    this.tabs += 1;
    Enumeration localEnumeration = this.grammar.rules.elements();
    while (localEnumeration.hasMoreElements())
    {
      println("");
      GrammarSymbol localGrammarSymbol = (GrammarSymbol)localEnumeration.nextElement();
      if (!(localGrammarSymbol instanceof RuleSymbol))
        continue;
      genRule((RuleSymbol)localGrammarSymbol);
    }
    this.tabs -= 1;
    println("");
    println("*** End of tree-walker rules");
    println("");
    println("*** End of tree-walker");
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void gen(WildcardElement paramWildcardElement)
  {
    print("Match wildcard");
    if (paramWildcardElement.getLabel() != null)
      _print(", label = " + paramWildcardElement.getLabel());
    _println("");
  }

  public void gen(ZeroOrMoreBlock paramZeroOrMoreBlock)
  {
    println("Start ZERO-OR-MORE (...)+ block:");
    this.tabs += 1;
    genBlockPreamble(paramZeroOrMoreBlock);
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramZeroOrMoreBlock);
    if (!bool)
      println("Warning: This zero-or-more block is non-deterministic");
    genCommonBlock(paramZeroOrMoreBlock);
    this.tabs -= 1;
    println("End ZERO-OR-MORE block.");
  }

  protected void genAlt(Alternative paramAlternative)
  {
    for (AlternativeElement localAlternativeElement = paramAlternative.head; !(localAlternativeElement instanceof BlockEndElement); localAlternativeElement = localAlternativeElement.next)
      localAlternativeElement.generate();
    if (paramAlternative.getTreeSpecifier() != null)
      println("AST will be built as: " + paramAlternative.getTreeSpecifier().getText());
  }

  protected void genBlockPreamble(AlternativeBlock paramAlternativeBlock)
  {
    if (paramAlternativeBlock.initAction != null)
      printAction("Init action: " + paramAlternativeBlock.initAction);
  }

  public void genCommonBlock(AlternativeBlock paramAlternativeBlock)
  {
    int i = paramAlternativeBlock.alternatives.size() == 1 ? 1 : 0;
    println("Start of an alternative block.");
    this.tabs += 1;
    println("The lookahead set for this block is:");
    this.tabs += 1;
    genLookaheadSetForBlock(paramAlternativeBlock);
    this.tabs -= 1;
    if (i != 0)
    {
      println("This block has a single alternative");
      if (paramAlternativeBlock.getAlternativeAt(0).synPred != null)
      {
        println("Warning: you specified a syntactic predicate for this alternative,");
        println("and it is the only alternative of a block and will be ignored.");
      }
    }
    else
    {
      println("This block has multiple alternatives:");
      this.tabs += 1;
    }
    for (int j = 0; j < paramAlternativeBlock.alternatives.size(); j++)
    {
      Alternative localAlternative = paramAlternativeBlock.getAlternativeAt(j);
      AlternativeElement localAlternativeElement = localAlternative.head;
      println("");
      if (j != 0)
        print("Otherwise, ");
      else
        print("");
      _println("Alternate(" + (j + 1) + ") will be taken IF:");
      println("The lookahead set: ");
      this.tabs += 1;
      genLookaheadSetForAlt(localAlternative);
      this.tabs -= 1;
      if ((localAlternative.semPred != null) || (localAlternative.synPred != null))
        print("is matched, AND ");
      else
        println("is matched.");
      if (localAlternative.semPred != null)
      {
        _println("the semantic predicate:");
        this.tabs += 1;
        println(localAlternative.semPred);
        if (localAlternative.synPred != null)
          print("is true, AND ");
        else
          println("is true.");
      }
      if (localAlternative.synPred != null)
      {
        _println("the syntactic predicate:");
        this.tabs += 1;
        genSynPred(localAlternative.synPred);
        this.tabs -= 1;
        println("is matched.");
      }
      genAlt(localAlternative);
    }
    println("");
    println("OTHERWISE, a NoViableAlt exception will be thrown");
    println("");
    if (i == 0)
    {
      this.tabs -= 1;
      println("End of alternatives");
    }
    this.tabs -= 1;
    println("End of alternative block.");
  }

  public void genFollowSetForRuleBlock(RuleBlock paramRuleBlock)
  {
    Lookahead localLookahead = this.grammar.theLLkAnalyzer.FOLLOW(1, paramRuleBlock.endNode);
    printSet(this.grammar.maxk, 1, localLookahead);
  }

  protected void genHeader()
  {
    println("ANTLR-generated file resulting from grammar " + this.antlrTool.grammarFile);
    println("Diagnostic output");
    println("");
    println("Terence Parr, MageLang Institute");
    println("with John Lilley, Empathy Software");
    println("ANTLR Version " + Tool.version + "; 1989-2005");
    println("");
    println("*** Header Action.");
    println("This action will appear at the top of all generated files.");
    this.tabs += 1;
    printAction(this.behavior.getHeaderAction(""));
    this.tabs -= 1;
    println("*** End of Header Action");
    println("");
  }

  protected void genLookaheadSetForAlt(Alternative paramAlternative)
  {
    if ((this.doingLexRules) && (paramAlternative.cache[1].containsEpsilon()))
    {
      println("MATCHES ALL");
      return;
    }
    int i = paramAlternative.lookaheadDepth;
    if (i == 2147483647)
      i = this.grammar.maxk;
    for (int j = 1; j <= i; j++)
    {
      Lookahead localLookahead = paramAlternative.cache[j];
      printSet(i, j, localLookahead);
    }
  }

  public void genLookaheadSetForBlock(AlternativeBlock paramAlternativeBlock)
  {
    int i = 0;
    Object localObject;
    for (int j = 0; j < paramAlternativeBlock.alternatives.size(); j++)
    {
      localObject = paramAlternativeBlock.getAlternativeAt(j);
      if (((Alternative)localObject).lookaheadDepth == 2147483647)
      {
        i = this.grammar.maxk;
        break;
      }
      if (i >= ((Alternative)localObject).lookaheadDepth)
        continue;
      i = ((Alternative)localObject).lookaheadDepth;
    }
    for (j = 1; j <= i; j++)
    {
      localObject = this.grammar.theLLkAnalyzer.look(j, paramAlternativeBlock);
      printSet(i, j, (Lookahead)localObject);
    }
  }

  public void genNextToken()
  {
    println("");
    println("*** Lexer nextToken rule:");
    println("The lexer nextToken rule is synthesized from all of the user-defined");
    println("lexer rules.  It logically consists of one big alternative block with");
    println("each user-defined rule being an alternative.");
    println("");
    RuleBlock localRuleBlock = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
    RuleSymbol localRuleSymbol = new RuleSymbol("mnextToken");
    localRuleSymbol.setDefined();
    localRuleSymbol.setBlock(localRuleBlock);
    localRuleSymbol.access = "private";
    this.grammar.define(localRuleSymbol);
    if (!this.grammar.theLLkAnalyzer.deterministic(localRuleBlock))
    {
      println("The grammar analyzer has determined that the synthesized");
      println("nextToken rule is non-deterministic (i.e., it has ambiguities)");
      println("This means that there is some overlap of the character");
      println("lookahead for two or more of your lexer rules.");
    }
    genCommonBlock(localRuleBlock);
    println("*** End of nextToken lexer rule.");
  }

  public void genRule(RuleSymbol paramRuleSymbol)
  {
    println("");
    String str = this.doingLexRules ? "Lexer" : "Parser";
    println("*** " + str + " Rule: " + paramRuleSymbol.getId());
    if (!paramRuleSymbol.isDefined())
    {
      println("This rule is undefined.");
      println("This means that the rule was referenced somewhere in the grammar,");
      println("but a definition for the rule was not encountered.");
      println("It is also possible that syntax errors during the parse of");
      println("your grammar file prevented correct processing of the rule.");
      println("*** End " + str + " Rule: " + paramRuleSymbol.getId());
      return;
    }
    this.tabs += 1;
    if (paramRuleSymbol.access.length() != 0)
      println("Access: " + paramRuleSymbol.access);
    RuleBlock localRuleBlock = paramRuleSymbol.getBlock();
    if (localRuleBlock.returnAction != null)
    {
      println("Return value(s): " + localRuleBlock.returnAction);
      if (this.doingLexRules)
      {
        println("Error: you specified return value(s) for a lexical rule.");
        println("\tLexical rules have an implicit return type of 'int'.");
      }
    }
    else if (this.doingLexRules)
    {
      println("Return value: lexical rule returns an implicit token type");
    }
    else
    {
      println("Return value: none");
    }
    if (localRuleBlock.argAction != null)
      println("Arguments: " + localRuleBlock.argAction);
    genBlockPreamble(localRuleBlock);
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(localRuleBlock);
    if (!bool)
      println("Error: This rule is non-deterministic");
    genCommonBlock(localRuleBlock);
    ExceptionSpec localExceptionSpec = localRuleBlock.findExceptionSpec("");
    if (localExceptionSpec != null)
    {
      println("You specified error-handler(s) for this rule:");
      this.tabs += 1;
      for (int i = 0; i < localExceptionSpec.handlers.size(); i++)
      {
        if (i != 0)
          println("");
        ExceptionHandler localExceptionHandler = (ExceptionHandler)localExceptionSpec.handlers.elementAt(i);
        println("Error-handler(" + (i + 1) + ") catches [" + localExceptionHandler.exceptionTypeAndName.getText() + "] and executes:");
        printAction(localExceptionHandler.action.getText());
      }
      this.tabs -= 1;
      println("End error-handlers.");
    }
    else if (!this.doingLexRules)
    {
      println("Default error-handling will be generated, which catches all");
      println("parser exceptions and consumes tokens until the follow-set is seen.");
    }
    if (!this.doingLexRules)
    {
      println("The follow set for this rule is:");
      this.tabs += 1;
      genFollowSetForRuleBlock(localRuleBlock);
      this.tabs -= 1;
    }
    this.tabs -= 1;
    println("*** End " + str + " Rule: " + paramRuleSymbol.getId());
  }

  protected void genSynPred(SynPredBlock paramSynPredBlock)
  {
    this.syntacticPredLevel += 1;
    gen(paramSynPredBlock);
    this.syntacticPredLevel -= 1;
  }

  protected void genTokenTypes(TokenManager paramTokenManager)
    throws IOException
  {
    this.antlrTool.reportProgress("Generating " + paramTokenManager.getName() + TokenTypesFileSuffix + TokenTypesFileExt);
    this.currentOutput = this.antlrTool.openOutputFile(paramTokenManager.getName() + TokenTypesFileSuffix + TokenTypesFileExt);
    this.tabs = 0;
    genHeader();
    println("");
    println("*** Tokens used by the parser");
    println("This is a list of the token numeric values and the corresponding");
    println("token identifiers.  Some tokens are literals, and because of that");
    println("they have no identifiers.  Literals are double-quoted.");
    this.tabs += 1;
    Vector localVector = paramTokenManager.getVocabulary();
    for (int i = 4; i < localVector.size(); i++)
    {
      String str = (String)localVector.elementAt(i);
      if (str == null)
        continue;
      println(str + " = " + i);
    }
    this.tabs -= 1;
    println("*** End of tokens used by the parser");
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public String getASTCreateString(Vector paramVector)
  {
    return "***Create an AST from a vector here***" + System.getProperty("line.separator");
  }

  public String getASTCreateString(GrammarAtom paramGrammarAtom, String paramString)
  {
    return "[" + paramString + "]";
  }

  protected String processActionForSpecialSymbols(String paramString, int paramInt, RuleBlock paramRuleBlock, ActionTransInfo paramActionTransInfo)
  {
    return paramString;
  }

  public String mapTreeId(String paramString, ActionTransInfo paramActionTransInfo)
  {
    return paramString;
  }

  public void printSet(int paramInt1, int paramInt2, Lookahead paramLookahead)
  {
    int i = 5;
    int[] arrayOfInt = paramLookahead.fset.toArray();
    if (paramInt1 != 1)
      print("k==" + paramInt2 + ": {");
    else
      print("{ ");
    if (arrayOfInt.length > i)
    {
      _println("");
      this.tabs += 1;
      print("");
    }
    int j = 0;
    for (int k = 0; k < arrayOfInt.length; k++)
    {
      j++;
      if (j > i)
      {
        _println("");
        print("");
        j = 0;
      }
      if (this.doingLexRules)
        _print(this.charFormatter.literalChar(arrayOfInt[k]));
      else
        _print((String)this.grammar.tokenManager.getVocabulary().elementAt(arrayOfInt[k]));
      if (k == arrayOfInt.length - 1)
        continue;
      _print(", ");
    }
    if (arrayOfInt.length > i)
    {
      _println("");
      this.tabs -= 1;
      print("");
    }
    _println(" }");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.DiagnosticCodeGenerator
 * JD-Core Version:    0.6.0
 */