package antlr;

class CppCharFormatter
  implements CharFormatter
{
  public String escapeChar(int paramInt, boolean paramBoolean)
  {
    switch (paramInt)
    {
    case 10:
      return "\\n";
    case 9:
      return "\\t";
    case 13:
      return "\\r";
    case 92:
      return "\\\\";
    case 39:
      return "\\'";
    case 34:
      return "\\\"";
    }
    if ((paramInt < 32) || (paramInt > 126))
    {
      if (paramInt > 255)
      {
        for (String str = Integer.toString(paramInt, 16); str.length() < 4; str = '0' + str);
        return "\\u" + str;
      }
      return "\\" + Integer.toString(paramInt, 8);
    }
    return String.valueOf((char)paramInt);
  }

  public String escapeString(String paramString)
  {
    String str = new String();
    for (int i = 0; i < paramString.length(); i++)
      str = str + escapeChar(paramString.charAt(i), false);
    return str;
  }

  public String literalChar(int paramInt)
  {
    String str = "0x" + Integer.toString(paramInt, 16);
    if ((paramInt >= 0) && (paramInt <= 126))
      str = str + " /* '" + escapeChar(paramInt, true) + "' */ ";
    return str;
  }

  public String literalString(String paramString)
  {
    return "\"" + escapeString(paramString) + "\"";
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.CppCharFormatter
 * JD-Core Version:    0.6.0
 */