package antlr;

import antlr.collections.impl.Vector;

class AlternativeBlock extends AlternativeElement
{
  protected String initAction = null;
  protected Vector alternatives = new Vector(5);
  protected String label;
  protected int alti;
  protected int altj;
  protected int analysisAlt;
  protected boolean hasAnAction = false;
  protected boolean hasASynPred = false;
  protected int ID = 0;
  protected static int nblks;
  boolean not = false;
  boolean greedy = true;
  boolean greedySet = false;
  protected boolean doAutoGen = true;
  protected boolean warnWhenFollowAmbig = true;
  protected boolean generateAmbigWarnings = true;

  public AlternativeBlock(Grammar paramGrammar)
  {
    super(paramGrammar);
    this.not = false;
    nblks += 1;
    this.ID = nblks;
  }

  public AlternativeBlock(Grammar paramGrammar, Token paramToken, boolean paramBoolean)
  {
    super(paramGrammar, paramToken);
    this.not = paramBoolean;
    nblks += 1;
    this.ID = nblks;
  }

  public void addAlternative(Alternative paramAlternative)
  {
    this.alternatives.appendElement(paramAlternative);
  }

  public void generate()
  {
    this.grammar.generator.gen(this);
  }

  public Alternative getAlternativeAt(int paramInt)
  {
    return (Alternative)this.alternatives.elementAt(paramInt);
  }

  public Vector getAlternatives()
  {
    return this.alternatives;
  }

  public boolean getAutoGen()
  {
    return this.doAutoGen;
  }

  public String getInitAction()
  {
    return this.initAction;
  }

  public String getLabel()
  {
    return this.label;
  }

  public Lookahead look(int paramInt)
  {
    return this.grammar.theLLkAnalyzer.look(paramInt, this);
  }

  public void prepareForAnalysis()
  {
    for (int i = 0; i < this.alternatives.size(); i++)
    {
      Alternative localAlternative = (Alternative)this.alternatives.elementAt(i);
      localAlternative.cache = new Lookahead[this.grammar.maxk + 1];
      localAlternative.lookaheadDepth = -1;
    }
  }

  public void removeTrackingOfRuleRefs(Grammar paramGrammar)
  {
    for (int i = 0; i < this.alternatives.size(); i++)
    {
      Alternative localAlternative = getAlternativeAt(i);
      for (AlternativeElement localAlternativeElement = localAlternative.head; localAlternativeElement != null; localAlternativeElement = localAlternativeElement.next)
        if ((localAlternativeElement instanceof RuleRefElement))
        {
          RuleRefElement localRuleRefElement = (RuleRefElement)localAlternativeElement;
          RuleSymbol localRuleSymbol = (RuleSymbol)paramGrammar.getSymbol(localRuleRefElement.targetRule);
          if (localRuleSymbol == null)
            this.grammar.antlrTool.error("rule " + localRuleRefElement.targetRule + " referenced in (...)=>, but not defined");
          else
            localRuleSymbol.references.removeElement(localRuleRefElement);
        }
        else
        {
          if (!(localAlternativeElement instanceof AlternativeBlock))
            continue;
          ((AlternativeBlock)localAlternativeElement).removeTrackingOfRuleRefs(paramGrammar);
        }
    }
  }

  public void setAlternatives(Vector paramVector)
  {
    this.alternatives = paramVector;
  }

  public void setAutoGen(boolean paramBoolean)
  {
    this.doAutoGen = paramBoolean;
  }

  public void setInitAction(String paramString)
  {
    this.initAction = paramString;
  }

  public void setLabel(String paramString)
  {
    this.label = paramString;
  }

  public void setOption(Token paramToken1, Token paramToken2)
  {
    if (paramToken1.getText().equals("warnWhenFollowAmbig"))
    {
      if (paramToken2.getText().equals("true"))
        this.warnWhenFollowAmbig = true;
      else if (paramToken2.getText().equals("false"))
        this.warnWhenFollowAmbig = false;
      else
        this.grammar.antlrTool.error("Value for warnWhenFollowAmbig must be true or false", this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
    }
    else if (paramToken1.getText().equals("generateAmbigWarnings"))
    {
      if (paramToken2.getText().equals("true"))
        this.generateAmbigWarnings = true;
      else if (paramToken2.getText().equals("false"))
        this.generateAmbigWarnings = false;
      else
        this.grammar.antlrTool.error("Value for generateAmbigWarnings must be true or false", this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
    }
    else if (paramToken1.getText().equals("greedy"))
    {
      if (paramToken2.getText().equals("true"))
      {
        this.greedy = true;
        this.greedySet = true;
      }
      else if (paramToken2.getText().equals("false"))
      {
        this.greedy = false;
        this.greedySet = true;
      }
      else
      {
        this.grammar.antlrTool.error("Value for greedy must be true or false", this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
      }
    }
    else
      this.grammar.antlrTool.error("Invalid subrule option: " + paramToken1.getText(), this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
  }

  public String toString()
  {
    String str1 = " (";
    if (this.initAction != null)
      str1 = str1 + this.initAction;
    for (int i = 0; i < this.alternatives.size(); i++)
    {
      Alternative localAlternative = getAlternativeAt(i);
      Lookahead[] arrayOfLookahead = localAlternative.cache;
      int j = localAlternative.lookaheadDepth;
      if (j != -1)
        if (j == 2147483647)
        {
          str1 = str1 + "{?}:";
        }
        else
        {
          str1 = str1 + " {";
          for (int k = 1; k <= j; k++)
          {
            str1 = str1 + arrayOfLookahead[k].toString(",", this.grammar.tokenManager.getVocabulary());
            if ((k >= j) || (arrayOfLookahead[(k + 1)] == null))
              continue;
            str1 = str1 + ";";
          }
          str1 = str1 + "}:";
        }
      AlternativeElement localAlternativeElement = localAlternative.head;
      String str2 = localAlternative.semPred;
      if (str2 != null)
        str1 = str1 + str2;
      while (localAlternativeElement != null)
      {
        str1 = str1 + localAlternativeElement;
        localAlternativeElement = localAlternativeElement.next;
      }
      if (i >= this.alternatives.size() - 1)
        continue;
      str1 = str1 + " |";
    }
    str1 = str1 + " )";
    return str1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.AlternativeBlock
 * JD-Core Version:    0.6.0
 */