package antlr;

import antlr.collections.impl.BitSet;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;

public class ANTLRTokdefLexer extends CharScanner
  implements ANTLRTokdefParserTokenTypes, TokenStream
{
  public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
  public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
  public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
  public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());

  public ANTLRTokdefLexer(InputStream paramInputStream)
  {
    this(new ByteBuffer(paramInputStream));
  }

  public ANTLRTokdefLexer(Reader paramReader)
  {
    this(new CharBuffer(paramReader));
  }

  public ANTLRTokdefLexer(InputBuffer paramInputBuffer)
  {
    this(new LexerSharedInputState(paramInputBuffer));
  }

  public ANTLRTokdefLexer(LexerSharedInputState paramLexerSharedInputState)
  {
    super(paramLexerSharedInputState);
    this.caseSensitiveLiterals = true;
    setCaseSensitive(true);
    this.literals = new Hashtable();
  }

  public Token nextToken()
    throws TokenStreamException
  {
    Token localToken = null;
    while (true)
    {
      Object localObject = null;
      int i = 0;
      resetText();
      try
      {
        switch (LA(1))
        {
        case '\t':
        case '\n':
        case '\r':
        case ' ':
          mWS(true);
          localToken = this._returnToken;
          break;
        case '(':
          mLPAREN(true);
          localToken = this._returnToken;
          break;
        case ')':
          mRPAREN(true);
          localToken = this._returnToken;
          break;
        case '=':
          mASSIGN(true);
          localToken = this._returnToken;
          break;
        case '"':
          mSTRING(true);
          localToken = this._returnToken;
          break;
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':
          mID(true);
          localToken = this._returnToken;
          break;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
          mINT(true);
          localToken = this._returnToken;
          break;
        case '\013':
        case '\f':
        case '\016':
        case '\017':
        case '\020':
        case '\021':
        case '\022':
        case '\023':
        case '\024':
        case '\025':
        case '\026':
        case '\027':
        case '\030':
        case '\031':
        case '\032':
        case '\033':
        case '\034':
        case '\035':
        case '\036':
        case '\037':
        case '!':
        case '#':
        case '$':
        case '%':
        case '&':
        case '\'':
        case '*':
        case '+':
        case ',':
        case '-':
        case '.':
        case '/':
        case ':':
        case ';':
        case '<':
        case '>':
        case '?':
        case '@':
        case '[':
        case '\\':
        case ']':
        case '^':
        case '_':
        case '`':
        default:
          if ((LA(1) == '/') && (LA(2) == '/'))
          {
            mSL_COMMENT(true);
            localToken = this._returnToken;
          }
          else if ((LA(1) == '/') && (LA(2) == '*'))
          {
            mML_COMMENT(true);
            localToken = this._returnToken;
          }
          else if (LA(1) == 65535)
          {
            uponEOF();
            this._returnToken = makeToken(1);
          }
          else
          {
            throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
          }
        }
        if (this._returnToken == null)
          continue;
        i = this._returnToken.getType();
        this._returnToken.setType(i);
        return this._returnToken;
      }
      catch (RecognitionException localRecognitionException)
      {
        throw new TokenStreamRecognitionException(localRecognitionException);
      }
      catch (CharStreamException localCharStreamException)
      {
        if (!(localCharStreamException instanceof CharStreamIOException))
          break;
        throw new TokenStreamIOException(((CharStreamIOException)localCharStreamException).io);
      }
    }
    throw new TokenStreamException(localCharStreamException.getMessage());
  }

  public final void mWS(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 10;
    switch (LA(1))
    {
    case ' ':
      match(' ');
      break;
    case '\t':
      match('\t');
      break;
    case '\r':
      match('\r');
      if (LA(1) == '\n')
        match('\n');
      newline();
      break;
    case '\n':
      match('\n');
      newline();
      break;
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    i = -1;
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mSL_COMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 11;
    match("//");
    while (_tokenSet_0.member(LA(1)))
      match(_tokenSet_0);
    switch (LA(1))
    {
    case '\n':
      match('\n');
      break;
    case '\r':
      match('\r');
      if (LA(1) != '\n')
        break;
      match('\n');
      break;
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    i = -1;
    newline();
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mML_COMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 12;
    match("/*");
    while (true)
    {
      if ((LA(1) == '*') && (_tokenSet_1.member(LA(2))))
      {
        match('*');
        matchNot('/');
        continue;
      }
      if (LA(1) == '\n')
      {
        match('\n');
        newline();
        continue;
      }
      if (!_tokenSet_2.member(LA(1)))
        break;
      matchNot('*');
    }
    match("*/");
    i = -1;
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mLPAREN(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 7;
    match('(');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mRPAREN(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 8;
    match(')');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mASSIGN(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 6;
    match('=');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mSTRING(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 5;
    match('"');
    while (true)
    {
      if (LA(1) == '\\')
      {
        mESC(false);
        continue;
      }
      if (!_tokenSet_3.member(LA(1)))
        break;
      matchNot('"');
    }
    match('"');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mESC(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 13;
    match('\\');
    switch (LA(1))
    {
    case 'n':
      match('n');
      break;
    case 'r':
      match('r');
      break;
    case 't':
      match('t');
      break;
    case 'b':
      match('b');
      break;
    case 'f':
      match('f');
      break;
    case '"':
      match('"');
      break;
    case '\'':
      match('\'');
      break;
    case '\\':
      match('\\');
      break;
    case '0':
    case '1':
    case '2':
    case '3':
      matchRange('0', '3');
      if ((LA(1) >= '0') && (LA(1) <= '9') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mDIGIT(false);
        if ((LA(1) >= '0') && (LA(1) <= '9') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
        {
          mDIGIT(false);
        }
        else
        {
          if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
            break;
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
      }
      else
      {
        if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    case '4':
    case '5':
    case '6':
    case '7':
      matchRange('4', '7');
      if ((LA(1) >= '0') && (LA(1) <= '9') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mDIGIT(false);
      }
      else
      {
        if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    case 'u':
      match('u');
      mXDIGIT(false);
      mXDIGIT(false);
      mXDIGIT(false);
      mXDIGIT(false);
      break;
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mDIGIT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 14;
    matchRange('0', '9');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mXDIGIT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 15;
    switch (LA(1))
    {
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
      matchRange('0', '9');
      break;
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
      matchRange('a', 'f');
      break;
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
      matchRange('A', 'F');
      break;
    case ':':
    case ';':
    case '<':
    case '=':
    case '>':
    case '?':
    case '@':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
    case '[':
    case '\\':
    case ']':
    case '^':
    case '_':
    case '`':
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mID(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 4;
    switch (LA(1))
    {
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
    case 'g':
    case 'h':
    case 'i':
    case 'j':
    case 'k':
    case 'l':
    case 'm':
    case 'n':
    case 'o':
    case 'p':
    case 'q':
    case 'r':
    case 's':
    case 't':
    case 'u':
    case 'v':
    case 'w':
    case 'x':
    case 'y':
    case 'z':
      matchRange('a', 'z');
      break;
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
      matchRange('A', 'Z');
      break;
    case '[':
    case '\\':
    case ']':
    case '^':
    case '_':
    case '`':
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    while (true)
      switch (LA(1))
      {
      case 'a':
      case 'b':
      case 'c':
      case 'd':
      case 'e':
      case 'f':
      case 'g':
      case 'h':
      case 'i':
      case 'j':
      case 'k':
      case 'l':
      case 'm':
      case 'n':
      case 'o':
      case 'p':
      case 'q':
      case 'r':
      case 's':
      case 't':
      case 'u':
      case 'v':
      case 'w':
      case 'x':
      case 'y':
      case 'z':
        matchRange('a', 'z');
        break;
      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
      case 'G':
      case 'H':
      case 'I':
      case 'J':
      case 'K':
      case 'L':
      case 'M':
      case 'N':
      case 'O':
      case 'P':
      case 'Q':
      case 'R':
      case 'S':
      case 'T':
      case 'U':
      case 'V':
      case 'W':
      case 'X':
      case 'Y':
      case 'Z':
        matchRange('A', 'Z');
        break;
      case '_':
        match('_');
        break;
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
        matchRange('0', '9');
      case ':':
      case ';':
      case '<':
      case '=':
      case '>':
      case '?':
      case '@':
      case '[':
      case '\\':
      case ']':
      case '^':
      case '`':
      }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mINT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 9;
    for (int k = 0; ; k++)
      if ((LA(1) >= '0') && (LA(1) <= '9'))
      {
        mDIGIT(false);
      }
      else
      {
        if (k >= 1)
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  private static final long[] mk_tokenSet_0()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -9224L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_1()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -140737488355336L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_2()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -4398046512136L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_3()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -17179869192L;
    arrayOfLong[1] = -268435457L;
    for (int i = 2; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.ANTLRTokdefLexer
 * JD-Core Version:    0.6.0
 */