package antlr;

import antlr.collections.impl.BitSet;

public class ANTLRParser extends LLkParser
  implements ANTLRTokenTypes
{
  private static final boolean DEBUG_PARSER = false;
  ANTLRGrammarParseBehavior behavior;
  Tool antlrTool;
  protected int blockNesting = -1;
  public static final String[] _tokenNames = { "<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"tokens\"", "\"header\"", "STRING_LITERAL", "ACTION", "DOC_COMMENT", "\"lexclass\"", "\"class\"", "\"extends\"", "\"Lexer\"", "\"TreeParser\"", "OPTIONS", "ASSIGN", "SEMI", "RCURLY", "\"charVocabulary\"", "CHAR_LITERAL", "INT", "OR", "RANGE", "TOKENS", "TOKEN_REF", "OPEN_ELEMENT_OPTION", "CLOSE_ELEMENT_OPTION", "LPAREN", "RPAREN", "\"Parser\"", "\"protected\"", "\"public\"", "\"private\"", "BANG", "ARG_ACTION", "\"returns\"", "COLON", "\"throws\"", "COMMA", "\"exception\"", "\"catch\"", "RULE_REF", "NOT_OP", "SEMPRED", "TREE_BEGIN", "QUESTION", "STAR", "PLUS", "IMPLIES", "CARET", "WILDCARD", "\"options\"", "WS", "COMMENT", "SL_COMMENT", "ML_COMMENT", "ESC", "DIGIT", "XDIGIT", "NESTED_ARG_ACTION", "NESTED_ACTION", "WS_LOOP", "INTERNAL_RULE_REF", "WS_OPT" };
  public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
  public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
  public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
  public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
  public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
  public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
  public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
  public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
  public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
  public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
  public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());
  public static final BitSet _tokenSet_11 = new BitSet(mk_tokenSet_11());

  public ANTLRParser(TokenBuffer paramTokenBuffer, ANTLRGrammarParseBehavior paramANTLRGrammarParseBehavior, Tool paramTool)
  {
    super(paramTokenBuffer, 1);
    this.tokenNames = _tokenNames;
    this.behavior = paramANTLRGrammarParseBehavior;
    this.antlrTool = paramTool;
  }

  public void reportError(String paramString)
  {
    this.antlrTool.error(paramString, getFilename(), -1, -1);
  }

  public void reportError(RecognitionException paramRecognitionException)
  {
    reportError(paramRecognitionException, paramRecognitionException.getErrorMessage());
  }

  public void reportError(RecognitionException paramRecognitionException, String paramString)
  {
    this.antlrTool.error(paramString, paramRecognitionException.getFilename(), paramRecognitionException.getLine(), paramRecognitionException.getColumn());
  }

  public void reportWarning(String paramString)
  {
    this.antlrTool.warning(paramString, getFilename(), -1, -1);
  }

  private boolean lastInRule()
    throws TokenStreamException
  {
    return (this.blockNesting == 0) && ((LA(1) == 16) || (LA(1) == 39) || (LA(1) == 21));
  }

  private void checkForMissingEndRule(Token paramToken)
  {
    if (paramToken.getColumn() == 1)
      this.antlrTool.warning("did you forget to terminate previous rule?", getFilename(), paramToken.getLine(), paramToken.getColumn());
  }

  protected ANTLRParser(TokenBuffer paramTokenBuffer, int paramInt)
  {
    super(paramTokenBuffer, paramInt);
    this.tokenNames = _tokenNames;
  }

  public ANTLRParser(TokenBuffer paramTokenBuffer)
  {
    this(paramTokenBuffer, 2);
  }

  protected ANTLRParser(TokenStream paramTokenStream, int paramInt)
  {
    super(paramTokenStream, paramInt);
    this.tokenNames = _tokenNames;
  }

  public ANTLRParser(TokenStream paramTokenStream)
  {
    this(paramTokenStream, 2);
  }

  public ANTLRParser(ParserSharedInputState paramParserSharedInputState)
  {
    super(paramParserSharedInputState, 2);
    this.tokenNames = _tokenNames;
  }

  public final void grammar()
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    try
    {
      while (LA(1) == 5)
      {
        if (this.inputState.guessing == 0)
          localToken1 = null;
        match(5);
        switch (LA(1))
        {
        case 6:
          localToken1 = LT(1);
          match(6);
          break;
        case 7:
          break;
        default:
          throw new NoViableAltException(LT(1), getFilename());
        }
        localToken2 = LT(1);
        match(7);
        if (this.inputState.guessing != 0)
          continue;
        this.behavior.refHeaderAction(localToken1, localToken2);
      }
      switch (LA(1))
      {
      case 14:
        fileOptionsSpec();
        break;
      case 1:
      case 7:
      case 8:
      case 9:
      case 10:
        break;
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 11:
      case 12:
      case 13:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      while ((LA(1) >= 7) && (LA(1) <= 10))
        classDef();
      match(1);
    }
    catch (RecognitionException localRecognitionException)
    {
      if (this.inputState.guessing == 0)
      {
        reportError(localRecognitionException, "rule grammar trapped:\n" + localRecognitionException.toString());
        consumeUntil(1);
      }
      else
      {
        throw localRecognitionException;
      }
    }
  }

  public final void fileOptionsSpec()
    throws RecognitionException, TokenStreamException
  {
    match(14);
    while ((LA(1) == 24) || (LA(1) == 41))
    {
      Token localToken1 = id();
      match(15);
      Token localToken2 = optionValue();
      if (this.inputState.guessing == 0)
        this.behavior.setFileOption(localToken1, localToken2, getInputState().filename);
      match(16);
    }
    match(17);
  }

  public final void classDef()
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    String str = null;
    try
    {
      switch (LA(1))
      {
      case 7:
        localToken1 = LT(1);
        match(7);
        if (this.inputState.guessing != 0)
          break;
        this.behavior.refPreambleAction(localToken1);
        break;
      case 8:
      case 9:
      case 10:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      switch (LA(1))
      {
      case 8:
        localToken2 = LT(1);
        match(8);
        if (this.inputState.guessing != 0)
          break;
        str = localToken2.getText();
        break;
      case 9:
      case 10:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      int i = 0;
      int j;
      if (((LA(1) == 9) || (LA(1) == 10)) && ((LA(2) == 24) || (LA(2) == 41)))
      {
        j = mark();
        i = 1;
        this.inputState.guessing += 1;
        try
        {
          switch (LA(1))
          {
          case 9:
            match(9);
            break;
          case 10:
            match(10);
            id();
            match(11);
            match(12);
            break;
          default:
            throw new NoViableAltException(LT(1), getFilename());
          }
        }
        catch (RecognitionException localRecognitionException2)
        {
          i = 0;
        }
        rewind(j);
        this.inputState.guessing -= 1;
      }
      if (i != 0)
      {
        lexerSpec(str);
      }
      else
      {
        j = 0;
        if ((LA(1) == 10) && ((LA(2) == 24) || (LA(2) == 41)))
        {
          int m = mark();
          j = 1;
          this.inputState.guessing += 1;
          try
          {
            match(10);
            id();
            match(11);
            match(13);
          }
          catch (RecognitionException localRecognitionException3)
          {
            j = 0;
          }
          rewind(m);
          this.inputState.guessing -= 1;
        }
        if (j != 0)
          treeParserSpec(str);
        else if ((LA(1) == 10) && ((LA(2) == 24) || (LA(2) == 41)))
          parserSpec(str);
        else
          throw new NoViableAltException(LT(1), getFilename());
      }
      rules();
      if (this.inputState.guessing == 0)
        this.behavior.endGrammar();
    }
    catch (RecognitionException localRecognitionException1)
    {
      if (this.inputState.guessing == 0)
      {
        if ((localRecognitionException1 instanceof NoViableAltException))
        {
          NoViableAltException localNoViableAltException = (NoViableAltException)localRecognitionException1;
          if (localNoViableAltException.token.getType() == 8)
            reportError(localRecognitionException1, "JAVADOC comments may only prefix rules and grammars");
          else
            reportError(localRecognitionException1, "rule classDef trapped:\n" + localRecognitionException1.toString());
        }
        else
        {
          reportError(localRecognitionException1, "rule classDef trapped:\n" + localRecognitionException1.toString());
        }
        this.behavior.abortGrammar();
        for (int k = 1; k != 0; k = 0)
        {
          consume();
          switch (LA(1))
          {
          case 1:
          case 9:
          case 10:
          }
        }
      }
      throw localRecognitionException1;
    }
  }

  public final Token id()
    throws RecognitionException, TokenStreamException
  {
    Token localToken2 = null;
    Token localToken3 = null;
    Token localToken1 = null;
    switch (LA(1))
    {
    case 24:
      localToken2 = LT(1);
      match(24);
      if (this.inputState.guessing != 0)
        break;
      localToken1 = localToken2;
      break;
    case 41:
      localToken3 = LT(1);
      match(41);
      if (this.inputState.guessing != 0)
        break;
      localToken1 = localToken3;
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    return localToken1;
  }

  public final void lexerSpec(String paramString)
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    String str = null;
    Token localToken3;
    switch (LA(1))
    {
    case 9:
      localToken1 = LT(1);
      match(9);
      localToken3 = id();
      if (this.inputState.guessing != 0)
        break;
      this.antlrTool.warning("lexclass' is deprecated; use 'class X extends Lexer'", getFilename(), localToken1.getLine(), localToken1.getColumn());
      break;
    case 10:
      match(10);
      localToken3 = id();
      match(11);
      match(12);
      switch (LA(1))
      {
      case 27:
        str = superClass();
        break;
      case 16:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.startLexer(getFilename(), localToken3, str, paramString);
    match(16);
    switch (LA(1))
    {
    case 14:
      lexerOptionsSpec();
      break;
    case 7:
    case 8:
    case 23:
    case 24:
    case 30:
    case 31:
    case 32:
    case 41:
      break;
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.endOptions();
    switch (LA(1))
    {
    case 23:
      tokensSpec();
      break;
    case 7:
    case 8:
    case 24:
    case 30:
    case 31:
    case 32:
    case 41:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    switch (LA(1))
    {
    case 7:
      localToken2 = LT(1);
      match(7);
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refMemberAction(localToken2);
      break;
    case 8:
    case 24:
    case 30:
    case 31:
    case 32:
    case 41:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
  }

  public final void treeParserSpec(String paramString)
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    String str = null;
    match(10);
    Token localToken2 = id();
    match(11);
    match(13);
    switch (LA(1))
    {
    case 27:
      str = superClass();
      break;
    case 16:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.startTreeWalker(getFilename(), localToken2, str, paramString);
    match(16);
    switch (LA(1))
    {
    case 14:
      treeParserOptionsSpec();
      break;
    case 7:
    case 8:
    case 23:
    case 24:
    case 30:
    case 31:
    case 32:
    case 41:
      break;
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.endOptions();
    switch (LA(1))
    {
    case 23:
      tokensSpec();
      break;
    case 7:
    case 8:
    case 24:
    case 30:
    case 31:
    case 32:
    case 41:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    switch (LA(1))
    {
    case 7:
      localToken1 = LT(1);
      match(7);
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refMemberAction(localToken1);
      break;
    case 8:
    case 24:
    case 30:
    case 31:
    case 32:
    case 41:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
  }

  public final void parserSpec(String paramString)
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    String str = null;
    match(10);
    Token localToken2 = id();
    switch (LA(1))
    {
    case 11:
      match(11);
      match(29);
      switch (LA(1))
      {
      case 27:
        str = superClass();
        break;
      case 16:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
    case 16:
      if (this.inputState.guessing != 0)
        break;
      this.antlrTool.warning("use 'class X extends Parser'", getFilename(), localToken2.getLine(), localToken2.getColumn());
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.startParser(getFilename(), localToken2, str, paramString);
    match(16);
    switch (LA(1))
    {
    case 14:
      parserOptionsSpec();
      break;
    case 7:
    case 8:
    case 23:
    case 24:
    case 30:
    case 31:
    case 32:
    case 41:
      break;
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.endOptions();
    switch (LA(1))
    {
    case 23:
      tokensSpec();
      break;
    case 7:
    case 8:
    case 24:
    case 30:
    case 31:
    case 32:
    case 41:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    switch (LA(1))
    {
    case 7:
      localToken1 = LT(1);
      match(7);
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refMemberAction(localToken1);
      break;
    case 8:
    case 24:
    case 30:
    case 31:
    case 32:
    case 41:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
  }

  public final void rules()
    throws RecognitionException, TokenStreamException
  {
    for (int i = 0; ; i++)
      if ((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))))
      {
        rule();
      }
      else
      {
        if (i >= 1)
          break;
        throw new NoViableAltException(LT(1), getFilename());
      }
  }

  public final Token optionValue()
    throws RecognitionException, TokenStreamException
  {
    Token localToken2 = null;
    Token localToken3 = null;
    Token localToken4 = null;
    Token localToken1 = null;
    switch (LA(1))
    {
    case 24:
    case 41:
      localToken1 = qualifiedID();
      break;
    case 6:
      localToken2 = LT(1);
      match(6);
      if (this.inputState.guessing != 0)
        break;
      localToken1 = localToken2;
      break;
    case 19:
      localToken3 = LT(1);
      match(19);
      if (this.inputState.guessing != 0)
        break;
      localToken1 = localToken3;
      break;
    case 20:
      localToken4 = LT(1);
      match(20);
      if (this.inputState.guessing != 0)
        break;
      localToken1 = localToken4;
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    return localToken1;
  }

  public final void parserOptionsSpec()
    throws RecognitionException, TokenStreamException
  {
    match(14);
    while ((LA(1) == 24) || (LA(1) == 41))
    {
      Token localToken1 = id();
      match(15);
      Token localToken2 = optionValue();
      if (this.inputState.guessing == 0)
        this.behavior.setGrammarOption(localToken1, localToken2);
      match(16);
    }
    match(17);
  }

  public final void treeParserOptionsSpec()
    throws RecognitionException, TokenStreamException
  {
    match(14);
    while ((LA(1) == 24) || (LA(1) == 41))
    {
      Token localToken1 = id();
      match(15);
      Token localToken2 = optionValue();
      if (this.inputState.guessing == 0)
        this.behavior.setGrammarOption(localToken1, localToken2);
      match(16);
    }
    match(17);
  }

  public final void lexerOptionsSpec()
    throws RecognitionException, TokenStreamException
  {
    match(14);
    while (true)
      switch (LA(1))
      {
      case 18:
        match(18);
        match(15);
        BitSet localBitSet = charSet();
        match(16);
        if (this.inputState.guessing != 0)
          continue;
        this.behavior.setCharVocabulary(localBitSet);
        break;
      case 24:
      case 41:
        Token localToken1 = id();
        match(15);
        Token localToken2 = optionValue();
        if (this.inputState.guessing == 0)
          this.behavior.setGrammarOption(localToken1, localToken2);
        match(16);
      }
    match(17);
  }

  public final BitSet charSet()
    throws RecognitionException, TokenStreamException
  {
    BitSet localBitSet1 = null;
    BitSet localBitSet2 = null;
    localBitSet1 = setBlockElement();
    while (LA(1) == 21)
    {
      match(21);
      localBitSet2 = setBlockElement();
      if (this.inputState.guessing != 0)
        continue;
      localBitSet1.orInPlace(localBitSet2);
    }
    return localBitSet1;
  }

  public final void subruleOptionsSpec()
    throws RecognitionException, TokenStreamException
  {
    match(14);
    while ((LA(1) == 24) || (LA(1) == 41))
    {
      Token localToken1 = id();
      match(15);
      Token localToken2 = optionValue();
      if (this.inputState.guessing == 0)
        this.behavior.setSubruleOption(localToken1, localToken2);
      match(16);
    }
    match(17);
  }

  public final Token qualifiedID()
    throws RecognitionException, TokenStreamException
  {
    CommonToken localCommonToken = null;
    StringBuffer localStringBuffer = new StringBuffer(30);
    Token localToken = id();
    if (this.inputState.guessing == 0)
      localStringBuffer.append(localToken.getText());
    while (LA(1) == 50)
    {
      match(50);
      localToken = id();
      if (this.inputState.guessing != 0)
        continue;
      localStringBuffer.append('.');
      localStringBuffer.append(localToken.getText());
    }
    if (this.inputState.guessing == 0)
    {
      localCommonToken = new CommonToken(24, localStringBuffer.toString());
      localCommonToken.setLine(localToken.getLine());
    }
    return localCommonToken;
  }

  public final BitSet setBlockElement()
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    BitSet localBitSet = null;
    int i = 0;
    localToken1 = LT(1);
    match(19);
    if (this.inputState.guessing == 0)
    {
      i = ANTLRLexer.tokenTypeForCharLiteral(localToken1.getText());
      localBitSet = BitSet.of(i);
    }
    int j;
    int k;
    switch (LA(1))
    {
    case 22:
      match(22);
      localToken2 = LT(1);
      match(19);
      if (this.inputState.guessing != 0)
        break;
      j = ANTLRLexer.tokenTypeForCharLiteral(localToken2.getText());
      if (j < i)
        this.antlrTool.error("Malformed range line ", getFilename(), localToken1.getLine(), localToken1.getColumn());
      k = i + 1;
    case 16:
    case 21:
    default:
      while (k <= j)
      {
        localBitSet.add(k);
        k++;
        continue;
        break;
        throw new NoViableAltException(LT(1), getFilename());
      }
    }
    return localBitSet;
  }

  public final void tokensSpec()
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    Token localToken3 = null;
    match(23);
    for (int i = 0; ; i++)
      if ((LA(1) == 6) || (LA(1) == 24))
      {
        switch (LA(1))
        {
        case 24:
          if (this.inputState.guessing == 0)
            localToken2 = null;
          localToken1 = LT(1);
          match(24);
          switch (LA(1))
          {
          case 15:
            match(15);
            localToken2 = LT(1);
            match(6);
            break;
          case 16:
          case 25:
            break;
          default:
            throw new NoViableAltException(LT(1), getFilename());
          }
          if (this.inputState.guessing == 0)
            this.behavior.defineToken(localToken1, localToken2);
          switch (LA(1))
          {
          case 25:
            tokensSpecOptions(localToken1);
            break;
          case 16:
            break;
          default:
            throw new NoViableAltException(LT(1), getFilename());
          }
        case 6:
          localToken3 = LT(1);
          match(6);
          if (this.inputState.guessing == 0)
            this.behavior.defineToken(null, localToken3);
          switch (LA(1))
          {
          case 25:
            tokensSpecOptions(localToken3);
            break;
          case 16:
            break;
          default:
            throw new NoViableAltException(LT(1), getFilename());
          }
        default:
          throw new NoViableAltException(LT(1), getFilename());
        }
        match(16);
      }
      else
      {
        if (i >= 1)
          break;
        throw new NoViableAltException(LT(1), getFilename());
      }
    match(17);
  }

  public final void tokensSpecOptions(Token paramToken)
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    match(25);
    localToken1 = id();
    match(15);
    localToken2 = optionValue();
    if (this.inputState.guessing == 0)
      this.behavior.refTokensSpecElementOption(paramToken, localToken1, localToken2);
    while (LA(1) == 16)
    {
      match(16);
      localToken1 = id();
      match(15);
      localToken2 = optionValue();
      if (this.inputState.guessing != 0)
        continue;
      this.behavior.refTokensSpecElementOption(paramToken, localToken1, localToken2);
    }
    match(26);
  }

  public final String superClass()
    throws RecognitionException, TokenStreamException
  {
    String str = null;
    match(27);
    if (this.inputState.guessing == 0)
    {
      str = LT(1).getText();
      str = StringUtils.stripFrontBack(str, "\"", "\"");
    }
    match(6);
    match(28);
    return str;
  }

  public final void rule()
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    Token localToken3 = null;
    Token localToken4 = null;
    Token localToken5 = null;
    Token localToken6 = null;
    Token localToken7 = null;
    String str1 = "public";
    String str2 = null;
    boolean bool = true;
    this.blockNesting = -1;
    switch (LA(1))
    {
    case 8:
      localToken1 = LT(1);
      match(8);
      if (this.inputState.guessing != 0)
        break;
      str2 = localToken1.getText();
      break;
    case 24:
    case 30:
    case 31:
    case 32:
    case 41:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    switch (LA(1))
    {
    case 30:
      localToken2 = LT(1);
      match(30);
      if (this.inputState.guessing != 0)
        break;
      str1 = localToken2.getText();
      break;
    case 31:
      localToken3 = LT(1);
      match(31);
      if (this.inputState.guessing != 0)
        break;
      str1 = localToken3.getText();
      break;
    case 32:
      localToken4 = LT(1);
      match(32);
      if (this.inputState.guessing != 0)
        break;
      str1 = localToken4.getText();
      break;
    case 24:
    case 41:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    Token localToken8 = id();
    switch (LA(1))
    {
    case 33:
      match(33);
      if (this.inputState.guessing != 0)
        break;
      bool = false;
      break;
    case 7:
    case 14:
    case 34:
    case 35:
    case 36:
    case 37:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.defineRuleName(localToken8, str1, bool, str2);
    switch (LA(1))
    {
    case 34:
      localToken5 = LT(1);
      match(34);
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refArgAction(localToken5);
      break;
    case 7:
    case 14:
    case 35:
    case 36:
    case 37:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    switch (LA(1))
    {
    case 35:
      match(35);
      localToken6 = LT(1);
      match(34);
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refReturnAction(localToken6);
      break;
    case 7:
    case 14:
    case 36:
    case 37:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    switch (LA(1))
    {
    case 37:
      throwsSpec();
      break;
    case 7:
    case 14:
    case 36:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    switch (LA(1))
    {
    case 14:
      ruleOptionsSpec();
      break;
    case 7:
    case 36:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    switch (LA(1))
    {
    case 7:
      localToken7 = LT(1);
      match(7);
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refInitAction(localToken7);
      break;
    case 36:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    match(36);
    block();
    match(16);
    switch (LA(1))
    {
    case 39:
      exceptionGroup();
      break;
    case 1:
    case 7:
    case 8:
    case 9:
    case 10:
    case 24:
    case 30:
    case 31:
    case 32:
    case 41:
      break;
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 40:
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.endRule(localToken8.getText());
  }

  public final void throwsSpec()
    throws RecognitionException, TokenStreamException
  {
    String str = null;
    match(37);
    Token localToken1 = id();
    if (this.inputState.guessing == 0)
      str = localToken1.getText();
    while (LA(1) == 38)
    {
      match(38);
      Token localToken2 = id();
      if (this.inputState.guessing != 0)
        continue;
      str = str + "," + localToken2.getText();
    }
    if (this.inputState.guessing == 0)
      this.behavior.setUserExceptions(str);
  }

  public final void ruleOptionsSpec()
    throws RecognitionException, TokenStreamException
  {
    match(14);
    while ((LA(1) == 24) || (LA(1) == 41))
    {
      Token localToken1 = id();
      match(15);
      Token localToken2 = optionValue();
      if (this.inputState.guessing == 0)
        this.behavior.setRuleOption(localToken1, localToken2);
      match(16);
    }
    match(17);
  }

  public final void block()
    throws RecognitionException, TokenStreamException
  {
    if (this.inputState.guessing == 0)
      this.blockNesting += 1;
    alternative();
    while (LA(1) == 21)
    {
      match(21);
      alternative();
    }
    if (this.inputState.guessing == 0)
      this.blockNesting -= 1;
  }

  public final void exceptionGroup()
    throws RecognitionException, TokenStreamException
  {
    if (this.inputState.guessing == 0)
      this.behavior.beginExceptionGroup();
    for (int i = 0; ; i++)
      if (LA(1) == 39)
      {
        exceptionSpec();
      }
      else
      {
        if (i >= 1)
          break;
        throw new NoViableAltException(LT(1), getFilename());
      }
    if (this.inputState.guessing == 0)
      this.behavior.endExceptionGroup();
  }

  public final void alternative()
    throws RecognitionException, TokenStreamException
  {
    boolean bool = true;
    switch (LA(1))
    {
    case 33:
      match(33);
      if (this.inputState.guessing != 0)
        break;
      bool = false;
      break;
    case 6:
    case 7:
    case 16:
    case 19:
    case 21:
    case 24:
    case 27:
    case 28:
    case 39:
    case 41:
    case 42:
    case 43:
    case 44:
    case 50:
      break;
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 17:
    case 18:
    case 20:
    case 22:
    case 23:
    case 25:
    case 26:
    case 29:
    case 30:
    case 31:
    case 32:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 40:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.beginAlt(bool);
    while (_tokenSet_2.member(LA(1)))
      element();
    switch (LA(1))
    {
    case 39:
      exceptionSpecNoLabel();
      break;
    case 16:
    case 21:
    case 28:
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.endAlt();
  }

  public final void element()
    throws RecognitionException, TokenStreamException
  {
    elementNoOptionSpec();
    switch (LA(1))
    {
    case 25:
      elementOptionSpec();
      break;
    case 6:
    case 7:
    case 16:
    case 19:
    case 21:
    case 24:
    case 27:
    case 28:
    case 39:
    case 41:
    case 42:
    case 43:
    case 44:
    case 50:
      break;
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 17:
    case 18:
    case 20:
    case 22:
    case 23:
    case 26:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 40:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
  }

  public final void exceptionSpecNoLabel()
    throws RecognitionException, TokenStreamException
  {
    match(39);
    if (this.inputState.guessing == 0)
      this.behavior.beginExceptionSpec(null);
    while (LA(1) == 40)
      exceptionHandler();
    if (this.inputState.guessing == 0)
      this.behavior.endExceptionSpec();
  }

  public final void exceptionSpec()
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    match(39);
    switch (LA(1))
    {
    case 34:
      localToken1 = LT(1);
      match(34);
      if (this.inputState.guessing != 0)
        break;
      localToken2 = localToken1;
      break;
    case 1:
    case 7:
    case 8:
    case 9:
    case 10:
    case 24:
    case 30:
    case 31:
    case 32:
    case 39:
    case 40:
    case 41:
      break;
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 33:
    case 35:
    case 36:
    case 37:
    case 38:
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.beginExceptionSpec(localToken2);
    while (LA(1) == 40)
      exceptionHandler();
    if (this.inputState.guessing == 0)
      this.behavior.endExceptionSpec();
  }

  public final void exceptionHandler()
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    match(40);
    localToken1 = LT(1);
    match(34);
    localToken2 = LT(1);
    match(7);
    if (this.inputState.guessing == 0)
      this.behavior.refExceptionHandler(localToken1, localToken2);
  }

  public final void elementNoOptionSpec()
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    Token localToken3 = null;
    Token localToken4 = null;
    Token localToken5 = null;
    Token localToken6 = null;
    Token localToken7 = null;
    Token localToken8 = null;
    Token localToken9 = null;
    Token localToken10 = null;
    Token localToken11 = null;
    int i = 1;
    switch (LA(1))
    {
    case 7:
      localToken7 = LT(1);
      match(7);
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refAction(localToken7);
      break;
    case 43:
      localToken8 = LT(1);
      match(43);
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refSemPred(localToken8);
      break;
    case 44:
      tree();
      break;
    default:
      if (((LA(1) == 24) || (LA(1) == 41)) && (LA(2) == 15))
      {
        localToken10 = id();
        match(15);
        if (((LA(1) == 24) || (LA(1) == 41)) && (LA(2) == 36))
        {
          localToken9 = id();
          match(36);
          if (this.inputState.guessing == 0)
            checkForMissingEndRule(localToken9);
        }
        else if (((LA(1) != 24) && (LA(1) != 41)) || (!_tokenSet_3.member(LA(2))))
        {
          throw new NoViableAltException(LT(1), getFilename());
        }
      }
      switch (LA(1))
      {
      case 41:
        localToken1 = LT(1);
        match(41);
        switch (LA(1))
        {
        case 34:
          localToken2 = LT(1);
          match(34);
          if (this.inputState.guessing != 0)
            break;
          localToken11 = localToken2;
          break;
        case 6:
        case 7:
        case 16:
        case 19:
        case 21:
        case 24:
        case 25:
        case 27:
        case 28:
        case 33:
        case 39:
        case 41:
        case 42:
        case 43:
        case 44:
        case 50:
          break;
        case 8:
        case 9:
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 17:
        case 18:
        case 20:
        case 22:
        case 23:
        case 26:
        case 29:
        case 30:
        case 31:
        case 32:
        case 35:
        case 36:
        case 37:
        case 38:
        case 40:
        case 45:
        case 46:
        case 47:
        case 48:
        case 49:
        default:
          throw new NoViableAltException(LT(1), getFilename());
        }
        switch (LA(1))
        {
        case 33:
          match(33);
          if (this.inputState.guessing != 0)
            break;
          i = 3;
          break;
        case 6:
        case 7:
        case 16:
        case 19:
        case 21:
        case 24:
        case 25:
        case 27:
        case 28:
        case 39:
        case 41:
        case 42:
        case 43:
        case 44:
        case 50:
          break;
        case 8:
        case 9:
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 17:
        case 18:
        case 20:
        case 22:
        case 23:
        case 26:
        case 29:
        case 30:
        case 31:
        case 32:
        case 34:
        case 35:
        case 36:
        case 37:
        case 38:
        case 40:
        case 45:
        case 46:
        case 47:
        case 48:
        case 49:
        default:
          throw new NoViableAltException(LT(1), getFilename());
        }
        if (this.inputState.guessing != 0)
          break;
        this.behavior.refRule(localToken10, localToken1, localToken9, localToken11, i);
        break;
      case 24:
        localToken3 = LT(1);
        match(24);
        switch (LA(1))
        {
        case 34:
          localToken4 = LT(1);
          match(34);
          if (this.inputState.guessing != 0)
            break;
          localToken11 = localToken4;
          break;
        case 6:
        case 7:
        case 16:
        case 19:
        case 21:
        case 24:
        case 25:
        case 27:
        case 28:
        case 39:
        case 41:
        case 42:
        case 43:
        case 44:
        case 50:
          break;
        case 8:
        case 9:
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 17:
        case 18:
        case 20:
        case 22:
        case 23:
        case 26:
        case 29:
        case 30:
        case 31:
        case 32:
        case 33:
        case 35:
        case 36:
        case 37:
        case 38:
        case 40:
        case 45:
        case 46:
        case 47:
        case 48:
        case 49:
        default:
          throw new NoViableAltException(LT(1), getFilename());
        }
        if (this.inputState.guessing != 0)
          break;
        this.behavior.refToken(localToken10, localToken3, localToken9, localToken11, false, i, lastInRule());
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
        if ((_tokenSet_4.member(LA(1))) && (_tokenSet_5.member(LA(2))))
          if (((LA(1) == 24) || (LA(1) == 41)) && (LA(2) == 36))
          {
            localToken9 = id();
            match(36);
            if (this.inputState.guessing == 0)
              checkForMissingEndRule(localToken9);
          }
          else if ((!_tokenSet_4.member(LA(1))) || (!_tokenSet_6.member(LA(2))))
          {
            throw new NoViableAltException(LT(1), getFilename());
          }
        switch (LA(1))
        {
        case 41:
          localToken5 = LT(1);
          match(41);
          switch (LA(1))
          {
          case 34:
            localToken6 = LT(1);
            match(34);
            if (this.inputState.guessing != 0)
              break;
            localToken11 = localToken6;
            break;
          case 6:
          case 7:
          case 16:
          case 19:
          case 21:
          case 24:
          case 25:
          case 27:
          case 28:
          case 33:
          case 39:
          case 41:
          case 42:
          case 43:
          case 44:
          case 50:
            break;
          case 8:
          case 9:
          case 10:
          case 11:
          case 12:
          case 13:
          case 14:
          case 15:
          case 17:
          case 18:
          case 20:
          case 22:
          case 23:
          case 26:
          case 29:
          case 30:
          case 31:
          case 32:
          case 35:
          case 36:
          case 37:
          case 38:
          case 40:
          case 45:
          case 46:
          case 47:
          case 48:
          case 49:
          default:
            throw new NoViableAltException(LT(1), getFilename());
          }
          switch (LA(1))
          {
          case 33:
            match(33);
            if (this.inputState.guessing != 0)
              break;
            i = 3;
            break;
          case 6:
          case 7:
          case 16:
          case 19:
          case 21:
          case 24:
          case 25:
          case 27:
          case 28:
          case 39:
          case 41:
          case 42:
          case 43:
          case 44:
          case 50:
            break;
          case 8:
          case 9:
          case 10:
          case 11:
          case 12:
          case 13:
          case 14:
          case 15:
          case 17:
          case 18:
          case 20:
          case 22:
          case 23:
          case 26:
          case 29:
          case 30:
          case 31:
          case 32:
          case 34:
          case 35:
          case 36:
          case 37:
          case 38:
          case 40:
          case 45:
          case 46:
          case 47:
          case 48:
          case 49:
          default:
            throw new NoViableAltException(LT(1), getFilename());
          }
          if (this.inputState.guessing != 0)
            break;
          this.behavior.refRule(localToken10, localToken5, localToken9, localToken11, i);
          break;
        case 42:
          match(42);
          switch (LA(1))
          {
          case 19:
          case 24:
            notTerminal(localToken9);
            break;
          case 27:
            ebnf(localToken9, true);
            break;
          default:
            throw new NoViableAltException(LT(1), getFilename());
          }
        case 27:
          ebnf(localToken9, false);
          break;
        default:
          if (((LA(1) == 6) || (LA(1) == 19) || (LA(1) == 24)) && (LA(2) == 22))
          {
            range(localToken9);
          }
          else if ((_tokenSet_7.member(LA(1))) && (_tokenSet_8.member(LA(2))))
          {
            terminal(localToken9);
          }
          else
          {
            throw new NoViableAltException(LT(1), getFilename());
            throw new NoViableAltException(LT(1), getFilename());
          }
        }
      }
    }
  }

  public final void elementOptionSpec()
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    match(25);
    localToken1 = id();
    match(15);
    localToken2 = optionValue();
    if (this.inputState.guessing == 0)
      this.behavior.refElementOption(localToken1, localToken2);
    while (LA(1) == 16)
    {
      match(16);
      localToken1 = id();
      match(15);
      localToken2 = optionValue();
      if (this.inputState.guessing != 0)
        continue;
      this.behavior.refElementOption(localToken1, localToken2);
    }
    match(26);
  }

  public final void range(Token paramToken)
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    Token localToken3 = null;
    Token localToken4 = null;
    Token localToken5 = null;
    Token localToken6 = null;
    Token localToken7 = null;
    Token localToken8 = null;
    int i = 1;
    switch (LA(1))
    {
    case 19:
      localToken1 = LT(1);
      match(19);
      match(22);
      localToken2 = LT(1);
      match(19);
      switch (LA(1))
      {
      case 33:
        match(33);
        if (this.inputState.guessing != 0)
          break;
        i = 3;
        break;
      case 6:
      case 7:
      case 16:
      case 19:
      case 21:
      case 24:
      case 25:
      case 27:
      case 28:
      case 39:
      case 41:
      case 42:
      case 43:
      case 44:
      case 50:
        break;
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 17:
      case 18:
      case 20:
      case 22:
      case 23:
      case 26:
      case 29:
      case 30:
      case 31:
      case 32:
      case 34:
      case 35:
      case 36:
      case 37:
      case 38:
      case 40:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refCharRange(localToken1, localToken2, paramToken, i, lastInRule());
      break;
    case 6:
    case 24:
      switch (LA(1))
      {
      case 24:
        localToken3 = LT(1);
        match(24);
        if (this.inputState.guessing != 0)
          break;
        localToken7 = localToken3;
        break;
      case 6:
        localToken4 = LT(1);
        match(6);
        if (this.inputState.guessing != 0)
          break;
        localToken7 = localToken4;
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      match(22);
      switch (LA(1))
      {
      case 24:
        localToken5 = LT(1);
        match(24);
        if (this.inputState.guessing != 0)
          break;
        localToken8 = localToken5;
        break;
      case 6:
        localToken6 = LT(1);
        match(6);
        if (this.inputState.guessing != 0)
          break;
        localToken8 = localToken6;
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      i = ast_type_spec();
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refTokenRange(localToken7, localToken8, paramToken, i, lastInRule());
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
  }

  public final void terminal(Token paramToken)
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    Token localToken3 = null;
    Token localToken4 = null;
    Token localToken5 = null;
    int i = 1;
    Token localToken6 = null;
    switch (LA(1))
    {
    case 19:
      localToken1 = LT(1);
      match(19);
      switch (LA(1))
      {
      case 33:
        match(33);
        if (this.inputState.guessing != 0)
          break;
        i = 3;
        break;
      case 6:
      case 7:
      case 16:
      case 19:
      case 21:
      case 24:
      case 25:
      case 27:
      case 28:
      case 39:
      case 41:
      case 42:
      case 43:
      case 44:
      case 50:
        break;
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 17:
      case 18:
      case 20:
      case 22:
      case 23:
      case 26:
      case 29:
      case 30:
      case 31:
      case 32:
      case 34:
      case 35:
      case 36:
      case 37:
      case 38:
      case 40:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refCharLiteral(localToken1, paramToken, false, i, lastInRule());
      break;
    case 24:
      localToken2 = LT(1);
      match(24);
      i = ast_type_spec();
      switch (LA(1))
      {
      case 34:
        localToken3 = LT(1);
        match(34);
        if (this.inputState.guessing != 0)
          break;
        localToken6 = localToken3;
        break;
      case 6:
      case 7:
      case 16:
      case 19:
      case 21:
      case 24:
      case 25:
      case 27:
      case 28:
      case 39:
      case 41:
      case 42:
      case 43:
      case 44:
      case 50:
        break;
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 17:
      case 18:
      case 20:
      case 22:
      case 23:
      case 26:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 35:
      case 36:
      case 37:
      case 38:
      case 40:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refToken(null, localToken2, paramToken, localToken6, false, i, lastInRule());
      break;
    case 6:
      localToken4 = LT(1);
      match(6);
      i = ast_type_spec();
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refStringLiteral(localToken4, paramToken, i, lastInRule());
      break;
    case 50:
      localToken5 = LT(1);
      match(50);
      i = ast_type_spec();
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refWildcard(localToken5, paramToken, i);
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
  }

  public final void notTerminal(Token paramToken)
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    int i = 1;
    switch (LA(1))
    {
    case 19:
      localToken1 = LT(1);
      match(19);
      switch (LA(1))
      {
      case 33:
        match(33);
        if (this.inputState.guessing != 0)
          break;
        i = 3;
        break;
      case 6:
      case 7:
      case 16:
      case 19:
      case 21:
      case 24:
      case 25:
      case 27:
      case 28:
      case 39:
      case 41:
      case 42:
      case 43:
      case 44:
      case 50:
        break;
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 17:
      case 18:
      case 20:
      case 22:
      case 23:
      case 26:
      case 29:
      case 30:
      case 31:
      case 32:
      case 34:
      case 35:
      case 36:
      case 37:
      case 38:
      case 40:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refCharLiteral(localToken1, paramToken, true, i, lastInRule());
      break;
    case 24:
      localToken2 = LT(1);
      match(24);
      i = ast_type_spec();
      if (this.inputState.guessing != 0)
        break;
      this.behavior.refToken(null, localToken2, paramToken, null, true, i, lastInRule());
      break;
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
  }

  public final void ebnf(Token paramToken, boolean paramBoolean)
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    Token localToken3 = null;
    localToken1 = LT(1);
    match(27);
    if (this.inputState.guessing == 0)
      this.behavior.beginSubRule(paramToken, localToken1, paramBoolean);
    if (LA(1) == 14)
    {
      subruleOptionsSpec();
      switch (LA(1))
      {
      case 7:
        localToken2 = LT(1);
        match(7);
        if (this.inputState.guessing != 0)
          break;
        this.behavior.refInitAction(localToken2);
        break;
      case 36:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      match(36);
    }
    else if ((LA(1) == 7) && (LA(2) == 36))
    {
      localToken3 = LT(1);
      match(7);
      if (this.inputState.guessing == 0)
        this.behavior.refInitAction(localToken3);
      match(36);
    }
    else if ((!_tokenSet_9.member(LA(1))) || (!_tokenSet_10.member(LA(2))))
    {
      throw new NoViableAltException(LT(1), getFilename());
    }
    block();
    match(28);
    switch (LA(1))
    {
    case 6:
    case 7:
    case 16:
    case 19:
    case 21:
    case 24:
    case 25:
    case 27:
    case 28:
    case 33:
    case 39:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 50:
      switch (LA(1))
      {
      case 45:
        match(45);
        if (this.inputState.guessing != 0)
          break;
        this.behavior.optionalSubRule();
        break;
      case 46:
        match(46);
        if (this.inputState.guessing != 0)
          break;
        this.behavior.zeroOrMoreSubRule();
        break;
      case 47:
        match(47);
        if (this.inputState.guessing != 0)
          break;
        this.behavior.oneOrMoreSubRule();
        break;
      case 6:
      case 7:
      case 16:
      case 19:
      case 21:
      case 24:
      case 25:
      case 27:
      case 28:
      case 33:
      case 39:
      case 41:
      case 42:
      case 43:
      case 44:
      case 50:
        break;
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 17:
      case 18:
      case 20:
      case 22:
      case 23:
      case 26:
      case 29:
      case 30:
      case 31:
      case 32:
      case 34:
      case 35:
      case 36:
      case 37:
      case 38:
      case 40:
      case 48:
      case 49:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      switch (LA(1))
      {
      case 33:
        match(33);
        if (this.inputState.guessing != 0)
          break;
        this.behavior.noASTSubRule();
        break;
      case 6:
      case 7:
      case 16:
      case 19:
      case 21:
      case 24:
      case 25:
      case 27:
      case 28:
      case 39:
      case 41:
      case 42:
      case 43:
      case 44:
      case 50:
        break;
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 17:
      case 18:
      case 20:
      case 22:
      case 23:
      case 26:
      case 29:
      case 30:
      case 31:
      case 32:
      case 34:
      case 35:
      case 36:
      case 37:
      case 38:
      case 40:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
    case 48:
      match(48);
      if (this.inputState.guessing != 0)
        break;
      this.behavior.synPred();
      break;
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 17:
    case 18:
    case 20:
    case 22:
    case 23:
    case 26:
    case 29:
    case 30:
    case 31:
    case 32:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 40:
    case 49:
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    if (this.inputState.guessing == 0)
      this.behavior.endSubRule();
  }

  public final void tree()
    throws RecognitionException, TokenStreamException
  {
    Token localToken = null;
    localToken = LT(1);
    match(44);
    if (this.inputState.guessing == 0)
      this.behavior.beginTree(localToken);
    rootNode();
    if (this.inputState.guessing == 0)
      this.behavior.beginChildList();
    for (int i = 0; ; i++)
      if (_tokenSet_2.member(LA(1)))
      {
        element();
      }
      else
      {
        if (i >= 1)
          break;
        throw new NoViableAltException(LT(1), getFilename());
      }
    if (this.inputState.guessing == 0)
      this.behavior.endChildList();
    match(28);
    if (this.inputState.guessing == 0)
      this.behavior.endTree();
  }

  public final void rootNode()
    throws RecognitionException, TokenStreamException
  {
    Token localToken = null;
    if (((LA(1) == 24) || (LA(1) == 41)) && (LA(2) == 36))
    {
      localToken = id();
      match(36);
      if (this.inputState.guessing == 0)
        checkForMissingEndRule(localToken);
    }
    else if ((!_tokenSet_7.member(LA(1))) || (!_tokenSet_11.member(LA(2))))
    {
      throw new NoViableAltException(LT(1), getFilename());
    }
    terminal(localToken);
  }

  public final int ast_type_spec()
    throws RecognitionException, TokenStreamException
  {
    int i = 1;
    switch (LA(1))
    {
    case 49:
      match(49);
      if (this.inputState.guessing != 0)
        break;
      i = 2;
      break;
    case 33:
      match(33);
      if (this.inputState.guessing != 0)
        break;
      i = 3;
      break;
    case 6:
    case 7:
    case 16:
    case 19:
    case 21:
    case 24:
    case 25:
    case 27:
    case 28:
    case 34:
    case 39:
    case 41:
    case 42:
    case 43:
    case 44:
    case 50:
      break;
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 17:
    case 18:
    case 20:
    case 22:
    case 23:
    case 26:
    case 29:
    case 30:
    case 31:
    case 32:
    case 35:
    case 36:
    case 37:
    case 38:
    case 40:
    case 45:
    case 46:
    case 47:
    case 48:
    default:
      throw new NoViableAltException(LT(1), getFilename());
    }
    return i;
  }

  private static final long[] mk_tokenSet_0()
  {
    long[] arrayOfLong = { 2206556225792L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_1()
  {
    long[] arrayOfLong = { 2472844214400L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_2()
  {
    long[] arrayOfLong = { 1158885407195328L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_3()
  {
    long[] arrayOfLong = { 1159461236965568L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_4()
  {
    long[] arrayOfLong = { 1132497128128576L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_5()
  {
    long[] arrayOfLong = { 1722479914074304L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_6()
  {
    long[] arrayOfLong = { 1722411194597568L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_7()
  {
    long[] arrayOfLong = { 1125899924144192L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_8()
  {
    long[] arrayOfLong = { 1722411190386880L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_9()
  {
    long[] arrayOfLong = { 1159444023476416L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_10()
  {
    long[] arrayOfLong = { 2251345007067328L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_11()
  {
    long[] arrayOfLong = { 1721861130420416L, 0L };
    return arrayOfLong;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.ANTLRParser
 * JD-Core Version:    0.6.0
 */