package antlr;

public class ANTLRHashString
{
  private String s;
  private char[] buf;
  private int len;
  private CharScanner lexer;
  private static final int prime = 151;

  public ANTLRHashString(char[] paramArrayOfChar, int paramInt, CharScanner paramCharScanner)
  {
    this.lexer = paramCharScanner;
    setBuffer(paramArrayOfChar, paramInt);
  }

  public ANTLRHashString(CharScanner paramCharScanner)
  {
    this.lexer = paramCharScanner;
  }

  public ANTLRHashString(String paramString, CharScanner paramCharScanner)
  {
    this.lexer = paramCharScanner;
    setString(paramString);
  }

  private final char charAt(int paramInt)
  {
    return this.s != null ? this.s.charAt(paramInt) : this.buf[paramInt];
  }

  public boolean equals(Object paramObject)
  {
    if ((!(paramObject instanceof ANTLRHashString)) && (!(paramObject instanceof String)))
      return false;
    ANTLRHashString localANTLRHashString;
    if ((paramObject instanceof String))
      localANTLRHashString = new ANTLRHashString((String)paramObject, this.lexer);
    else
      localANTLRHashString = (ANTLRHashString)paramObject;
    int i = length();
    if (localANTLRHashString.length() != i)
      return false;
    if (this.lexer.getCaseSensitiveLiterals())
      for (j = 0; j < i; j++)
        if (charAt(j) != localANTLRHashString.charAt(j))
          return false;
    for (int j = 0; j < i; j++)
      if (this.lexer.toLower(charAt(j)) != this.lexer.toLower(localANTLRHashString.charAt(j)))
        return false;
    return true;
  }

  public int hashCode()
  {
    int i = 0;
    int j = length();
    if (this.lexer.getCaseSensitiveLiterals())
      for (k = 0; k < j; k++)
        i = i * 151 + charAt(k);
    for (int k = 0; k < j; k++)
      i = i * 151 + this.lexer.toLower(charAt(k));
    return i;
  }

  private final int length()
  {
    return this.s != null ? this.s.length() : this.len;
  }

  public void setBuffer(char[] paramArrayOfChar, int paramInt)
  {
    this.buf = paramArrayOfChar;
    this.len = paramInt;
    this.s = null;
  }

  public void setString(String paramString)
  {
    this.s = paramString;
    this.buf = null;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.ANTLRHashString
 * JD-Core Version:    0.6.0
 */