/*      */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
/*      */ import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
/*      */ import EDU.oswego.cs.dl.util.concurrent.BoundedPriorityQueue;
/*      */ import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
/*      */ import EDU.oswego.cs.dl.util.concurrent.Channel;
/*      */ import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
/*      */ import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
/*      */ import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
/*      */ import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
/*      */ import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
/*      */ import EDU.oswego.cs.dl.util.concurrent.Slot;
/*      */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
/*      */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
/*      */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
/*      */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedRef;
/*      */ import EDU.oswego.cs.dl.util.concurrent.SynchronousChannel;
/*      */ import EDU.oswego.cs.dl.util.concurrent.WaitFreeQueue;
/*      */ import EDU.oswego.cs.dl.util.concurrent.WaitableInt;
/*      */ import java.awt.Color;
/*      */ import java.awt.Container;
/*      */ import java.awt.Dimension;
/*      */ import java.awt.Font;
/*      */ import java.awt.GridLayout;
/*      */ import java.awt.event.ActionEvent;
/*      */ import java.awt.event.ActionListener;
/*      */ import java.awt.event.ItemEvent;
/*      */ import java.awt.event.ItemListener;
/*      */ import java.awt.event.WindowAdapter;
/*      */ import java.awt.event.WindowEvent;
/*      */ import java.io.PrintStream;
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ import javax.swing.BoxLayout;
/*      */ import javax.swing.JButton;
/*      */ import javax.swing.JCheckBox;
/*      */ import javax.swing.JComboBox;
/*      */ import javax.swing.JComponent;
/*      */ import javax.swing.JFrame;
/*      */ import javax.swing.JLabel;
/*      */ import javax.swing.JPanel;
/*      */ import javax.swing.SwingUtilities;
/*      */ import javax.swing.border.Border;
/*      */ import javax.swing.border.LineBorder;
/*      */ 
/*      */ public class SynchronizationTimer
/*      */ {
/*  391 */   static final int[] nthreadsChoices = { 
/*  392 */     1, 
/*  393 */     2, 
/*  394 */     4, 
/*  395 */     8, 
/*  396 */     16, 
/*  397 */     32, 
/*  398 */     64, 
/*  399 */     128, 
/*  400 */     256, 
/*  401 */     512, 
/*  402 */     1024 };
/*      */   static final int BLOCK_MODE = 0;
/*      */   static final int TIMEOUT_MODE = 1;
/*  408 */   static final int[] syncModes = { 0, 1 };
/*      */   static final int PRECISION = 10;
/*  485 */   final ThreadInfo[] threadInfo = new ThreadInfo[nthreadsChoices.length];
/*      */   static final int headerRows = 1;
/*      */   static final int classColumn = 0;
/*      */   static final int headerColumns = 1;
/*  496 */   final int tableRows = TestedClass.classes.length + 1;
/*  497 */   final int tableColumns = nthreadsChoices.length + 1;
/*      */ 
/*  499 */   final JComponent[][] resultTable_ = new JComponent[this.tableRows][this.tableColumns];
/*      */ 
/*  621 */   final SynchronizedInt nextClassIdx_ = new SynchronizedInt(0);
/*  622 */   final SynchronizedInt nextThreadIdx_ = new SynchronizedInt(0);
/*      */ 
/* 1106 */   ClockDaemon timeDaemon = new ClockDaemon();
/*      */ 
/* 1125 */   private final SynchronizedRef contention_ = new SynchronizedRef(null);
/* 1126 */   private final SynchronizedInt loopsPerTest_ = new SynchronizedInt(0);
/*      */ 
/* 1129 */   private final SynchronizedBoolean echoToSystemOut = new SynchronizedBoolean(false);
/*      */ 
/* 1132 */   private final JButton startstop_ = new JButton("Start");
/*      */ 
/* 1134 */   private WaitableInt testNumber_ = new WaitableInt(1);
/*      */ 
/* 1146 */   private SynchronizedBoolean running_ = new SynchronizedBoolean(false);
/*      */ 
/*      */   public static void main(String[] args)
/*      */   {
/*  279 */     JFrame frame = new JFrame("Times per call in microseconds");
/*      */ 
/*  281 */     frame.addWindowListener(new WindowAdapter() {
/*  282 */       public void windowClosing(WindowEvent e) { System.exit(0);
/*      */       }
/*      */     });
/*  285 */     frame.getContentPane().add(new SynchronizationTimer().mainPanel());
/*  286 */     frame.pack();
/*  287 */     frame.setVisible(true);
/*      */   }
/*      */ 
/*      */   static String modeToString(int m)
/*      */   {
/*  414 */     String sms;
/*      */     String sms;
/*  414 */     if (m == 0) { sms = "block";
/*      */     }
/*      */     else
/*      */     {
/*  415 */       String sms;
/*  415 */       if (m == 1) sms = "timeout"; else
/*  416 */         sms = "No such mode"; 
/*      */     }
/*  417 */     return sms;
/*      */   }
/*      */ 
/*      */   static String biasToString(int b)
/*      */   {
/*  422 */     String sms;
/*      */     String sms;
/*  422 */     if (b < 0) { sms = "slower producer";
/*      */     }
/*      */     else
/*      */     {
/*  423 */       String sms;
/*  423 */       if (b == 0) { sms = "balanced prod/cons rate";
/*      */       }
/*      */       else
/*      */       {
/*  424 */         String sms;
/*  424 */         if (b > 0) sms = "slower consumer"; else
/*  425 */           sms = "No such bias"; 
/*      */       }
/*      */     }
/*  426 */     return sms;
/*      */   }
/*      */ 
/*      */   static String p2ToString(int n)
/*      */   {
/*  431 */     String suf = "";
/*  432 */     if (n >= 1024) {
/*  433 */       n /= 1024;
/*  434 */       suf = "K";
/*  435 */       if (n >= 1024) {
/*  436 */         n /= 1024;
/*  437 */         suf = "M";
/*      */       }
/*      */     }
/*  440 */     return n + suf;
/*      */   }
/*      */ 
/*      */   static String formatTime(long ns, boolean showDecimal)
/*      */   {
/*  446 */     long intpart = ns / 10L;
/*  447 */     long decpart = ns % 10L;
/*  448 */     if (!showDecimal) {
/*  449 */       if (decpart >= 5L)
/*  450 */         intpart += 1L;
/*  451 */       return Long.toString(intpart);
/*      */     }
/*      */ 
/*  454 */     String sint = Long.toString(intpart);
/*  455 */     String sdec = Long.toString(decpart);
/*  456 */     if (decpart == 0L) {
/*  457 */       int z = 10;
/*  458 */       while (z > 10) {
/*  459 */         sdec = "0" + sdec;
/*  460 */         z /= 10;
/*      */       }
/*      */     }
/*  463 */     String ts = sint + "." + sdec;
/*  464 */     return ts;
/*      */   }
/*      */ 
/*      */   boolean threadEnabled(int nthreads)
/*      */   {
/*  488 */     return this.threadInfo[nthreads].getEnabled().booleanValue();
/*      */   }
/*      */ 
/*      */   JPanel resultPanel()
/*      */   {
/*  503 */     JPanel[] colPanel = new JPanel[this.tableColumns];
/*  504 */     for (int col = 0; col < this.tableColumns; col++) {
/*  505 */       colPanel[col] = new JPanel();
/*  506 */       colPanel[col].setLayout(new GridLayout(this.tableRows, 1));
/*  507 */       if (col != 0) {
/*  508 */         colPanel[col].setBackground(Color.white);
/*      */       }
/*      */     }
/*  511 */     Color hdrbg = colPanel[0].getBackground();
/*  512 */     Border border = new LineBorder(hdrbg);
/*      */ 
/*  514 */     Font font = new Font("Dialog", 0, 12);
/*  515 */     Dimension labDim = new Dimension(40, 16);
/*  516 */     Dimension cbDim = new Dimension(154, 16);
/*      */ 
/*  518 */     JLabel cornerLab = new JLabel(" Classes      \\      Threads");
/*  519 */     cornerLab.setMinimumSize(cbDim);
/*  520 */     cornerLab.setPreferredSize(cbDim);
/*  521 */     cornerLab.setFont(font);
/*  522 */     this.resultTable_[0][0] = cornerLab;
/*  523 */     colPanel[0].add(cornerLab);
/*      */ 
/*  525 */     for (int col = 1; col < this.tableColumns; col++) {
/*  526 */       int nthreads = col - 1;
/*  527 */       JCheckBox tcb = new JCheckBox(this.threadInfo[nthreads].name, true);
/*  528 */       tcb.addActionListener(new ActionListener(nthreads) {
/*      */         public void actionPerformed(ActionEvent evt) {
/*  530 */           SynchronizationTimer.this.threadInfo[this.val$nthreads].toggleEnabled();
/*      */         }
/*      */       });
/*  534 */       tcb.setMinimumSize(labDim);
/*  535 */       tcb.setPreferredSize(labDim);
/*  536 */       tcb.setFont(font);
/*  537 */       tcb.setBackground(hdrbg);
/*  538 */       this.resultTable_[0][col] = tcb;
/*  539 */       colPanel[col].add(tcb);
/*      */     }
/*      */ 
/*  543 */     for (int row = 1; row < this.tableRows; row++) {
/*  544 */       int cls = row - 1;
/*      */ 
/*  546 */       JCheckBox cb = new JCheckBox(TestedClass.classes[cls].name, true);
/*  547 */       cb.addActionListener(new ActionListener(cls) {
/*      */         public void actionPerformed(ActionEvent evt) {
/*  549 */           SynchronizationTimer.TestedClass.classes[this.val$cls].toggleEnabled();
/*      */         }
/*      */       });
/*  552 */       this.resultTable_[row][0] = cb;
/*  553 */       cb.setMinimumSize(cbDim);
/*  554 */       cb.setPreferredSize(cbDim);
/*  555 */       cb.setFont(font);
/*  556 */       colPanel[0].add(cb);
/*      */ 
/*  558 */       for (int col = 1; col < this.tableColumns; col++) {
/*  559 */         int nthreads = col - 1;
/*  560 */         JLabel lab = new JLabel("");
/*  561 */         this.resultTable_[row][col] = lab;
/*      */ 
/*  563 */         lab.setMinimumSize(labDim);
/*  564 */         lab.setPreferredSize(labDim);
/*  565 */         lab.setBorder(border);
/*  566 */         lab.setFont(font);
/*  567 */         lab.setBackground(Color.white);
/*  568 */         lab.setForeground(Color.black);
/*  569 */         lab.setHorizontalAlignment(4);
/*      */ 
/*  571 */         colPanel[col].add(lab);
/*      */       }
/*      */     }
/*      */ 
/*  575 */     JPanel tblPanel = new JPanel();
/*  576 */     tblPanel.setLayout(new BoxLayout(tblPanel, 0));
/*  577 */     for (int col = 0; col < this.tableColumns; col++) {
/*  578 */       tblPanel.add(colPanel[col]);
/*      */     }
/*      */ 
/*  581 */     return tblPanel;
/*      */   }
/*      */ 
/*      */   void setTime(long ns, int clsIdx, int nthrIdx)
/*      */   {
/*  586 */     int row = clsIdx + 1;
/*  587 */     int col = nthrIdx + 1;
/*  588 */     JLabel cell = (JLabel)this.resultTable_[row][col];
/*      */ 
/*  590 */     SwingUtilities.invokeLater(new Runnable(cell, ns) {
/*      */       public void run() {
/*  592 */         this.val$cell.setText(SynchronizationTimer.formatTime(this.val$ns, true));
/*      */       }
/*      */     });
/*      */   }
/*      */ 
/*      */   void clearTable()
/*      */   {
/*  600 */     for (int i = 1; i < this.tableRows; i++)
/*  601 */       for (int j = 1; j < this.tableColumns; j++)
/*  602 */         ((JLabel)this.resultTable_[i][j]).setText("");
/*      */   }
/*      */ 
/*      */   void setChecks(boolean setting)
/*      */   {
/*  608 */     for (int i = 0; i < TestedClass.classes.length; i++) {
/*  609 */       TestedClass.classes[i].setEnabled(new Boolean(setting));
/*  610 */       ((JCheckBox)this.resultTable_[(i + 1)][0]).setSelected(setting);
/*      */     }
/*      */   }
/*      */ 
/*      */   public SynchronizationTimer()
/*      */   {
/*  616 */     for (int i = 0; i < this.threadInfo.length; i++)
/*  617 */       this.threadInfo[i] = new ThreadInfo(nthreadsChoices[i]);
/*      */   }
/*      */ 
/*      */   JPanel mainPanel()
/*      */   {
/*  626 */     new PrintStart();
/*  627 */     JPanel paramPanel = new JPanel();
/*  628 */     paramPanel.setLayout(new GridLayout(5, 3));
/*      */ 
/*  630 */     JPanel buttonPanel = new JPanel();
/*  631 */     buttonPanel.setLayout(new GridLayout(1, 3));
/*      */ 
/*  633 */     this.startstop_.addActionListener(new ActionListener() {
/*      */       public void actionPerformed(ActionEvent evt) {
/*  635 */         if (SynchronizationTimer.this.running_.get())
/*  636 */           SynchronizationTimer.this.cancel();
/*      */         else
/*      */           try {
/*  639 */             SynchronizationTimer.this.startTestSeries(new SynchronizationTimer.TestSeries(SynchronizationTimer.this));
/*      */           }
/*      */           catch (InterruptedException ex) {
/*  642 */             SynchronizationTimer.this.endTestSeries();
/*      */           }
/*      */       }
/*      */     });
/*  647 */     paramPanel.add(this.startstop_);
/*      */ 
/*  649 */     JPanel p1 = new JPanel();
/*  650 */     p1.setLayout(new GridLayout(1, 2));
/*      */ 
/*  652 */     JButton continueButton = new JButton("Continue");
/*      */ 
/*  654 */     continueButton.addActionListener(new ActionListener() {
/*      */       public void actionPerformed(ActionEvent evt) {
/*  656 */         if (!SynchronizationTimer.this.running_.get())
/*      */           try {
/*  658 */             SynchronizationTimer.this
/*  659 */               .startTestSeries(new SynchronizationTimer.TestSeries(SynchronizationTimer.this, SynchronizationTimer.this.nextClassIdx_.get(), 
/*  659 */               SynchronizationTimer.this.nextThreadIdx_.get()));
/*      */           }
/*      */           catch (InterruptedException ex) {
/*  662 */             SynchronizationTimer.this.endTestSeries();
/*      */           }
/*      */       }
/*      */     });
/*  667 */     p1.add(continueButton);
/*      */ 
/*  669 */     JButton clearButton = new JButton("Clear cells");
/*      */ 
/*  671 */     clearButton.addActionListener(new ActionListener() {
/*      */       public void actionPerformed(ActionEvent evt) {
/*  673 */         SynchronizationTimer.this.clearTable();
/*      */       }
/*      */     });
/*  677 */     p1.add(clearButton);
/*      */ 
/*  679 */     paramPanel.add(p1);
/*      */ 
/*  681 */     JPanel p3 = new JPanel();
/*  682 */     p3.setLayout(new GridLayout(1, 2));
/*      */ 
/*  684 */     JButton setButton = new JButton("All classes");
/*      */ 
/*  686 */     setButton.addActionListener(new ActionListener() {
/*      */       public void actionPerformed(ActionEvent evt) {
/*  688 */         SynchronizationTimer.this.setChecks(true);
/*      */       }
/*      */     });
/*  692 */     p3.add(setButton);
/*      */ 
/*  695 */     JButton unsetButton = new JButton("No classes");
/*      */ 
/*  697 */     unsetButton.addActionListener(new ActionListener() {
/*      */       public void actionPerformed(ActionEvent evt) {
/*  699 */         SynchronizationTimer.this.setChecks(false);
/*      */       }
/*      */     });
/*  703 */     p3.add(unsetButton);
/*  704 */     paramPanel.add(p3);
/*      */ 
/*  706 */     JPanel p2 = new JPanel();
/*      */ 
/*  708 */     p2.setLayout(new BoxLayout(p2, 0));
/*      */ 
/*  711 */     JCheckBox consoleBox = new JCheckBox("Console echo");
/*  712 */     consoleBox.addItemListener(new ItemListener() {
/*      */       public void itemStateChanged(ItemEvent evt) {
/*  714 */         SynchronizationTimer.this.echoToSystemOut.complement();
/*      */       }
/*      */     });
/*  720 */     JLabel poolinfo = new JLabel("Active threads:      0");
/*      */ 
/*  722 */     p2.add(poolinfo);
/*  723 */     p2.add(consoleBox);
/*      */ 
/*  725 */     paramPanel.add(p2);
/*      */ 
/*  727 */     paramPanel.add(contentionBox());
/*  728 */     paramPanel.add(itersBox());
/*  729 */     paramPanel.add(cloopBox());
/*  730 */     paramPanel.add(barrierBox());
/*  731 */     paramPanel.add(exchangeBox());
/*  732 */     paramPanel.add(biasBox());
/*  733 */     paramPanel.add(capacityBox());
/*  734 */     paramPanel.add(timeoutBox());
/*  735 */     paramPanel.add(syncModePanel());
/*  736 */     paramPanel.add(producerSyncModePanel());
/*  737 */     paramPanel.add(consumerSyncModePanel());
/*      */ 
/*  739 */     startPoolStatus(poolinfo);
/*      */ 
/*  741 */     JPanel mainPanel = new JPanel();
/*  742 */     mainPanel.setLayout(new BoxLayout(mainPanel, 1));
/*      */ 
/*  744 */     JPanel tblPanel = resultPanel();
/*      */ 
/*  746 */     mainPanel.add(tblPanel);
/*  747 */     mainPanel.add(paramPanel);
/*  748 */     return mainPanel;
/*      */   }
/*      */ 
/*      */   JComboBox syncModePanel()
/*      */   {
/*  755 */     JComboBox syncModeComboBox = new JComboBox();
/*      */ 
/*  757 */     for (int j = 0; j < syncModes.length; j++) {
/*  758 */       String lab = "Locks: " + modeToString(syncModes[j]);
/*  759 */       syncModeComboBox.addItem(lab);
/*      */     }
/*  761 */     syncModeComboBox.addItemListener(new ItemListener() {
/*      */       public void itemStateChanged(ItemEvent evt) {
/*  763 */         JComboBox src = (JComboBox)evt.getItemSelectable();
/*  764 */         int idx = src.getSelectedIndex();
/*  765 */         RNG.syncMode.set(SynchronizationTimer.syncModes[idx]);
/*      */       }
/*      */     });
/*  769 */     RNG.syncMode.set(syncModes[0]);
/*  770 */     syncModeComboBox.setSelectedIndex(0);
/*  771 */     return syncModeComboBox;
/*      */   }
/*      */ 
/*      */   JComboBox producerSyncModePanel() {
/*  775 */     JComboBox producerSyncModeComboBox = new JComboBox();
/*      */ 
/*  777 */     for (int j = 0; j < syncModes.length; j++) {
/*  778 */       String lab = "Producers: " + modeToString(syncModes[j]);
/*  779 */       producerSyncModeComboBox.addItem(lab);
/*      */     }
/*  781 */     producerSyncModeComboBox.addItemListener(new ItemListener() {
/*      */       public void itemStateChanged(ItemEvent evt) {
/*  783 */         JComboBox src = (JComboBox)evt.getItemSelectable();
/*  784 */         int idx = src.getSelectedIndex();
/*  785 */         RNG.producerMode.set(SynchronizationTimer.syncModes[idx]);
/*      */       }
/*      */     });
/*  789 */     RNG.producerMode.set(syncModes[0]);
/*  790 */     producerSyncModeComboBox.setSelectedIndex(0);
/*  791 */     return producerSyncModeComboBox;
/*      */   }
/*      */ 
/*      */   JComboBox consumerSyncModePanel() {
/*  795 */     JComboBox consumerSyncModeComboBox = new JComboBox();
/*      */ 
/*  797 */     for (int j = 0; j < syncModes.length; j++) {
/*  798 */       String lab = "Consumers: " + modeToString(syncModes[j]);
/*  799 */       consumerSyncModeComboBox.addItem(lab);
/*      */     }
/*  801 */     consumerSyncModeComboBox.addItemListener(new ItemListener() {
/*      */       public void itemStateChanged(ItemEvent evt) {
/*  803 */         JComboBox src = (JComboBox)evt.getItemSelectable();
/*  804 */         int idx = src.getSelectedIndex();
/*  805 */         RNG.consumerMode.set(SynchronizationTimer.syncModes[idx]);
/*      */       }
/*      */     });
/*  809 */     RNG.consumerMode.set(syncModes[0]);
/*  810 */     consumerSyncModeComboBox.setSelectedIndex(0);
/*  811 */     return consumerSyncModeComboBox;
/*      */   }
/*      */ 
/*      */   JComboBox contentionBox()
/*      */   {
/*  817 */     Fraction[] contentionChoices = { 
/*  818 */       new Fraction(0L, 1L), 
/*  819 */       new Fraction(1L, 16L), 
/*  820 */       new Fraction(1L, 8L), 
/*  821 */       new Fraction(1L, 4L), 
/*  822 */       new Fraction(1L, 2L), 
/*  823 */       new Fraction(1L, 1L) };
/*      */ 
/*  826 */     JComboBox contentionComboBox = new JComboBox();
/*      */ 
/*  828 */     for (int j = 0; j < contentionChoices.length; j++) {
/*  829 */       String lab = contentionChoices[j].asDouble() * 100.0D + 
/*  830 */         "% contention/sharing";
/*  831 */       contentionComboBox.addItem(lab);
/*      */     }
/*  833 */     contentionComboBox.addItemListener(new ItemListener(contentionChoices) {
/*      */       public void itemStateChanged(ItemEvent evt) {
/*  835 */         JComboBox src = (JComboBox)evt.getItemSelectable();
/*  836 */         int idx = src.getSelectedIndex();
/*  837 */         SynchronizationTimer.this.contention_.set(this.val$contentionChoices[idx]);
/*      */       }
/*      */     });
/*  841 */     this.contention_.set(contentionChoices[3]);
/*  842 */     contentionComboBox.setSelectedIndex(3);
/*  843 */     return contentionComboBox;
/*      */   }
/*      */ 
/*      */   JComboBox itersBox() {
/*  847 */     int[] loopsPerTestChoices = { 
/*  848 */       1, 
/*  849 */       16, 
/*  850 */       256, 
/*  851 */       1024, 
/*  852 */       2048, 
/*  853 */       4096, 
/*  854 */       8192, 
/*  855 */       16384, 
/*  856 */       32768, 
/*  857 */       65536, 
/*  858 */       131072, 
/*  859 */       262144, 
/*  860 */       524288, 
/*  861 */       1048576 };
/*      */ 
/*  864 */     JComboBox precComboBox = new JComboBox();
/*      */ 
/*  866 */     for (int j = 0; j < loopsPerTestChoices.length; j++) {
/*  867 */       String lab = p2ToString(loopsPerTestChoices[j]) + 
/*  868 */         " calls per thread per test";
/*  869 */       precComboBox.addItem(lab);
/*      */     }
/*  871 */     precComboBox.addItemListener(new ItemListener(loopsPerTestChoices) {
/*      */       public void itemStateChanged(ItemEvent evt) {
/*  873 */         JComboBox src = (JComboBox)evt.getItemSelectable();
/*  874 */         int idx = src.getSelectedIndex();
/*  875 */         SynchronizationTimer.this.loopsPerTest_.set(this.val$loopsPerTestChoices[idx]);
/*      */       }
/*      */     });
/*  879 */     this.loopsPerTest_.set(loopsPerTestChoices[8]);
/*  880 */     precComboBox.setSelectedIndex(8);
/*      */ 
/*  882 */     return precComboBox;
/*      */   }
/*      */ 
/*      */   JComboBox cloopBox() {
/*  886 */     int[] computationsPerCallChoices = { 
/*  887 */       1, 
/*  888 */       2, 
/*  889 */       4, 
/*  890 */       8, 
/*  891 */       16, 
/*  892 */       32, 
/*  893 */       64, 
/*  894 */       128, 
/*  895 */       256, 
/*  896 */       512, 
/*  897 */       1024, 
/*  898 */       2048, 
/*  899 */       4096, 
/*  900 */       8192, 
/*  901 */       16384, 
/*  902 */       32768, 
/*  903 */       65536 };
/*      */ 
/*  906 */     JComboBox cloopComboBox = new JComboBox();
/*      */ 
/*  908 */     for (int j = 0; j < computationsPerCallChoices.length; j++) {
/*  909 */       String lab = p2ToString(computationsPerCallChoices[j]) + 
/*  910 */         " computations per call";
/*  911 */       cloopComboBox.addItem(lab);
/*      */     }
/*  913 */     cloopComboBox.addItemListener(new ItemListener(computationsPerCallChoices) {
/*      */       public void itemStateChanged(ItemEvent evt) {
/*  915 */         JComboBox src = (JComboBox)evt.getItemSelectable();
/*  916 */         int idx = src.getSelectedIndex();
/*  917 */         RNG.computeLoops.set(this.val$computationsPerCallChoices[idx]);
/*      */       }
/*      */     });
/*  921 */     RNG.computeLoops.set(computationsPerCallChoices[3]);
/*  922 */     cloopComboBox.setSelectedIndex(3);
/*  923 */     return cloopComboBox;
/*      */   }
/*      */ 
/*      */   JComboBox barrierBox() {
/*  927 */     int[] itersPerBarrierChoices = { 
/*  928 */       1, 
/*  929 */       2, 
/*  930 */       4, 
/*  931 */       8, 
/*  932 */       16, 
/*  933 */       32, 
/*  934 */       64, 
/*  935 */       128, 
/*  936 */       256, 
/*  937 */       512, 
/*  938 */       1024, 
/*  939 */       2048, 
/*  940 */       4096, 
/*  941 */       8192, 
/*  942 */       16384, 
/*  943 */       32768, 
/*  944 */       65536, 
/*  945 */       131072, 
/*  946 */       262144, 
/*  947 */       524288, 
/*  948 */       1048576 };
/*      */ 
/*  951 */     JComboBox barrierComboBox = new JComboBox();
/*      */ 
/*  953 */     for (int j = 0; j < itersPerBarrierChoices.length; j++) {
/*  954 */       String lab = p2ToString(itersPerBarrierChoices[j]) + 
/*  955 */         " iterations per barrier";
/*  956 */       barrierComboBox.addItem(lab);
/*      */     }
/*  958 */     barrierComboBox.addItemListener(new ItemListener(itersPerBarrierChoices) {
/*      */       public void itemStateChanged(ItemEvent evt) {
/*  960 */         JComboBox src = (JComboBox)evt.getItemSelectable();
/*  961 */         int idx = src.getSelectedIndex();
/*  962 */         RNG.itersPerBarrier.set(this.val$itersPerBarrierChoices[idx]);
/*      */       }
/*      */     });
/*  966 */     RNG.itersPerBarrier.set(itersPerBarrierChoices[13]);
/*  967 */     barrierComboBox.setSelectedIndex(13);
/*      */ 
/*  972 */     return barrierComboBox;
/*      */   }
/*      */ 
/*      */   JComboBox exchangeBox() {
/*  976 */     int[] exchangerChoices = { 
/*  977 */       1, 
/*  978 */       2, 
/*  979 */       4, 
/*  980 */       8, 
/*  981 */       16, 
/*  982 */       32, 
/*  983 */       64, 
/*  984 */       128, 
/*  985 */       256, 
/*  986 */       512, 
/*  987 */       1024 };
/*      */ 
/*  990 */     JComboBox exchComboBox = new JComboBox();
/*      */ 
/*  992 */     for (int j = 0; j < exchangerChoices.length; j++) {
/*  993 */       String lab = p2ToString(exchangerChoices[j]) + 
/*  994 */         " max threads per barrier";
/*  995 */       exchComboBox.addItem(lab);
/*      */     }
/*  997 */     exchComboBox.addItemListener(new ItemListener(exchangerChoices) {
/*      */       public void itemStateChanged(ItemEvent evt) {
/*  999 */         JComboBox src = (JComboBox)evt.getItemSelectable();
/* 1000 */         int idx = src.getSelectedIndex();
/* 1001 */         RNG.exchangeParties.set(this.val$exchangerChoices[idx]);
/*      */       }
/*      */     });
/* 1005 */     RNG.exchangeParties.set(exchangerChoices[1]);
/* 1006 */     exchComboBox.setSelectedIndex(1);
/* 1007 */     return exchComboBox;
/*      */   }
/*      */ 
/*      */   JComboBox biasBox() {
/* 1011 */     int[] biasChoices = { 
/* 1012 */       -1, 
/* 1014 */       0, 1 };
/*      */ 
/* 1018 */     JComboBox biasComboBox = new JComboBox();
/*      */ 
/* 1020 */     for (int j = 0; j < biasChoices.length; j++) {
/* 1021 */       String lab = biasToString(biasChoices[j]);
/* 1022 */       biasComboBox.addItem(lab);
/*      */     }
/* 1024 */     biasComboBox.addItemListener(new ItemListener(biasChoices) {
/*      */       public void itemStateChanged(ItemEvent evt) {
/* 1026 */         JComboBox src = (JComboBox)evt.getItemSelectable();
/* 1027 */         int idx = src.getSelectedIndex();
/* 1028 */         RNG.bias.set(this.val$biasChoices[idx]);
/*      */       }
/*      */     });
/* 1032 */     RNG.bias.set(biasChoices[1]);
/* 1033 */     biasComboBox.setSelectedIndex(1);
/* 1034 */     return biasComboBox;
/*      */   }
/*      */ 
/*      */   JComboBox capacityBox()
/*      */   {
/* 1039 */     int[] bufferCapacityChoices = { 
/* 1040 */       1, 
/* 1041 */       4, 
/* 1042 */       64, 
/* 1043 */       256, 
/* 1044 */       1024, 
/* 1045 */       4096, 
/* 1046 */       16384, 
/* 1047 */       65536, 
/* 1048 */       262144, 
/* 1049 */       1048576 };
/*      */ 
/* 1052 */     JComboBox bcapComboBox = new JComboBox();
/*      */ 
/* 1054 */     for (int j = 0; j < bufferCapacityChoices.length; j++) {
/* 1055 */       String lab = p2ToString(bufferCapacityChoices[j]) + 
/* 1056 */         " element bounded buffers";
/* 1057 */       bcapComboBox.addItem(lab);
/*      */     }
/* 1059 */     bcapComboBox.addItemListener(new ItemListener(bufferCapacityChoices) {
/*      */       public void itemStateChanged(ItemEvent evt) {
/* 1061 */         JComboBox src = (JComboBox)evt.getItemSelectable();
/* 1062 */         int idx = src.getSelectedIndex();
/* 1063 */         DefaultChannelCapacity.set(this.val$bufferCapacityChoices[idx]);
/*      */       }
/*      */     });
/* 1068 */     DefaultChannelCapacity.set(bufferCapacityChoices[3]);
/* 1069 */     bcapComboBox.setSelectedIndex(3);
/* 1070 */     return bcapComboBox;
/*      */   }
/*      */ 
/*      */   JComboBox timeoutBox()
/*      */   {
/* 1076 */     long[] timeoutChoices = { 
/* 1078 */       0, 1L, 
/* 1079 */       10L, 
/* 1080 */       100L, 
/* 1081 */       1000L, 
/* 1082 */       10000L, 
/* 1083 */       100000L };
/*      */ 
/* 1087 */     JComboBox timeoutComboBox = new JComboBox();
/*      */ 
/* 1089 */     for (int j = 0; j < timeoutChoices.length; j++) {
/* 1090 */       String lab = timeoutChoices[j] + " msec timeouts";
/* 1091 */       timeoutComboBox.addItem(lab);
/*      */     }
/* 1093 */     timeoutComboBox.addItemListener(new ItemListener(timeoutChoices) {
/*      */       public void itemStateChanged(ItemEvent evt) {
/* 1095 */         JComboBox src = (JComboBox)evt.getItemSelectable();
/* 1096 */         int idx = src.getSelectedIndex();
/* 1097 */         RNG.timeout.set(this.val$timeoutChoices[idx]);
/*      */       }
/*      */     });
/* 1101 */     RNG.timeout.set(timeoutChoices[3]);
/* 1102 */     timeoutComboBox.setSelectedIndex(3);
/* 1103 */     return timeoutComboBox;
/*      */   }
/*      */ 
/*      */   void startPoolStatus(JLabel status)
/*      */   {
/* 1109 */     Runnable updater = new Runnable(status) {
/* 1110 */       int lastps = 0;
/*      */ 
/* 1112 */       public void run() { int ps = Threads.activeThreads.get();
/* 1113 */         if (this.lastps != ps) {
/* 1114 */           this.lastps = ps;
/* 1115 */           SwingUtilities.invokeLater(new Runnable(this.val$status, ps) {
/*      */             public void run() {
/* 1117 */               this.val$status.setText("Active threads: " + this.val$ps);
/*      */             }
/*      */           });
/*      */         }
/*      */       }
/*      */     };
/* 1122 */     this.timeDaemon.executePeriodically(250L, updater, false);
/*      */   }
/*      */ 
/*      */   private void runOneTest(Runnable tst)
/*      */     throws InterruptedException
/*      */   {
/* 1137 */     int nt = this.testNumber_.get();
/* 1138 */     Threads.pool.execute(tst);
/* 1139 */     this.testNumber_.whenNotEqual(nt, null);
/*      */   }
/*      */ 
/*      */   private void endOneTest() {
/* 1143 */     this.testNumber_.increment();
/*      */   }
/*      */ 
/*      */   void cancel()
/*      */   {
/* 1150 */     synchronized (RNG.constructionLock) {
/*      */       try {
/* 1152 */         Threads.pool.interruptAll();
/*      */       }
/*      */       catch (Exception ex) {
/* 1155 */         System.out.println("\nException during cancel:\n" + ex);
/* 1156 */         return;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   void startTestSeries(Runnable tst) throws InterruptedException
/*      */   {
/* 1163 */     this.running_.set(true);
/* 1164 */     this.startstop_.setText("Stop");
/* 1165 */     Threads.pool.execute(tst);
/*      */   }
/*      */ 
/*      */   void endTestSeries()
/*      */   {
/* 1177 */     this.running_.set(false);
/* 1178 */     SwingUtilities.invokeLater(new PrintStart());
/*      */   }
/*      */ 
/*      */   static class BarrierTimer
/*      */     implements Runnable
/*      */   {
/* 1259 */     private long startTime_ = 0L;
/* 1260 */     private long endTime_ = 0L;
/*      */ 
/*      */     public synchronized long getTime() {
/* 1263 */       return this.endTime_ - this.startTime_;
/*      */     }
/*      */ 
/*      */     public synchronized void run() {
/* 1267 */       long now = System.currentTimeMillis();
/* 1268 */       if (this.startTime_ == 0L)
/* 1269 */         this.startTime_ = now;
/*      */       else
/* 1271 */         this.endTime_ = now; 
/*      */     }
/*      */   }
/*      */ 
/*      */   class OneTest implements Runnable {
/*      */     final int clsIdx;
/*      */     final int nthreadsIdx;
/*      */ 
/*      */     OneTest(int idx, int t) {
/* 1280 */       this.clsIdx = idx;
/* 1281 */       this.nthreadsIdx = t; } 
/* 1285 */     public void run() { Thread.currentThread().setPriority(2);
/*      */ 
/* 1287 */       boolean wasInterrupted = false;
/*      */ 
/* 1289 */       SynchronizationTimer.TestedClass entry = SynchronizationTimer.TestedClass.classes[this.clsIdx];
/*      */ 
/* 1291 */       JLabel cell = (JLabel)SynchronizationTimer.this.resultTable_[(this.clsIdx + 1)][(this.nthreadsIdx + 1)];
/* 1292 */       Color oldfg = cell.getForeground();
/*      */       boolean clear;
/*      */       try { if (Thread.interrupted());
/*      */         int nthreads;
/*      */         int iters;
/*      */         Fraction pshr;
/*      */         do
/*      */         {
/*      */           do
/*      */           {
/*      */             boolean clear;
/* 1297 */             return;
/* 1298 */           }while (!SynchronizationTimer.this.threadEnabled(this.nthreadsIdx));
/*      */ 
/* 1300 */           nthreads = SynchronizationTimer.nthreadsChoices[this.nthreadsIdx];
/* 1301 */           iters = SynchronizationTimer.this.loopsPerTest_.get();
/* 1302 */           pshr = (Fraction)SynchronizationTimer.this.contention_.get();
/*      */         }
/* 1304 */         while (!entry.isEnabled(nthreads, pshr));
/*      */ 
/* 1306 */         SynchronizationTimer.BarrierTimer timer = new SynchronizationTimer.BarrierTimer();
/* 1307 */         CyclicBarrier barrier = new CyclicBarrier(nthreads + 1, timer);
/*      */ 
/* 1309 */         Class cls = entry.cls;
/* 1310 */         Class chanCls = entry.buffCls;
/*      */         try
/*      */         {
/* 1313 */           SwingUtilities.invokeAndWait(new Runnable(cell) {
/*      */             public void run() {
/* 1315 */               this.val$cell.setForeground(Color.blue);
/* 1316 */               this.val$cell.setText("RUN");
/* 1317 */               this.val$cell.repaint();
/*      */             } } );
/*      */         }
/*      */         catch (InvocationTargetException ex) {
/* 1322 */           ex.printStackTrace();
/* 1323 */           System.exit(-1);
/*      */         }
/* 1325 */         synchronized (RNG.constructionLock) {
/* 1326 */           RNG.reset(nthreads);
/*      */ 
/* 1328 */           if (chanCls == null) {
/* 1329 */             RNG shared = (RNG)cls.newInstance();
/* 1330 */             for (int k = 0; k < nthreads; k++) {
/* 1331 */               RNG pri = (RNG)cls.newInstance();
/* 1332 */               TestLoop l = new TestLoop(shared, pri, pshr, iters, barrier);
/* 1333 */               Threads.pool.execute(l.testLoop());
/*      */             }
/*      */           }
/*      */           else {
/* 1337 */             Channel shared = (Channel)chanCls.newInstance();
/* 1338 */             if (nthreads == 1) {
/* 1339 */               ChanRNG single = (ChanRNG)cls.newInstance();
/* 1340 */               single.setSingle(true);
/* 1341 */               PCTestLoop l = new PCTestLoop(single.getDelegate(), single, pshr, 
/* 1342 */                 iters, barrier, 
/* 1343 */                 shared, shared);
/* 1344 */               Threads.pool.execute(l.testLoop(true));
/*      */             } else {
/* 1346 */               if (nthreads % 2 != 0) {
/* 1347 */                 throw new Error("Must have even number of threads!");
/*      */               }
/* 1349 */               int npairs = nthreads / 2;
/*      */ 
/* 1351 */               for (int k = 0; k < npairs; k++) {
/* 1352 */                 ChanRNG t = (ChanRNG)cls.newInstance();
/* 1353 */                 t.setSingle(false);
/* 1354 */                 Channel chan = (Channel)chanCls.newInstance();
/*      */ 
/* 1356 */                 PCTestLoop l = new PCTestLoop(t.getDelegate(), t, pshr, 
/* 1357 */                   iters, barrier, 
/* 1358 */                   shared, chan);
/*      */ 
/* 1360 */                 Threads.pool.execute(l.testLoop(false));
/* 1361 */                 Threads.pool.execute(l.testLoop(true));
/*      */               }
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 1367 */           if (SynchronizationTimer.this.echoToSystemOut.get()) {
/* 1368 */             System.out.print(
/* 1369 */               entry.name + " " + 
/* 1370 */               nthreads + "T " + 
/* 1371 */               pshr + "S " + 
/* 1372 */               RNG.computeLoops.get() + "I " + 
/* 1373 */               RNG.syncMode.get() + "Lm " + 
/* 1374 */               RNG.timeout.get() + "TO " + 
/* 1375 */               RNG.producerMode.get() + "Pm " + 
/* 1376 */               RNG.consumerMode.get() + "Cm " + 
/* 1377 */               RNG.bias.get() + "B " + 
/* 1378 */               DefaultChannelCapacity.get() + "C " + 
/* 1379 */               RNG.exchangeParties.get() + "Xp " + 
/* 1380 */               RNG.itersPerBarrier.get() + "Ib : ");
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1389 */         barrier.barrier();
/*      */ 
/* 1391 */         barrier.barrier();
/*      */ 
/* 1393 */         long tm = timer.getTime();
/* 1394 */         long totalIters = nthreads * iters;
/* 1395 */         double dns = tm * 1000.0D * 10.0D / totalIters;
/* 1396 */         long ns = Math.round(dns);
/*      */ 
/* 1398 */         SynchronizationTimer.this.setTime(ns, this.clsIdx, this.nthreadsIdx);
/*      */ 
/* 1400 */         if (SynchronizationTimer.this.echoToSystemOut.get()) {
/* 1401 */           System.out.println(SynchronizationTimer.formatTime(ns, true));
/*      */         }
/*      */       }
/*      */       catch (BrokenBarrierException ex)
/*      */       {
/* 1406 */         wasInterrupted = true;
/*      */       }
/*      */       catch (InterruptedException ex)
/*      */       {
/*      */         boolean clear;
/* 1409 */         wasInterrupted = true;
/* 1410 */         Thread.currentThread().interrupt();
/*      */       }
/*      */       catch (Exception ex)
/*      */       {
/*      */         boolean clear;
/* 1413 */         ex.printStackTrace();
/* 1414 */         System.out.println("Construction Exception?");
/* 1415 */         System.exit(-1);
/*      */       }
/*      */       finally
/*      */       {
/*      */         boolean clear;
/* 1418 */         boolean clear = wasInterrupted;
/* 1419 */         SwingUtilities.invokeLater(new Runnable(clear, cell, oldfg) {
/*      */           public void run() {
/* 1421 */             if (this.val$clear) this.val$cell.setText("");
/* 1422 */             this.val$cell.setForeground(this.val$oldfg);
/* 1423 */             this.val$cell.repaint();
/*      */           }
/*      */         });
/* 1427 */         Thread.currentThread().setPriority(5);
/* 1428 */         SynchronizationTimer.this.endOneTest();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   class PrintStart
/*      */     implements Runnable
/*      */   {
/*      */     PrintStart()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void run()
/*      */     {
/* 1171 */       SynchronizationTimer.this.startstop_.setText("Start");
/*      */     }
/*      */   }
/*      */ 
/*      */   class TestSeries
/*      */     implements Runnable
/*      */   {
/*      */     final int firstclass;
/*      */     final int firstnthreads;
/*      */ 
/*      */     TestSeries()
/*      */     {
/* 1196 */       this.firstclass = 0;
/* 1197 */       this.firstnthreads = 0;
/*      */     }
/*      */ 
/*      */     TestSeries(int firstc, int firstnt) {
/* 1201 */       this.firstclass = firstc;
/* 1202 */       this.firstnthreads = firstnt;
/*      */     }
/*      */ 
/*      */     // ERROR //
/*      */     public void run()
/*      */     {
/*      */       // Byte code:
/*      */       //   0: invokestatic 32	java/lang/Thread:currentThread	()Ljava/lang/Thread;
/*      */       //   3: iconst_5
/*      */       //   4: invokevirtual 38	java/lang/Thread:setPriority	(I)V
/*      */       //   7: aload_0
/*      */       //   8: getfield 22	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:firstnthreads	I
/*      */       //   11: istore_1
/*      */       //   12: aload_0
/*      */       //   13: getfield 20	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:firstclass	I
/*      */       //   16: istore_2
/*      */       //   17: iload_1
/*      */       //   18: getstatic 42	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:nthreadsChoices	[I
/*      */       //   21: arraylength
/*      */       //   22: if_icmpge +176 -> 198
/*      */       //   25: iload_2
/*      */       //   26: getstatic 48	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestedClass:classes	[LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestedClass;
/*      */       //   29: arraylength
/*      */       //   30: if_icmpge +168 -> 198
/*      */       //   33: aload_0
/*      */       //   34: getfield 15	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:this$0	LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;
/*      */       //   37: iload_1
/*      */       //   38: invokevirtual 54	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:threadEnabled	(I)Z
/*      */       //   41: ifeq +74 -> 115
/*      */       //   44: getstatic 48	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestedClass:classes	[LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestedClass;
/*      */       //   47: iload_2
/*      */       //   48: aaload
/*      */       //   49: astore_3
/*      */       //   50: getstatic 42	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:nthreadsChoices	[I
/*      */       //   53: iload_1
/*      */       //   54: iaload
/*      */       //   55: istore 4
/*      */       //   57: aload_0
/*      */       //   58: getfield 15	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:this$0	LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;
/*      */       //   61: invokestatic 58	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:access$1	(LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;)LEDU/oswego/cs/dl/util/concurrent/SynchronizedInt;
/*      */       //   64: invokevirtual 62	EDU/oswego/cs/dl/util/concurrent/SynchronizedInt:get	()I
/*      */       //   67: istore 5
/*      */       //   69: aload_0
/*      */       //   70: getfield 15	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:this$0	LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;
/*      */       //   73: invokestatic 68	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:access$2	(LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;)LEDU/oswego/cs/dl/util/concurrent/SynchronizedRef;
/*      */       //   76: invokevirtual 72	EDU/oswego/cs/dl/util/concurrent/SynchronizedRef:get	()Ljava/lang/Object;
/*      */       //   79: checkcast 77	EDU/oswego/cs/dl/util/concurrent/misc/Fraction
/*      */       //   82: astore 6
/*      */       //   84: aload_3
/*      */       //   85: iload 4
/*      */       //   87: aload 6
/*      */       //   89: invokevirtual 79	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestedClass:isEnabled	(ILEDU/oswego/cs/dl/util/concurrent/misc/Fraction;)Z
/*      */       //   92: ifeq +23 -> 115
/*      */       //   95: aload_0
/*      */       //   96: getfield 15	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:this$0	LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;
/*      */       //   99: new 83	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$OneTest
/*      */       //   102: dup
/*      */       //   103: aload_0
/*      */       //   104: getfield 15	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:this$0	LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;
/*      */       //   107: iload_2
/*      */       //   108: iload_1
/*      */       //   109: invokespecial 85	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$OneTest:<init>	(LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;II)V
/*      */       //   112: invokestatic 87	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:access$3	(LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;Ljava/lang/Runnable;)V
/*      */       //   115: iinc 2 1
/*      */       //   118: iload_2
/*      */       //   119: getstatic 48	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestedClass:classes	[LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestedClass;
/*      */       //   122: arraylength
/*      */       //   123: if_icmplt +19 -> 142
/*      */       //   126: iconst_0
/*      */       //   127: istore_2
/*      */       //   128: iinc 1 1
/*      */       //   131: iload_1
/*      */       //   132: getstatic 42	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:nthreadsChoices	[I
/*      */       //   135: arraylength
/*      */       //   136: if_icmplt +6 -> 142
/*      */       //   139: goto +59 -> 198
/*      */       //   142: aload_0
/*      */       //   143: getfield 15	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:this$0	LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;
/*      */       //   146: getfield 91	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:nextClassIdx_	LEDU/oswego/cs/dl/util/concurrent/SynchronizedInt;
/*      */       //   149: iload_2
/*      */       //   150: invokevirtual 95	EDU/oswego/cs/dl/util/concurrent/SynchronizedInt:set	(I)I
/*      */       //   153: pop
/*      */       //   154: aload_0
/*      */       //   155: getfield 15	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:this$0	LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;
/*      */       //   158: getfield 99	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:nextThreadIdx_	LEDU/oswego/cs/dl/util/concurrent/SynchronizedInt;
/*      */       //   161: iload_1
/*      */       //   162: invokevirtual 95	EDU/oswego/cs/dl/util/concurrent/SynchronizedInt:set	(I)I
/*      */       //   165: pop
/*      */       //   166: goto -133 -> 33
/*      */       //   169: astore_1
/*      */       //   170: invokestatic 32	java/lang/Thread:currentThread	()Ljava/lang/Thread;
/*      */       //   173: invokevirtual 102	java/lang/Thread:interrupt	()V
/*      */       //   176: aload_0
/*      */       //   177: getfield 15	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:this$0	LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;
/*      */       //   180: invokevirtual 105	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:endTestSeries	()V
/*      */       //   183: goto +22 -> 205
/*      */       //   186: astore 7
/*      */       //   188: aload_0
/*      */       //   189: getfield 15	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:this$0	LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;
/*      */       //   192: invokevirtual 105	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:endTestSeries	()V
/*      */       //   195: aload 7
/*      */       //   197: athrow
/*      */       //   198: aload_0
/*      */       //   199: getfield 15	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer$TestSeries:this$0	LEDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer;
/*      */       //   202: invokevirtual 105	EDU/oswego/cs/dl/util/concurrent/misc/SynchronizationTimer:endTestSeries	()V
/*      */       //   205: return
/*      */       //
/*      */       // Exception table:
/*      */       //   from	to	target	type
/*      */       //   7	169	169	java/lang/InterruptedException
/*      */       //   7	176	186	finally
/*      */     }
/*      */   }
/*      */ 
/*      */   static class TestedClass
/*      */   {
/*      */     final String name;
/*      */     final Class cls;
/*      */     final boolean multipleOK;
/*      */     final boolean singleOK;
/*      */     final Class buffCls;
/*  299 */     Boolean enabled_ = new Boolean(true);
/*      */ 
/*  329 */     static final TestedClass dummy = new TestedClass("", null, false, false);
/*      */ 
/*  331 */     static final TestedClass[] classes = { 
/*  333 */       new TestedClass("NoSynchronization", NoSynchRNG.class, false, true), 
/*  334 */       new TestedClass("PublicSynchronization", PublicSynchRNG.class, true, true), 
/*  335 */       new TestedClass("NestedSynchronization", AllSynchRNG.class, true, true), 
/*  337 */       new TestedClass("SDelegated", SDelegatedRNG.class, true, true), 
/*  339 */       new TestedClass("SynchLongUsingSet", SynchLongRNG.class, true, true), 
/*  340 */       new TestedClass("SynchLongUsingCommit", AClongRNG.class, true, true), 
/*  342 */       new TestedClass("Semaphore", SemRNG.class, true, true), 
/*  343 */       new TestedClass("WaiterPrefSemaphore", WpSemRNG.class, true, true), 
/*  344 */       new TestedClass("FIFOSemaphore", FifoRNG.class, true, true), 
/*  345 */       new TestedClass("PrioritySemaphore", PrioritySemRNG.class, true, true), 
/*  346 */       new TestedClass("Mutex", MutexRNG.class, true, true), 
/*  347 */       new TestedClass("ReentrantLock", RlockRNG.class, true, true), 
/*  349 */       new TestedClass("WriterPrefRWLock", WpRWlockRNG.class, true, true), 
/*  350 */       new TestedClass("ReaderPrefRWLock", ReaderPrefRWlockRNG.class, true, true), 
/*  351 */       new TestedClass("FIFORWLock", FIFORWlockRNG.class, true, true), 
/*  352 */       new TestedClass("ReentrantRWL", ReentrantRWlockRNG.class, true, true), 
/*  356 */       new TestedClass("LinkedQueue", ChanRNG.class, true, true, 
/*  357 */       LinkedQueue.class), 
/*  359 */       new TestedClass("WaitFreeQueue", ChanRNG.class, true, true, 
/*  360 */       WaitFreeQueue.class), 
/*  362 */       new TestedClass("BoundedLinkedQueue", ChanRNG.class, true, true, 
/*  363 */       BoundedLinkedQueue.class), 
/*  364 */       new TestedClass("BoundedBuffer", ChanRNG.class, true, true, 
/*  365 */       BoundedBuffer.class), 
/*  366 */       new TestedClass("CondVarBoundedBuffer", ChanRNG.class, true, true, 
/*  367 */       CVBuffer.class), 
/*  368 */       new TestedClass("BoundedPriorityQueue", ChanRNG.class, true, true, 
/*  369 */       BoundedPriorityQueue.class), 
/*  370 */       new TestedClass("Slot", ChanRNG.class, true, true, 
/*  371 */       Slot.class), 
/*  373 */       new TestedClass("SynchronousChannel", ChanRNG.class, true, false, 
/*  374 */       SynchronousChannel.class), 
/*  377 */       new TestedClass("DirectExecutor", DirectExecutorRNG.class, true, true), 
/*  378 */       new TestedClass("SemaphoreLckExecutor", LockedSemRNG.class, true, true), 
/*  379 */       new TestedClass("QueuedExecutor", QueuedExecutorRNG.class, true, true), 
/*  380 */       new TestedClass("ThreadedExecutor", ThreadedExecutorRNG.class, true, true), 
/*  381 */       new TestedClass("PooledExecutor", PooledExecutorRNG.class, true, true) };
/*      */ 
/*      */     synchronized void setEnabled(Boolean b)
/*      */     {
/*  301 */       this.enabled_ = b; } 
/*  302 */     synchronized Boolean getEnabled() { return this.enabled_; }
/*      */ 
/*      */     synchronized void toggleEnabled() {
/*  305 */       boolean enabled = this.enabled_.booleanValue();
/*  306 */       this.enabled_ = new Boolean(!enabled);
/*      */     }
/*      */ 
/*      */     synchronized boolean isEnabled(int nthreads, Fraction shared) {
/*  310 */       boolean enabled = this.enabled_.booleanValue();
/*  311 */       if (!enabled) return false;
/*  312 */       if ((!this.singleOK) && (nthreads <= 1)) return false;
/*  313 */       return (this.multipleOK) || (nthreads <= 1) || (shared.compareTo(0L) <= 0);
/*      */     }
/*      */ 
/*      */     TestedClass(String n, Class c, boolean m, boolean sok)
/*      */     {
/*  319 */       this.name = n; this.cls = c; this.multipleOK = m; this.singleOK = sok;
/*  320 */       this.buffCls = null;
/*      */     }
/*      */ 
/*      */     TestedClass(String n, Class c, boolean m, boolean sok, Class bc) {
/*  324 */       this.name = n; this.cls = c; this.multipleOK = m; this.singleOK = sok;
/*  325 */       this.buffCls = bc;
/*      */     }
/*      */   }
/*      */ 
/*      */   static class ThreadInfo
/*      */   {
/*      */     final String name;
/*      */     final int number;
/*      */     Boolean enabled;
/*      */ 
/*      */     ThreadInfo(int nthr)
/*      */     {
/*  473 */       this.number = nthr;
/*  474 */       this.name = SynchronizationTimer.p2ToString(nthr);
/*  475 */       this.enabled = new Boolean(true);
/*      */     }
/*      */     synchronized Boolean getEnabled() {
/*  478 */       return this.enabled; } 
/*  479 */     synchronized void setEnabled(Boolean v) { this.enabled = v; } 
/*      */     synchronized void toggleEnabled() {
/*  481 */       this.enabled = new Boolean(!this.enabled.booleanValue());
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.SynchronizationTimer
 * JD-Core Version:    0.6.0
 */