/*      */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.Sync;
/*      */ 
/*      */ class SyncDelegatedRNG extends DelegatedRNG
/*      */ {
/*      */   protected final Sync cond_;
/*      */ 
/*      */   public SyncDelegatedRNG(Sync c)
/*      */   {
/* 1893 */     this.cond_ = c;
/* 1894 */     setDelegate(new NoSynchRNG());
/*      */   }
/*      */ 
/*      */   protected final void acquire() throws InterruptedException
/*      */   {
/* 1899 */     if (this.smode == 0) {
/* 1900 */       this.cond_.acquire();
/*      */     }
/*      */     else
/* 1903 */       while (!this.cond_.attempt(this.waitTime));
/*      */   }
/*      */ 
/*      */   public long next() {
/*      */     try {
/* 1909 */       acquire();
/*      */ 
/* 1911 */       getDelegate().update();
/* 1912 */       long l = getDelegate().get();
/* 1913 */       this.cond_.release();
/* 1914 */       return l;
/*      */     }
/*      */     catch (InterruptedException x) {
/* 1917 */       Thread.currentThread().interrupt();
/* 1918 */     }return 0L;
/*      */   }
/*      */ 
/*      */   public long get()
/*      */   {
/*      */     try {
/* 1924 */       acquire();
/* 1925 */       long l = getDelegate().get();
/* 1926 */       this.cond_.release();
/* 1927 */       return l;
/*      */     }
/*      */     catch (InterruptedException x) {
/* 1930 */       Thread.currentThread().interrupt();
/* 1931 */     }return 0L;
/*      */   }
/*      */ 
/*      */   public void update()
/*      */   {
/*      */     try {
/* 1937 */       acquire();
/* 1938 */       getDelegate().update();
/* 1939 */       this.cond_.release();
/*      */     }
/*      */     catch (InterruptedException x) {
/* 1942 */       Thread.currentThread().interrupt();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.SyncDelegatedRNG
 * JD-Core Version:    0.6.0
 */