/*      */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
/*      */ import EDU.oswego.cs.dl.util.concurrent.Sync;
/*      */ 
/*      */ class RWLockRNG extends NoSynchRNG
/*      */ {
/*      */   protected final ReadWriteLock lock_;
/*      */ 
/*      */   public RWLockRNG(ReadWriteLock l)
/*      */   {
/* 1978 */     this.lock_ = l;
/*      */   }
/*      */ 
/*      */   protected final void acquireR() throws InterruptedException {
/* 1982 */     if (this.smode == 0) {
/* 1983 */       this.lock_.readLock().acquire();
/*      */     }
/*      */     else
/* 1986 */       while (!this.lock_.readLock().attempt(this.waitTime));
/*      */   }
/*      */ 
/*      */   protected final void acquireW() throws InterruptedException {
/* 1991 */     if (this.smode == 0) {
/* 1992 */       this.lock_.writeLock().acquire();
/*      */     }
/*      */     else
/* 1995 */       while (!this.lock_.writeLock().attempt(this.waitTime));
/*      */   }
/*      */ 
/*      */   public long next()
/*      */   {
/* 2001 */     long l = 0L;
/*      */     try {
/* 2003 */       acquireR();
/* 2004 */       l = this.current_;
/* 2005 */       this.lock_.readLock().release();
/*      */     }
/*      */     catch (InterruptedException x) {
/* 2008 */       Thread.currentThread().interrupt();
/* 2009 */       return 0L;
/*      */     }
/*      */ 
/* 2012 */     l = compute(l);
/*      */     try
/*      */     {
/* 2015 */       acquireW();
/* 2016 */       set(l);
/* 2017 */       this.lock_.writeLock().release();
/* 2018 */       return l;
/*      */     }
/*      */     catch (InterruptedException x) {
/* 2021 */       Thread.currentThread().interrupt();
/* 2022 */     }return 0L;
/*      */   }
/*      */ 
/*      */   public long get()
/*      */   {
/*      */     try
/*      */     {
/* 2029 */       acquireR();
/* 2030 */       long l = this.current_;
/* 2031 */       this.lock_.readLock().release();
/* 2032 */       return l;
/*      */     }
/*      */     catch (InterruptedException x) {
/* 2035 */       Thread.currentThread().interrupt();
/* 2036 */     }return 0L;
/*      */   }
/*      */ 
/*      */   public void update()
/*      */   {
/* 2041 */     long l = 0L;
/*      */     try
/*      */     {
/* 2044 */       acquireR();
/* 2045 */       l = this.current_;
/* 2046 */       this.lock_.readLock().release();
/*      */     }
/*      */     catch (InterruptedException x) {
/* 2049 */       Thread.currentThread().interrupt();
/* 2050 */       return;
/*      */     }
/*      */ 
/* 2053 */     l = compute(l);
/*      */     try
/*      */     {
/* 2056 */       acquireW();
/* 2057 */       set(l);
/* 2058 */       this.lock_.writeLock().release();
/*      */     }
/*      */     catch (InterruptedException x) {
/* 2061 */       Thread.currentThread().interrupt();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.RWLockRNG
 * JD-Core Version:    0.6.0
 */