/*      */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
/*      */ import EDU.oswego.cs.dl.util.concurrent.Channel;
/*      */ import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
/*      */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
/*      */ 
/*      */ class PCTestLoop extends TestLoop
/*      */ {
/*      */   final Channel primaryChannel;
/*      */   final Channel sharedChannel;
/*      */ 
/*      */   public PCTestLoop(RNG sh, RNG pri, Fraction pshr, int it, CyclicBarrier br, Channel shChan, Channel priChan)
/*      */   {
/* 1593 */     super(sh, pri, pshr, it, br);
/* 1594 */     this.sharedChannel = shChan;
/* 1595 */     this.primaryChannel = priChan;
/*      */   }
/*      */ 
/*      */   public Runnable testLoop(boolean isProducer) {
/* 1599 */     return new Runnable(isProducer) {
/*      */       public void run() {
/* 1601 */         int delta = -1;
/* 1602 */         Thread.currentThread().setPriority(5 + delta);
/* 1603 */         int itersPerBarrier = RNG.itersPerBarrier.get();
/*      */         try
/*      */         {
/* 1606 */           int nshared = (int)(PCTestLoop.this.iters * PCTestLoop.this.pshared.asDouble());
/* 1607 */           int nprimary = PCTestLoop.this.iters - nshared;
/* 1608 */           int idx = PCTestLoop.this.firstidx;
/*      */ 
/* 1610 */           PCTestLoop.this.barrier.barrier();
/*      */ 
/* 1612 */           ChanRNG target = (ChanRNG)PCTestLoop.this.primary;
/*      */ 
/* 1614 */           for (int i = PCTestLoop.this.iters; i > 0; i--) {
/* 1615 */             idx++;
/* 1616 */             if (i % itersPerBarrier == 0) {
/* 1617 */               PCTestLoop.this.primary.exchange();
/*      */             }
/*      */             else
/*      */             {
/*      */               Channel c;
/*      */               Channel c;
/* 1621 */               if ((nshared > 0) && (PCTestLoop.this.useShared[(idx % PCTestLoop.this.useShared.length)] != 0)) {
/* 1622 */                 nshared--;
/* 1623 */                 c = PCTestLoop.this.sharedChannel;
/*      */               }
/*      */               else {
/* 1626 */                 nprimary--;
/* 1627 */                 c = PCTestLoop.this.primaryChannel;
/*      */               }
/*      */               long rnd;
/*      */               long rnd;
/* 1631 */               if (this.val$isProducer)
/* 1632 */                 rnd = target.producerNext(c);
/*      */               else {
/* 1634 */                 rnd = target.consumerNext(c);
/*      */               }
/* 1636 */               if ((rnd % 2L == 0L) && (Thread.currentThread().isInterrupted()))
/*      */                 break;
/*      */             }
/*      */           }
/*      */         }
/*      */         catch (BrokenBarrierException localBrokenBarrierException) {
/*      */         }
/*      */         catch (InterruptedException ex) {
/* 1644 */           Thread.currentThread().interrupt();
/*      */         }
/*      */         finally {
/*      */           try {
/* 1648 */             PCTestLoop.this.barrier.barrier();
/*      */           }
/*      */           catch (InterruptedException ex) {
/* 1651 */             Thread.currentThread().interrupt();
/*      */           }
/*      */           catch (BrokenBarrierException localBrokenBarrierException3) {
/*      */           }
/*      */           finally {
/* 1656 */             Thread.currentThread().setPriority(5);
/*      */           }
/*      */         }
/*      */       }
/*      */     };
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.PCTestLoop
 * JD-Core Version:    0.6.0
 */