/*      */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.Callable;
/*      */ import EDU.oswego.cs.dl.util.concurrent.Executor;
/*      */ import EDU.oswego.cs.dl.util.concurrent.FutureResult;
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ 
/*      */ abstract class ExecutorRNG extends DelegatedRNG
/*      */ {
/*      */   Executor executor_;
/* 2125 */   Runnable delegatedUpdate_ = null;
/* 2126 */   Callable delegatedNext_ = null;
/*      */ 
/* 2150 */   FutureResult nextResult_ = null;
/*      */ 
/*      */   synchronized void setExecutor(Executor e)
/*      */   {
/* 2122 */     this.executor_ = e; } 
/* 2123 */   synchronized Executor getExecutor() { return this.executor_;
/*      */   }
/*      */ 
/*      */   synchronized Runnable delegatedUpdateCommand()
/*      */   {
/* 2129 */     if (this.delegatedUpdate_ == null)
/* 2130 */       this.delegatedUpdate_ = new UpdateCommand(getDelegate());
/* 2131 */     return this.delegatedUpdate_;
/*      */   }
/*      */ 
/*      */   synchronized Callable delegatedNextFunction() {
/* 2135 */     if (this.delegatedNext_ == null)
/* 2136 */       this.delegatedNext_ = new NextFunction(getDelegate());
/* 2137 */     return this.delegatedNext_;
/*      */   }
/*      */ 
/*      */   public void update() {
/*      */     try {
/* 2142 */       getExecutor().execute(delegatedUpdateCommand());
/*      */     }
/*      */     catch (InterruptedException ex) {
/* 2145 */       Thread.currentThread().interrupt();
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized long next()
/*      */   {
/* 2153 */     long res = 0L;
/*      */     try {
/* 2155 */       if (this.nextResult_ == null) {
/* 2156 */         this.nextResult_ = new FutureResult();
/* 2157 */         this.nextResult_.set(new Long(getDelegate().next()));
/*      */       }
/* 2159 */       FutureResult currentResult = this.nextResult_;
/*      */ 
/* 2161 */       this.nextResult_ = new FutureResult();
/* 2162 */       Runnable r = this.nextResult_.setter(delegatedNextFunction());
/* 2163 */       getExecutor().execute(r);
/*      */ 
/* 2165 */       res = ((Long)currentResult.get()).longValue();
/*      */     }
/*      */     catch (InterruptedException ex)
/*      */     {
/* 2169 */       Thread.currentThread().interrupt();
/*      */     }
/*      */     catch (InvocationTargetException ex) {
/* 2172 */       ex.printStackTrace();
/* 2173 */       throw new Error("Bad Callable?");
/*      */     }
/* 2175 */     return res;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.ExecutorRNG
 * JD-Core Version:    0.6.0
 */