/*      */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.Channel;
/*      */ 
/*      */ class ChanRNG extends DelegatedRNG
/*      */ {
/*      */   boolean single_;
/*      */ 
/*      */   ChanRNG()
/*      */   {
/* 2251 */     setDelegate(new PublicSynchRNG());
/*      */   }
/*      */   public synchronized void setSingle(boolean s) {
/* 2254 */     this.single_ = s; } 
/* 2255 */   public synchronized boolean isSingle() { return this.single_; }
/*      */ 
/*      */   public long producerNext(Channel c) throws InterruptedException {
/* 2258 */     RNG r = getDelegate();
/* 2259 */     if (isSingle()) {
/* 2260 */       c.put(r);
/* 2261 */       r = (RNG)c.take();
/* 2262 */       r.update();
/*      */     }
/*      */     else {
/* 2265 */       if (this.pcBias < 0) {
/* 2266 */         r.update();
/* 2267 */         r.update();
/*      */       }
/* 2269 */       else if (this.pcBias == 0) {
/* 2270 */         r.update();
/*      */       }
/*      */ 
/* 2273 */       if (this.pmode == 0) {
/* 2274 */         c.put(r);
/*      */       }
/*      */       else
/* 2277 */         while (!c.offer(r, this.waitTime));
/*      */     }
/* 2280 */     return r.get();
/*      */   }
/*      */ 
/*      */   public long consumerNext(Channel c) throws InterruptedException {
/* 2284 */     RNG r = null;
/* 2285 */     if (this.cmode == 0)
/* 2286 */       r = (RNG)c.take();
/*      */     else {
/*      */       do
/* 2289 */         r = (RNG)c.poll(this.waitTime); while (r == null);
/*      */     }
/*      */ 
/* 2292 */     if (this.pcBias == 0) {
/* 2293 */       r.update();
/*      */     }
/* 2295 */     else if (this.pcBias > 0) {
/* 2296 */       r.update();
/* 2297 */       r.update();
/*      */     }
/* 2299 */     return r.get();
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG
 * JD-Core Version:    0.6.0
 */