/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public final class WaiterPreferenceSemaphore extends Semaphore
/*     */ {
/*  59 */   protected long waits_ = 0L;
/*     */ 
/*     */   public WaiterPreferenceSemaphore(long initial)
/*     */   {
/*  56 */     super(initial);
/*     */   }
/*     */ 
/*     */   public void acquire()
/*     */     throws InterruptedException
/*     */   {
/*  62 */     if (Thread.interrupted()) throw new InterruptedException();
/*  63 */     synchronized (this)
/*     */     {
/*  68 */       if (this.permits_ > this.waits_) {
/*  69 */         this.permits_ -= 1L;
/*  70 */         return;
/*     */       }
/*     */ 
/*  73 */       this.waits_ += 1L;
/*     */       try {
/*     */         do
/*  76 */           wait();
/*  77 */         while (this.permits_ <= 0L);
/*  78 */         this.waits_ -= 1L;
/*  79 */         this.permits_ -= 1L;
/*  80 */         return;
/*     */       }
/*     */       catch (InterruptedException ex)
/*     */       {
/*  85 */         this.waits_ -= 1L;
/*  86 */         notify();
/*  87 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean attempt(long msecs) throws InterruptedException
/*     */   {
/*  94 */     if (Thread.interrupted()) throw new InterruptedException();
/*     */ 
/*  96 */     synchronized (this) {
/*  97 */       if (this.permits_ > this.waits_) {
/*  98 */         this.permits_ -= 1L;
/*  99 */         return true;
/*     */       }
/* 101 */       if (msecs <= 0L) {
/* 102 */         return false;
/*     */       }
/* 104 */       this.waits_ += 1L;
/*     */ 
/* 106 */       long startTime = System.currentTimeMillis();
/* 107 */       long waitTime = msecs;
/*     */       try
/*     */       {
/*     */         do {
/* 111 */           wait(waitTime);
/* 112 */           if (this.permits_ > 0L) {
/* 113 */             this.waits_ -= 1L;
/* 114 */             this.permits_ -= 1L;
/* 115 */             return true;
/*     */           }
/*     */ 
/* 118 */           waitTime = msecs - (System.currentTimeMillis() - startTime);
/* 119 */         }while (waitTime > 0L);
/* 120 */         this.waits_ -= 1L;
/* 121 */         return false;
/*     */       }
/*     */       catch (InterruptedException ex)
/*     */       {
/* 127 */         this.waits_ -= 1L;
/* 128 */         notify();
/* 129 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void release()
/*     */   {
/* 136 */     this.permits_ += 1L;
/* 137 */     notify();
/*     */   }
/*     */ 
/*     */   public synchronized void release(long n)
/*     */   {
/* 142 */     this.permits_ += n;
/* 143 */     for (long i = 0L; i < n; i += 1L) notify();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.WaiterPreferenceSemaphore
 * JD-Core Version:    0.6.0
 */