/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class WaitableShort extends SynchronizedShort
/*     */ {
/*     */   public WaitableShort(short initialValue)
/*     */   {
/*  30 */     super(initialValue);
/*     */   }
/*     */ 
/*     */   public WaitableShort(short initialValue, Object lock)
/*     */   {
/*  38 */     super(initialValue, lock);
/*     */   }
/*     */ 
/*     */   public short set(short newValue)
/*     */   {
/*  43 */     synchronized (this.lock_) {
/*  44 */       this.lock_.notifyAll();
/*  45 */       return super.set(newValue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(short assumedValue, short newValue) {
/*  50 */     synchronized (this.lock_) {
/*  51 */       boolean success = super.commit(assumedValue, newValue);
/*  52 */       if (success) this.lock_.notifyAll();
/*  53 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public short increment() {
/*  58 */     synchronized (this.lock_) {
/*  59 */       this.lock_.notifyAll();
/*  60 */       return super.increment();
/*     */     }
/*     */   }
/*     */ 
/*     */   public short decrement() {
/*  65 */     synchronized (this.lock_) {
/*  66 */       this.lock_.notifyAll();
/*  67 */       return super.decrement();
/*     */     }
/*     */   }
/*     */ 
/*     */   public short add(short amount) {
/*  72 */     synchronized (this.lock_) {
/*  73 */       this.lock_.notifyAll();
/*  74 */       return super.add(amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public short subtract(short amount) {
/*  79 */     synchronized (this.lock_) {
/*  80 */       this.lock_.notifyAll();
/*  81 */       return super.subtract(amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public short multiply(short factor) {
/*  86 */     synchronized (this.lock_) {
/*  87 */       this.lock_.notifyAll();
/*  88 */       return super.multiply(factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public short divide(short factor) {
/*  93 */     synchronized (this.lock_) {
/*  94 */       this.lock_.notifyAll();
/*  95 */       return super.divide(factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public short complement()
/*     */   {
/* 104 */     synchronized (this.lock_) {
/* 105 */       this.value_ = (short)(this.value_ ^ 0xFFFFFFFF);
/* 106 */       this.lock_.notifyAll();
/* 107 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public short and(short b)
/*     */   {
/* 116 */     synchronized (this.lock_) {
/* 117 */       this.value_ = (short)(this.value_ & b);
/* 118 */       this.lock_.notifyAll();
/* 119 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public short or(short b)
/*     */   {
/* 128 */     synchronized (this.lock_) {
/* 129 */       this.value_ = (short)(this.value_ | b);
/* 130 */       this.lock_.notifyAll();
/* 131 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public short xor(short b)
/*     */   {
/* 141 */     synchronized (this.lock_) {
/* 142 */       this.value_ = (short)(this.value_ ^ b);
/* 143 */       this.lock_.notifyAll();
/* 144 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenEqual(short c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 154 */     synchronized (this.lock_) {
/* 155 */       while (this.value_ != c) this.lock_.wait();
/* 156 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenNotEqual(short c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 165 */     synchronized (this.lock_) {
/* 166 */       while (this.value_ == c) this.lock_.wait();
/* 167 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenLessEqual(short c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 176 */     synchronized (this.lock_) {
/* 177 */       while (this.value_ > c) this.lock_.wait();
/* 178 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenLess(short c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 187 */     synchronized (this.lock_) {
/* 188 */       while (this.value_ >= c) this.lock_.wait();
/* 189 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenGreaterEqual(short c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 198 */     synchronized (this.lock_) {
/* 199 */       while (this.value_ < c) this.lock_.wait();
/* 200 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenGreater(short c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 209 */     synchronized (this.lock_) {
/* 210 */       while (this.value_ <= c) this.lock_.wait();
/* 211 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.WaitableShort
 * JD-Core Version:    0.6.0
 */