/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class WaitableBoolean extends SynchronizedBoolean
/*     */ {
/*     */   public WaitableBoolean(boolean initialValue)
/*     */   {
/*  25 */     super(initialValue);
/*     */   }
/*     */ 
/*     */   public WaitableBoolean(boolean initialValue, Object lock)
/*     */   {
/*  33 */     super(initialValue, lock);
/*     */   }
/*     */ 
/*     */   public boolean set(boolean newValue)
/*     */   {
/*  38 */     synchronized (this.lock_) {
/*  39 */       this.lock_.notifyAll();
/*  40 */       return super.set(newValue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(boolean assumedValue, boolean newValue) {
/*  45 */     synchronized (this.lock_) {
/*  46 */       boolean success = super.commit(assumedValue, newValue);
/*  47 */       if (success) this.lock_.notifyAll();
/*  48 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean complement() {
/*  53 */     synchronized (this.lock_) {
/*  54 */       this.lock_.notifyAll();
/*  55 */       return super.complement();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean and(boolean b) {
/*  60 */     synchronized (this.lock_) {
/*  61 */       this.lock_.notifyAll();
/*  62 */       return super.and(b);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean or(boolean b) {
/*  67 */     synchronized (this.lock_) {
/*  68 */       this.lock_.notifyAll();
/*  69 */       return super.or(b);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean xor(boolean b) {
/*  74 */     synchronized (this.lock_) {
/*  75 */       this.lock_.notifyAll();
/*  76 */       return super.xor(b);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenFalse(Runnable action)
/*     */     throws InterruptedException
/*     */   {
/*  86 */     synchronized (this.lock_) {
/*  87 */       while (this.value_) this.lock_.wait();
/*  88 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenTrue(Runnable action)
/*     */     throws InterruptedException
/*     */   {
/*  97 */     synchronized (this.lock_) {
/*  98 */       while (!this.value_) this.lock_.wait();
/*  99 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenEqual(boolean c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 109 */     synchronized (this.lock_) {
/* 110 */       while (this.value_ != c) this.lock_.wait();
/* 111 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenNotEqual(boolean c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 120 */     synchronized (this.lock_) {
/* 121 */       while (this.value_ == c) this.lock_.wait();
/* 122 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.WaitableBoolean
 * JD-Core Version:    0.6.0
 */