/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class WaitFreeQueue
/*     */   implements Channel
/*     */ {
/*  78 */   protected volatile Node head = new Node(null);
/*     */ 
/*  80 */   protected volatile Node tail = this.head;
/*     */ 
/*  83 */   protected final Object tailLock = new Object();
/*     */ 
/*     */   protected synchronized boolean CASHead(Node oldHead, Node newHead)
/*     */   {
/*  87 */     if (this.head == oldHead) {
/*  88 */       this.head = newHead;
/*  89 */       return true;
/*     */     }
/*     */ 
/*  92 */     return false;
/*     */   }
/*     */ 
/*     */   protected boolean CASTail(Node oldTail, Node newTail)
/*     */   {
/*  97 */     synchronized (this.tailLock) {
/*  98 */       if (this.tail == oldTail) {
/*  99 */         this.tail = newTail;
/* 100 */         return true;
/*     */       }
/*     */ 
/* 103 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void put(Object x) throws InterruptedException {
/* 108 */     if (x == null) throw new IllegalArgumentException();
/* 109 */     if (Thread.interrupted()) throw new InterruptedException();
/* 110 */     Node n = new Node(x);
/*     */     while (true)
/*     */     {
/* 113 */       Node t = this.tail;
/*     */ 
/* 115 */       if (t.CASNext(null, n))
/*     */       {
/* 118 */         CASTail(t, n);
/* 119 */         return;
/*     */       }
/*     */ 
/* 123 */       CASTail(t, t.next);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean offer(Object x, long msecs) throws InterruptedException {
/* 128 */     put(x);
/* 129 */     return true; } 
/*     */   protected Object extract() throws InterruptedException { Node h;
/*     */     Node first;
/*     */     Object result;
/*     */     do { h = this.head;
/* 136 */       first = h.next;
/*     */ 
/* 138 */       if (first == null) {
/* 139 */         return null;
/*     */       }
/* 141 */       result = first.value; }
/* 142 */     while (!CASHead(h, first));
/* 143 */     return result;
/*     */   }
/*     */ 
/*     */   public Object peek()
/*     */   {
/* 148 */     Node first = this.head.next;
/*     */ 
/* 150 */     if (first == null) {
/* 151 */       return null;
/*     */     }
/*     */ 
/* 156 */     synchronized (this) {
/* 157 */       return first.value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object take()
/*     */     throws InterruptedException
/*     */   {
/* 170 */     if (Thread.interrupted()) throw new InterruptedException(); while (true)
/*     */     {
/* 172 */       Object x = extract();
/* 173 */       if (x != null) {
/* 174 */         return x;
/*     */       }
/* 176 */       Thread.sleep(0L);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object poll(long msecs)
/*     */     throws InterruptedException
/*     */   {
/* 186 */     if (Thread.interrupted()) throw new InterruptedException();
/* 187 */     if (msecs <= 0L) {
/* 188 */       return extract();
/*     */     }
/* 190 */     long startTime = System.currentTimeMillis();
/*     */     while (true) {
/* 192 */       Object x = extract();
/* 193 */       if (x != null)
/* 194 */         return x;
/* 195 */       if (System.currentTimeMillis() - startTime >= msecs) {
/* 196 */         return null;
/*     */       }
/* 198 */       Thread.sleep(0L);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static final class Node
/*     */   {
/*     */     protected final Object value;
/*     */     protected volatile Node next;
/*     */ 
/*     */     protected Node(Object x)
/*     */     {
/*  64 */       this.value = x;
/*     */     }
/*     */ 
/*     */     protected synchronized boolean CASNext(Node oldNext, Node newNext) {
/*  68 */       if (this.next == oldNext) {
/*  69 */         this.next = newNext;
/*  70 */         return true;
/*     */       }
/*     */ 
/*  73 */       return false;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.WaitFreeQueue
 * JD-Core Version:    0.6.0
 */