/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class SynchronousChannel
/*     */   implements BoundedChannel
/*     */ {
/*  66 */   protected static final Object CANCELLED = new Object();
/*     */ 
/*  90 */   protected final Queue waitingPuts = new Queue();
/*  91 */   protected final Queue waitingTakes = new Queue();
/*     */ 
/*     */   public int capacity()
/*     */   {
/*  97 */     return 0;
/*     */   }
/*     */ 
/*     */   public Object peek()
/*     */   {
/* 103 */     return null;
/*     */   }
/*     */ 
/*     */   public void put(Object x) throws InterruptedException {
/* 107 */     if (x == null) throw new IllegalArgumentException();
/*     */ 
/*     */     LinkedNode item;
/*     */     while (true)
/*     */     {
/* 117 */       if (Thread.interrupted()) throw new InterruptedException();
/*     */ 
/* 123 */       item = null;
/*     */ 
/* 125 */       synchronized (this)
/*     */       {
/* 127 */         LinkedNode slot = this.waitingTakes.deq();
/*     */ 
/* 130 */         if (slot == null)
/* 131 */           this.waitingPuts.enq(item = new LinkedNode(x));
/*     */       }
/*     */       LinkedNode slot;
/* 134 */       if (slot == null) {
/*     */         break;
/*     */       }
/* 137 */       synchronized (slot) {
/* 138 */         if (slot.value != CANCELLED) {
/* 139 */           slot.value = x;
/* 140 */           slot.notify();
/* 141 */           return;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 149 */     synchronized (item) {
/*     */       try {
/* 151 */         while (item.value != null)
/* 152 */           item.wait();
/* 153 */         return;
/*     */       }
/*     */       catch (InterruptedException ie)
/*     */       {
/* 157 */         if (item.value == null) {
/* 158 */           Thread.currentThread().interrupt();
/* 159 */           return;
/*     */         }
/*     */ 
/* 162 */         item.value = CANCELLED;
/* 163 */         throw ie;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object take()
/*     */     throws InterruptedException
/*     */   {
/*     */     LinkedNode slot;
/*     */     while (true)
/*     */     {
/* 175 */       if (Thread.interrupted()) throw new InterruptedException();
/*     */ 
/* 178 */       slot = null;
/*     */ 
/* 180 */       synchronized (this) {
/* 181 */         LinkedNode item = this.waitingPuts.deq();
/* 182 */         if (item == null)
/* 183 */           this.waitingTakes.enq(slot = new LinkedNode());
/*     */       }
/*     */       LinkedNode item;
/* 186 */       if (item == null) break;
/* 187 */       synchronized (item) {
/* 188 */         Object x = item.value;
/* 189 */         if (x != CANCELLED) {
/* 190 */           item.value = null;
/* 191 */           item.next = null;
/* 192 */           item.notify();
/* 193 */           return x;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 199 */     synchronized (slot) {
/*     */       try {
/*     */         while (true) {
/* 202 */           Object x = slot.value;
/* 203 */           if (x != null) {
/* 204 */             slot.value = null;
/* 205 */             slot.next = null;
/* 206 */             return x;
/*     */           }
/*     */ 
/* 209 */           slot.wait();
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ie) {
/* 213 */         Object x = slot.value;
/* 214 */         if (x != null) {
/* 215 */           slot.value = null;
/* 216 */           slot.next = null;
/* 217 */           Thread.currentThread().interrupt();
/* 218 */           return x;
/*     */         }
/*     */ 
/* 221 */         slot.value = CANCELLED;
/* 222 */         throw ie;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean offer(Object x, long msecs)
/*     */     throws InterruptedException
/*     */   {
/* 236 */     if (x == null) throw new IllegalArgumentException(); long waitTime = msecs;
/* 238 */     long startTime = 0L;
/*     */     LinkedNode item;
/*     */     do { if (Thread.interrupted()) throw new InterruptedException();
/*     */ 
/* 244 */       item = null;
/*     */ 
/* 246 */       synchronized (this) {
/* 247 */         LinkedNode slot = this.waitingTakes.deq();
/* 248 */         if (slot == null) {
/* 249 */           if (waitTime <= 0L) {
/* 250 */             return false;
/*     */           }
/* 252 */           this.waitingPuts.enq(item = new LinkedNode(x));
/*     */         }
/*     */       }
/*     */       LinkedNode slot;
/* 256 */       if (slot != null) {
/* 257 */         synchronized (slot) {
/* 258 */           if (slot.value != CANCELLED) {
/* 259 */             slot.value = x;
/* 260 */             slot.notify();
/* 261 */             return true;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 266 */       long now = System.currentTimeMillis();
/* 267 */       if (startTime == 0L)
/* 268 */         startTime = now;
/*     */       else
/* 270 */         waitTime = msecs - (now - startTime);
/*     */     }
/* 272 */     while (item == null);
/* 273 */     synchronized (item) {
/*     */       try {
/*     */         while (true) {
/* 276 */           if (item.value == null)
/* 277 */             return true;
/* 278 */           if (waitTime <= 0L) {
/* 279 */             item.value = CANCELLED;
/* 280 */             return false;
/*     */           }
/* 282 */           item.wait(waitTime);
/* 283 */           waitTime = msecs - (System.currentTimeMillis() - startTime);
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ie) {
/* 287 */         if (item.value == null) {
/* 288 */           Thread.currentThread().interrupt();
/* 289 */           return true;
/*     */         }
/*     */ 
/* 292 */         item.value = CANCELLED;
/* 293 */         throw ie;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object poll(long msecs) throws InterruptedException {
/* 302 */     long waitTime = msecs;
/* 303 */     long startTime = 0L;
/*     */     LinkedNode slot;
/*     */     do {
/* 306 */       if (Thread.interrupted()) throw new InterruptedException();
/*     */ 
/* 309 */       slot = null;
/*     */ 
/* 311 */       synchronized (this) {
/* 312 */         LinkedNode item = this.waitingPuts.deq();
/* 313 */         if (item == null) {
/* 314 */           if (waitTime <= 0L) {
/* 315 */             return null;
/*     */           }
/* 317 */           this.waitingTakes.enq(slot = new LinkedNode());
/*     */         }
/*     */       }
/*     */       LinkedNode item;
/* 321 */       if (item != null) {
/* 322 */         synchronized (item) {
/* 323 */           Object x = item.value;
/* 324 */           if (x != CANCELLED) {
/* 325 */             item.value = null;
/* 326 */             item.next = null;
/* 327 */             item.notify();
/* 328 */             return x;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 333 */       long now = System.currentTimeMillis();
/* 334 */       if (startTime == 0L)
/* 335 */         startTime = now;
/*     */       else
/* 337 */         waitTime = msecs - (now - startTime);
/*     */     }
/* 339 */     while (slot == null);
/* 340 */     synchronized (slot) {
/*     */       try {
/*     */         while (true) {
/* 343 */           Object x = slot.value;
/* 344 */           if (x != null) {
/* 345 */             slot.value = null;
/* 346 */             slot.next = null;
/* 347 */             return x;
/*     */           }
/* 349 */           if (waitTime <= 0L) {
/* 350 */             slot.value = CANCELLED;
/* 351 */             return null;
/*     */           }
/* 353 */           slot.wait(waitTime);
/* 354 */           waitTime = msecs - (System.currentTimeMillis() - startTime);
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ie) {
/* 358 */         Object x = slot.value;
/* 359 */         if (x != null) {
/* 360 */           slot.value = null;
/* 361 */           slot.next = null;
/* 362 */           Thread.currentThread().interrupt();
/* 363 */           return x;
/*     */         }
/*     */ 
/* 366 */         slot.value = CANCELLED;
/* 367 */         throw ie;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static class Queue
/*     */   {
/*     */     protected LinkedNode head;
/*     */     protected LinkedNode last;
/*     */ 
/*     */     protected void enq(LinkedNode p)
/*     */     {
/*  76 */       if (this.last == null)
/*  77 */         this.last = (this.head = p);
/*     */       else
/*  79 */         this.last = (this.last.next = p);
/*     */     }
/*     */ 
/*     */     protected LinkedNode deq() {
/*  83 */       LinkedNode p = this.head;
/*  84 */       if ((p != null) && ((this.head = p.next) == null))
/*  85 */         this.last = null;
/*  86 */       return p;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SynchronousChannel
 * JD-Core Version:    0.6.0
 */