/*    */ package EDU.oswego.cs.dl.util.concurrent;
/*    */ 
/*    */ public class SynchronizedRef extends SynchronizedVariable
/*    */ {
/*    */   protected Object value_;
/*    */ 
/*    */   public SynchronizedRef(Object initialValue)
/*    */   {
/* 34 */     this.value_ = initialValue;
/*    */   }
/*    */ 
/*    */   public SynchronizedRef(Object initialValue, Object lock)
/*    */   {
/* 42 */     super(lock);
/* 43 */     this.value_ = initialValue;
/*    */   }
/*    */ 
/*    */   public final Object get()
/*    */   {
/* 49 */     synchronized (this.lock_) { return this.value_;
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object set(Object newValue)
/*    */   {
/* 57 */     synchronized (this.lock_) {
/* 58 */       Object old = this.value_;
/* 59 */       this.value_ = newValue;
/* 60 */       return old;
/*    */     }
/*    */   }
/*    */ 
/*    */   public boolean commit(Object assumedValue, Object newValue)
/*    */   {
/* 69 */     synchronized (this.lock_) {
/* 70 */       boolean success = assumedValue == this.value_;
/* 71 */       if (success) this.value_ = newValue;
/* 72 */       return success;
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object swap(SynchronizedRef other)
/*    */   {
/* 88 */     if (other == this) return get();
/* 89 */     SynchronizedRef fst = this;
/* 90 */     SynchronizedRef snd = other;
/* 91 */     if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
/* 92 */       fst = other;
/* 93 */       snd = this;
/*    */     }
/* 95 */     synchronized (fst.lock_) {
/* 96 */       synchronized (snd.lock_) {
/* 97 */         fst.set(snd.set(fst.get()));
/* 98 */         return get();
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SynchronizedRef
 * JD-Core Version:    0.6.0
 */