/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class SynchronizedInt extends SynchronizedVariable
/*     */   implements Comparable, Cloneable
/*     */ {
/*     */   protected int value_;
/*     */ 
/*     */   public SynchronizedInt(int initialValue)
/*     */   {
/*  33 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public SynchronizedInt(int initialValue, Object lock)
/*     */   {
/*  41 */     super(lock);
/*  42 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public final int get()
/*     */   {
/*  48 */     synchronized (this.lock_) { return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int set(int newValue)
/*     */   {
/*  56 */     synchronized (this.lock_) {
/*  57 */       int old = this.value_;
/*  58 */       this.value_ = newValue;
/*  59 */       return old;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(int assumedValue, int newValue)
/*     */   {
/*  68 */     synchronized (this.lock_) {
/*  69 */       boolean success = assumedValue == this.value_;
/*  70 */       if (success) this.value_ = newValue;
/*  71 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int swap(SynchronizedInt other)
/*     */   {
/*  86 */     if (other == this) return get();
/*  87 */     SynchronizedInt fst = this;
/*  88 */     SynchronizedInt snd = other;
/*  89 */     if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
/*  90 */       fst = other;
/*  91 */       snd = this;
/*     */     }
/*  93 */     synchronized (fst.lock_) {
/*  94 */       synchronized (snd.lock_) {
/*  95 */         fst.set(snd.set(fst.get()));
/*  96 */         return get();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int increment()
/*     */   {
/* 106 */     synchronized (this.lock_) {
/* 107 */       return ++this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int decrement()
/*     */   {
/* 116 */     synchronized (this.lock_) {
/* 117 */       return --this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int add(int amount)
/*     */   {
/* 126 */     synchronized (this.lock_) {
/* 127 */       return this.value_ += amount;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int subtract(int amount)
/*     */   {
/* 136 */     synchronized (this.lock_) {
/* 137 */       return this.value_ -= amount;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int multiply(int factor)
/*     */   {
/* 146 */     synchronized (this.lock_) {
/* 147 */       return this.value_ *= factor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int divide(int factor)
/*     */   {
/* 156 */     synchronized (this.lock_) {
/* 157 */       return this.value_ /= factor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int negate()
/*     */   {
/* 166 */     synchronized (this.lock_) {
/* 167 */       this.value_ = (-this.value_);
/* 168 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int complement()
/*     */   {
/* 177 */     synchronized (this.lock_) {
/* 178 */       this.value_ ^= -1;
/* 179 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int and(int b)
/*     */   {
/* 188 */     synchronized (this.lock_) {
/* 189 */       this.value_ &= b;
/* 190 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int or(int b)
/*     */   {
/* 199 */     synchronized (this.lock_) {
/* 200 */       this.value_ |= b;
/* 201 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int xor(int b)
/*     */   {
/* 211 */     synchronized (this.lock_) {
/* 212 */       this.value_ ^= b;
/* 213 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int compareTo(int other) {
/* 218 */     int val = get();
/* 219 */     return val == other ? 0 : val < other ? -1 : 1;
/*     */   }
/*     */ 
/*     */   public int compareTo(SynchronizedInt other) {
/* 223 */     return compareTo(other.get());
/*     */   }
/*     */ 
/*     */   public int compareTo(Object other) {
/* 227 */     return compareTo((SynchronizedInt)other);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other) {
/* 231 */     if ((other != null) && 
/* 232 */       ((other instanceof SynchronizedInt))) {
/* 233 */       return get() == ((SynchronizedInt)other).get();
/*     */     }
/* 235 */     return false;
/*     */   }
/*     */   public int hashCode() {
/* 238 */     return get();
/*     */   }
/* 240 */   public String toString() { return String.valueOf(get());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SynchronizedInt
 * JD-Core Version:    0.6.0
 */