/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class SynchronizedFloat extends SynchronizedVariable
/*     */   implements Comparable, Cloneable
/*     */ {
/*     */   protected float value_;
/*     */ 
/*     */   public SynchronizedFloat(float initialValue)
/*     */   {
/*  33 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public SynchronizedFloat(float initialValue, Object lock)
/*     */   {
/*  41 */     super(lock);
/*  42 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public final float get()
/*     */   {
/*  48 */     synchronized (this.lock_) { return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public float set(float newValue)
/*     */   {
/*  56 */     synchronized (this.lock_) {
/*  57 */       float old = this.value_;
/*  58 */       this.value_ = newValue;
/*  59 */       return old;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(float assumedValue, float newValue)
/*     */   {
/*  68 */     synchronized (this.lock_) {
/*  69 */       boolean success = assumedValue == this.value_;
/*  70 */       if (success) this.value_ = newValue;
/*  71 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public float swap(SynchronizedFloat other)
/*     */   {
/*  87 */     if (other == this) return get();
/*  88 */     SynchronizedFloat fst = this;
/*  89 */     SynchronizedFloat snd = other;
/*  90 */     if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
/*  91 */       fst = other;
/*  92 */       snd = this;
/*     */     }
/*  94 */     synchronized (fst.lock_) {
/*  95 */       synchronized (snd.lock_) {
/*  96 */         fst.set(snd.set(fst.get()));
/*  97 */         return get();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public float add(float amount)
/*     */   {
/* 108 */     synchronized (this.lock_) {
/* 109 */       return this.value_ += amount;
/*     */     }
/*     */   }
/*     */ 
/*     */   public float subtract(float amount)
/*     */   {
/* 118 */     synchronized (this.lock_) {
/* 119 */       return this.value_ -= amount;
/*     */     }
/*     */   }
/*     */ 
/*     */   public float multiply(float factor)
/*     */   {
/* 128 */     synchronized (this.lock_) {
/* 129 */       return this.value_ *= factor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public float divide(float factor)
/*     */   {
/* 138 */     synchronized (this.lock_) {
/* 139 */       return this.value_ /= factor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int compareTo(float other) {
/* 144 */     float val = get();
/* 145 */     return val == other ? 0 : val < other ? -1 : 1;
/*     */   }
/*     */ 
/*     */   public int compareTo(SynchronizedFloat other) {
/* 149 */     return compareTo(other.get());
/*     */   }
/*     */ 
/*     */   public int compareTo(Object other) {
/* 153 */     return compareTo((SynchronizedFloat)other);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other) {
/* 157 */     if ((other != null) && 
/* 158 */       ((other instanceof SynchronizedFloat))) {
/* 159 */       return get() == ((SynchronizedFloat)other).get();
/*     */     }
/* 161 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 165 */     return Float.floatToIntBits(get());
/*     */   }
/*     */   public String toString() {
/* 168 */     return String.valueOf(get());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SynchronizedFloat
 * JD-Core Version:    0.6.0
 */