/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class SynchronizedDouble extends SynchronizedVariable
/*     */   implements Comparable, Cloneable
/*     */ {
/*     */   protected double value_;
/*     */ 
/*     */   public SynchronizedDouble(double initialValue)
/*     */   {
/*  33 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public SynchronizedDouble(double initialValue, Object lock)
/*     */   {
/*  41 */     super(lock);
/*  42 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public final double get()
/*     */   {
/*  48 */     synchronized (this.lock_) { return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public double set(double newValue)
/*     */   {
/*  56 */     synchronized (this.lock_) {
/*  57 */       double old = this.value_;
/*  58 */       this.value_ = newValue;
/*  59 */       return old;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(double assumedValue, double newValue)
/*     */   {
/*  68 */     synchronized (this.lock_) {
/*  69 */       boolean success = assumedValue == this.value_;
/*  70 */       if (success) this.value_ = newValue;
/*  71 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public double swap(SynchronizedDouble other)
/*     */   {
/*  87 */     if (other == this) return get();
/*  88 */     SynchronizedDouble fst = this;
/*  89 */     SynchronizedDouble snd = other;
/*  90 */     if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
/*  91 */       fst = other;
/*  92 */       snd = this;
/*     */     }
/*  94 */     synchronized (fst.lock_) {
/*  95 */       synchronized (snd.lock_) {
/*  96 */         fst.set(snd.set(fst.get()));
/*  97 */         return get();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public double add(double amount)
/*     */   {
/* 108 */     synchronized (this.lock_) {
/* 109 */       return this.value_ += amount;
/*     */     }
/*     */   }
/*     */ 
/*     */   public double subtract(double amount)
/*     */   {
/* 118 */     synchronized (this.lock_) {
/* 119 */       return this.value_ -= amount;
/*     */     }
/*     */   }
/*     */ 
/*     */   public double multiply(double factor)
/*     */   {
/* 128 */     synchronized (this.lock_) {
/* 129 */       return this.value_ *= factor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public double divide(double factor)
/*     */   {
/* 138 */     synchronized (this.lock_) {
/* 139 */       return this.value_ /= factor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int compareTo(double other) {
/* 144 */     double val = get();
/* 145 */     return val == other ? 0 : val < other ? -1 : 1;
/*     */   }
/*     */ 
/*     */   public int compareTo(SynchronizedDouble other) {
/* 149 */     return compareTo(other.get());
/*     */   }
/*     */ 
/*     */   public int compareTo(Object other) {
/* 153 */     return compareTo((SynchronizedDouble)other);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other) {
/* 157 */     if ((other != null) && 
/* 158 */       ((other instanceof SynchronizedDouble))) {
/* 159 */       return get() == ((SynchronizedDouble)other).get();
/*     */     }
/* 161 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 165 */     long bits = Double.doubleToLongBits(get());
/* 166 */     return (int)(bits ^ bits >> 32);
/*     */   }
/*     */   public String toString() {
/* 169 */     return String.valueOf(get());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SynchronizedDouble
 * JD-Core Version:    0.6.0
 */