/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.util.Comparator;
/*     */ import java.util.SortedSet;
/*     */ 
/*     */ public class SyncSortedSet extends SyncSet
/*     */   implements SortedSet
/*     */ {
/*     */   public SyncSortedSet(SortedSet set, Sync sync)
/*     */   {
/*  35 */     super(set, sync);
/*     */   }
/*     */ 
/*     */   public SyncSortedSet(SortedSet set, ReadWriteLock rwl)
/*     */   {
/*  43 */     super(set, rwl.readLock(), rwl.writeLock());
/*     */   }
/*     */ 
/*     */   public SyncSortedSet(SortedSet set, Sync readLock, Sync writeLock)
/*     */   {
/*  51 */     super(set, readLock, writeLock);
/*     */   }
/*     */ 
/*     */   protected SortedSet baseSortedSet()
/*     */   {
/*  56 */     return (SortedSet)this.c_;
/*     */   }
/*     */ 
/*     */   public Comparator comparator() {
/*  60 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  62 */       Comparator localComparator = baseSortedSet().comparator();
/*     */       return localComparator;
/*     */     }
/*     */     finally {
/*  65 */       afterRead(wasInterrupted);
/*  66 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Object first() {
/*  70 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  72 */       Object localObject2 = baseSortedSet().first();
/*     */       return localObject2;
/*     */     }
/*     */     finally {
/*  75 */       afterRead(wasInterrupted);
/*  76 */     }throw localObject1;
/*     */   }
/*     */ 
/*     */   public Object last() {
/*  80 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  82 */       Object localObject2 = baseSortedSet().last();
/*     */       return localObject2;
/*     */     }
/*     */     finally {
/*  85 */       afterRead(wasInterrupted);
/*  86 */     }throw localObject1;
/*     */   }
/*     */ 
/*     */   public SortedSet subSet(Object fromElement, Object toElement)
/*     */   {
/*  91 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  93 */       SyncSortedSet localSyncSortedSet = new SyncSortedSet(baseSortedSet().subSet(fromElement, toElement), 
/*  94 */         this.rd_, this.wr_);
/*     */       return localSyncSortedSet;
/*     */     }
/*     */     finally
/*     */     {
/*  97 */       afterRead(wasInterrupted);
/*  98 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public SortedSet headSet(Object toElement) {
/* 102 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 104 */       SyncSortedSet localSyncSortedSet = new SyncSortedSet(baseSortedSet().headSet(toElement), 
/* 105 */         this.rd_, this.wr_);
/*     */       return localSyncSortedSet;
/*     */     }
/*     */     finally
/*     */     {
/* 108 */       afterRead(wasInterrupted);
/* 109 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public SortedSet tailSet(Object fromElement) {
/* 113 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 115 */       SyncSortedSet localSyncSortedSet = new SyncSortedSet(baseSortedSet().tailSet(fromElement), 
/* 116 */         this.rd_, this.wr_);
/*     */       return localSyncSortedSet;
/*     */     }
/*     */     finally
/*     */     {
/* 119 */       afterRead(wasInterrupted);
/* 120 */     }throw localObject;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SyncSortedSet
 * JD-Core Version:    0.6.0
 */