/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class Mutex
/*     */   implements Sync
/*     */ {
/* 112 */   protected boolean inuse_ = false;
/*     */ 
/*     */   public void acquire() throws InterruptedException {
/* 115 */     if (Thread.interrupted()) throw new InterruptedException();
/* 116 */     synchronized (this) {
/*     */       try {
/* 118 */         while (this.inuse_) wait();
/* 119 */         this.inuse_ = true;
/*     */       }
/*     */       catch (InterruptedException ex) {
/* 122 */         notify();
/* 123 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void release() {
/* 129 */     this.inuse_ = false;
/* 130 */     notify();
/*     */   }
/*     */ 
/*     */   public boolean attempt(long msecs) throws InterruptedException
/*     */   {
/* 135 */     if (Thread.interrupted()) throw new InterruptedException();
/* 136 */     synchronized (this) {
/* 137 */       if (!this.inuse_) {
/* 138 */         this.inuse_ = true;
/* 139 */         return true;
/*     */       }
/* 141 */       if (msecs <= 0L) {
/* 142 */         return false;
/*     */       }
/* 144 */       long waitTime = msecs;
/* 145 */       long start = System.currentTimeMillis();
/*     */       try {
/*     */         do {
/* 148 */           wait(waitTime);
/* 149 */           if (!this.inuse_) {
/* 150 */             this.inuse_ = true;
/* 151 */             return true;
/*     */           }
/*     */ 
/* 154 */           waitTime = msecs - (System.currentTimeMillis() - start);
/* 155 */         }while (waitTime > 0L);
/* 156 */         return false;
/*     */       }
/*     */       catch (InterruptedException ex)
/*     */       {
/* 161 */         notify();
/* 162 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.Mutex
 * JD-Core Version:    0.6.0
 */