/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class LinkedQueue
/*     */   implements Channel
/*     */ {
/*     */   protected LinkedNode head_;
/*  43 */   protected final Object putLock_ = new Object();
/*     */   protected LinkedNode last_;
/*  57 */   protected int waitingForTake_ = 0;
/*     */ 
/*     */   public LinkedQueue() {
/*  60 */     this.head_ = new LinkedNode(null);
/*  61 */     this.last_ = this.head_;
/*     */   }
/*     */ 
/*     */   protected void insert(Object x)
/*     */   {
/*  66 */     synchronized (this.putLock_) {
/*  67 */       LinkedNode p = new LinkedNode(x);
/*  68 */       synchronized (this.last_) {
/*  69 */         this.last_.next = p;
/*  70 */         this.last_ = p;
/*     */       }
/*  72 */       if (this.waitingForTake_ > 0)
/*  73 */         this.putLock_.notify();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized Object extract()
/*     */   {
/*  79 */     synchronized (this.head_) {
/*  80 */       Object x = null;
/*  81 */       LinkedNode first = this.head_.next;
/*  82 */       if (first != null) {
/*  83 */         x = first.value;
/*  84 */         first.value = null;
/*  85 */         this.head_ = first;
/*     */       }
/*  87 */       return x;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void put(Object x) throws InterruptedException
/*     */   {
/*  93 */     if (x == null) throw new IllegalArgumentException();
/*  94 */     if (Thread.interrupted()) throw new InterruptedException();
/*  95 */     insert(x);
/*     */   }
/*     */ 
/*     */   public boolean offer(Object x, long msecs) throws InterruptedException {
/*  99 */     if (x == null) throw new IllegalArgumentException();
/* 100 */     if (Thread.interrupted()) throw new InterruptedException();
/* 101 */     insert(x);
/* 102 */     return true;
/*     */   }
/*     */ 
/*     */   public Object take() throws InterruptedException {
/* 106 */     if (Thread.interrupted()) throw new InterruptedException();
/*     */ 
/* 108 */     Object x = extract();
/* 109 */     if (x != null) {
/* 110 */       return x;
/*     */     }
/* 112 */     synchronized (this.putLock_) {
/*     */       try {
/* 114 */         this.waitingForTake_ += 1;
/*     */         while (true) {
/* 116 */           x = extract();
/* 117 */           if (x != null) {
/* 118 */             this.waitingForTake_ -= 1;
/* 119 */             return x;
/*     */           }
/*     */ 
/* 122 */           this.putLock_.wait();
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ex)
/*     */       {
/* 127 */         this.waitingForTake_ -= 1;
/* 128 */         this.putLock_.notify();
/* 129 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object peek()
/*     */   {
/* 136 */     synchronized (this.head_) {
/* 137 */       LinkedNode first = this.head_.next;
/* 138 */       if (first != null) {
/* 139 */         return first.value;
/*     */       }
/* 141 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 147 */     synchronized (this.head_) {
/* 148 */       return this.head_.next == null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object poll(long msecs) throws InterruptedException {
/* 153 */     if (Thread.interrupted()) throw new InterruptedException();
/* 154 */     Object x = extract();
/* 155 */     if (x != null) {
/* 156 */       return x;
/*     */     }
/* 158 */     synchronized (this.putLock_) {
/*     */       try {
/* 160 */         long waitTime = msecs;
/* 161 */         long start = msecs <= 0L ? 0L : System.currentTimeMillis();
/* 162 */         this.waitingForTake_ += 1;
/*     */         while (true) {
/* 164 */           x = extract();
/* 165 */           if ((x != null) || (waitTime <= 0L)) {
/* 166 */             this.waitingForTake_ -= 1;
/* 167 */             return x;
/*     */           }
/*     */ 
/* 170 */           this.putLock_.wait(waitTime);
/* 171 */           waitTime = msecs - (System.currentTimeMillis() - start);
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ex)
/*     */       {
/* 176 */         this.waitingForTake_ -= 1;
/* 177 */         this.putLock_.notify();
/* 178 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.LinkedQueue
 * JD-Core Version:    0.6.0
 */