/*    */ package EDU.oswego.cs.dl.util.concurrent;
/*    */ 
/*    */ public class Latch
/*    */   implements Sync
/*    */ {
/* 48 */   protected boolean latched_ = false;
/*    */ 
/*    */   public void acquire()
/*    */     throws InterruptedException
/*    */   {
/* 61 */     if (Thread.interrupted()) throw new InterruptedException();
/* 62 */     synchronized (this) {
/* 63 */       while (!this.latched_)
/* 64 */         wait();
/*    */     }
/*    */   }
/*    */ 
/*    */   public boolean attempt(long msecs) throws InterruptedException {
/* 69 */     if (Thread.interrupted()) throw new InterruptedException();
/* 70 */     synchronized (this) {
/* 71 */       if (this.latched_)
/* 72 */         return true;
/* 73 */       if (msecs <= 0L) {
/* 74 */         return false;
/*    */       }
/* 76 */       long waitTime = msecs;
/* 77 */       long start = System.currentTimeMillis();
/*    */       do {
/* 79 */         wait(waitTime);
/* 80 */         if (this.latched_) {
/* 81 */           return true;
/*    */         }
/* 83 */         waitTime = msecs - (System.currentTimeMillis() - start);
/* 84 */       }while (waitTime > 0L);
/* 85 */       return false;
/*    */     }
/*    */   }
/*    */ 
/*    */   public synchronized void release()
/*    */   {
/* 94 */     this.latched_ = true;
/* 95 */     notifyAll();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.Latch
 * JD-Core Version:    0.6.0
 */