/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ 
/*     */ public class FutureResult
/*     */ {
/*  49 */   protected Object value_ = null;
/*     */ 
/*  52 */   protected boolean ready_ = false;
/*     */ 
/*  55 */   protected InvocationTargetException exception_ = null;
/*     */ 
/*     */   public Runnable setter(Callable function)
/*     */   {
/*  72 */     return new Runnable(function) {
/*     */       public void run() {
/*     */         try {
/*  75 */           FutureResult.this.set(this.val$function.call());
/*     */         }
/*     */         catch (Throwable ex) {
/*  78 */           FutureResult.this.setException(ex);
/*     */         }
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   protected Object doGet() throws InvocationTargetException {
/*  86 */     if (this.exception_ != null) {
/*  87 */       throw this.exception_;
/*     */     }
/*  89 */     return this.value_;
/*     */   }
/*     */ 
/*     */   public synchronized Object get()
/*     */     throws InterruptedException, InvocationTargetException
/*     */   {
/* 101 */     while (!this.ready_) wait();
/* 102 */     return doGet();
/*     */   }
/*     */ 
/*     */   public synchronized Object timedGet(long msecs)
/*     */     throws TimeoutException, InterruptedException, InvocationTargetException
/*     */   {
/* 117 */     long startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
/* 118 */     long waitTime = msecs;
/* 119 */     if (this.ready_) return doGet();
/* 120 */     if (waitTime <= 0L) throw new TimeoutException(msecs);
/*     */     do
/*     */     {
/* 123 */       wait(waitTime);
/* 124 */       if (this.ready_) return doGet();
/*     */ 
/* 126 */       waitTime = msecs - (System.currentTimeMillis() - startTime);
/* 127 */     }while (waitTime > 0L);
/* 128 */     throw new TimeoutException(msecs);
/*     */   }
/*     */ 
/*     */   public synchronized void set(Object newValue)
/*     */   {
/* 141 */     this.value_ = newValue;
/* 142 */     this.ready_ = true;
/* 143 */     notifyAll();
/*     */   }
/*     */ 
/*     */   public synchronized void setException(Throwable ex)
/*     */   {
/* 152 */     this.exception_ = new InvocationTargetException(ex);
/* 153 */     this.ready_ = true;
/* 154 */     notifyAll();
/*     */   }
/*     */ 
/*     */   public synchronized InvocationTargetException getException()
/*     */   {
/* 166 */     return this.exception_;
/*     */   }
/*     */ 
/*     */   public synchronized boolean isReady()
/*     */   {
/* 174 */     return this.ready_;
/*     */   }
/*     */ 
/*     */   public synchronized Object peek()
/*     */   {
/* 182 */     return this.value_;
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/* 194 */     this.value_ = null;
/* 195 */     this.exception_ = null;
/* 196 */     this.ready_ = false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.FutureResult
 * JD-Core Version:    0.6.0
 */