/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ 
/*     */ public class FJTaskRunnerGroup
/*     */   implements Executor
/*     */ {
/*     */   protected final FJTaskRunner[] threads;
/* 128 */   protected final LinkedQueue entryQueue = new LinkedQueue();
/*     */ 
/* 131 */   protected int activeCount = 0;
/*     */ 
/* 136 */   protected int nstarted = 0;
/*     */   static final boolean COLLECT_STATS = true;
/* 151 */   long initTime = 0L;
/*     */ 
/* 154 */   int entries = 0;
/*     */   static final int DEFAULT_SCAN_PRIORITY = 2;
/*     */   static final long SCANS_PER_SLEEP = 15L;
/*     */   static final long MAX_SLEEP_TIME = 100L;
/*     */ 
/*     */   public FJTaskRunnerGroup(int groupSize)
/*     */   {
/* 169 */     this.threads = new FJTaskRunner[groupSize];
/* 170 */     initializeThreads();
/* 171 */     this.initTime = System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   public void execute(Runnable r)
/*     */     throws InterruptedException
/*     */   {
/* 184 */     if ((r instanceof FJTask)) {
/* 185 */       this.entryQueue.put((FJTask)r);
/*     */     }
/*     */     else {
/* 188 */       this.entryQueue.put(new FJTask.Wrap(r));
/*     */     }
/* 190 */     signalNewTask();
/*     */   }
/*     */ 
/*     */   public void executeTask(FJTask t)
/*     */   {
/*     */     try
/*     */     {
/* 199 */       this.entryQueue.put(t);
/* 200 */       signalNewTask();
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 203 */       Thread.currentThread().interrupt();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void invoke(Runnable r)
/*     */     throws InterruptedException
/*     */   {
/* 215 */     InvokableFJTask w = new InvokableFJTask(r);
/* 216 */     this.entryQueue.put(w);
/* 217 */     signalNewTask();
/* 218 */     w.awaitTermination();
/*     */   }
/*     */ 
/*     */   public void interruptAll()
/*     */   {
/* 237 */     Thread current = Thread.currentThread();
/* 238 */     boolean stopCurrent = false;
/*     */ 
/* 240 */     for (int i = 0; i < this.threads.length; i++) {
/* 241 */       Thread t = this.threads[i];
/* 242 */       if (t == current)
/* 243 */         stopCurrent = true;
/*     */       else
/* 245 */         t.interrupt();
/*     */     }
/* 247 */     if (stopCurrent)
/* 248 */       current.interrupt();
/*     */   }
/*     */ 
/*     */   public synchronized void setScanPriorities(int pri)
/*     */   {
/* 260 */     for (int i = 0; i < this.threads.length; i++) {
/* 261 */       FJTaskRunner t = this.threads[i];
/* 262 */       t.setScanPriority(pri);
/* 263 */       if (t.active) continue; t.setPriority(pri);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void setRunPriorities(int pri)
/*     */   {
/* 277 */     for (int i = 0; i < this.threads.length; i++) {
/* 278 */       FJTaskRunner t = this.threads[i];
/* 279 */       t.setRunPriority(pri);
/* 280 */       if (!t.active) continue; t.setPriority(pri);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 288 */     return this.threads.length;
/*     */   }
/*     */ 
/*     */   public synchronized int getActiveCount()
/*     */   {
/* 298 */     return this.activeCount;
/*     */   }
/*     */ 
/*     */   public void stats()
/*     */   {
/* 368 */     long time = System.currentTimeMillis() - this.initTime;
/* 369 */     double secs = time / 1000.0D;
/* 370 */     long totalRuns = 0L;
/* 371 */     long totalScans = 0L;
/* 372 */     long totalSteals = 0L;
/*     */ 
/* 374 */     System.out.print("Thread\tQ Cap\tScans\tNew\tRuns\n");
/*     */ 
/* 381 */     for (int i = 0; i < this.threads.length; i++) {
/* 382 */       FJTaskRunner t = this.threads[i];
/* 383 */       int truns = t.runs;
/* 384 */       totalRuns += truns;
/*     */ 
/* 386 */       int tscans = t.scans;
/* 387 */       totalScans += tscans;
/*     */ 
/* 389 */       int tsteals = t.steals;
/* 390 */       totalSteals += tsteals;
/*     */ 
/* 392 */       String star = getActive(t) ? "*" : " ";
/*     */ 
/* 395 */       System.out.print("T" + i + star + 
/* 396 */         "\t" + t.deqSize() + 
/* 397 */         "\t" + tscans + 
/* 398 */         "\t" + tsteals + 
/* 399 */         "\t" + truns + 
/* 400 */         "\n");
/*     */     }
/*     */ 
/* 403 */     System.out.print("Total\t    \t" + 
/* 405 */       totalScans + 
/* 406 */       "\t" + totalSteals + 
/* 407 */       "\t" + totalRuns + 
/* 408 */       "\n");
/*     */ 
/* 410 */     System.out.print("Execute: " + this.entries);
/*     */ 
/* 412 */     System.out.print("\tTime: " + secs);
/*     */ 
/* 414 */     long rps = 0L;
/* 415 */     if (secs != 0.0D) rps = Math.round(totalRuns / secs);
/*     */ 
/* 417 */     System.out.println("\tRate: " + rps);
/*     */   }
/*     */ 
/*     */   protected FJTaskRunner[] getArray()
/*     */   {
/* 429 */     return this.threads;
/*     */   }
/*     */ 
/*     */   protected FJTask pollEntryQueue()
/*     */   {
/*     */     try
/*     */     {
/* 439 */       FJTask t = (FJTask)this.entryQueue.poll(0L);
/* 440 */       return t;
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 443 */       Thread.currentThread().interrupt();
/* 444 */     }return null;
/*     */   }
/*     */ 
/*     */   protected synchronized boolean getActive(FJTaskRunner t)
/*     */   {
/* 456 */     return t.active;
/*     */   }
/*     */ 
/*     */   protected synchronized void setActive(FJTaskRunner t)
/*     */   {
/* 466 */     if (!t.active) {
/* 467 */       t.active = true;
/* 468 */       this.activeCount += 1;
/* 469 */       if (this.nstarted < this.threads.length)
/* 470 */         this.threads[(this.nstarted++)].start();
/*     */       else
/* 472 */         notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized void setInactive(FJTaskRunner t)
/*     */   {
/* 481 */     if (t.active) {
/* 482 */       t.active = false;
/* 483 */       this.activeCount -= 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized void checkActive(FJTaskRunner t, long scans)
/*     */   {
/* 536 */     setInactive(t);
/*     */     try
/*     */     {
/* 540 */       if ((this.activeCount == 0) && (this.entryQueue.peek() == null)) {
/* 541 */         wait();
/*     */       }
/*     */       else
/*     */       {
/* 547 */         long msecs = scans / 15L;
/* 548 */         if (msecs > 100L) msecs = 100L;
/* 549 */         int nsecs = msecs == 0L ? 1 : 0;
/* 550 */         wait(msecs, nsecs);
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 554 */       notify();
/* 555 */       Thread.currentThread().interrupt();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized void signalNewTask()
/*     */   {
/* 566 */     this.entries += 1;
/* 567 */     if (this.nstarted < this.threads.length)
/* 568 */       this.threads[(this.nstarted++)].start();
/*     */     else
/* 570 */       notify();
/*     */   }
/*     */ 
/*     */   protected void initializeThreads()
/*     */   {
/* 578 */     for (int i = 0; i < this.threads.length; i++) this.threads[i] = new FJTaskRunner(this);
/*     */   }
/*     */ 
/*     */   protected static final class InvokableFJTask extends FJTask
/*     */   {
/*     */     protected final Runnable wrapped;
/* 590 */     protected boolean terminated = false;
/*     */ 
/* 592 */     protected InvokableFJTask(Runnable r) { this.wrapped = r; }
/*     */ 
/*     */     public void run() {
/*     */       try {
/* 596 */         if ((this.wrapped instanceof FJTask))
/* 597 */           FJTask.invoke((FJTask)this.wrapped);
/*     */         else
/* 599 */           this.wrapped.run();
/*     */       }
/*     */       finally {
/* 602 */         setTerminated();
/*     */       }
/*     */     }
/*     */ 
/*     */     protected synchronized void setTerminated() {
/* 607 */       this.terminated = true;
/* 608 */       notifyAll();
/*     */     }
/*     */ 
/*     */     protected synchronized void awaitTermination() throws InterruptedException {
/* 612 */       while (!this.terminated) wait();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup
 * JD-Core Version:    0.6.0
 */