/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.util.Random;
/*     */ 
/*     */ public class FJTaskRunner extends Thread
/*     */ {
/*     */   protected final FJTaskRunnerGroup group;
/*     */   protected static final int INITIAL_CAPACITY = 4096;
/*     */   protected static final int MAX_CAPACITY = 1073741824;
/* 285 */   protected VolatileTaskRef[] deq = VolatileTaskRef.newArray(4096);
/*     */ 
/* 300 */   protected volatile int top = 0;
/*     */ 
/* 308 */   protected volatile int base = 0;
/*     */ 
/* 316 */   protected final Object barrier = new Object();
/*     */ 
/* 327 */   protected boolean active = false;
/*     */   protected final Random victimRNG;
/* 334 */   protected int scanPriority = 2;
/*     */   protected int runPriority;
/*     */   static final boolean COLLECT_STATS = true;
/* 371 */   protected int runs = 0;
/*     */ 
/* 374 */   protected int scans = 0;
/*     */ 
/* 377 */   protected int steals = 0;
/*     */ 
/*     */   protected FJTaskRunner(FJTaskRunnerGroup g)
/*     */   {
/* 219 */     this.group = g;
/* 220 */     this.victimRNG = new Random(System.identityHashCode(this));
/* 221 */     this.runPriority = getPriority();
/* 222 */     setDaemon(true);
/*     */   }
/*     */ 
/*     */   protected final FJTaskRunnerGroup getGroup()
/*     */   {
/* 229 */     return this.group;
/*     */   }
/*     */ 
/*     */   protected int deqSize()
/*     */   {
/* 288 */     return this.deq.length;
/*     */   }
/*     */ 
/*     */   protected void setScanPriority(int pri)
/*     */   {
/* 347 */     this.scanPriority = pri;
/*     */   }
/*     */ 
/*     */   protected void setRunPriority(int pri)
/*     */   {
/* 354 */     this.runPriority = pri;
/*     */   }
/*     */ 
/*     */   protected final void push(FJTask r)
/*     */   {
/* 391 */     int t = this.top;
/*     */ 
/* 401 */     if (t < (this.base & this.deq.length - 1) + this.deq.length)
/*     */     {
/* 403 */       this.deq[(t & this.deq.length - 1)].put(r);
/* 404 */       this.top = (t + 1);
/*     */     }
/*     */     else
/*     */     {
/* 408 */       slowPush(r);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized void slowPush(FJTask r)
/*     */   {
/* 417 */     checkOverflow();
/* 418 */     push(r);
/*     */   }
/*     */ 
/*     */   protected final synchronized void put(FJTask r)
/*     */   {
/*     */     while (true)
/*     */     {
/* 432 */       int b = this.base - 1;
/* 433 */       if (this.top < b + this.deq.length)
/*     */       {
/* 435 */         int newBase = b & this.deq.length - 1;
/* 436 */         this.deq[newBase].put(r);
/* 437 */         this.base = newBase;
/*     */ 
/* 439 */         if (b != newBase) {
/* 440 */           int newTop = this.top & this.deq.length - 1;
/* 441 */           if (newTop < newBase) newTop += this.deq.length;
/* 442 */           this.top = newTop;
/*     */         }
/* 444 */         return;
/*     */       }
/*     */ 
/* 447 */       checkOverflow();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected final FJTask pop()
/*     */   {
/* 471 */     int t = --this.top;
/*     */ 
/* 482 */     if (this.base + 1 < t) {
/* 483 */       return this.deq[(t & this.deq.length - 1)].take();
/*     */     }
/* 485 */     return confirmPop(t);
/*     */   }
/*     */ 
/*     */   protected final synchronized FJTask confirmPop(int provisionalTop)
/*     */   {
/* 496 */     if (this.base <= provisionalTop) {
/* 497 */       return this.deq[(provisionalTop & this.deq.length - 1)].take();
/*     */     }
/*     */ 
/* 505 */     this.top = (this.base = 0);
/* 506 */     return null;
/*     */   }
/*     */ 
/*     */   protected final synchronized FJTask take()
/*     */   {
/* 523 */     int b = this.base++;
/*     */ 
/* 525 */     if (b < this.top) {
/* 526 */       return confirmTake(b);
/*     */     }
/*     */ 
/* 529 */     this.base = b;
/* 530 */     return null;
/*     */   }
/*     */ 
/*     */   protected FJTask confirmTake(int oldBase)
/*     */   {
/* 547 */     synchronized (this.barrier) {
/* 548 */       if (oldBase < this.top)
/*     */       {
/* 558 */         return this.deq[(oldBase & this.deq.length - 1)].get();
/*     */       }
/*     */ 
/* 561 */       this.base = oldBase;
/* 562 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void checkOverflow()
/*     */   {
/* 576 */     int t = this.top;
/* 577 */     int b = this.base;
/*     */ 
/* 579 */     if (t - b < this.deq.length - 1)
/*     */     {
/* 581 */       int newBase = b & this.deq.length - 1;
/* 582 */       int newTop = this.top & this.deq.length - 1;
/* 583 */       if (newTop < newBase) newTop += this.deq.length;
/* 584 */       this.top = newTop;
/* 585 */       this.base = newBase;
/*     */ 
/* 592 */       int i = newBase;
/*     */       do {
/* 594 */         this.deq[i].ref = null;
/* 595 */         i = i - 1 & this.deq.length - 1;
/*     */ 
/* 593 */         if (i == newTop) break; 
/* 593 */       }while (this.deq[i].ref != null);
/*     */     }
/*     */     else
/*     */     {
/* 601 */       int newTop = t - b;
/* 602 */       int oldcap = this.deq.length;
/* 603 */       int newcap = oldcap * 2;
/*     */ 
/* 605 */       if (newcap >= 1073741824) {
/* 606 */         throw new Error("FJTask queue maximum capacity exceeded");
/*     */       }
/* 608 */       VolatileTaskRef[] newdeq = new VolatileTaskRef[newcap];
/*     */ 
/* 611 */       for (int j = 0; j < oldcap; j++) newdeq[j] = this.deq[(b++ & oldcap - 1)];
/*     */ 
/* 614 */       for (int j = oldcap; j < newcap; j++) newdeq[j] = new VolatileTaskRef();
/*     */ 
/* 616 */       this.deq = newdeq;
/* 617 */       this.base = 0;
/* 618 */       this.top = newTop;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void scan(FJTask waitingFor)
/*     */   {
/* 641 */     FJTask task = null;
/*     */ 
/* 644 */     boolean lowered = false;
/*     */ 
/* 656 */     FJTaskRunner[] ts = this.group.getArray();
/* 657 */     int idx = this.victimRNG.nextInt(ts.length);
/*     */ 
/* 659 */     for (int i = 0; i < ts.length; i++)
/*     */     {
/* 661 */       FJTaskRunner t = ts[idx];
/* 662 */       idx++; if (idx >= ts.length) idx = 0;
/*     */ 
/* 664 */       if ((t == null) || (t == this))
/*     */         continue;
/* 666 */       if ((waitingFor != null) && (waitingFor.isDone()))
/*     */       {
/*     */         break;
/*     */       }
/* 670 */       this.scans += 1;
/* 671 */       task = t.take();
/* 672 */       if (task != null) {
/* 673 */         this.steals += 1;
/* 674 */         break;
/*     */       }
/* 676 */       if (isInterrupted()) {
/*     */         break;
/*     */       }
/* 679 */       if (!lowered) {
/* 680 */         lowered = true;
/* 681 */         setPriority(this.scanPriority);
/*     */       }
/*     */       else {
/* 684 */         yield();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 691 */     if (task == null) {
/* 692 */       this.scans += 1;
/* 693 */       task = this.group.pollEntryQueue();
/* 694 */       if (task != null) this.steals += 1;
/*     */     }
/*     */ 
/* 697 */     if (lowered) setPriority(this.runPriority);
/*     */ 
/* 699 */     if ((task != null) && (!task.isDone())) {
/* 700 */       this.runs += 1;
/* 701 */       task.run();
/* 702 */       task.setDone();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void scanWhileIdling()
/*     */   {
/* 719 */     FJTask task = null;
/*     */ 
/* 721 */     boolean lowered = false;
/* 722 */     long iters = 0L;
/*     */ 
/* 724 */     FJTaskRunner[] ts = this.group.getArray();
/* 725 */     int idx = this.victimRNG.nextInt(ts.length);
/*     */     do
/*     */     {
/* 728 */       for (int i = 0; i < ts.length; i++)
/*     */       {
/* 730 */         FJTaskRunner t = ts[idx];
/* 731 */         idx++; if (idx >= ts.length) idx = 0;
/*     */ 
/* 733 */         if ((t != null) && (t != this)) {
/* 734 */           this.scans += 1;
/*     */ 
/* 736 */           task = t.take();
/* 737 */           if (task != null) {
/* 738 */             this.steals += 1;
/* 739 */             if (lowered) setPriority(this.runPriority);
/* 740 */             this.group.setActive(this);
/* 741 */             break;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 746 */       if (task == null) {
/* 747 */         if (isInterrupted()) {
/* 748 */           return;
/*     */         }
/* 750 */         this.scans += 1;
/* 751 */         task = this.group.pollEntryQueue();
/*     */ 
/* 753 */         if (task != null) {
/* 754 */           this.steals += 1;
/* 755 */           if (lowered) setPriority(this.runPriority);
/* 756 */           this.group.setActive(this);
/*     */         }
/*     */         else {
/* 759 */           iters += 1L;
/*     */ 
/* 761 */           if (iters >= 15L) {
/* 762 */             this.group.checkActive(this, iters);
/* 763 */             if (isInterrupted())
/* 764 */               return;
/*     */           }
/* 766 */           else if (!lowered) {
/* 767 */             lowered = true;
/* 768 */             setPriority(this.scanPriority);
/*     */           }
/*     */           else {
/* 771 */             yield();
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 775 */     while (task == null);
/*     */ 
/* 778 */     if (!task.isDone()) {
/* 779 */       this.runs += 1;
/* 780 */       task.run();
/* 781 */       task.setDone();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     try
/*     */     {
/* 795 */       while (!interrupted())
/*     */       {
/* 797 */         FJTask task = pop();
/* 798 */         if (task != null) {
/* 799 */           if (task.isDone())
/*     */             continue;
/* 801 */           this.runs += 1;
/* 802 */           task.run();
/* 803 */           task.setDone();
/*     */         }
/*     */         else
/*     */         {
/* 807 */           scanWhileIdling();
/*     */         }
/*     */       }
/*     */     } finally {
/* 811 */       this.group.setInactive(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected final void taskYield()
/*     */   {
/* 822 */     FJTask task = pop();
/* 823 */     if (task != null) {
/* 824 */       if (!task.isDone()) {
/* 825 */         this.runs += 1;
/* 826 */         task.run();
/* 827 */         task.setDone();
/*     */       }
/*     */     }
/*     */     else
/* 831 */       scan(null);
/*     */   }
/*     */ 
/*     */   protected final void taskJoin(FJTask w)
/*     */   {
/* 842 */     while (!w.isDone())
/*     */     {
/* 844 */       FJTask task = pop();
/* 845 */       if (task != null) {
/* 846 */         if (!task.isDone()) {
/* 847 */           this.runs += 1;
/* 848 */           task.run();
/* 849 */           task.setDone();
/* 850 */           if (task == w) return;
/*     */         }
/*     */       }
/*     */       else
/* 854 */         scan(w);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected final void coInvoke(FJTask w, FJTask v)
/*     */   {
/* 868 */     int t = this.top;
/* 869 */     if (t < (this.base & this.deq.length - 1) + this.deq.length)
/*     */     {
/* 871 */       this.deq[(t & this.deq.length - 1)].put(w);
/* 872 */       this.top = (t + 1);
/*     */ 
/* 876 */       if (!v.isDone()) {
/* 877 */         this.runs += 1;
/* 878 */         v.run();
/* 879 */         v.setDone();
/*     */       }
/*     */ 
/* 884 */       while (!w.isDone()) {
/* 885 */         FJTask task = pop();
/* 886 */         if (task != null) {
/* 887 */           if (!task.isDone()) {
/* 888 */             this.runs += 1;
/* 889 */             task.run();
/* 890 */             task.setDone();
/* 891 */             if (task == w) return;
/*     */           }
/*     */         }
/*     */         else
/* 895 */           scan(w);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 900 */       slowCoInvoke(w, v);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void slowCoInvoke(FJTask w, FJTask v)
/*     */   {
/* 909 */     push(w);
/* 910 */     FJTask.invoke(v);
/* 911 */     taskJoin(w);
/*     */   }
/*     */ 
/*     */   protected final void coInvoke(FJTask[] tasks)
/*     */   {
/* 920 */     int nforks = tasks.length - 1;
/*     */ 
/* 924 */     int t = this.top;
/*     */ 
/* 926 */     if ((nforks >= 0) && (t + nforks < (this.base & this.deq.length - 1) + this.deq.length)) {
/* 927 */       for (int i = 0; i < nforks; i++) {
/* 928 */         this.deq[(t++ & this.deq.length - 1)].put(tasks[i]);
/* 929 */         this.top = t;
/*     */       }
/*     */ 
/* 933 */       FJTask v = tasks[nforks];
/* 934 */       if (!v.isDone()) {
/* 935 */         this.runs += 1;
/* 936 */         v.run();
/* 937 */         v.setDone();
/*     */       }
/*     */ 
/* 942 */       for (int i = 0; i < nforks; i++) {
/* 943 */         FJTask w = tasks[i];
/* 944 */         while (!w.isDone())
/*     */         {
/* 946 */           FJTask task = pop();
/* 947 */           if (task != null) {
/* 948 */             if (!task.isDone()) {
/* 949 */               this.runs += 1;
/* 950 */               task.run();
/* 951 */               task.setDone();
/*     */             }
/*     */           }
/*     */           else
/* 955 */             scan(w);
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 961 */       slowCoInvoke(tasks);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void slowCoInvoke(FJTask[] tasks)
/*     */   {
/* 969 */     for (int i = 0; i < tasks.length; i++) push(tasks[i]);
/* 970 */     for (int i = 0; i < tasks.length; i++) taskJoin(tasks[i]);
/*     */   }
/*     */ 
/*     */   protected static final class VolatileTaskRef
/*     */   {
/*     */     protected volatile FJTask ref;
/*     */ 
/*     */     protected final void put(FJTask r)
/*     */     {
/* 262 */       this.ref = r;
/*     */     }
/* 264 */     protected final FJTask get() { return this.ref; } 
/*     */     protected final FJTask take() {
/* 266 */       FJTask r = this.ref; this.ref = null; return r;
/*     */     }
/*     */ 
/*     */     protected static VolatileTaskRef[] newArray(int cap)
/*     */     {
/* 274 */       VolatileTaskRef[] a = new VolatileTaskRef[cap];
/* 275 */       for (int k = 0; k < cap; k++) a[k] = new VolatileTaskRef();
/* 276 */       return a;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.FJTaskRunner
 * JD-Core Version:    0.6.0
 */