/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public abstract class FJTask
/*     */   implements Runnable
/*     */ {
/*     */   private volatile boolean done;
/*     */ 
/*     */   public static FJTaskRunner getFJTaskRunner()
/*     */   {
/* 154 */     return (FJTaskRunner)Thread.currentThread();
/*     */   }
/*     */ 
/*     */   public static FJTaskRunnerGroup getFJTaskRunnerGroup()
/*     */   {
/* 163 */     return getFJTaskRunner().getGroup();
/*     */   }
/*     */ 
/*     */   public final boolean isDone()
/*     */   {
/* 176 */     return this.done;
/*     */   }
/*     */ 
/*     */   protected final void setDone()
/*     */   {
/* 184 */     this.done = true;
/*     */   }
/*     */ 
/*     */   public void cancel()
/*     */   {
/* 197 */     setDone();
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 210 */     this.done = false;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 225 */     getFJTaskRunnerGroup().executeTask(this);
/*     */   }
/*     */ 
/*     */   public void fork()
/*     */   {
/* 250 */     getFJTaskRunner().push(this);
/*     */   }
/*     */ 
/*     */   public static void yield()
/*     */   {
/* 279 */     getFJTaskRunner().taskYield();
/*     */   }
/*     */ 
/*     */   public void join()
/*     */   {
/* 288 */     getFJTaskRunner().taskJoin(this);
/*     */   }
/*     */ 
/*     */   public static void invoke(FJTask t)
/*     */   {
/* 302 */     if (!t.isDone()) {
/* 303 */       t.run();
/* 304 */       t.setDone();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void coInvoke(FJTask task1, FJTask task2)
/*     */   {
/* 368 */     getFJTaskRunner().coInvoke(task1, task2);
/*     */   }
/*     */ 
/*     */   public static void coInvoke(FJTask[] tasks)
/*     */   {
/* 382 */     getFJTaskRunner().coInvoke(tasks);
/*     */   }
/*     */ 
/*     */   public static FJTask seq(FJTask[] tasks)
/*     */   {
/* 433 */     return new Seq(tasks);
/*     */   }
/*     */ 
/*     */   public static FJTask par(FJTask[] tasks)
/*     */   {
/* 473 */     return new Par(tasks);
/*     */   }
/*     */ 
/*     */   public static FJTask seq(FJTask task1, FJTask task2)
/*     */   {
/* 501 */     return new Seq2(task1, task2);
/*     */   }
/*     */ 
/*     */   public static FJTask par(FJTask task1, FJTask task2)
/*     */   {
/* 528 */     return new Par2(task1, task2);
/*     */   }
/*     */ 
/*     */   public static class Par extends FJTask
/*     */   {
/*     */     protected final FJTask[] tasks;
/*     */ 
/*     */     public Par(FJTask[] tasks)
/*     */     {
/* 451 */       this.tasks = tasks;
/*     */     }
/*     */ 
/*     */     public Par(FJTask task1, FJTask task2)
/*     */     {
/* 458 */       this.tasks = new FJTask[] { task1, task2 };
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 463 */       FJTask.coInvoke(this.tasks);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Par2 extends FJTask
/*     */   {
/*     */     protected final FJTask fst;
/*     */     protected final FJTask snd;
/*     */ 
/*     */     public Par2(FJTask task1, FJTask task2)
/*     */     {
/* 514 */       this.fst = task1;
/* 515 */       this.snd = task2;
/*     */     }
/*     */     public void run() {
/* 518 */       FJTask.coInvoke(this.fst, this.snd);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Seq extends FJTask
/*     */   {
/*     */     protected final FJTask[] tasks;
/*     */ 
/*     */     public Seq(FJTask[] tasks)
/*     */     {
/* 412 */       this.tasks = tasks;
/*     */     }
/*     */ 
/*     */     public Seq(FJTask task1, FJTask task2)
/*     */     {
/* 419 */       this.tasks = new FJTask[] { task1, task2 };
/*     */     }
/*     */ 
/*     */     public void run() {
/* 423 */       for (int i = 0; i < this.tasks.length; i++) FJTask.invoke(this.tasks[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Seq2 extends FJTask
/*     */   {
/*     */     protected final FJTask fst;
/*     */     protected final FJTask snd;
/*     */ 
/*     */     public Seq2(FJTask task1, FJTask task2)
/*     */     {
/* 486 */       this.fst = task1;
/* 487 */       this.snd = task2;
/*     */     }
/*     */     public void run() {
/* 490 */       FJTask.invoke(this.fst);
/* 491 */       FJTask.invoke(this.snd);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Wrap extends FJTask
/*     */   {
/*     */     protected final Runnable runnable;
/*     */ 
/*     */     public Wrap(Runnable r)
/*     */     {
/* 393 */       this.runnable = r; } 
/* 394 */     public void run() { this.runnable.run();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.FJTask
 * JD-Core Version:    0.6.0
 */