/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class CyclicBarrier
/*     */   implements Barrier
/*     */ {
/*     */   protected final int parties_;
/*  89 */   protected boolean broken_ = false;
/*  90 */   protected Runnable barrierCommand_ = null;
/*     */   protected int count_;
/*  92 */   protected int resets_ = 0;
/*     */ 
/*     */   public CyclicBarrier(int parties)
/*     */   {
/* 100 */     this(parties, null);
/*     */   }
/*     */ 
/*     */   public CyclicBarrier(int parties, Runnable command)
/*     */   {
/* 109 */     if (parties <= 0) throw new IllegalArgumentException();
/* 110 */     this.parties_ = parties;
/* 111 */     this.count_ = parties;
/* 112 */     this.barrierCommand_ = command;
/*     */   }
/*     */ 
/*     */   public synchronized Runnable setBarrierCommand(Runnable command)
/*     */   {
/* 125 */     Runnable old = this.barrierCommand_;
/* 126 */     this.barrierCommand_ = command;
/* 127 */     return old;
/*     */   }
/*     */   public synchronized boolean broken() {
/* 130 */     return this.broken_;
/*     */   }
/*     */ 
/*     */   public synchronized void restart()
/*     */   {
/* 143 */     this.broken_ = false;
/* 144 */     this.resets_ += 1;
/* 145 */     this.count_ = this.parties_;
/* 146 */     notifyAll();
/*     */   }
/*     */ 
/*     */   public int parties() {
/* 150 */     return this.parties_;
/*     */   }
/*     */ 
/*     */   public int barrier()
/*     */     throws InterruptedException, BrokenBarrierException
/*     */   {
/* 178 */     return doBarrier(false, 0L);
/*     */   }
/*     */ 
/*     */   public int attemptBarrier(long msecs)
/*     */     throws InterruptedException, TimeoutException, BrokenBarrierException
/*     */   {
/* 211 */     return doBarrier(true, msecs);
/*     */   }
/*     */ 
/*     */   protected synchronized int doBarrier(boolean timed, long msecs)
/*     */     throws InterruptedException, TimeoutException, BrokenBarrierException
/*     */   {
/* 217 */     int index = --this.count_;
/*     */ 
/* 219 */     if (this.broken_) {
/* 220 */       throw new BrokenBarrierException(index);
/*     */     }
/* 222 */     if (Thread.interrupted()) {
/* 223 */       this.broken_ = true;
/* 224 */       notifyAll();
/* 225 */       throw new InterruptedException();
/*     */     }
/* 227 */     if (index == 0) {
/* 228 */       this.count_ = this.parties_;
/* 229 */       this.resets_ += 1;
/* 230 */       notifyAll();
/*     */       try {
/* 232 */         if (this.barrierCommand_ != null)
/* 233 */           this.barrierCommand_.run();
/* 234 */         return 0;
/*     */       }
/*     */       catch (RuntimeException ex) {
/* 237 */         this.broken_ = true;
/* 238 */         return 0;
/*     */       }
/*     */     }
/* 241 */     if ((timed) && (msecs <= 0L)) {
/* 242 */       this.broken_ = true;
/* 243 */       notifyAll();
/* 244 */       throw new TimeoutException(msecs);
/*     */     }
/*     */ 
/* 247 */     int r = this.resets_;
/* 248 */     long startTime = timed ? System.currentTimeMillis() : 0L;
/* 249 */     long waitTime = msecs;
/*     */     do {
/*     */       do {
/*     */         try { wait(waitTime);
/*     */         }
/*     */         catch (InterruptedException ex)
/*     */         {
/* 256 */           if (this.resets_ == r) {
/* 257 */             this.broken_ = true;
/* 258 */             notifyAll();
/* 259 */             throw ex;
/*     */           }
/*     */ 
/* 262 */           Thread.currentThread().interrupt();
/*     */         }
/*     */ 
/* 266 */         if (this.broken_) {
/* 267 */           throw new BrokenBarrierException(index);
/*     */         }
/* 269 */         if (r != this.resets_)
/* 270 */           return index;
/*     */       }
/* 272 */       while (!timed);
/* 273 */       waitTime = msecs - (System.currentTimeMillis() - startTime);
/* 274 */     }while (waitTime > 0L);
/* 275 */     this.broken_ = true;
/* 276 */     notifyAll();
/* 277 */     throw new TimeoutException(msecs);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.CyclicBarrier
 * JD-Core Version:    0.6.0
 */