/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class CountDown
/*     */   implements Sync
/*     */ {
/*     */   protected final int initialCount_;
/*     */   protected int count_;
/*     */ 
/*     */   public CountDown(int count)
/*     */   {
/*  60 */     this.count_ = (this.initialCount_ = count);
/*     */   }
/*     */ 
/*     */   public void acquire()
/*     */     throws InterruptedException
/*     */   {
/*  69 */     if (Thread.interrupted()) throw new InterruptedException();
/*  70 */     synchronized (this) {
/*  71 */       while (this.count_ > 0)
/*  72 */         wait();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean attempt(long msecs) throws InterruptedException
/*     */   {
/*  78 */     if (Thread.interrupted()) throw new InterruptedException();
/*  79 */     synchronized (this) {
/*  80 */       if (this.count_ <= 0)
/*  81 */         return true;
/*  82 */       if (msecs <= 0L) {
/*  83 */         return false;
/*     */       }
/*  85 */       long waitTime = msecs;
/*  86 */       long start = System.currentTimeMillis();
/*     */       do {
/*  88 */         wait(waitTime);
/*  89 */         if (this.count_ <= 0) {
/*  90 */           return true;
/*     */         }
/*  92 */         waitTime = msecs - (System.currentTimeMillis() - start);
/*  93 */       }while (waitTime > 0L);
/*  94 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void release()
/*     */   {
/* 107 */     if (--this.count_ == 0)
/* 108 */       notifyAll();
/*     */   }
/*     */ 
/*     */   public int initialCount() {
/* 112 */     return this.initialCount_;
/*     */   }
/*     */ 
/*     */   public synchronized int currentCount()
/*     */   {
/* 120 */     return this.count_;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.CountDown
 * JD-Core Version:    0.6.0
 */